<?php
/*
    myPHP Guestbook Copyright (C) 2003 - 2006  Claudio Pose
    myPHP Guestbook was an open source project of Networkarea.ch

    Version 3.x Copyright (C) 2011 - 2014 Christian Thomas, www.hostonline.de

	Version 4.x (MySQLi) Copyright (C) 2014 - 2022 Wolfgang Leverberg, www.php-guestbook.de

    This file is a part of myPHP Guestbook.
    myPHP Guestbook is free software; you can redistribute it and/or modify it under the terms of the 
    GNU General Public License as published by the Free Software Foundation; either version 3 of the 
    License, or (at your option) any later version.

    myPHP Guestbook is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
    even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

    See the GNU General Public License for more details.

	##################################################################################################
    
	Parts of the source code of this file "pic.upload.php" are from:
	
	ISP Image Upload und Resize PHP Programm
	(c) Joachim Patten (ISP), 2013
	isp_image_resize Ver.1.5 : Version vom 08.02.2013
	
	COPYRIGHT NOTICE
	Copyright Joachim Patten (ISP)
	URL: http://www.neusser-marktplatz.de
	
	isp_image_resize.php can be used and changed free of charge.
	By using this script you accept that ISP, Joachim Patten,
	is exempt from any liability and warranty with regard to its use.

	##################################################################################################

    02.01.2022
*/
	define('UPLOAD_INFO', false);		// If the file upload does not work in the individual case, an activation of further checks can provide the admin with helpful information about the reason.
										// See also: <http://php.net/manual/en/features.file-upload.errors.php>. In normal case this function should be deactivated (constant "UPLOAD_INFO" = false).

	$count_entries = $ausgabe01 = $ausgabe02 = $ausgabe03 = $ausgabe04 = $ausgabe05 = $ergebnis_upload = $fehler = $mime_type = "";

	require_once("includes/functions.inc.php");
	require_once("includes/lang.inc.php");

	header("X-Robots-Tag: noindex");
	header("content-type: text/html; charset=\"".$encoding."\"" );
	header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
	header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
	header("Cache-Control: no-store, no-cache, must-revalidate");
	header("Pragma: no-cache");

	//Preparation of the exclusion of permanently blocked IPs according to the table with redirection to the start page
	$ip_sperre = $gbook->query("SELECT `ip` FROM `".$table."_forbidden_ip` WHERE `ip` = '".$_SERVER['REMOTE_ADDR']."'") or die();

	if ($ip_sperre != ""){
		$sperre = $ip_sperre->num_rows;
	}

	//If the guestbook or file uploads are locked in the "General configuration" settings or if the guestbook is operated in blog mode => preparation of the redirection to the start page
	$sql_no_upload  = $gbook->query("SELECT `guestbook_status`, `images_in_entries`, `button_link` FROM `".$table."_properties`") or die();
	$no_upload 		= $sql_no_upload->fetch_assoc();

	if(!$no_upload['images_in_entries'] OR $sperre) {
		header("Location: ".$url."index.php");
		die();
	}

	if(!$no_upload['guestbook_status']) {
		if($no_upload['button_link'] != 2) {
			header("Location: ".$url."index.php");
			die();
		}
		elseif(!isset($_COOKIE['blogmode'])) {
			header("Location: ".$url."index.php");
			die();
		}
	}
	else {
		if($no_upload['button_link'] == 2 && !isset($_COOKIE['blogmode'])) {
			header("Location: ".$url."index.php");
			die();
		}
	}

	isset($_SERVER['HTTP_REFERER']) ? $woher = htmlspecialchars($_SERVER['HTTP_REFERER']) : $woher = "";
	isset($_SERVER['SERVER_NAME']) ? $hostname = htmlspecialchars($_SERVER['SERVER_NAME']) : $hostname = "";

	if (isset($_GET['action']))	{
		$_GET['action'] = $gbook->real_escape_string($_GET['action']);

		if ($_GET['action'] !== "step1" && $_GET['action'] !== "step2" && $_GET['action'] !== "step3") {
			$_GET['action'] = "step1";
		}
	}
	else {
		$_GET['action'] = "step1";
	}

	switch($_GET['action'])	{
		case "step1";
		$_GET['action'] = "step1";
		$uploadError = 'upload-no-error';
		break;

		case "step2";
		$_GET['action'] = "step2";
		$uploadError = 'upload-error';
		break;

		case "step3";
		$_GET['action'] = "step3";
		$uploadError = 'upload-no-error';
		break;

		default:
		$_GET['action'] = "step1";
		$uploadError = 'upload-no-error';
		break;
	}

	$upload_konfig 	= $gbook->query("SELECT `max_filesize`, `max_width`, `max_height`, `jpg_quality`, `upload_max` FROM `".$table."_upload`") or die();
	$upload			= $upload_konfig->fetch_assoc();

	$shortIP = anonymizeIp($masterIP);

	//Monitor the number of uploaded files and block the IP when the maximum number of allowed uploads is reached
	$sql_count_upload = $gbook->query("SELECT `counter` FROM `".$table."_upload_counter` WHERE `ip` = '$shortIP'") or die();
	($sql_count_upload != "") ?	list($count_upload) = $sql_count_upload->fetch_row() : $count_upload = 0;
	($count_upload < $upload['upload_max']) ? $freeupload = true : $freeupload = false;

	$sql_properties = $gbook->query("SELECT `default_template`, `guestbook_title`, `button_link` FROM `".$table."_properties`");
	$properties		= $sql_properties->fetch_assoc();

	$sql_template = $gbook->query("SELECT `fontfamily` FROM `".$table."_template` WHERE `id` = '".$properties['default_template']."'");
	list($fontFamily) = $sql_template->fetch_row();

	($fontFamily == '"Comic Sans MS",cursive' || $fontFamily == '"Courier New",Courier,serif' || $fontFamily == '"Lucida Sans","Lucida Sans Unicode",sans-serif' || $fontFamily == 'verdana,Helvetica,sans-serif') ? $fontSize = 14 : $fontSize = 15;

	$sql_check_recipient = $gbook->query("SELECT `user_email` FROM `".$table."_login` WHERE `status` = '1' OR `status` = '3'");

	if($freeupload != true && ($_GET['action'] == "step1" OR $_GET['action'] == "step2")) {
		$ausgabe05 ="<p>&nbsp;</p>
					<p>&nbsp;</p>
					<p>&nbsp;</p>
					<p>&nbsp;</p>
					<p class=\"text-center\"><strong>".$pmsg[30]." ".$upload['upload_max']." ".$pmsg[31]."; ".$pmsg[33].".</strong></p>
					<div class=\"aligncenter\">
					<br />
					<form action=\"#\" method=\"post\">
						<p><input class=\"button-gb\" type=\"button\" value=\"".$amsg[118]."\" onclick=\"window.close();\" /></p>
					</form>		
					</div>";
	}
	else {
		if ($_GET['action'] == "step1")	{
			$ausgabe01 .=
					"".$pmsg[1]."<br />
					<form action=\"?action=step2\" method=\"post\">
						<p class=\"aligncenter\"><button name=\"accept_02\" type=\"submit\" class=\"button-gb\" value=\"".$pmsg[2]."\">".$pmsg[2]."</button></p>
						<p class=\"dsR3\"><input type=\"hidden\" name=\"accept\" value=\"1\" /><input type=\"hidden\" name=\"woher\" value=\"".$woher."\" /><input type=\"hidden\" name=\"control\" value=\"".time()."\" /></p>
					</form>
					<div class=\"aligncenter\">
						<br />
						<form action=\"#\" method=\"post\">
							<p><input class=\"button-gb\" type=\"button\" value=\"".$pmsg[3]."\" onclick=\"window.close();\" /></p>
						</form>		
					</div>";
		}
		elseif ($_GET['action'] == "step2")	{
			// No direct access to the upload form (step2) without confirmation of the terms of use (step1)
			(isset($_POST['woher'])) ? $pic_referrer = htmlspecialchars($_POST['woher']) : $pic_referrer = "";
			(isset($_POST['accept'])) ? $accept = htmlspecialchars($_POST['accept']) : $accept = "0";

			// Extra Sausage for IE
			$_POST['control'] = isset($_POST['control']) ? htmlspecialchars($_POST['control']) : "";
			($_POST['control'] >= (time()-60)) ? $cc = 7 : $cc = "";

			if (((substr_count($pic_referrer, $hostname) == 1) OR ($_POST['control'] != "" && ($cc == '7'))) && $accept == '1')	{
				$maxfilesize = ''.$upload['max_filesize'].'';
				$maxfilesize_kb = $maxfilesize*1024;
				$maxfilesize_by = $maxfilesize_kb*1024;
				$fieldname = 'bild'; 
				$uploaddir = 'img_guest'; 
				$allowedfiletype = array('jpg','jpeg','png','JPG','JPEG');
				$upload_blacklist = array('.php', '.pl', '.cgi', '.aspx', '.exe', '.sh', '.php3', '.htaccess');
				isset($_FILES[$fieldname]["name"]) ? $filename = htmlspecialchars($_FILES[$fieldname]["name"]) : $filename = '';
				$quality = ''.$upload['jpg_quality'].'';
				$outfile = ''.$url.''.$uploaddir.'/';

				$dateiname  = $endung = $filetyp = $orgname = $allesok = $fehler = '';
				$table_pic	= ''.$table.'_pictures';
				$ausgabe02 .= "<p class=\"text-center\"><strong>".$pmsg[4]."</strong></p>
							<br />";

				// Maximum photo dimensions in pixels
				$uploadMaxWidth = ''.$upload['max_width'].'';
				$uploadMaxHeight = ''.$upload['max_height'].'';

				// Function Graphics Reduction and EXIF Header cleanup
				function ResizeImage($filename, $outfile, $new_img_max_x, $new_img_max_y) {
					global $quality, $filetyp, $uploadMaxWidth, $uploadMaxHeight;

					$file = basename($filename);

					// Which version of GDLIB is installed?
					if(@imagecreatetruecolor(1,1)) $GDLIB_VERS = 2;
					else $GDLIB_VERS = 1;

					//-----------------------------------------------------------------------------
					// Reduce jpg files and rotate, if necessary

					if($filetyp == "jpg") {
						if(function_exists("imagecreatefromjpeg")) {
							$imgA = imagecreatefromjpeg($filename);
							$exifO = exif_read_data($filename);

							if(isset($exifO) && !empty($exifO['Orientation'])) {
								switch($exifO['Orientation']) {
									case 8:
									$imgA = imagerotate($imgA,90,0);
									break;

									case 3:
									$imgA = imagerotate($imgA,180,0);
									break;

									case 6:
									$imgA = imagerotate($imgA,-90,0);
									break;
								}
							}

							$org_x = imagesx($imgA);
							$org_y = imagesy($imgA);

							if($org_x > $org_y)	{
								$new_img_max_x = $new_img_max_x;
								$new_img_max_y = $org_y / ($org_x / $new_img_max_x);
								$new_img_max_y = floor($new_img_max_y);

								if($new_img_max_y > $uploadMaxHeight) {
									$new_img_max_x = $new_img_max_x / ($new_img_max_y / $uploadMaxHeight);
									$new_img_max_x = floor($new_img_max_x);
									$new_img_max_y = $uploadMaxHeight;
								}
							}

							if($org_x < $org_y)	{
								$new_img_max_y = $new_img_max_y;
								$new_img_max_x = $org_x / ($org_y / $new_img_max_y);
								$new_img_max_x = floor($new_img_max_x);

								if($new_img_max_x > $uploadMaxWidth) {
									$new_img_max_y = $new_img_max_y / ($new_img_max_x / $uploadMaxWidth);
									$new_img_max_y = floor($new_img_max_y);
									$new_img_max_x = $uploadMaxWidth;
								}
							}

							if($org_x == $org_y) {
								if ($new_img_max_x < $new_img_max_y) {
									$new_img_max_x = $new_img_max_x;
									$new_img_max_y = $new_img_max_x;
								}
								else {
									$new_img_max_x = $new_img_max_y;
									$new_img_max_y = $new_img_max_y;
								}
							}

							if($GDLIB_VERS == 2) {
								$imgB = imagecreatetruecolor($new_img_max_x,$new_img_max_y);
								imagecopyresampled($imgB, $imgA,0,0,0,0, $new_img_max_x, $new_img_max_y, $org_x ,$org_y);
							}

							if($GDLIB_VERS == 1) {
								$imgB = imagecreate($new_img_max_x,$new_img_max_y);
								imagecopyresized($imgB, $imgA,0,0,0,0, $new_img_max_x, $new_img_max_y, $org_x ,$org_y);
							}
							imagejpeg($imgB, $outfile, $quality);

							imagedestroy($imgA);
							imagedestroy($imgB);
						}
						else {
							return false;
						}
					}

					// End of reduce jpg files
					//-----------------------------------------------------------------------------
					// Reduce png files

					if($filetyp == "png") {
						if(function_exists("imagecreatefrompng")) {
							$imgA = imagecreatefrompng($filename);
							imageAlphaBlending($imgA, false);
							imageSaveAlpha($imgA, true);

							$org_x = imagesx($imgA);
							$org_y = imagesy($imgA);

							if($org_x > $org_y)	{
								$new_img_max_x = $new_img_max_x;
								$new_img_max_y = $org_y / ($org_x / $new_img_max_x);
								$new_img_max_y = floor($new_img_max_y);

								if($new_img_max_y > $uploadMaxHeight) {
									$new_img_max_x = $new_img_max_x / ($new_img_max_y / $uploadMaxHeight);
									$new_img_max_x = floor($new_img_max_x);
									$new_img_max_y = $uploadMaxHeight;
								}
							}

							if($org_x < $org_y)	{
								$new_img_max_y = $new_img_max_y;
								$new_img_max_x = $org_x / ($org_y / $new_img_max_y);
								$new_img_max_x = floor($new_img_max_x);

								if($new_img_max_x > $uploadMaxWidth) {
									$new_img_max_y = $new_img_max_y / ($new_img_max_x / $uploadMaxWidth);
									$new_img_max_y = floor($new_img_max_y);
									$new_img_max_x = $uploadMaxWidth;
								}
							}

							if($org_x == $org_y) {
								if ($new_img_max_x < $new_img_max_y) {
									$new_img_max_x = $new_img_max_x;
									$new_img_max_y = $new_img_max_x;
								}
								else {
									$new_img_max_x = $new_img_max_y;
									$new_img_max_y = $new_img_max_y;
								}
							}

							if($GDLIB_VERS == 2) {
								$imgB = imagecreatetruecolor($new_img_max_x,$new_img_max_y);
								imageAlphaBlending($imgB, false);
								imageSaveAlpha($imgB, true);

								imagecopyresampled($imgB, $imgA,0,0,0,0, $new_img_max_x, $new_img_max_y, $org_x ,$org_y);
							}

							if($GDLIB_VERS == 1) {
								$imgB = imagecreate($new_img_max_x,$new_img_max_y);
								imageAlphaBlending($imgB, false);
								imageSaveAlpha($imgB, true);

								imagecopyresized($imgB, $imgA,0,0,0,0, $new_img_max_x, $new_img_max_y, $org_x ,$org_y);
							}

							imagepng($imgB, $outfile);

							imagedestroy($imgA);
							imagedestroy($imgB);
						}
						else {
							return false;
						}
					}

					// End of reduce png files

					// If the function for reducing jpg and png files is not available => error

					if(!$imgA) {
						return false;
					}
					return true;
				}
				// End function Graphics Reduction and EXIF Header cleanup

				// Function EXIF Header Cleanup for files that do not (!) exceed the maximum width or height.
				function CleanImage($filename, $outfile, $org_x, $org_y) {
					global $quality, $filetyp;

					$file = basename($filename);

					// Which version of GDLIB is installed?
					if(@imagecreatetruecolor(1,1)) $GDLIB_VERS = 2;
					else $GDLIB_VERS = 1;

					//-----------------------------------------------------------------------------
					// Cleanup jpg files and rotate, if necessary

					if($filetyp == "jpg") {
						if(function_exists("imagecreatefromjpeg")) {
							$imgA = imagecreatefromjpeg($filename);
							$exifO = exif_read_data($filename);

							if(isset($exifO) && !empty($exifO['Orientation'])) {
								switch($exifO['Orientation']) {
									case 8:
									$imgA = imagerotate($imgA,90,0);
									break;

									case 3:
									$imgA = imagerotate($imgA,180,0);
									break;

									case 6:
									$imgA = imagerotate($imgA,-90,0);
									break;
								}
							}

							$org_x = imagesx($imgA);
							$org_y = imagesy($imgA);

							if($GDLIB_VERS == 2) {
								$imgB = imagecreatetruecolor($org_x,$org_y);
								imagecopyresampled($imgB, $imgA,0,0,0,0, $org_x, $org_y, $org_x ,$org_y);
							}

							if($GDLIB_VERS == 1) {
								$imgB = imagecreate($org_x,$org_Y);
								imagecopyresized($imgB, $imgA,0,0,0,0, $org_x, $org_Y, $org_x ,$org_y);
							}
							imagejpeg($imgB, $outfile, $quality);

							imagedestroy($imgA);
							imagedestroy($imgB);
						}
						else {
							return false;
						}
					}

					// End of cleanup jpg files
					//-----------------------------------------------------------------------------
					// Cleanup png files

					if($filetyp == "png") {
						if(function_exists("imagecreatefrompng")) {
							$imgA = imagecreatefrompng($filename);
							imageAlphaBlending($imgA, false);
							imageSaveAlpha($imgA, true);

							$org_x = imagesx($imgA);
							$org_y = imagesy($imgA);

							if($GDLIB_VERS == 2) {
								$imgB = imagecreatetruecolor($org_x,$org_y);
								imageAlphaBlending($imgB, false);
								imageSaveAlpha($imgB, true);

								imagecopyresampled($imgB, $imgA,0,0,0,0, $org_x, $org_y, $org_x ,$org_y);
							}

							if($GDLIB_VERS == 1) {
								$imgB = imagecreate($org_x,$org_y);
								imageAlphaBlending($imgB, false);
								imageSaveAlpha($imgB, true);

								imagecopyresized($imgB, $imgA,0,0,0,0, $org_x, $org_y, $org_x ,$org_y);
							}

							imagepng($imgB, $outfile);

							imagedestroy($imgA);
							imagedestroy($imgB);
						}
						else {
							return false;
						}
					}
					// End of cleanup png files

					if(!$imgA) {
						return false;
					}
					return true;
				}
				// End function EXIF header cleanup

				// Save variables
				function quote_smart($value) {
					if (get_magic_quotes_gpc())	{
						$value = stripslashes($value);
					}

					// Put in quotation marks, if there is no number or a numeric string
					if (!is_numeric($value)) {
						$value = "'".$gbook->real_escape_string($value)."'";
					}
					return $value;
				}

				// If id is passed, then save and load the record
				if (isset($_REQUEST['id'])) {
					$id = strip_tags(trim($_REQUEST['id']));
					$id = $gbook->real_escape_string($id);
					$id = (is_numeric($id) && !empty($id) && (intval($id) == $id)) ? $id : '';
				}
				else {
					$id = '';
				}

				if(!empty($id))	{
					$asql	=	$gbook->query("SELECT `pic_name` FROM `$table_pic` WHERE `id` = $id") or die(); 
					$bildrs =	$uploaddir."/".$gbook->result($asql);
				}

				$ausgabe03 .= "".$pmsg[5]."
							<p class=\"text-center\"><strong>$maxfilesize MB (= $maxfilesize_kb KB)</strong><br />
							<p>".$pmsg[6]."<strong> ";

				if(count($allowedfiletype) > 1)	{ 
					$last = array_pop($allowedfiletype);

					$ausgabe03 .= implode(', ', $allowedfiletype); 
					$ausgabe03 .= ' + '.$last; 
				}
				elseif(count($allowedfiletype) == 1) {
					$ausgabe03 .= $allowedfiletype[0];
				}

				$ausgabe03 .= "</strong></p>
						<p>".$pmsg[30]." ".$upload['upload_max']." ".$pmsg[31]." ".$pmsg[32].".</p>
						".$pmsg[7]."
						";

				// Preparation for saving graphic data in database	
				function uploaddb($dateiname,$new_width,$new_height,$table_pic,$id,$file) {
					global $gbook, $table;

					if(!empty($id))	{
						if (file_exists($file))	{
							unlink($file); 
						} 
						$sql = sprintf("UPDATE `$table_pic` SET `pic_name` = '$dateiname', `width` = '$new_width', `height` = '$new_height', `title` = 'Upload: ".GB_DATE."', `date` = '".GB_DATE."', `time` = '".date("H:i")."'  WHERE `id` = '".$id."'") or die();
					}
					else {    
						$sql = sprintf("INSERT INTO `$table_pic` (`ip`, `pic_name`, `width`, `height`, `title`, `date`, `time`) VALUES (NULL, '$dateiname', '$new_width', '$new_height', 'Upload: ".GB_DATE."', '".GB_DATE."', '".date("H:i")."')") or die();
					}          

					$rs = $gbook->query($sql);

					if($rs)	{ 
						return "<p>&nbsp;</p>";
					}
					else { 
						return "<p class=\"text-center red\">".$pmsg[8]."</strong></p>"; 
					}         
				}

				// Query whether the form was sent and generation of a new filename and filename extension.
				if(isset($_POST['send'])) {
					$allesok = 1;
					$darray  = explode('.', str_replace('/', '.', $_FILES[$fieldname]['name']));

					mt_srand(makeRandomName());
					$orgname = md5(mt_rand());
					$orgname = substr($orgname, 0, 16);
					$orgname = preg_replace('/(.)(\\1{1,2})\\1*/sS', '$1$2', $orgname);

					// Error checking
					if($_FILES[$fieldname]['error'] == 2) {
						$allesok=0; 
						$fehler =''.$pmsg[14].'<br />'.$pmsg[10].''; 
					} 

					if($_FILES[$fieldname]['error'] == 0 AND $allesok == 1)	{
						$image_typ = getimagesize($_FILES[$fieldname]['tmp_name']);
						$image_mimetyp = $image_typ['mime'];

						// First check of the allowed MIME type using 'Fileinfo'-Extension
						 if ((version_compare(PHP_VERSION, '5.3.0') >= 0) && (function_exists('finfo_open')) && ($finfo = finfo_open(FILEINFO_MIME_TYPE))) {
							// Setup for returning MIME type using the magic database
							$finfo = finfo_open(FILEINFO_MIME_TYPE);

							$gbFilename = $_FILES[$fieldname]['tmp_name'];

							// Determining the MIME Type of the file
							$mime_type = finfo_file($finfo, $gbFilename);

							// Close connection
							finfo_close($finfo);

							if ($mime_type !== 'image/jpeg' && $mime_type !== 'image/png') {
								$allesok=0;
								$fehler =''.$pmsg[22].'';
							}
						}

						// Second check of the allowed MIME type using 'getimagesize()', check file size in pixels and create new filename extension
						if ($image_mimetyp != 'image/jpeg' && $image_mimetyp != 'image/png') {
							$allesok=0; 
							$fehler = ''.$pmsg[22].'';
						}
						elseif (($image_typ['0'] < 10) && ($image_typ['1'] < 10)) {
							$allesok=0;
							$fehler = ''.$pmsg[34].'';
						}
						elseif ($image_mimetyp == 'image/jpeg')	{
							$filetyp = 'jpg';
						}
						elseif ($image_mimetyp == 'image/png') {
							$filetyp = 'png';
						}
					}

					// Checking if there is the filename extension in the blacklist
					if (count($darray) > 1 AND $allesok == 1) {
						$endung  = trim(strtolower($darray[1]));

						foreach($upload_blacklist as $blacklist) {					
							$count_blacklist = substr_count(strtolower($_FILES[$fieldname]['name']), ''.$blacklist.'', 0);

							if($count_blacklist > 0) {
								$allesok=0;  
								$fehler=''.$pmsg[28].''; 
							} 
						}
					}

					if (UPLOAD_INFO) {
						if($_FILES[$fieldname]['error'] == 4 AND $allesok == 1)	{
							$allesok=0;  
							$fehler='Es wurde keine Datei hochgeladen.<br />No file was uploaded.'; 
						} 
						if($_FILES[$fieldname]['error'] == 6 AND $allesok == 1)	{
							$allesok=0;  
							$fehler='Fehlender temporärer Ordner.<br />Missing a temporary folder.'; 
						} 
						if($_FILES[$fieldname]['error'] == 7 AND $allesok == 1)	{
							$allesok=0;  
							$fehler='Speichern der Datei auf die Festplatte ist fehlgeschlagen.<br />Failed to write file to disk.'; 
						} 
						if($_FILES[$fieldname]['error'] == 8 AND $allesok == 1)	{
							$allesok=0;  
							$fehler='Eine PHP Erweiterung hat den Upload der Datei gestoppt. PHP bietet keine Möglichkeit an, um festzustellen welche Erweiterung das Hochladen der Datei gestoppt hat. Überprüfung aller geladenen Erweiterungen mittels phpinfo() könnte helfen.<br />
									A PHP extension stopped the file upload. PHP does not provide a way to ascertain which extension caused the file upload to stop; examining the list of loaded extensions with phpinfo() may help.'; 
						}
					}

					if($_FILES[$fieldname]['error'] == 1 AND $allesok == 1)	{
						$allesok=0;  
						$fehler=''.$pmsg[9].' ('.ini_get('upload_max_filesize').')!<br />'.$pmsg[10].''; 
					} 
					if($_FILES[$fieldname]['error'] == 3 AND $allesok == 1)	{
						$allesok=0; 
						$fehler = ''.$pmsg[11].''; 
					} 
					if($_FILES[$fieldname]['error'] != 0 AND $allesok == 1)	{
						$allesok=0; 
						$fehler ='<strong>'.$pmsg[12].'</strong>'; 
					}

					// Checking if there is the filename extension in the whitelist
					if(!in_array($endung, $allowedfiletype) AND $allesok == 1) {
						$allesok=0;           
						$fehler = ''.$pmsg[13].''; 
					} 
					if(filesize($_FILES[$fieldname]['tmp_name'])/1024/1024 >= $maxfilesize AND $allesok == 1) {
						$allesok=0; 
						$fehler = ''.$pmsg[14].'<br />'.$pmsg[10].''; 
					}
				}

				// If everything is ok, upload the file
				if($allesok && $filetyp != '') {
					// Upload-Counter
					$select_counter_ip = $gbook->query("SELECT `id` FROM `".$table."_upload_counter` WHERE `ip` = '$shortIP'");
					$counter_ip = $select_counter_ip->num_rows;

					if ($counter_ip > 0) {
						$gbook->query("UPDATE `".$table."_upload_counter` SET `upload_time` = ".time().", `counter` = `counter` + 1  WHERE `ip` = '$shortIP'");
					}
					else {
						$gbook->query("INSERT INTO `".$table."_upload_counter` (`ip`, `upload_time`, `counter`) VALUES ('$shortIP','".time()."','1')");
					}

					// Create new filename
					$dateiname = $orgname.'.'.$filetyp;

					// Upload
					move_uploaded_file($_FILES[$fieldname]['tmp_name'], $uploaddir.'/'.$dateiname);

					// Re-check after upload whether the MIME type is allowed and whether the image size needs to be changed.
					// Remove contents of the EXIF header.
					// Additionally check if the jpg-image is aligned correctly, rotate if necessary.
					$image_file_pfad = "{$uploaddir}/{$dateiname}";

					$size = getimagesize($image_file_pfad);
					$width = $size[0];
					$height = $size[1];
					$mimetype = $size[2];
					$value = true;

					//Type of graphic: 2 = JPG, 3 = PNG
					if ($mimetype == '2' OR $mimetype == '3') {
						if ($width > $uploadMaxWidth OR $height > $uploadMaxHeight)	{
							$value = ResizeImage($image_file_pfad, $image_file_pfad, $uploadMaxWidth, $uploadMaxHeight);
						}
						else {
							$value = CleanImage($image_file_pfad, $image_file_pfad, $width, $height);
						}

						if ($value == true)	{
							//Checking width and height of the reduced and cleaned image
							$new_size = getimagesize($image_file_pfad);
							$new_width = $new_size[0];
							$new_height = $new_size[1];

							// Save graphic data to database
							$ergebnis_upload = uploaddb($dateiname,$new_width,$new_height,"".$table."_pictures",$id,$image_file_pfad);

							//If the guestbook is not in blog mode => Notification mail from file upload to admin and - if activated - to moderator(s)
							if ($properties['button_link'] != 2) {
								$mk = 0;

								while ($mailRecipient = $sql_check_recipient->fetch_assoc()) {
									$empfaenger = "".$mailRecipient['user_email']."";
									$betreff = "".$pmsg[17]." - <".$properties['guestbook_title'].">\n";

									include ("includes/mail.header.inc.php");

									$nachricht = "".$pmsg[18]."<br /><br />
												<img src=\"".$outfile."".$dateiname."\" alt=\"\" width=\"".$new_width."\" height=\"".$new_height."\" /><br /><br />
												".$outfile."".$dateiname."";

									mail($empfaenger, $betreff, $nachricht, $header);

									$mk++;
									// Additional protection against uncontrolled, multiple email sending.
									if ($mk >= 4) {
										break;
									}
								}
							}

							$ausgabe01 = $ausgabe02 = $ausgabe03 = $ausgabe04 = "";
							$ausgabe05 ="<p class=\"text-center green\"><strong>".$pmsg[19]."</strong></p><br />
										".$pmsg[20]."
										<p>&nbsp;</p>
										<form action=\"?action=step3\" method=\"post\">
											<p class=\"dsR3\"><input type=\"hidden\" name=\"send\" value=\"send\" /><input type=\"hidden\" name=\"accept\" value=\"1\" /><input type=\"hidden\" name=\"woher\" value=\"".$woher."\" /></p>
											<p class=\"aligncenter\"><input class=\"button-gb\" type=\"submit\" value=\"".$pmsg[21]."\" onclick=\"opener.document.getElementById('text').value += ' [img]".$dateiname."[/img] ';\" /></p>
										</form>
										<div class=\"aligncenter\">
											<br />
											<form action=\"#\" method=\"post\">
												<p><input class=\"button-gb\" type=\"button\" value=\"".$pmsg[3]."\" onclick=\"window.close();\" /></p>
											</form>		
										</div>";
						}
						else {
							if (file_exists($image_file_pfad)) {
								unlink($image_file_pfad); 
							} 

							$fehler = ''.$pmsg[29].'';

							$ausgabe04 ="<div id=\"loading\" class=\"progress\"></div>
										<div class=\"aligncenter\">
											<form action=\"?action=step2\" enctype=\"multipart/form-data\" method=\"post\">
												<input type=\"hidden\" name=\"MAX_FILE_SIZE\" value=\"".$maxfilesize_by."\" />
												<div><input class=\"button-gb\" name=\"".$fieldname."\" type=\"file\" size=\"30\" accept=\"image/jpeg,image/png\" /></div>
												<p class=\"dsR3\"><input type=\"hidden\" name=\"send\" value=\"send\" /><input type=\"hidden\" name=\"id\" value=\"".$id."\" /><input type=\"hidden\" name=\"accept\" value=\"1\" /><input type=\"hidden\" name=\"woher\" value=\"".$woher."\" /></p>
												<p>&nbsp;</p>
												<p><input class=\"button-gb\" type=\"submit\" onclick=\"upload();\" name=\"laden\" value=\"".$pmsg[23]."\" /></p>
											</form>
										</div>";
						}
					}
					else  {
						if (file_exists($image_file_pfad)) {
							unlink($image_file_pfad); 
						} 

						$fehler = ''.$pmsg[22].'';

						$ausgabe04 ="
									<div id=\"loading\" class=\"progress\"></div>
									<div class=\"aligncenter\">
										<form action=\"?action=step2\" enctype=\"multipart/form-data\" method=\"post\">
											<input type=\"hidden\" name=\"MAX_FILE_SIZE\" value=\"".$maxfilesize_by."\" />
											<div><input class=\"button-gb\" name=\"".$fieldname."\" type=\"file\" size=\"30\" accept=\"image/jpeg,image/png\" /></div>
											<p class=\"dsR3\"><input type=\"hidden\" name=\"send\" value=\"send\" /><input type=\"hidden\" name=\"id\" value=\"".$id."\" /><input type=\"hidden\" name=\"accept\" value=\"1\" /><input type=\"hidden\" name=\"woher\" value=\"".$woher."\" /></p>
											<p>&nbsp;</p>
											<p><input class=\"button-gb\" type=\"submit\" onclick=\"upload();\" name=\"laden\" value=\"".$pmsg[23]."\" /></p>
										</form>
									</div>";
					}
				}
				else { 
					// Form output
					$ausgabe04 ="
								<div id=\"loading\" class=\"progress\"></div>
								<div class=\"aligncenter\">
									<form action=\"?action=step2\" enctype=\"multipart/form-data\" method=\"post\">
										<input type=\"hidden\" name=\"MAX_FILE_SIZE\" value=\"".$maxfilesize_by."\" />
										<div><input class=\"button-gb\" name=\"".$fieldname."\" type=\"file\" size=\"30\" accept=\"image/jpeg,image/png\" /></div>
										<p class=\"dsR3\"><input type=\"hidden\" name=\"send\" value=\"send\" /><input type=\"hidden\" name=\"id\" value=\"".$id."\" /><input type=\"hidden\" name=\"accept\" value=\"1\" /><input type=\"hidden\" name=\"woher\" value=\"".$woher."\" /></p>
										<p>&nbsp;</p>
										<p><input class=\"button-gb\" type=\"submit\" onclick=\"upload();\" name=\"laden\" value=\"".$pmsg[23]."\" /></p>
									</form>
								</div>
								<div class=\"aligncenter\">
									<br />
									<form action=\"#\" method=\"post\">
										<p><input class=\"button-gb\" type=\"button\" value=\"".$pmsg[3]."\" onclick=\"window.close();\" /></p>
									</form>		
								</div>";
				}
			}
			else {
				$ausgabe04 ="<p class=\"text-center\"><strong>".$pmsg[4]."</strong></p>
							<br />
							".$pmsg[16]."
							<br />
							<br />
							<div class=\"aligncenter\">
								<form action=\"?action=step1\" method=\"post\">
									<p><button name=\"zurück\" type=\"button\" class=\"button-gb\" value=\"".$fmsg[4]."\" onclick=\"location.href='pic.upload.php?action=step1'\">".$fmsg[4]."</button></p>
								</form>
							</div>
							<div class=\"aligncenter\">
								<br />
								<form action=\"#\" method=\"post\">
									<p><input class=\"button-gb\" type=\"button\" value=\"".$pmsg[3]."\" onclick=\"window.close();\" /></p>
								</form>		
							</div>";
			}
		}

		elseif ($_GET['action'] == "step3")	{
			//Capturing the title of the uploaded file and entering it in the database
			(isset($_POST['send'])) ? $pic_referrer = htmlspecialchars($_POST['woher']) : $pic_referrer = "";
			(isset($_POST['send'])) ? $accept = htmlspecialchars($_POST['accept']) : $accept = "0";

			if ((substr_count($pic_referrer, $hostname) == 1) && ($accept == '1')) {
				$last_entrie = $gbook->query("SELECT `id`, `title` FROM `".$table."_pictures` WHERE `id` = (SELECT max(id) FROM `".$table."_pictures`)");
				list($last_id, $last_title) = $last_entrie->fetch_row();

				if (isset($_POST['send_title'])) {
					$ausgabe05 = $error_title = "";

					$_POST['description'] = preg_replace("/-+/", "-", $_POST['description']);  // no double dashes
					$_POST['description'] = preg_replace("/\s+/", " ", $_POST['description']); // no double whitespaces

					if (!preg_match("/^[a-zA-Z".$allowed_characters."0-9 :?!,.-]*$/is", $_POST['description'])) {
						$error_title .="- ".$emsg[61]."";
					}

		            if ($error_title == "")	{
				        (isset($_POST['description']) AND $_POST['description'] != "") ? $_POST['description'] = $_POST['description'] : $_POST['description'] = $last_title;	

				        $_POST['description'] = $gbook->real_escape_string($_POST['description']);

						$update_pic_title = $gbook->query("UPDATE `".$table."_pictures` SET `title` = '".$_POST['description']."' WHERE `id` = '".$last_id."'");

						if ($update_pic_title) {
							$ausgabe05 ="<p>&nbsp;</p>
										<p>&nbsp;</p>
										<p class=\"text-center\"><strong>".$pmsg[24]."</strong></p>
										<p>&nbsp;</p>
										<p>&nbsp;</p>
										<p>&nbsp;</p>
										<form method=\"post\" action=\"#\">
											<p class=\"aligncenter\"><input class=\"button-gb\" type=\"button\" value=\"".$pmsg[25]."\" onclick=\"self.location.href='pic.upload.php?action=step1'\" /></p>
											<p>&nbsp;</p>
											<p class=\"aligncenter\"><input class=\"button-gb\" type=\"button\" value=\"".$pmsg[26]."\" onclick=\"window.close();\" /></p>
										</form>
										<br />
										";
						}
					}
					else {
						$ausgabe05 = "<p>&nbsp;</p>
									<p class=\"text-center red\"><strong>".$error_title."</strong></p><br />
									<p>&nbsp;</p>
									<p class=\"text-center\"><strong>".$pmsg[15]."</strong></p>
									<p class=\"text-center\">(".$pmsg[27].")</p>
									<br />
									<form method=\"post\" action=\"?action=step3\">
										<p class=\"aligncenter\"><input type=\"text\" class=\"insert\" name=\"description\" autofocus=\"autofocus\" autocomplete=\"off\" size=\"40\" maxlenght=\"60\" onfocus=\"this.value=''\" placeholder=\"".$last_title."\" value=\"";

								        if (isset($_POST['description']) AND $_POST['description'] != "") {
								            $ausgabe05 .= stripslashes(htmlspecialchars(strip_tags($_POST['description']), ENT_QUOTES));
								        }
										else {
											$ausgabe05 .= stripslashes(htmlspecialchars(strip_tags($last_title), ENT_QUOTES));
										}

										$ausgabe05 .="\" /></p>
													<p class=\"dsR3\"><input type=\"hidden\" name=\"send\" value=\"send\" /><input type=\"hidden\" name=\"accept\" value=\"1\" /><input type=\"hidden\" name=\"woher\" value=\"".$woher."\" /></p>
													<p>&nbsp;</p>
													<p>&nbsp;</p>
													<p class=\"aligncenter\"><input class=\"button-gb\" type=\"submit\" name=\"send_title\" value=\"".$fmsg[55]."\" /></p>
												</form>
												<br />
												";
					}
				}
				else {
					$ausgabe05 ="<p>&nbsp;</p>
								<p>&nbsp;</p>
								<p class=\"text-center\"><strong>".$pmsg[15]."</strong></p>
								<p class=\"text-center\">(".$pmsg[27].")</p>
								<br />
								<form method=\"post\" action=\"?action=step3\">
									<p class=\"aligncenter\"><input type=\"text\" class=\"insert\" name=\"description\" autofocus=\"autofocus\" autocomplete=\"off\" size=\"40\" maxlenght=\"60\" onfocus=\"this.value=''\" placeholder=\"".$last_title."\" value=\"";

							        if (isset($_POST['description']) AND $_POST['description'] != "") {
							            $ausgabe05 .= stripslashes(htmlspecialchars(strip_tags($_POST['description']), ENT_QUOTES));
							        }
									else {
										$ausgabe05 .= stripslashes(htmlspecialchars(strip_tags($last_title), ENT_QUOTES));
									}

									$ausgabe05 .="\" /></p>
										<p class=\"dsR3\"><input type=\"hidden\" name=\"send\" value=\"send\" /><input type=\"hidden\" name=\"accept\" value=\"1\" /><input type=\"hidden\" name=\"woher\" value=\"".$woher."\" /></p>
										<p>&nbsp;</p>
										<p>&nbsp;</p>
										<p class=\"aligncenter\"><input class=\"button-gb\" type=\"submit\" name=\"send_title\" value=\"".$fmsg[55]."\" /></p>
									</form>
									<br />
									";
				}
			}
			else {
				$ausgabe05 ="<p class=\"text-center\"><strong>".$pmsg[4]."</strong></p>
							<br />
							".$pmsg[16]."
							<br />
							<br />
							<div class=\"aligncenter\">
								<form action=\"?action=step1\" method=\"post\">
									<p><button name=\"zurück\" type=\"button\" class=\"button-gb\" value=\"".$fmsg[4]."\" onclick=\"location.href='pic.upload.php?action=step1'\">".$fmsg[4]."</button></p>
								</form>
							</div>
							<div class=\"aligncenter\">
								<br />
								<form action=\"#\" method=\"post\">
									<p><input class=\"button-gb\" type=\"button\" value=\"".$pmsg[3]."\" onclick=\"window.close();\" /></p>
								</form>		
							</div>";
			}
		}
		else {
			$ausgabe05 ="<p class=\"text-center\"><strong>".$pmsg[4]."</strong></p>
						<br />
						".$pmsg[16]."
						<br />
						<br />
						<div class=\"aligncenter\">
							<form action=\"?action=step1\" method=\"post\">
								<p><button name=\"zurück\" type=\"button\" class=\"button-gb\" value=\"".$fmsg[4]."\" onclick=\"location.href='pic.upload.php?action=step1'\">".$fmsg[4]."</button></p>
							</form>
						</div>
						<div class=\"aligncenter\">
							<br />
							<form action=\"#\" method=\"post\">
								<p><input class=\"button-gb\" type=\"button\" value=\"".$pmsg[3]."\" onclick=\"window.close();\" /></p>
							</form>		
						</div>";
		}
	}
		
	echo "<!DOCTYPE html>
	<!--[if IE 9]><html id=\"ie9\" dir=\"ltr\" lang=\"".$lang_short."\"><![endif]-->
	<!--[if !(IE 9) ]><!-->
	<html lang=\"".$lang_short."\">
	<!--<![endif]-->
	<head>
		<meta charset=\"".$encoding."\" />
		<meta name=\"language\" content=\"".$lang_short."\" />
		<meta name=\"viewport\" content=\"width=device-width\" />
		<title>".$properties['guestbook_title']."</title>
		<link rel=\"stylesheet\" href=\"".$url."".$cssStyle."\" />
		<style>
			body{font-family:".$fontFamily.";font-size:".$fontSize."px;color:#000000;background-color:#eeeeee;}
			#upload{font-size:".$fontSize."px;}.button-gb{font-family:".$fontFamily.";}
			li{margin-bottom:15px;}
			.progress{width:128px;height:15px;margin:20px auto;padding:0;border:0;background-image:none;}
			.progress-bar{width:128px;height:15px;margin:20px auto;padding:0;border:0;background-image:url(\"".$url."images/upload.gif\");background-repeat:no-repeat;}
			.upload-no-error{display:none;height:0;}
			.upload-error{display:block;min-height:20px;padding-top:10px;text-align:center;color:#c00000;}
			.upload-note{display:block;height:20px;padding-top:10px;padding-left:10px;text-align:center;font-weight:bold;color:blue;-webkit-animation:fade 3s infinite;animation:fade 3s infinite;}
			@keyframes fade{0%{opacity:1;}50%{opacity:0;}100%{opacity:1;}}@-webkit-keyframes fade{0%{opacity:1;}50%{opacity:0;}100%{opacity:1;}}
		</style>
		<script>
			function upload(){window.setTimeout('upload02()',500);};
			function upload02(){
				var usernote='".$pmsg[35]."';
				document.getElementById('loading').className='progress-bar';
				document.getElementById('display-error').className='upload-note';
				document.getElementById('display-error').textContent=usernote;
			};
		</script>
	</head>
	<body>
		<div id=\"upload\">
		";
			echo $ausgabe01;
			echo $ausgabe02;
			echo $ausgabe03;
			echo"<div id=\"display-error\" class=\"".$uploadError."\">".$fehler."</div>";
			echo $ergebnis_upload;
			echo $ausgabe04;
			echo $ausgabe05;
	echo"
		</div>
	</body>
	</html>";
?>