<?php
/*
	myPHP Guestbook Copyright (C) 2003 - 2006  Claudio Pose
	myPHP Guestbook was an open source project of Networkarea.ch

	Version 3.x Copyright (C) 2011 - 2014 Christian Thomas, www.hostonline.de

	Version 4.x (MySQLi) Copyright (C) 2014 - 2022 Wolfgang Leverberg, www.php-guestbook.de

	This file is a part of myPHP Guestbook.
	myPHP Guestbook is free software; you can redistribute it and/or modify it under the terms of the 
	GNU General Public License as published by the Free Software Foundation; either version 3 of the 
	License, or (at your option) any later version.

	myPHP Guestbook is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
	even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

	See the GNU General Public License for more details.

	02.01.2022
*/
    
// Variablen

    $version    = "V 4.10.9";
    $encoding   = "utf-8";
    $language   = "Deutsch";
    $lang_short = "de";
    $cssStyle	= "mygbook-style-4108.css";
    
// Cookie Belehrung

    $cmsg[0]  = 'Wenn Sie eine andere Sprache auswählen, stimmen Sie zu, dass Ihre Einstellung in einem Cookie gespeichert wird. (Inhalt des Cookies: "de", "en", "fr", "it", "nl", "pl", "pt", "sv", "cz" oder "sk".) - Der Cookie wird mit dem Schließen des Browsers automatisch wieder gelöscht.';
    
// Text Danke-E-Mail an Gast

	$thankYou[0] = 'Lieber Gast,<br /><br />ich bedanke mich für Deinen Eintrag in meinem Gästebuch von "'.$_SERVER['SERVER_NAME'].'" und hoffe, bald wieder etwas von Dir zu lesen.<br /><br />Mit freundlichem Gruß<br />Administrator';

// EU-DSGVO

    $dsgvo[0] = 'Ich stimme der Speicherung und Verarbeitung meiner Daten nach der <span class="nowrap">EU-DSGVO zu</span>.';
    $dsgvo[1] = 'Datenschutzerklärung';

// Admin-Panel-Menü Phrasen

    $amsg[0] = 'Admin-Control-Panel';
    $amsg[1] = 'Bitte einloggen!';
    $amsg[2] = 'Einträge';
    $amsg[3] = 'Einträge und Kommentare';
    $amsg[4] = 'Einstellungen';
    $amsg[5] = 'Admin- + Login Daten';
    $amsg[6] = 'Allgemeine Konfiguration';
    $amsg[7] = 'CSS-Style:';
    $amsg[8] = 'Standard Style';
    $amsg[9] = 'Style neu erstellen';
    $amsg[10] = 'Style löschen';
    $amsg[11] = 'Style editieren';
    $amsg[12] = 'Template';
    $amsg[13] = 'Standard Template';
    $amsg[14] = 'Template neu erstellen';
    $amsg[15] = 'Template löschen';
    $amsg[16] = 'Template editieren';
    $amsg[17] = 'Smileys';
    $amsg[18] = 'Smileys anzeigen';
    $amsg[19] = 'Smiley hinzufügen';
    $amsg[20] = 'Badwords';
    $amsg[21] = 'Badwords anzeigen';
    $amsg[22] = 'Badword hinzufügen';
    $amsg[23] = 'Backup';
    $amsg[24] = 'Backup erstellen';
    $amsg[25] = 'Backup-Liste';
    $amsg[26] = 'Sonstiges';
    $amsg[27] = 'Statistik';
    $amsg[28] = 'Schutz des Gästebuchs';
    $amsg[29] = 'Logout';
    $amsg[30] = 'Der Eintrag wurde aktiviert';
    $amsg[31] = 'Der Aktivierungscode ist falsch, es wurde kein Eintrag freigeschaltet';
    $amsg[32] = 'Absatz';
    $amsg[33] = 'Eintrag bearbeiten';
    $amsg[34] = 'Eintrag, der kommentiert wird.';
    $amsg[35] = 'Spamwords anzeigen';
    $amsg[36] = 'Spamwords hinzufügen';
    $amsg[37] = 'IP-Sperren';
    $amsg[38] = 'Spamfilter';
    $amsg[39] = 'Einträge unter allen IPs möglich?';
    $amsg[40] = 'Liste der gesperrten IPs anzeigen';
    $amsg[41] = 'NEIN';
    $amsg[42] = 'Alle Einträge freigegeben?';
    $amsg[43] = 'gesperrt:';
    $amsg[44] = 'Letztes BackUp:';
    $amsg[45] = 'Keine Spam-Wörter vorhanden.';
    $amsg[46] = 'Die Liste der Schlüsselwörter, die bei einer Verwendung<br />im Textbeitrag zu dessen Identifizierung als Spam führen.';
    $amsg[47] = 'Spam-Erkennung durch Schlüsselwörter aktiviert?';
    $amsg[48] = 'Die Funktion muss in den allgemeinen<br />Konfigurationseinstellungen aktiviert werden.';
    $amsg[49] = 'Spam-Wort';
    $amsg[50] = 'Setzen Sie unten das gewünschte Schlüsselwort ein,<br />das den Beitrag als spam-verdächtig markiert.';
    $amsg[51] = 'Durch Spam gesperrte IPs zur Eintragsseite:';
    $amsg[52] = 'Zur Zeit keine IPs gesperrt.';
    $amsg[53] = 'Hier eingetragene IPs werden nach '.$delete_spamIps.' Tagen automatisch gelöscht.<br />Falls bestimmte IPs ausnahmsweise länger gespeichert bleiben sollen,<br />bitte den grünen Haken zu der betroffenen IP anklicken.';
    $amsg[54] = 'IP:';
    $amsg[55] = 'Datum:';
    $amsg[56] = 'Uhrzeit:';
    $amsg[57] = 'IP löschen:';
    $amsg[58] = 'Löschen?';
    $amsg[59] = 'Banner aktivieren';
    $amsg[60] = 'IP wird nach '.$delete_spamIps.' Tagen gelöscht. Verhindern?';
    $amsg[61] = 'IP wird nicht automatisch gelöscht! Ändern?';
    $amsg[62] = 'IP hinzufügen:';
    $amsg[63] = 'Löschen/Speichern';
    $amsg[64] = 'Banner editieren';
    $amsg[65] = 'Bitte die im Anhang befindliche BackUp-Datei abspeichern.';
    $amsg[66] = 'Das Backup der DB-Einträge im Gästebuch<br />wurde erfolgreich erstellt.';
    $amsg[67] = 'Eine Kopie der BackUp-Datei wurde per E-Mail verschickt.';
    $amsg[68] = 'Den E-Mail Anhang bitte an einem sicheren Ort speichern.';
    $amsg[69] = 'Wählen Sie aus den aufgeführten Dateien eine aus.';
    $amsg[70] = 'Folgende BackUp-Dateien sind vorhanden:';
    $amsg[71] = 'Dateiname:';
    $amsg[72] = 'Sperrung des GB-Eintrags!';
    $amsg[73] = 'Markierte Wiederherstellen';
    $amsg[74] = '<p class="zentriert">Beim Wiederherstellen von Gästebuch-Einträgen aus einem Backup</p><p class="zentriert">werden die alten Datenbank-Einträge gelöscht!</p>';
    $amsg[75] = 'Freigabe des GB-Eintrags!';   
    $amsg[76] = 'Mit FTP hochgeladene BackUp-Datei der BackUp-Liste hinzufügen:';    
    $amsg[77] = 'Alle im Verzeichnis "backup" enthaltenen<br />Sicherungsdateien sind in der Datenbank erfasst.';    
    $amsg[78] = 'Dateinamen speichern';    
    $amsg[79] = 'Sie haben nicht alle Felder ausgefüllt.';    
    $amsg[80] = 'Sie haben unter "Allgemeine Konfiguration" die Option:<br />"Alle BackUps vom Server löschen" aktiviert.<br /><br />Das soeben erstellte BackUp wurde daher wieder gelöscht.<br /><br />Deshalb sollte die per E-Mail verschickte BackUp-Datei an einem sicheren Ort gesondert gespeichert werden.';    
    $amsg[81] = 'Es wurde eine neue BackUp-Datei gefunden,<br />die noch nicht in der Datenbank erfasst ist.<br /><br />Zum Speichern in der Datenbank die Datei im Drop-Down-Menü<br />auswählen und auf "Dateinamen speichern" klicken.';
    $amsg[82] = 'Hilfe';
    $amsg[83] = 'Sie haben unter "Allgemeine Konfiguration" die Option:<br />"Alle BackUps vom Server löschen" aktiviert.<br /><br />Es wurden daher alle auf dem Server befindlichen myPHP Guestbook-BackUps<br />einschließlich dem soeben zur Wiederherstellung verwendeten wieder gelöscht.';
    $amsg[84] = 'Beitrag';
    $amsg[85] = 'vom';
    $amsg[86] = 'schrieb am';
    $amsg[87] = 'Noch kein BackUp vorhanden.<br />Sie sollten regelmäßig ein BackUp Ihrer Gästebucheinträge erstellen.';
    $amsg[88] = 'Achtung!\\n\\nNeben dem Datenbankeintrag wird auch die Bilddatei vom Server gelöscht.\\n\\nDie Aktion kann nicht rückgängig gemacht werden!\\n\\nFortfahren?';
    $amsg[89] = 'Text freigegeben?';
    $amsg[90] = 'Bild freigegeben?';
    $amsg[91] = 'Gepostete Bilder';
    $amsg[92] = 'Datei-Uploads bearbeiten';
    $amsg[93] = 'Hier werden die im Gästebuch eingestellten Bilder angezeigt.';
    $amsg[94] = 'Neues Bild manuell einfügen ?';
    $amsg[95] = 'Die zu löschende Datei markieren.\\n\\nAchtung!\\n\\nDie Aktion kann nicht rückgängig gemacht werden!\\n\\nFortfahren?';
    $amsg[96] = 'Eintrag bearbeiten';
    $amsg[97] = 'Titel:';
    $amsg[98] = 'Hier werden die im Gästebuch eingestellten Bilder angezeigt';
    $amsg[99] = 'Die Upload-Funktion für Bilder in Gästebucheinträgen ist nicht aktiviert.';
    $amsg[100] = 'Wenn Sie dieses Feature nutzen möchten, müssen Sie "BBCodes" und "Bilder in Gästebucheinträgen anzeigen" unter "Allgemeine Konfiguration" aktivieren.';
    $amsg[101] = 'Datenbankeintrag des Bildes bearbeiten.<br />Bei Bedarf die Ausrichtung von *jpg-Dateien korrigieren.';
    $amsg[102] = 'Neues Bild in Datenbank eintragen';
    $amsg[103] = 'Upload Konfiguration';
    $amsg[104] = 'Hier können Einstellungen zum Datei-Upload vorgenommen werden.';
    $amsg[105] = '<br />Maximal zulässige Größe der hochzuladenden Datei in MB:<br /><span class="size-10">(1 - 6 MB | Eingabe wirksam je nach Konfiguration des Servers -<br /><strong class="red">Beachten Sie auch den Hinweis unter "Info"!</strong>)</span>';
    $amsg[106] = '<br />Maximale Breite der Grafik in Pixel:<br /><span class="size-10">(Die Obergrenze liegt aktuell bei';
    $amsg[107] = '<br />und variiert je nach gewählter Breite des Gästebuchs)</span>';
    $amsg[108] = '<br />Maximale Höhe der Grafik in Pixel:';
    $amsg[109] = '<br />Bildqualität in Prozent:<br /><span class="size-10">(empfohlen 70 - 80%)</span>';
    $amsg[110] = 'Hier können Sie Grundeinstellungen des Template verändern.';
    $amsg[111] = 'Zitieren von Beiträgen aktivieren:';
    $amsg[112] = 'Noch keine Bilder vorhanden.';
    $amsg[113] = 'Auswahl websichere Farben und Grautöne';
    $amsg[114] = 'Websichere Farben und Grautöne';
    $amsg[115] = 'Die als "websicher" geltenden 216 Farben und 256 Grautöne';
    $amsg[116] = 'Wenn Sie keine bestimmte Farbe festlegen, wird automatisch "transparent" eingetragen.';
    $amsg[117] = '<br />Maximale Anzahl der zugelassenen Datei-Uploads<br />je Posting:<br /><span class="size-10">(20 Min. IP-Sperre für über dem Limit liegende Uploads.)</span>';
    $amsg[118] = 'Fenster schließen';
    $amsg[119] = 'Info';
    $amsg[120] = 'E-Mail Adresse beim Gästebucheintrag';
    $amsg[121] = 'Pflichtfeld,<br />E-Mail Adressen werden im Gästebuch ...';
    $amsg[122] = 'kein';
    $amsg[123] = 'ist';
    $amsg[124] = 'angezeigt:';
    $amsg[125] = 'nicht angezeigt:';
    $amsg[126] = 'Eintragsfeld für "Ort"';
    $amsg[127] = 'Eintragsfeld für "Land"';
    $amsg[128] = 'Eintragsfeld für "Betreff" <strong>verbergen</strong>:';
    $amsg[129] = 'Herkunft';
    $amsg[130] = 'E-Mail Konfiguration';
    $amsg[131] = 'Hier bestimmen Sie die Absender-Adresse für alle vom Programm<br />automatisch verschickten E-Mails und den Text, der dem Gast<br />nach einem Eintrag im Gästebuch per E-Mail übermittelt wird.';
    $amsg[132] = 'E-Mail-Adresse editieren';
    $amsg[133] = 'Deutsch';
    $amsg[134] = 'Englisch';
    $amsg[135] = 'Text E-Mail';
    $amsg[136] = 'Um die "Danke-E-Mail" zu ändern, muss die Option:<br /><strong>"Per E-Mail für Gästebucheintrag bedanken"</strong><br />unter <strong>"Allgemeine Konfiguration"</strong> aktiviert sein.';
    $amsg[137] = '"Danke-E-Mail" an Gast aktiviert?';
    $amsg[138] = 'E-Mail editieren';
    $amsg[139] = 'Platzhalter für "Ort / Land".';
    $amsg[140] = 'Platzhalter für "aus: "';
    $amsg[141] = 'Aktion erfolgreich abgeschlossen';
    $amsg[142] = 'Link zum Admin-Control-Panel anzeigen:';
    $amsg[143] = 'Platzhalter für HTML-Tag Zeilenumbruch "&#60;br /&#62;"';
    $amsg[144] = 'Drücken Sie eine beliebige Taste auf Ihrer Tastatur';
    $amsg[145] = 'Gespeicherte IPs aus alten Einträgen löschen?';
    $amsg[146] = 'E-Mail Absender-Adresse oder<br />Text für \'Danke-E-Mail\' ändern?';
    $amsg[147] = 'Der Text für die "Danke-E-Mail" kann ebenso wie der Absender für alle vom Programm automatisch verschickten E-Mails geändert werden unter dem Link: <div class="text-center"><br />"<a href="?action=thanks_email&#38;show=guest_mail&#38;'.session_name().'='.session_id().'" title="Zum Ändern Link anklicken">E-Mail Konfiguration</a>"</div>.';
    $amsg[148] = 'Link zur Seite für Gästebucheinträge:';
    $amsg[149] = '<p>Legen Sie über die Auswahl der Radio-Buttons fest, ob der Link oberhalb und unterhalb der Gästebucheinträge zur Seite für neue Einträge als anklickbarer Text oder als Button oder gar nicht (Blog-Modus) erscheinen soll.</p><p>In das entsprechende Textfeld geben Sie ein, wie der anklickbare Text bzw. die Beschriftung des Buttons lauten soll.</p><p>Der Text kann bis 35 Zeichen lang sein.</p><p>Wenn Sie keinen Text eingeben, wird die Vorgabe aus der Sprachdatei verwendet.</p>Für zusätzliche Erläuterungen siehe unter dem Link <a href="?action=help&#38;'.session_name().'='.session_id().'#anchor-LinkButton" title="Aufruf der Hilfe-Datei">"Hilfe" Abschnitt IV.3.2.2.</a>.';
    $amsg[150] = 'Sicherheitshinweis';
    $amsg[151] = 'E-Mail-Adresse, die als <strong>Absender</strong> der vom Programm automatisch verschickten E-Mails angezeigt wird.';
    $amsg[152] = 'Die E-Mail-Adresse, die als Absender der vom Programm automatisch verschickten E-Mails verwendet wird (E-Mail Header "From"), sollte möglichst nicht identisch sein mit der Admin-E-Mail-Adresse.';
    $amsg[153] = 'Bitte schauen Sie in Ihren E-Mail-Eingang.';
    $amsg[154] = 'Login deaktiviert!';
    $amsg[155] = '<b>Achtung!</b><br /><br />Es gab ';
    $amsg[156] = ' fehlerhafte Versuche zum Login in des Admin Bereich.<br /><br />Das Login wurde gesperrt und sollte zur Sicherheit vor weiteren Versuchen, dort unberechtigt einzudringen, einige Tage gesperrt bleiben.<br /><br />Das Login wird nach ';
    $amsg[157] = ' Tagen automatisch wieder freigeschaltet. Falls Sie es vorher wieder freigeben möchten, bitte den folgenden Link anklicken:';
    $amsg[158] = 'Die Eingaben wurden gespeichert.';
    $amsg[159] = 'Check-Box für "Info-E-Mail" an Gast bei<br />Kommentierung seines Eintrags <strong>verbergen</strong>:';
    $amsg[160] = 'Info-E-Mail an Gast';
    $amsg[161] = 'Bei Aktivierung dieser Option wird unter dem Eingabefeld für den Gästebucheintrag eine Check-Box eingeblendet, mit der der Gast wählen kann, ob er über einen Kommentar zu seinem Gästebucheintrag automatisch per E-Mail informiert werden möchte.<br /><br /><strong>Achtung:</strong> Wenn das Inputfeld für die Eingabe einer E-Mail-Adresse verborgen wird, wird die Option "Info-E-Mail an Gast" ebenfalls automatisch deaktiviert!';
    $amsg[162] = 'Dein Gästebucheintrag';
    $amsg[163] = 'Hallo Gast,<br /><br />Dein Eintrag im Gästebuch auf der Website "'.$_SERVER['SERVER_NAME'].'" wurde kommentiert.<br /><br />Gruss Administrator';
    $amsg[164] = 'Der Gast wird über den Admin-Kommentar per E-Mail informiert.';
    $amsg[165] = 'E-Mail an Gast bei Admin-Kommentar?';
    $amsg[166] = 'E-Mail an Gast wenn sein Eintrag zitiert wird?';
    $amsg[167] = 'JA';
    $amsg[168] = 'NEIN, schon erledigt.';
    $amsg[169] = 'Text-Link';
    $amsg[170] = 'Html-Button';
    $amsg[171] = 'Text des Links/Buttons:';
    $amsg[172] = 'Link entfernen (Blog-Modus)';
    $amsg[173] = 'Niederländisch';
    $amsg[174] = 'Portugiesisch';
    $amsg[175] = 'Zitatfunktion';
    $amsg[176] = 'Bei einem Betrieb des Gästebuchs im sogen. "Blog-Modus", lässt sich die Zitatfunktion nicht aktivieren bzw. wird automatisch deaktiviert.';
    $amsg[177] = 'Admin Blog';
    $amsg[178] = 'Hier können Sie einen neuen Eintrag verfassen.';
    $amsg[179] = 'Gästebuch im Blog-Modus?';
    $amsg[180] = 'Blog-Modus';
    $amsg[181] = '<p>Die Links auf der öffentlichen Seite mit den Gästebucheinträgen ("index.php") zur Seite für einen neuen Eintrag ("insert.php") sind ausgeblendet.</p>
<p>Die Eintragsseite ("insert.php") und die Seite für Foto-Uploads ("pic.upload.php") sind im Web nicht mehr aufrufbar.</p>
<p>Neue Einträge und Foto-Uploads sind nur noch durch den Admin hier im Control-Panel möglich.</p>
Einstellung des Blog-Modus unter dem Link "<a href="?action=guestbook_options&#38;'.session_name().'='.session_id().'" title="Zum Ändern Link anklicken">Allgemeine Konfiguration</a>", dort: "Link zur Seite für Gästebucheinträge".';
    $amsg[182] = 'Spam-Verdacht: Der Gästebucheintrag beginnt mit einem Link.';
    $amsg[183] = 'Die verwendete Sprache entspricht der Auswahl unter \'Allgemeine Konfiguration\'.';
    $amsg[184] = 'Aktuelle Spracheinstellung:';
    $amsg[185] = 'Bewertungsfunktion';
    $amsg[186] = 'Bewertungsfunktion Grafik';
    $amsg[187] = 'Text zur Bewertungsfunktion';
    $amsg[188] = 'Hier können Sie die Bewertungsfunktion aktivieren, mit der der Gast bei einem Eintrag ins Gästebuch zwischen 1 und 5 Sternen vergeben kann, die in seinem Beitrag dann angezeigt werden.
<p>Beim Anklicken der Bewertung im Gästebucheintrag wird ein kurzer erläuternder Text eingeblendet, je nach Einstellung mit oder ohne Anzeige des Durchschnittswerts aller abgegebenen Bewertungen.</p>
<p>In das Textfeld darunter können Sie eingeben, was der Gast bewerten soll, z.B. Ihre Website, dort veröffentlichte Fotos o.ä..</p>
<p>Es können bis zu 35 Zeichen eingegeben werden. Der Text sollte aber so kurz wie möglich sein.</p>
Wenn Sie keinen Text eingeben, wird die Vorgabe aus der Sprachdatei verwendet.';
    $amsg[189] = 'Einige CSS-Code-Beispiele für individuelle Anpassungen in den Link- und Schriftfarben, Schattenfarben u.a. finden Sie unter dem Link "<a href="?action=help&#38;'.session_name().'='.session_id().'#anchor-EditStyle">Hilfe", Abschnitt IV. 3.4.2, "Style editieren</a>"';
    $amsg[190] = 'Alle Einstellungen für diese Variablen erfolgen über die Eingabefelder unter dem Link: "<a href="?action=edit_template&#38;'.session_name().'='.session_id().'">Template editieren</a>".';
    $amsg[191] = 'Für unterschiedliche Schriftfarben auf der "index.php" und der "insert.php" siehe das Beispiel unter dem Link "<a href="?action=help&#38;'.session_name().'='.session_id().'#anchor-EditStyle">Hilfe", Abschnitt IV. 3.4.2, "Style editieren</a>"';
    $amsg[192] = 'Dokumentation';
    $amsg[193] = 'deaktivieren';
    $amsg[194] = 'aktivieren <strong class="red">ohne</strong> Durchschnittswert';
    $amsg[195] = 'aktivieren <strong class="red">mit</strong> Durchschnittswert';
    $amsg[196] = '<p class="size-14"><strong>Ihr Admin-Passwort ist nicht optimal gesichert.</strong></p>';
    $amsg[197] = '<p class="red size-14"><strong>Sie sollten Ihr Passwort jetzt neu eingeben,<br />damit es mit einem sichereren Hash-Wert gespeichert wird.</strong></p>';
    $amsg[198] = 'verbergen';
    $amsg[199] = 'Achtung! Datenschutz beachten!';
    $amsg[200] = 'Sie sollten ein neues Passwort zum Login eingeben.';
    $amsg[201] = 'Die Tabelle mit den Login-Daten ist beschädigt.';
	$amsg[202] = 'Anklicken zum Ändern.';
	$amsg[203] = 'Laden Sie die Bilddatei (Format *.jpeg, *.png oder *gif) in das Verzeichnis "img_guest" auf dem Server. - <strong>Beachten Sie Breite und Höhe des Bildes und verkleinern es ggf. vor dem Upload.</strong> (Nach dem derzeit gewählten Template sollte die Breite des Bildes max. betragen:';
	$amsg[204] = 'Die neue Datei wird unten im Drop-Down-Menü angezeigt und kann ausgewählt werden. Auf den eingeblendeten Button "Dateinamen speichern" klicken.';
	$amsg[205] = 'Die Daten der Datei werden automatisch in die Datenbank eingetragen. Den vorformulierten Title können Sie anschließend durch einen Klick auf das Edit-Icon: <img class="img-ok" title="Eintrag bearbeiten" src="../images/edit.png" width="14" height="14" alt="Eintrag bearbeiten" /> bearbeiten.';
	$amsg[206] = 'Link deaktiviert!';
	$amsg[207] = '<p>Wenn Sie aus dem Admin-Panel einen Link zu einer anderen URL anklicken, wird die Session-Id mit dem Referrer übertragen und ist für den Empfänger über die Log-Datei sichtbar.</p>
<p>Damit besteht die Gefahr, dass sich dieser Dritte Zugang zum Admin-Control-Panel verschaffen kann, wenn auch nur für die begrenzte Zeit bis zur Zerstörung der Session.</p>
Um jedes Risiko auszuschließen, werden deshalb Links in diesem Bereich deaktiviert.';
	$amsg[208] = 'Bezeichnung für "Betreff"-Feld ändern:';
	$amsg[209] = '<p>Auch wenn das Gästebuch nicht aktiviert ist, können Sie hier Einträge verfassen und in der Datenbank speichern.</p>Diese Einträge sind aber erst nach der Aktivierung des Gästebuchs öffentlich sichtbar.';
	$amsg[210] = 'Session lifetime';
	$amsg[211] = 'Session beendet';
	$amsg[212] = 'Schrift';
	$amsg[213] = 'Schriftgröße';
	$amsg[214] = '<span class="aligncenter"><strong>Hinweis:</strong></span><br />Bei einer Monitorbreite von weniger als 501px wird die Schriftgröße automatisch auf 14px eingestellt.';
	$amsg[215] = 'Link Farbe';
	$amsg[216] = 'Hover Farbe';
	$amsg[217] = 'Platzhalter für Schriftart';
	$amsg[218] = 'Platzhalter für Schriftgröße';
	$amsg[219] = 'Platzhalter für Link Farbe';
	$amsg[220] = 'Platzhalter für Link hover Farbe';
	$amsg[221] = 'Test E-Mail';
	$amsg[222] = 'E-Mail Versand erfolgreich.';
	$amsg[223] = 'Bitte kontrollieren Sie Ihr E-Mail Postfach.';
	$amsg[224] = 'E-Mail Versand nicht erfolgreich.';
	$amsg[225] = 'Test E-Mail versenden';
	$amsg[226] = 'Formular für neue Einträge<br />gleiche Breite wie Gästebuch?<br /><span class="size-10">(Grundeinstellung: max-width = 550px)</span>';
	$amsg[227] = 'automatisch:';
	$amsg[228] = 'jetzt:';
	$amsg[229] = 'BackUp verwenden:';
	$amsg[230] = 'Nur Text, kein Banner';
	$amsg[231] = 'Falls Sie nur einen Begrüßungstext ohne ein Banner wünschen, markieren Sie die entsprechende Checkbox und klicken auf "OK".';
	$amsg[232] = 'Es ist bereits ein Text ohne Banner vorhanden.<br />Editieren Sie den vorhandenen Text nach Ihren Wünschen.';
	$amsg[233] = 'Nur Begrüßungstext ohne Banner hinzufügen';
	$amsg[234] = 'Link zur Datenschutzerklärung anzeigen:';
	$amsg[235] = 'URL zur Datenschutzerklärung:';
	$amsg[236] = 'Datenschutz-Hinweis:';
	$amsg[237] = 'Wenn Sie auf Ihrer Website eine Seite mit einer Datenschutzerklärung anbieten, haben Sie hier die Möglichkeit, den Link zu dieser Seite auf den beiden Seiten des Gästebuchs "index.php" und "insert.php" anzeigen zu lassen.
<p>Aktivieren Sie dazu die entsprechende Option und tragen Sie in das Feld darunter die URL zur Seite mit der Datenschutzerklärung ein.</p>
Wenn Sie mehr darüber wissen möchten, wie und bei welchen Anlässen vom Script Cookies benutzt und IPs verarbeitet werden und welche Möglichkeiten Sie haben, dies zu beeinflussen, lesen Sie die Abschnitte III.5. in der Hilfe, "<a href="?action=help&#38;'.session_name().'='.session_id().'#anchor-Cookie">Datenschutz und das myPHP Guestbook</a>".';
	$amsg[238] = 'Menü öffnen';
	$amsg[239] = 'Menü';
	$amsg[240] = 'Link testen';
	$amsg[241] = 'Der Gast muss der Verarbeitung seiner Eingaben<br />durch markieren einer Checkbox ausdrücklich zustimmen:';
	$amsg[242] = 'Zur Zeit online:';
	$amsg[243] = 'Bitte gültigen Hexadezimal-Farb-Code eingeben!\\n\\n(Raute und 3 oder 6 Zeichen)';
	$amsg[244] = 'Farbmuster für diesen RGB-Code';
	$amsg[245] = 'Deckkraft';
	$amsg[246] = 'Als Admin-E-Mail-Adresse sollte ein gesonderter E-Mail Account gewählt werden, der ansonsten nicht benutzt wird und anderen Personen unbekannt ist.';
	$amsg[247] = 'gutes Passwort';
	$amsg[248] = 'schlechtes Passwort';
	$amsg[249] = 'Passwort sichtbar machen:';
	$amsg[250] = 'Bild drehen';
	$amsg[251] = 'Keine Änderung';
	$amsg[252] = '90° nach rechts';
	$amsg[253] = '90° nach links';
	$amsg[254] = 'Aktion erfolgreich.';
	$amsg[255] = 'Wenn ein Bild nach einer Drehung unverändert angezeigt wird, leeren Sie den Browser-Cache und laden die Seite neu.';
	$amsg[256] = 'Aktivierung innerhalb der EU empfohlen!';
	$amsg[257] = 'Suchfunktion aktivieren:';
	$amsg[258] = 'Permalinks aktivieren:';
	$amsg[259] = 'Platzhalter für das verlinkte Permalink-Icon.';
	$amsg[260] = 'Bei gleichzeitiger Aktivierung der Suchfunktion und der Sprachauswahl durch den Gast sollte das Template mindestens 500px oder breiter sein.<br /><br />Für weitere Einzelheiten siehe unter dem Link "<a href="?action=help&#38;'.session_name().'='.session_id().'#anchor-search">Hilfe", Abschnitt IV. 3.2.2.d, "Suchfunktion aktivieren</a>"';
    $amsg[261] = 'Ihre PHP- und MySQL-Version';
    $amsg[262] = 'Sie verwenden PHP Version';
    $amsg[263] = 'Sie verwenden MySQL-Version';
    $amsg[264] = 'DSGVO';
    $amsg[265] = 'IP für '.$delete_spamIps.' Tage speichern, wenn ein Eintrag<br />wegen Spam verworfen wurde?';
    $amsg[266] = 'Das Speichern von IPs nach Spam-Einträgen ist deaktiviert.';
    $amsg[267] = 'Erweiterter Datenschutz';
    $amsg[268] = 'Die Verarbeitung von IPs und das Setzen von Cookies<br />auf dem Endgerät des Gastes vollständig verhindern?';
    $amsg[269] = 'Wenn diese Checkbox markiert ist, sind folgende Funktionen des <span class="italic nowrap">myPHP Guestbook</span> deaktiviert:';
    $amsg[270] = 'Wenn Sie diese Checkbox markieren und auf "Speichern" klicken, werden folgende Funktionen des <span class="italic nowrap">myPHP Guestbook</span> deaktiviert:';
    $amsg[271] = 'Achtung!';
    $amsg[272] = 'die Sprachauswahl durch den Gast';
    $amsg[273] = 'die Suchfunktion';
    $amsg[274] = 'die Statistik über die Aufrufe des Gästebuchs';
    $amsg[275] = 'der Upload von Bilddateien durch den Gast';
    $amsg[276] = 'die Erfassung und befristete Sperrung von IPs, unter denen Spameinträge erfolgt sind';
    $amsg[277] = 'der Schutz vor automatischen Masseneinträgen (Flood-Sperre)';
    $amsg[278] = 'Deaktivierte Funktionen können nur einzeln jede für sich oben erneut aktiviert werden.';
    $amsg[279] = 'Alle gespeicherten IPs und IP-Hashes gelöscht.';
    $amsg[280] = 'Außerdem werden alle in der Datenbank gespeicherten IPs und IP-Hashes gelöscht.';
    $amsg[281] = 'Emojis automatisch aus einem Eintrag löschen,<br />wenn mehr als '.$maxSmilies.' Stück verwendet werden?';
    $amsg[282] = 'Wenn ein Gast neue Bilddateien hochgeladen und in seinen Eintrag eingefügt hat, denken Sie daran, auch die Dateien im Verzeichnis "img_guest" vom Server auf Ihren Rechner zur Sicherung herunter zu laden.';
    $amsg[283] = 'Falls es Probleme beim Upload gibt, laden Sie die Datei per FTP in das Verzeichnis "banner".';
    $amsg[284] = 'Falls es Probleme beim Upload gibt, laden Sie die Datei per FTP in das Verzeichnis "img_guest".';
    $amsg[285] = 'Zwei-Faktor-Authentisierung';
    $amsg[286] = 'Zweites Passwort';
    $amsg[287] = 'Geben Sie den folgenden Code zum Login in den Admin-Bereich ein:';
    $amsg[288] = 'Der Code ist 3 Minuten gültig, bevor er verfällt.';
    $amsg[289] = 'Mehr ...';
    $amsg[290] = 'Wegen weiterer Konfigurationsmöglichkeiten öffnen Sie die Datei "<span class="blue">settings.inc.php</span>" im Verzeichnis "<span class="blue">includes</span>" und lesen Sie die Erläuterungen unter "<a href="?action=help&#38;'.session_name().'='.session_id().'#anchor-MoreKonfig">Hilfe ==> Weitere Konfigurationsmöglichkeiten</a>".';
	$amsg[291] = 'Wenn Sie keine bestimmte Farbe festlegen, wird automatisch "weiß" eingetragen.';
	$amsg[292] = 'das Zitieren von Beiträgen durch den Gast';
	$amsg[293] = '';
	$amsg[294] = '';
	$amsg[295] = '';
	$amsg[296] = '';
	$amsg[297] = '';
	$amsg[298] = '';
	$amsg[299] = '';
    $amsg[300] = 'Benutzername schon vorhanden!<br />Bitte wählen Sie einen anderen Benutzernamen.';
    $amsg[301] = 'E-Mail-Adresse schon vorhanden!<br />Bitte wählen Sie eine andere E-Mail-Adresse.';
    $amsg[302] = 'Wenn Sie diese Option aktivieren, haben Sie die Möglichkeit, ein eigenes Banner und auf Wunsch auch einen individuellen Begrüßungstext auf den Gästebuchseiten anzeigen zu lassen.<br /><br />Diese Funktion ist bei Nutzung der Dateien aus dem "include"-Download nicht verfügbar.<br /><br />Für weitere Einzelheiten siehe unter dem Link "<a href="?action=help&#38;'.session_name().'='.session_id().'#anchor-banner">Hilfe", Abschnitt IV. 3.5, "Banner und individueller Begrüßungstext</a>"';
    $amsg[303] = 'Bearbeiten Sie hier Ihre Admin-Zugangsdaten<br />und Ihre Admin-E-Mail-Adresse:';
    $amsg[304] = 'Hier können Sie bis zu drei Personen reduzierte<br />"Moderatoren-Rechte" einräumen:';
    $amsg[305] = 'Reduzierte Moderatorenrechte';
    $amsg[306] = 'Moderatoren können sich mit eingeschränkten Rechten ins Admin-Panel einloggen.
<p>Moderatoren können Gästebuch-Einträge und eingestellte Bilder sperren oder freigeben und Einträge kommentieren aber <strong>keine Einträge oder Bilder löschen oder editieren</strong>.</p>
<p>Moderatoren können ferner BackUps erstellen und BackUps einspielen, sowie die Statistik und die "Hilfe"-Datei einsehen.</p>
<p>Mit diesen Einschränkungen haben Moderatoren also Zugriff und Bearbeitungsmöglichkeiten unter den verlinkten Seiten in der Navigation unter "Einträge", "Backup" und "Sonstiges".</p>
<p>Alle weiteren Admin-Optionen sind für Moderatoren gesperrt bzw. nicht zugänglich.</p>
<p>Sie können festlegen, dass ein Moderator wie Sie als Admin vom Programm ebenfalls automatisch über neue Gästebucheinträge und Dateiuploads per E-Mail informiert wird.</p>
Testen Sie die Möglichkeiten eines Moderators durch Eingabe einer Test-Person.';
    $amsg[307] = 'Vorhandene Moderatoren:';
    $amsg[308] = 'Flagge';
    $amsg[309] = 'Markierten Eintrag bearbeiten oder löschen';
    $amsg[310] = 'Achtung!\\n\\nDie Aktion kann nicht rückgängig gemacht werden!\\n\\nFortfahren?';
    $amsg[311] = 'Sprache';
    $amsg[312] = 'Eintrag von';
    $amsg[313] = 'bearbeiten';
    $amsg[314] = 'Es wurde keine Auswahl getroffen!';
    $amsg[315] = 'Bitte nur einen Eintrag zur Bearbeitung auswählen!';
    $amsg[316] = 'Neuen Moderator eintragen';
    $amsg[317] = 'Eingabe neues Passwort optional';
    $amsg[318] = 'Beim Benutzernamen nur Buchstaben, Ziffern und<br />: - , . ? ! ( ) zulässig.';
    $amsg[319] = 'Update-Prüfung myPHP Guestbook';
    $amsg[320] = 'Die von Ihnen genutzte Version des <span class="italic">myPHP Guestbook</span> konnte nicht ermittelt werden.<br />Prüfen Sie die Variable "&#36;version" in der Datei "'.$lang_short.'.php", Ordner "lang".';
    $amsg[321] = 'Sie nutzen <span class="italic">myPHP Guestbook</span> '.$version.'.<br />Aktuell ist die Version';
    $amsg[322] = 'Sie sollten ein Update durchführen.';
    $amsg[323] = 'Zur Download-Seite von "www.php-guestbook.de"<br />den Button unten anklicken.';
    $amsg[324] = 'Zur Download-Seite von <span class="italic">myPHP Guestbook</span>';
    $amsg[325] = 'Sie nutzen bereits die aktuelle Version des <span class="italic">myPHP Guestbook</span>.';
    $amsg[326] = 'Update prüfen';
    $amsg[327] = 'Eintrag kommentieren';
    $amsg[328] = '<p>Wenn Sie den Upload von großen Dateien mit mehr als ~&nbsp;2&nbsp;bis&nbsp;3&nbsp;MB zulassen, sollte die maximale Laufzeit eines Scripts bei über 60 Sekunden liegen und der User sollte eine entsprechend schnelle Internetverbindung nutzen.</p><p>Die maximal ausführbare Verarbeitungszeit eines Scripts ist bei praktisch allen Providern begrenzt. Alles, was nicht innerhalb dieser Zeit vom Script verarbeitet werden kann, wird im Bearbeitungsprozess abgebrochen.</p>';
    $amsg[329] = 'Die maximale Laufzeit eines Scripts ist durch Ihren Provider auf';
    $amsg[330] = 'Sekunden';
    $amsg[331] = 'festgelegt';
    $amsg[332] = 'Achtung';
    $amsg[333] = 'Die maximale Größe, die eine hochgeladene Datei haben darf, wurde von Ihrem Provider auf';
    $amsg[334] = 'Die maximale Größe, die eine hochgeladene Datei haben darf, wurde von Ihrem Provider auf weniger als';
    $amsg[335] = 'Individuelle Sprachauswahl durch den Gast ...';
    $amsg[336] = 'deaktivieren';
    $amsg[337] = 'aktivieren <strong class="red">ohne</strong> Cookie-Hinweis:';
    $amsg[338] = 'aktivieren <strong class="red">mit</strong> Cookie-Hinweis:';   
    $amsg[339] = 'empfohlene Einstellung';   
    $amsg[340] = 'Anklicken für weitere Informationen';   
    $amsg[341] = 'Eintrag zum Banner bearbeiten.';
    $amsg[342] = 'Die Anzeige und Bearbeitung eines individuellen Banners mit Begrüßungstext<br />ist nicht aktiviert.';
    $amsg[343] = 'Wenn Sie dieses Feature nutzen möchten, müssen Sie "Banner aktivieren"<br />unter "Allgemeine Konfiguration" markieren.';
    $amsg[344] = 'Es wurde eine neue Grafik-Datei im Verzeichnis "banner" gefunden.';
    $amsg[345] = 'Es sind alle im Verzeichnis "banner"<br />befindlichen Grafik-Dateien in der Datenbank erfasst.';
    $amsg[346] = 'Breite';
    $amsg[347] = 'Höhe';
    $amsg[348] = 'URL für Banner';
    $amsg[349] = 'Individueller<br />Begrüßungstext';
    $amsg[350] = 'Zeichen';
    $amsg[351] = 'Diesen Eintrag auswählen';
    $amsg[352] = 'Kein Banner in der Datenbank erfasst.';
    $amsg[353] = 'Die in der Datenbank erfassten Banner werden hier angezeigt und können bearbeitet werden';
    $amsg[354] = 'max.';
    $amsg[355] = 'Eintrag ausgewählt?';
    $amsg[356] = 'Editieren';
    $amsg[357] = 'Eintrag und Datei löschen';
    $amsg[358] = 'In das Verzeichnis "banner" hochgeladene Grafik der Banner-Liste hinzufügen';
    $amsg[359] = 'Link zur Startseite der Homepage.';
    $amsg[360] = '[b]Ich begrüße Sie im Gästebuch meiner Homepage.[/b]\r\n\r\nHier können Sie Ihre Meinung oder Fragen zu dem Thema dieser Website veröffentlichen oder einfach nur einen kurzen Gruß hinterlassen. Ich freue mich über jedes Feedback eines Besuchers.\r\n\r\nPositive und negative Kritik helfen dabei, gut Gelungenes zu vertiefen und weniger gut Gelungenes zu verbessern.';
	$amsg[361] = 'Diese Funktion ist bei Nutzung der Dateien<br />aus dem "include"-Download nicht verfügbar.';
	$amsg[362] = 'Bei Nutzung der Dateien aus dem<br />"include"-Download nicht verfügbar.';
	$amsg[363] = 'Slowakisch';
	$amsg[364] = 'Tschechisch';
	$amsg[365] = 'Login-Sperre';
	$amsg[366] = 'Diesen Banner aktivieren oder editieren';
	$amsg[367] = 'E-Mail bei neuem Eintrag<br />auch an diesen Moderator?';
	$amsg[368] = 'In das Verzeichnis "img_guest" hochgeladenes Bild in die Datenbank aufnehmen:';
	$amsg[369] = 'Es wurde eine neue Bild-Datei im Verzeichnis "img_guest" gefunden.';
	$amsg[370] = 'Es sind alle im Verzeichnis "img_guest"<br />befindlichen Bild-Dateien in der Datenbank erfasst.';
	$amsg[371] = 'Banner';
	$amsg[372] = 'Banner anzeigen';
	$amsg[373] = 'Banner hinzufügen';
	$amsg[374] = 'So fügen Sie Ihren eigenen Banner ein';
	$amsg[375] = 'Laden Sie Ihr Banner (Format *.jpeg, *.png oder *.gif) in das Verzeichnis "banner" auf dem Server.';
	$amsg[376] = 'Sollte die neue Datei nach dem Hochladen nicht sofort unten im Drop-Down-Menü angezeigt werden, laden Sie diese Seite neu in Ihrem Browser.';
	$amsg[377] = 'Das neue Banner wird unten im Drop-Down-Menü angezeigt und kann ausgewählt werden. Auf den Button "Dateinamen speichern" klicken.';
	$amsg[378] = 'Die Daten des Banners werden automatisch in die Datenbank eingetragen. Die vorformulierten Texte können Sie anschließend durch einen Klick auf das Edit-Icon: <img class="img-ok" title="Eintrag bearbeiten" src="../images/edit.png" width="14" height="14" alt="Eintrag bearbeiten" /> frei bearbeiten.';
	$amsg[379] = '<p>Eingaben in diesem Feld können vom Programm nicht automatisch übersetzt werden und werden daher nur in der vom Admin voreingestellten Sprache angezeigt.</p>Wird die Sprachauswahl durch den Gast freigeschaltet und wählt ein User eine andere Sprache, werden Eingaben in diesem Feld ignoriert und statt dessen der Text aus der gewählten Sprachdatei angezeigt.';
	$amsg[380] = 'Kein Eintrag vorhanden!';
	
// Ende Admin-Panel-Menü Phrasen

// Error-Messages

    $emsg[0] = 'Sie haben nicht alle Felder ausgefüllt';
    $emsg[1] = 'Daten sind falsch, überprüfen Sie Ihre Angaben.';
    $emsg[2] = 'E-Mail Adresse fehlt oder ist ungültig';
    $emsg[3] = 'Die Passwörter stimmen nicht überein';
    $emsg[4] = 'Während dem Erstellen des Backups trat ein Fehler auf';
    $emsg[5] = 'Sie haben keine Backup-Datei ausgewählt';
    $emsg[6] = 'Die Backup-Datei konnte nicht gefunden werden, überprüfen Sie den Inhalt des Ordners backup.';
    $emsg[9] = 'Sie haben keinen Namen angegeben';
    $emsg[10] = 'Sie haben keinen Text geschrieben';
    $emsg[11] = 'Es ist ein Fehler aufgetreten!';
    $emsg[12] = 'Ihr Zugang ist wegen des Spamschutzes noch gesperrt';
    $emsg[13] = 'Die aktuelle Download-Version des <span class="italic">myPHP Guestbook</span><br />konnte nicht ermittelt werden.<br /><br />Bitte versuchen Sie es später noch einmal.';
    $emsg[14] = 'Ihr Provider stellt bei Ihrem Hostingpaket<br />nicht die notwendigen Extensions bereit,<br />um diese Funktion nutzen zu können.';
    $emsg[15] = 'Wenn Sie unter aktiviertem Blog-Modus Grafik-Dateien im Gästebuch hochladen oder BBCodes oder Emojis verwenden wollen, müssen Sie die Verwendung von Cookies in Ihrem Browser zulassen.';
    $emsg[16] = 'Kein Eintrag ausgewählt.';
    $emsg[17] = 'Das Gästebuch ist derzeit deaktiviert';
    $emsg[18] = 'Bitte beim Feld "(max.) Breite des Gästebuchs" nur Ziffern angeben';
    $emsg[19] = 'Bei Hintergrund-Verlaufsfarben Eingabe "transparent" nicht zulässig!<br />Gespeicherter Wert nicht geändert.';
    $emsg[20] = 'Bei Hintergrund-Verlaufsfarben muss eine Eingabe erfolgen!<br />Gespeicherter Wert nicht geändert.';
    $emsg[21] = 'Unzulässiger MIME-Type! Nur Bilddateien im Format';
    $emsg[22] = 'Bitte beim Feld "Einträge pro Seite" nur Ziffern angeben';
    $emsg[23] = 'Bitte beim Feld "Anzahl Links bei der Blätterfunktion" nur Ziffern angeben';
    $emsg[24] = 'Bitte beim Feld "Flood Sperre in Minuten" nur positive ganze Zahlen, min. 0';
    $emsg[25] = 'Bitte beim Feld "Reload Sperre für Statistik in Minuten" nur Ziffern angeben';
    $emsg[26] = 'Die Datei ist zu gross, max. 20 Kilobyte!';
    $emsg[27] = 'Der gewählte BBCode wird bereits verwendet';
    $emsg[28] = 'Es ist bereits ein Style mit dem gewählten Namen vorhanden';
    $emsg[29] = 'Es ist bereits ein Template mit dem gewählten Namen vorhanden';
    $emsg[30] = 'Keine Badwords vorhanden';
    $emsg[31] = 'Keine Smileys vorhanden';
    $emsg[32] = 'Ihr Eintrag enthält zu viele Zeichen.';
    $emsg[33] = 'Ihr Eintrag enthält zu wenig Zeichen, min.:';
    $emsg[34] = 'Beim Datum nur Ziffern getrennt durch Punkte oder Bindestriche eingeben.';
    $emsg[35] = 'Bei der Uhrzeit nur Ziffern getrennt durch Doppelpunkt eingeben.';
    $emsg[36] = 'Sorry, der Eintrag existiert nicht oder wurde gesperrt.';
    $emsg[37] = 'Bitte beim Feld "Maximale Wortlänge" nur Ziffern angeben, min. 30 und max. 125';
    $emsg[38] = 'Dateiname zu lang';
    $emsg[40] = 'Bitte beim Feld "Anzahl der Spam-Punkte" nur Ziffern angeben, min. 1 und max. 20';
    $emsg[41] = 'Bitte beim Feld "Anzahl der unverdächtigen Links in Beiträgen" nur Ziffern angeben, min. 0 und max. 20';
    $emsg[42] = 'Sie haben keine Datei ausgewählt oder die Datei ist schon in der Datenbank erfasst.';
    $emsg[43] = 'Unzulässige Eingabe bei der IP: nur Kleinbuchstaben, Ziffern oder : oder .';
    $emsg[44] = 'Eingabe nicht vollständig.';
    $emsg[45] = 'Sie haben keine Backup Datei ausgewählt.';
    $emsg[46] = '- Bitte nur eine Datei zur Wiederherstellung auswählen!';
    $emsg[47] = 'Achtung!\\n\\nWenn drei Einträge vorhanden sind, wird die älteste BackUp-Datei aus den vorhandenen Einträgen gelöscht!\\n\\nFortfahren?';
    $emsg[48] = 'Unzulässige Zeichen bei der Schriftgröße';
    $emsg[49] = 'Achtung! Feststelltaste aktiviert.';
    $emsg[50] = 'Achtung!\\n\\nWenn Sie die Statistik löschen, werden auch die\\nSummen aller Besucher und Seitenaufrufe auf Null gesetzt.\\n\\nFortfahren?';
    $emsg[51] = 'Der letzte Style in der Datenbank kann aus Sicherheitsgründen nicht gelöscht werden!';
    $emsg[52] = 'Das letzte Template in der Datenbank kann aus Sicherheitsgründen nicht gelöscht werden!';
    $emsg[53] = 'Sie haben keine URL eingegeben';
    $emsg[54] = 'Die eingegebene URL ist ungültig';
    $emsg[55] = 'Zum Einfügen von BBCodes und Emojis in Ihren Beitrag muss Javascript aktiviert sein.';
    $emsg[56] = 'Falsche Eingabe! Nur Großbuchstaben, Ziffern und ? ! +';
    $emsg[57] = 'Zum Schutz vor Spam ist es nicht gestattet, URLs (Links) ohne Verwendung der Eingabemaske einzugeben. -- Bitte verwenden Sie den BBCode-Button mit dem Link-Symbol.';
    $emsg[58] = 'Zum Schutz vor Spam ist die Eingabe von URLs (Links) in einem Beitrag nicht gestattet.';
    $emsg[59] = 'Grösse Datei-Upload in MB: Nur Zahlen, min. 1, max. 6';
    $emsg[60] = 'Bei den Feldern "Breite" und "Höhe" nur Ziffern zulässig.';
    $emsg[61] = 'Bei der Bildbeschreibung nur Buchstaben, Ziffern<br />oder : - , . ? ! zulässig.';
    $emsg[62] = 'Bei den Schriften muss eine Farbe eingegeben werden.<br />- Eingabe "transparent" bei Schriftfarben nicht möglich.';
    $emsg[63] = 'Zeichen';
    $emsg[64] = 'Beim Feld "Dateiname" nur Buchstaben, Ziffern und Punkt zulässig.';
    $emsg[65] = 'Im Feld "max. Breite der Grafik" nur Ziffern, mind. 10, max.';
    $emsg[66] = 'Im Feld "max. Höhe der Grafik" nur Ziffern, mind. 10, max. 1000';
    $emsg[67] = 'Im Feld "Bildqualität" nur Ziffern, mind. 10, max. 100';
    $emsg[68] = 'Keine GD-Bibliothek verfügbar, Bild-Upload nicht möglich.';
    $emsg[69] = 'In den Feldern für Hintergrundfarben und Schriftfarben<br />nur Buchstaben, Ziffern oder #, keine Leerzeichen.';
    $emsg[70] = 'Sie müssen der Verarbeitung Ihrer Eingaben zustimmen!';
    $emsg[71] = 'Keine gültige Farbbezeichnung, siehe den Link unten:<br />"Auswahl websichere Farben ..."';
    $emsg[72] = 'Im Feld "(max.) Breite des Gästebuchs" muss eine Eingabe erfolgen.';
    $emsg[73] = 'Max. Breite des Gästebuchs nicht kleiner als 280px.';
    $emsg[74] = 'Im Feld "Schriftfarbe" muss eine Farbe eingegeben werden.<br />- Eingabe "transparent" bei Schriftfarbe nicht möglich.';
    $emsg[75] = 'Im Feld "max. Anzahl Uploads" nur Ziffern, mind. 1, max. 10';
	$emsg[76] = 'Bei Ortsnamen nur Buchstaben, Ziffern und : - , . \' / ( )';
	$emsg[77] = 'Bei Ländernamen nur Buchstaben, Ziffern und : - , . \' / ( )';
	$emsg[78] = 'Bei "Herkunft" nur Buchstaben, Ziffern und : - , . \' / | ( )<br />Ort und Land getrennt durch: |';
	$emsg[79] = 'Bei den Feldern Gästebuchtitel, Link zur Eintragsseite,<br />Text zur Bewertungsfunktion und Bezeichnung "Betreff"-Feld<br />nur Buchstaben, Ziffern oder : - , . ? ! () \' /';
	$emsg[80] = 'Unzulässige Eingabe einer URL. - Eingaben in den markierten Feldern prüfen.';
	$emsg[81] = 'Beim Namen nur Buchstaben, Ziffern und \' - . () zulässig.';
	$emsg[82] = 'Info über einen Kommentar zu Ihrem Eintrag nur bei Eingabe einer E-Mail-Adresse.';
	$emsg[83] = 'Texteingabe max. 35 Zeichen.';
	$emsg[84] = 'Prüfen Sie die URL in der Konfigurationsdatei!';
	$emsg[85] = 'Siehe auch Hinweise unter';
	$emsg[86] = 'unzulässige Title-Zeichen, nur Buchstaben, Ziffern und ! ? \' : . , -';
	$emsg[87] = 'unzulässige Zeichen im Text, nicht zulässig < > { } "';
	$emsg[88] = 'Die letzte vorhandene Datei kann nicht gelöscht werden!';
	$emsg[89] = 'Fehler beim Datenbankeintrag der Admin-E-Mail Adresse!';
	$emsg[90] = 'Bitte Admin-E-Mail Adresse neu eingeben und speichern.';
	$emsg[91] = 'Der Suchbegriff ist zu kurz. Mindestens';
	$emsg[92] = 'Unzulässige Eingabe. Bitte nur Buchstaben, Ziffern und die Zeichen ! ? \' : . , -';
	$emsg[93] = 'Die Suche ist auf';
	$emsg[94] = 'Versuche in 1 Stunde beschränkt!';
	$emsg[95] = 'Mindestens ein Link hat keinen Ankertext.';
	$emsg[96] = 'Sie haben keinen Ort angegeben.';
	$emsg[97] = 'Sie haben kein Land angegeben.';
	$emsg[98] = '<strong>Hinweis:</strong> Nicht mehr als '.$maxSmilies.' Emojis erlaubt.<br />Einige Emojis wurden daher automatisch aus dem Eintrag entfernt.';
	$emsg[99] = 'Keine Passwort-Session gefunden.';
	$emsg[100] = 'Korrigieren Sie die unten angezeigten Fehler!';
    
// Ende Error-Messages

// Frontend - Phrasen    

    $fmsg[0] = 'Geben Sie hier Ihre persönlichen Daten an.';
    $fmsg[1] = 'Benutzername';
    $fmsg[2] = 'Gästebuch Administration';
    $fmsg[3] = 'Neues Passwort anfordern';
    $fmsg[4] = 'Zurück';
    $fmsg[5] = 'Neuen Eintrag veröffentlichen:';
    $fmsg[6] = 'Sie haben einen neuen Eintrag in Ihrem Gästebuch:';
    $fmsg[7] = 'Name:';
    $fmsg[8] = 'E-Mail';
    $fmsg[9] = 'Homepage:';
    $fmsg[10] = 'Nachricht:';
    $fmsg[11] = 'Ihr Eintrag muss noch vom Administrator geprüft werden!';
    $fmsg[12] = 'Zur Zeit sind '.$count_entries.' Einträge im Gästebuch';
    $fmsg[13] = 'Ins Gästebuch eintragen';
    $fmsg[14] = 'Weiter';
    $fmsg[15] = 'mehr ...';
    $fmsg[16] = 'Eintragen';
    $fmsg[17] = 'Start Hintergrund-Farbverlauf:';
    $fmsg[18] = 'Ende Hintergrund-Farbverlauf:';
    $fmsg[19] = 'Gästebuch';
    $fmsg[20] = 'Passwort';
    $fmsg[21] = 'Wichtig:';
    $fmsg[22] = 'Zum Einfügen auf den Emoji klicken.';
    $fmsg[23] = 'Home';
    $fmsg[24] = 'Einstellungen';
    $fmsg[25] = 'Style';
    $fmsg[26] = 'Standard Style';
    $fmsg[27] = 'Style neu erstellen';
    $fmsg[28] = 'Style löschen';
    $fmsg[29] = 'vorhandenen Style editieren';
    $fmsg[30] = 'Template';
    $fmsg[31] = 'Standard Template';
    $fmsg[32] = 'Template erstellen';
    $fmsg[33] = 'Template löschen';
    $fmsg[34] = 'Template editieren';
    $fmsg[35] = 'Smileys';
    $fmsg[37] = 'Smileys anzeigen';
    $fmsg[38] = 'Smiley hinzufügen';
    $fmsg[39] = 'Badwords';
    $fmsg[40] = 'Badwords anzeigen';
    $fmsg[41] = 'Badword hinzufügen';
    $fmsg[42] = 'Backup';
    $fmsg[43] = 'Backup erstellen';
    $fmsg[44] = 'Backup wiederherstellen';
    $fmsg[45] = 'Sonstiges';
    $fmsg[46] = 'Statistik';
    $fmsg[47] = 'Hilfe';
    $fmsg[49] = 'Logout';
    $fmsg[50] = 'Frontend anzeigen';
    $fmsg[52] = 'Geben Sie hier Ihre persönlichen Daten an.';
    $fmsg[53] = 'Neues Passwort:';
    $fmsg[54] = 'Passwort Wiederholung:';
    $fmsg[55] = 'Speichern';
    $fmsg[56] = 'Smiley:';
    $fmsg[57] = 'Aktuelle Spracheinstellung: <strong>'.$language.'</strong>. Landesflagge:';
    $fmsg[58] = 'Bitte wählen Sie den Standard Style aus,<br />der beim Aufruf von Ihrem Gästebuch verwendet wird.';
    $fmsg[59] = 'Ihr aktueller Style:';
    $fmsg[60] = 'Bitte wählen Sie das Standard Template aus,<br />das beim Aufruf von Ihrem Gästebuch angezeigt wird.';
    $fmsg[61] = 'Bitte wählen Sie den Style, den Sie löschen möchten.<br />Dieser Vorgang kann nicht rückgängig gemacht werden.';
    $fmsg[62] = 'Löschen';
    $fmsg[63] = 'Ihr aktuelles Standard Template:';
    $fmsg[64] = 'Bitte wählen Sie das Template, das Sie löschen möchten.<br />Dieser Vorgang kann nicht rückgängig gemacht werden.'; 
    $fmsg[65] = 'Bitte beim Feld "Breite" nur Ziffern angeben';
    $fmsg[66] = 'Bitte beim Feld "Höhe" nur Ziffern angeben';
    $fmsg[67] = 'Breite:<br /><span class="size-10">(in px)</span>';
    $fmsg[68] = 'Höhe:<br /><span class="size-10">(in px)</span>';
    $fmsg[69] = 'Bitte wählen Sie den Style, den Sie bearbeiten möchten.';
    $fmsg[70] = 'Bearbeiten';
    $fmsg[71] = 'Ändern Sie den ausgewählten CSS Code beliebig um.';
    $fmsg[72] = 'CSS Style:';
    $fmsg[73] = 'Bitte wählen Sie das Template, das Sie bearbeiten möchten.';
    $fmsg[78] = 'Der HTML Code, den Sie hier eingeben, ist nur für einen Beitrag, deshalb sollte er möglichst kurz sein.';
    $fmsg[79] = 'Platzhalter für den Namen des Users, der sich eingetragen hat.';
    $fmsg[80] = 'Platzhalter für das verlinkte E-Mail Icon.';
    $fmsg[81] = 'Platzhalter für das verlinkte Homepage Icon.';
    $fmsg[82] = 'Platzhalter für die Zeit des Eintrages.';
    $fmsg[83] = 'Platzhalter für den Text des Eintrages, den der User geschrieben hat.';
    $fmsg[84] = 'Platzhalter für den Kommentar des Admins<br />(falls vorhanden).';
    $fmsg[85] = 'Platzhalter für das verlinkte Zitat-Icon.';
    $fmsg[86] = 'Platzhalter für die max. Gästebuchbreite.';
    $fmsg[87] = 'Platzhalter für "Beitrag".';
    $fmsg[88] = 'Platzhalter für "vom".';
    $fmsg[89] = 'Platzhalter für "Name / Zeit Hintergrundfarbe".';
    $fmsg[90] = 'Platzhalter für "Eintrag Hintergrundfarbe"';
    $fmsg[91] = 'Bei Hintergrund-Farbverläufen müssen Eingaben zu Start und Ende erfolgen.<br />Die Eingabe "transparent" ist nicht zulässig.';
    $fmsg[92] = 'Gästebuch Hintergrundfarbe:';
    $fmsg[93] = 'Gästebuch Platzierung:';
    $fmsg[94] = 'Breite des Gästebuchs:';
    $fmsg[95] = 'Platzhalter für "schrieb am".';
    $fmsg[96] = 'Schriftfarbe';
    $fmsg[97] = 'Sprache auswählen';
    $fmsg[98] = 'Name / Zeit Hintergrundfarbe:';
    $fmsg[99] = 'Eintrag Hintergrundfarbe:';
    $fmsg[100] = 'Gästebuch Hintergrundbild URL:';
    $fmsg[101] = 'E-Mail Grafik:';
    $fmsg[102] = 'Homepage Grafik:';
    $fmsg[103] = 'Freigeben';
    $fmsg[104] = 'Alle auswählen';
    $fmsg[105] = 'Deaktivieren';
    $fmsg[106] = 'Kommentar';
    $fmsg[107] = 'Freigegeben';
    $fmsg[108] = 'Deaktiviert';
    $fmsg[109] = 'Neuer Eintrag';
    $fmsg[110] = 'Features Eintragsformular zum Gästebuch';
    $fmsg[113] = 'Allgemeine Einstellungen';
    $fmsg[114] = 'Titel des Gästebuchs:';
    $fmsg[115] = 'Beiträge pro Seite:';
    $fmsg[116] = 'Anzahl Links bei der Blätterfunktion:';
    $fmsg[117] = 'Flood Sperre in Minuten:';
    $fmsg[118] = 'Reload Sperre für Statistik in Minuten:';
    $fmsg[119] = 'E-Mail bei neuem Eintrag an Admin<br />und -wenn aktiviert- an Moderator(en):';
    $fmsg[120] = 'Emojis aktivieren:';
    $fmsg[121] = 'BBCodes aktivieren:';
    $fmsg[122] = 'Gästebuch Statistik:';
    $fmsg[123] = 'Einträge müssen freigegeben werden:';
    $fmsg[124] = 'HTML Code sperren:<br /><span class="size-10 red">(Sperrung dringend empfohlen!)</span>';
    $fmsg[125] = 'wird nicht öffentlich angezeigt';
    $fmsg[126] = 'Badword ist bereits vorhanden';
    $fmsg[127] = 'Setzen Sie unten das gewünschte Badword ein,<br />das durch Sterne (***) ersetzt wird.';
    $fmsg[128] = 'Badword:';
    $fmsg[129] = 'Bild entfernt.';
    $fmsg[130] = 'Backupdatei wieder löschen';
    $fmsg[131] = 'Hier können Sie Ihre eigenen Smileys hochladen,<br />geben Sie dazu die benötigten Daten an.';
    $fmsg[132] = 'Erstellen';
    $fmsg[133] = 'Fügen Sie hier Ihren Kommentar zum Eintrag ein.';
    $fmsg[134] = 'Kommentar löschen';
    $fmsg[135] = 'Falsche Zugangsdaten';
    $fmsg[136] = 'Login';
    $fmsg[137] = 'Tabelle:';
    $fmsg[138] = 'Datenschutzerklärung';
    $fmsg[139] = 'Name oder Alias'; 
    $fmsg[141] = 'Erstellen Sie hier Ihren eigenen Gästebuch Style';
    $fmsg[142] = 'Name des Styles:';
    $fmsg[143] = 'Code:';
    $fmsg[144] = 'Hier können Sie Ihr eigenes Gästebuch Template erstellen,<br />sollten dafür jedoch schon Erfahrung mit HTML haben.';
    $fmsg[145] = 'Template Name:';
    $fmsg[148] = 'Während der Wiederherstellung aus dem Backup traten ein oder mehrere Fehler auf'; 
    $fmsg[149] = 'Die Wiederherstellung aus dem Backup war erfolgreich';
    $fmsg[150] = 'Zurück zum Login';
    $fmsg[151] = 'E-Mail-Adresse';
    $fmsg[152] = 'Backup Datei:';
    $fmsg[153] = 'Wiederherstellen';
    $fmsg[154] = 'Gästebuch Statistik:';
    $fmsg[155] = 'Besucher gesamt:';
    $fmsg[156] = 'Aufrufe gesamt:';
    $fmsg[157] = 'Statistik der letzten '.$recording_days.' Tage von Ihrem Gästebuch:';
    $fmsg[158] = 'Datum:';
    $fmsg[159] = 'Besucher:';
    $fmsg[160] = 'Aufrufe:';
    $fmsg[161] = 'Statistik löschen';
    $fmsg[162] = 'Sie haben die Statistik nicht eingeschaltet.<br />Unter "Einstellungen -&#62; Allgemeine Konfiguration" können Sie die Statistik aktivieren.';
    $fmsg[164] = 'Hier sehen Sie die Liste der Wörter, die im Gästebuch zensiert werden.';
    $fmsg[165] = 'Badword';
    $fmsg[166] = 'Markierte Löschen';
    $fmsg[168] = 'Alle Emojis, die auf der Eintragsseite zu sehen sind, werden hier angezeigt.';
    $fmsg[169] = 'Editieren:';
    $fmsg[170] = 'Datum | Zeit:';
    $fmsg[171] = 'Platzhalter für das Datum des Eintrags.';
    $fmsg[172] = 'Zitat:';
    $fmsg[173] = 'Gästebuch aktiviert';
    $fmsg[174] = 'Minimale / maximale Eintragslänge festlegen:';
    $fmsg[175] = 'Maximale Eintragslänge in Zeichen:';
    $fmsg[176] = 'Minimale Eintragslänge in Zeichen:';
    $fmsg[179] = 'Vorschau';
    $fmsg[180] = 'links';
    $fmsg[181] = 'zentriert';
    $fmsg[182] = 'rechts';
    $fmsg[185] = 'fette Schrift';
    $fmsg[186] = 'kursive Schrift';
    $fmsg[187] = 'unterstrichene Schrift';
    $fmsg[188] = 'Schrift mit Schatten';
    $fmsg[189] = 'Der Eintrag, auf den Sie antworten';
    $fmsg[190] = 'Erwiderung zum Eintrag von';
    $fmsg[191] = 'Zitat';
    $fmsg[192] = 'Liste';
    $fmsg[193] = 'Beschreibung';
    $fmsg[194] = 'Link zu diesem Eintrag';
    $fmsg[195] = 'Alle Einträge ansehen';
    $fmsg[196] = 'Eintragsfeld für E-Mail-Adresse <strong>verbergen</strong>:';
    $fmsg[197] = 'Installieren';
    $fmsg[199] = 'Klick';
    $fmsg[200] = 'Antwort';
    $fmsg[201] = 'Eintragsfeld für Homepage Adresse <strong>verbergen</strong>:';
    $fmsg[202] = '';
    $fmsg[203] = 'Maximale Wortlänge:<br /><span class="size-10">(empfohlen: ~35 | bei aktiviertem HTML: bis 125)</span>';
    $fmsg[205] = '';
    $fmsg[206] = 'Per E-Mail für Eintrag bedanken:';
    $fmsg[207] = 'Homepage Adresse ist ungültig';
    $fmsg[208] = 'HTML Code bearbeiten';
    $fmsg[210] = 'Herzlichen Dank';
    $fmsg[211] = 'Spam-Verdacht: Name ohne Vokale.';
    $fmsg[212] = 'Dieser Gästebucheintrag ist zur Zeit noch deaktiviert. Mit einem Klick auf den folgenden Link wird er aktiviert und ist im Gästebuch sichtbar:';
    $fmsg[216] = 'Passwort vergessen?';
    $fmsg[217] = 'Sollten Sie kein neues Passwort angefordert haben, könnte es sein, dass jemand versucht, unerlaubt in den Admin-Bereich einzudringen. Loggen Sie sich unverzüglich dort ein und ändern Sie sowohl das Kennwort wie auch den Benutzernamen und die Admin-E-Mail Adresse.';
    $fmsg[220] = 'Bilder in Gästebucheinträgen anzeigen,<br />Bild-Upload aktivieren:<br /><span class="size-10">(BBCodes müssen aktiviert sein)</span>';
    $fmsg[221] = 'Neues Passwort zum Login ins Admin-Control-Panel';
    $fmsg[222] = '';
    $fmsg[223] = 'Sie haben ein neues Passwort zum Login in den Admin-Bereich des myPHP Guestbook angefordert.<br /><br />Das neue Passwort lautet:';
    $fmsg[226] = 'Zur Zeit kein Eintrag veröffentlicht';
    $fmsg[227] = 'Zur Zeit ist ein Eintrag im Gästebuch.';
    $fmsg[228] = 'Eintrag vom:';
    $fmsg[229] = 'Spam: Weiterleitung auf neue URL im Homepagefeld!';
    $fmsg[230] = 'geposteter Beitrag:';
    $fmsg[231] = 'Ein neuer Eintrag im Gästebuch wurde verworfen, der Absender gesperrt:';
    $fmsg[232] = 'Verworfener Gästebucheintrag - Spam';
    $fmsg[233] = 'Gesperrter Gästebucheintrag - Spamverdacht';
    $fmsg[234] = 'Ein neuer Eintrag im Gästebuch wurde gesperrt:';
    $fmsg[235] = 'Absender-IP:';
    $fmsg[236] = 'Dieser Gästebucheintrag ist zur Zeit noch deaktiviert.';
    $fmsg[237] = 'Eintrag inklusive ggf. eingestellter Fotos freischalten?';
    $fmsg[238] = 'Anzahl Spam-Punkte:';
    $fmsg[239] = 'Dieser Gästebucheintrag wurde verworfen, die IP des Absenders gesperrt.';
    $fmsg[240] = 'Dieser Gästebucheintrag ist zur Zeit wegen möglichem Spam noch gesperrt.';
    $fmsg[241] = 'Den Gästebucheintrag sperren?';
    $fmsg[242] = 'Spam-Verdacht: Die vom Verfasser in seinem Eintrag eingestellten Links überschreiten die unverdächtige Anzahl um -';
    $fmsg[243] = 'Spam: Der Verfasser hat für seinen Eintrag weniger als 4 Sekunden benötigt.';
    $fmsg[244] = 'Spam-Verdacht: Der Verfasser hat für seinen Eintrag zwar mind. 4, aber weniger als 9 Sekunden bis zur Abspeicherung gebraucht.';
    $fmsg[245] = 'Spam-Verdacht: Der Verfasser hat für seinen Eintrag mehr als 1 Stunde bis zur Abspeicherung gebraucht.';
    $fmsg[246] = 'Spam-Verdacht: Es wurden mehr als 30 Anschläge pro Sekunde verfasst.';
    $fmsg[247] = 'Zeitspanne Seitenaufruf - Beitragsabsendung:';
    $fmsg[248] = 'Sek.';
    $fmsg[249] = 'Zahl der Anschläge:';
    $fmsg[250] = 'Anschläge/Sek.:';
    $fmsg[251] = 'Spam: ein oder mehrere versteckte Input-Felder belegt.';
    $fmsg[252] = 'Spam-Verdacht: Eintrag mit Spam-Wörtern!';
    $fmsg[253] = 'Folgende Spamwörter wurden ermittelt:';
    $fmsg[254] = 'Anzahl der Verwendung im Text:';
    $fmsg[255] = 'Anzahl der Spam-Punkte,<br />die zum Verwerfen eines Beitrags führen:<br /><span class="size-10">(empfohlen: 4-5 / möglich: min. 1 und max. 20)</span>';
    $fmsg[256] = 'Spam mit Schlüsselwörtern in<br />Beiträgen erkennen und verhindern:';
    $fmsg[257] = 'Spam durch Anzahl der Links in<br />Beiträgen erkennen und verhindern:';
    $fmsg[258] = 'Anzahl der unverdächtigen Links in Beiträgen:<br /><span class="size-10">(empfohlen: bis 2 / möglich: min. 0 und max. 20)</span>';
    $fmsg[259] = 'Wertung der Spam-Merkmale';
    $fmsg[260] = 'Nutzung verstecktes Input-Feld: + 5 Pkte.<br />Eintrag beginnt mit einem Link: + 1 Pkt.<br />Umleitung im Homepagefeld: + 4 Pkte.<br />speichern des Beitrags &#60; 4 Sek.: + 5 Pkte.<br />speichern des Beitrags &#60; 9 Sek.: + 1 Pkt.<br />speichern des Beitrags &#62; 1 Std.: + 1 Pkt.<br /><strong class="red size-20">*</strong>Anschläge &#62; 30 Zeichen/Sek.: + 1 Pkt.<br /><strong class="red size-20">*</strong>fehlender/falscher Referrer: + 3 Pkte.<br /><strong class="red size-20">*</strong>pro Spam-Wort: + 1 Pkt.<br /><strong class="red size-20">*</strong>pro Link über Grenzwert: + 1 Pkt.<br /><strong class="red size-20">*</strong>Name ohne Vokal(e): + 1 Pkt.<hr /><strong class="red size-20">*</strong> Kann deaktiviert werden, siehe <a class="red" href="?action=help&#38;'.session_name().'='.session_id().'#anchor-disableSpam">HIER</a>.';
    $fmsg[261] = 'Aktivierung nur möglich, wenn mindestens ein Schlüsselwort vorhanden ist.';
    $fmsg[262] = '<b>Achtung!</b><br /><br />Der Gästebucheintrag wurde gesperrt!';
    $fmsg[263] = '<b>Achtung!</b><br /><br />Der Aktivierungscode ist ungültig, es wurde kein Gästebucheintrag gesperrt!';
    $fmsg[264] = '<b>Achtung!</b><br /><br />Der Gästebucheintrag inkl. ggf. eingestellter Bilder wurde freigeschaltet!';
    $fmsg[265] = '<b>Achtung!</b><br /><br />Der Aktivierungscode ist ungültig, es wurde kein Gästebucheintrag aktiviert!';
    $fmsg[266] = 'Link öffnet ein neues Fenster';
    $fmsg[267] = 'Dieser Gästebucheintrag wurde verworfen.';
    $fmsg[268] = 'Smileys';
    $fmsg[269] = 'Abbruch';
    $fmsg[270] = 'Sprache ändern? / Change language?';
    $fmsg[271] = 'Javascript muss aktiviert sein.';
    $fmsg[272] = '';
    $fmsg[273] = 'Einklappen';
    $fmsg[274] = 'grau';
    $fmsg[275] = 'BackUp nach dem Versand per E-Mail<br />wieder vom Server löschen?';
    $fmsg[276] = 'Achtung!\\n\\nBei einem Wechsel des Template denken Sie bitte daran,\\nauch den zugehörigen CSS-Style zu wechseln!\\n\\nFortfahren?';
    $fmsg[277] = 'Achtung!\\n\\nBei einem Wechsel des CSS-Style, denken Sie bitte daran,\\nggf. auch das zugehörige Template zu wechseln.\\n\\nFortfahren?';
    $fmsg[278] = 'Spam-Verdacht: Direkter Aufruf der Eintragsseite.';
    $fmsg[279] = 'Statistik seit dem ';
    $fmsg[280] = 'durchgestrichene Schrift';
    $fmsg[281] = 'Blocksatz';
    $fmsg[282] = 'rechtsbündige Schrift';
    $fmsg[283] = 'hochgestellte Schrift';
    $fmsg[284] = 'Bullet Liste';
    $fmsg[285] = 'nummerierte Liste';
    $fmsg[286] = 'Trennlinie';
    $fmsg[287] = 'Link einfügen';
    $fmsg[288] = 'E-Mail Adresse einfügen';
    $fmsg[289] = 'Farbe';
    $fmsg[290] = 'gelb';
    $fmsg[291] = 'orange';
    $fmsg[292] = 'hellgrün';
    $fmsg[293] = 'pink';
    $fmsg[294] = 'braun';
    $fmsg[295] = 'Größe';
    $fmsg[296] = 'Eingabemaske Gästebuch';
    $fmsg[297] = 'Ankertext eingeben, der verlinkt werden soll:';
    $fmsg[298] = 'Der hier eingebene Text ist der im Beitrag sichtbare,<br />anzuklickende Link.';
    $fmsg[299] = 'Bitte vollständige URL eingeben';
    $fmsg[300] = 'Eingaben abschließen<br />und in Ihren Beitrag einfügen';
    $fmsg[301] = 'E-Mail Adresse eingeben,<br />die in Ihrem Beitrag erscheinen soll:';
    $fmsg[302] = 'Sie haben keine Bezeichnung<br />für den Link eingegeben.<br /><br />Neuer Versuch ...';
    $fmsg[303] = 'Die Eingabe kann bis max. 80 Zeichen lang sein.';
    $fmsg[304] = '';
    $fmsg[305] = 'Sie haben keine E-Mail Adresse eingegeben.<br /><br />Neuer Versuch ...';
    $fmsg[306] = 'rot';
    $fmsg[307] = 'grün';
    $fmsg[308] = 'blau';
    $fmsg[309] = 'zentrierte Schrift';
    $fmsg[310] = 'Bild einfügen';
    $fmsg[311] = 'E-Mail senden';
    $fmsg[312] = '<strong>Es kann gesucht werden nach:</strong><ul><li>Usernamen,</li><li>Datum,</li><li>Text in Einträgen und Kommentaren</li></ul>';
    $fmsg[313] = 'Betreff:';
    $fmsg[314] = 'maximal zulässige Länge Ihres Eintrags:';
    $fmsg[315] = 'Zeichen';
    $fmsg[316] = 'Noch mögliche Zeichen:';
    $fmsg[317] = 'Bitte kürzen Sie Ihren Eintrag um';
    $fmsg[318] = 'Dieses Bild muss noch<br />freigeschaltet werden.';
    $fmsg[319] = 'Dieser Gästebucheintrag ist freigeschaltet, ggf. enthaltene Bilder sind noch gesperrt.';
    $fmsg[320] = 'Bild(er) freischalten?';
    $fmsg[321] = 'Diesen Eintrag zitieren';
    $fmsg[322] = 'Auf diesen Eintrag erwidern';
    $fmsg[323] = 'Text + Bild freigeben';
    $fmsg[324] = 'Nur Text freigeben';
    $fmsg[325] = 'Eintrag löschen';
    $fmsg[326] = 'Eintrag deaktivieren';
    $fmsg[327] = 'Farbe Beitragsrahmen:';
    $fmsg[328] = '<p class="text-center"><strong class="red">Achtung!</strong><br /><br />Bei einem Wechsel des Template denken Sie bitte daran,<br />auch den zugehörigen Standard-CSS-Style zu wechseln!</p>';
    $fmsg[329] = '<p class="text-center"><strong class="red">Achtung!</strong><br /><br />Bei einem Wechsel des CSS-Style denken Sie bitte daran,<br />auch das zugehörige Standard-Template zu wechseln!</p>';
    $fmsg[330] = 'Platzhalter für "Gästebuch Hintergrundfarbe"';
    $fmsg[331] = 'Folgende Variablen können im CSS-Code genutzt werden:';
    $fmsg[332] = 'Platzhalter für die Gästebuch Platzierung';
    $fmsg[333] = 'Platzhalter für die Schriftfarbe';
    $fmsg[334] = 'Pflichtfeld';
    $fmsg[335] = 'Verwendung von BBCodes nicht möglich.';
    $fmsg[336] = 'Verwendung von Smileys nicht möglich.';
    $fmsg[337] = 'optional';
    $fmsg[338] = 'Spam-Schutz aktivieren';
    $fmsg[339] = 'Um den Spam-Schutz wieder zu aktivieren<br />die Datei "settings.inc.php" im Ordner<br />"includes" öffnen und dort<br />die Konstante "SPAM_PROTECT"<br />von "false" auf "true" setzen.<br /><br />Änderung speichern und die geänderte Datei<br />"settings.inc.php" auf den Server laden.';
    $fmsg[340] = '<strong>Achtung!</strong> Der Spam-Schutz ist deaktiviert!*';
    $fmsg[341] = 'Bild-Upload-Prüfung aktivieren';
    $fmsg[342] = 'Um die Prüfung und Freischaltung hochgeladener<br />Grafik-Dateien durch den Admin wieder zu aktivieren<br />die Datei "settings.inc.php" im Ordner "includes"<br />öffnen und dort die Konstante<br />"PIC_CHECK" von "false" auf "true" setzen.<br /><br />Änderung speichern und die geänderte Datei<br />"settings.inc.php" wieder auf den Server laden.';
    $fmsg[343] = '<strong>Achtung!</strong> Hochgeladene Bilder<br />sind ohne Freigabe sofort sichtbar!';
    $fmsg[344] = 'Bild(er) sperren?';
    $fmsg[345] = 'Folgende Variablen können im Template genutzt werden:';
    $fmsg[346] = 'Ort:';
    $fmsg[347] = 'Land:';
    $fmsg[348] = 'Ihr Eintrag';
    $fmsg[349] = 'aus ';
    $fmsg[350] = 'Ich möchte über einen Kommentar per E-Mail informiert werden:';
    $fmsg[351] = 'Ihr Eintrag wird nach Prüfung durch den Admin freigeschaltet.';
    $fmsg[352] = 'Websitebewertung:';
    $fmsg[353] = 'Stern';
    $fmsg[354] = $fmsg[3541] = 'Sterne';
    $fmsg[355] = 'Bewertung löschen';
    $fmsg[356] = 'Platzhalter für die Bewertungsfunktion';
    $fmsg[357] = 'von 5 Sternen';
    $fmsg[358] = 'Durchschnitt';
    $fmsg[359] = 'bei';
    $fmsg[360] = 'Bewertungen';
    $fmsg[361] = 'Dieses neue Passwort ist';
    $fmsg[362] = 'Minuten gültig und wird danach aus Sicherheitsgründen automatisch deaktiviert.';
    $fmsg[363] = 'Suchen';
    $fmsg[364] = 'Suche löschen';
    $fmsg[365] = 'Reset';
    $fmsg[366] = 'Gefunden';

// ENDE Frontend - Phrasen  
    
// Datei-Upload - Phrasen
       
    $pmsg[1] = '<p class="text-center"><strong>Bevor es losgeht...</strong></p>
<p class="text-justify">Fotos bzw. Bilddateien sind urheberrechtlich geschützt. Deshalb dürfen hier nur selbstgefertigte Bilder hochgeladen und in Ihrem Beitrag veröffentlicht werden.</p>
<p>Mit dem Anklicken des "Bestätigen"-Buttons sichern Sie zu, dass</p>
<ul>
<li>...Sie nur Bilder hochladen und in Ihrem Eintrag verwenden, an denen Sie uneingeschränkte Nutzungsrechte haben und</li>
<li>...Sie daher keine Dateien verwenden, die von Dritten stammen, insbesondere keine aus dem Internet oder sonstwo ohne Erlaubnis kopierten Bilder hier einstellen.</li>
</ul>
<p class="text-justify"><strong>Das Einstellen pornografischer, sexistischer, obszöner, rassistischer, gewaltverherrlichender oder auf sonstige Art anstößiger Bilder ist untersagt.</strong></p>
<p class="text-justify"><strong>Hinweis:</strong> Beim Hochladen von Dateien werden aus Sicherheitsgründen die Inhalte eines EXIF-Headers entfernt, was z.B. auch Angaben zu Kamera- oder Aufnahmedaten, eventuell enthaltene Copyright-Angaben etc. umfasst. Außerdem werden die hochgeladenen Grafik-Dateien in ihrer Größe dem Layout des Gästebuchs angepasst. Die Bildmotive sind später möglicherweise über Suchmaschinen auffindbar.</p>';
	$pmsg[2] = 'Nutzungsbedingungen bestätigen';
	$pmsg[3] = 'Abbrechen';
	$pmsg[4] = 'So fügen Sie ein Bild in Ihren Eintrag ein:';
	$pmsg[5] = 'Die maximal zulässige Größe der Originaldatei darf betragen:';
	$pmsg[6] = 'Erlaubte Dateiformate sind:';
	$pmsg[7] = '<p>Je größer ein Bild, desto länger die Ladezeit! Je nach Dateigröße und Internetverbindung kann der Ladevorgang 1 Minute und mehr betragen.</p>
<p class="text-center"><strong>Ende und Erfolg des Ladevorgangs werden angezeigt,<br />- also bitte etwas Geduld.</strong></p>';
	$pmsg[8] = 'Speicherung nicht möglich.<br /><strong>Bitte wenden Sie sich an den Admin.';
	$pmsg[9] = 'Datei überschreitet die Uploadgröße<br />in der php.ini';
	$pmsg[10] = 'Wenn Sie keine Möglichkeit haben, die Datei zu verkleinern, können Sie sie mir gerne per E-Mail übermitteln, ich füge sie dann für Sie ein.';
	$pmsg[11] = '<strong>Datei nur teilweise hochgeladen!</strong><br />Bitte probieren Sie es noch einmal.';
	$pmsg[12] = 'Keine Datei ausgewählt!';
	$pmsg[13] = '<strong>Ungültiges Dateiformat!</strong><br />Nur Bilddateien im Format .jpg, .jpeg, .png, .JPG, .JPEG';
	$pmsg[14] = '<strong>Datei zu groß!</strong>';
	$pmsg[15] = 'Beschreibung zum hochgeladenen Bild eingeben:';
	$pmsg[16] = '<p>Sie haben die Nutzungsbedingungen für den Dateiupload nicht akzeptiert oder es ist ein Fehler bei der Bestätigung aufgetreten.</p><p>Bitte versuchen Sie es noch einmal.</p>';
	$pmsg[17] = 'myPHP Guestbook Dateiupload';
	$pmsg[18] = '<b>Achtung!</b>
<br /><br />
Es wurde eine Bilddatei im Gästebuch hochgeladen am<b> '.GB_DATE.' um '.date("H:i").' Uhr</b>.
<br /><br />
<b>Es wird dringend empfohlen, die Datei vor Freigabe zuerst auf Unbedenklichkeit zu prüfen!</b><br /><br />
Das Bild sollte unten angezeigt werden und kann ansonsten durch einen Klick auf den folgenden Link aufgerufen werden:';
	$pmsg[19] = 'Die Datei wurde erfolgreich hochgeladen.';
	$pmsg[20] = '<p><strong>Bitte klicken Sie jetzt auf den Button "Code erzeugen", um die Tags in Ihren Beitrag einzufügen, die für die anschließende Anzeige Ihres Bildes erforderlich sind.</strong></p><br />
<p class="text-center red">Der Code zwischen den beiden Tags:<br /><br /><strong>"[img]...[/img]"</strong><br /><br />darf anschließend <strong>nicht mehr verändert werden!</strong></p>';
	$pmsg[21] = 'Code erzeugen';
	$pmsg[22] = '<strong>Unzulässiger MIME-Type!</strong><br />Nur image.jpg oder image.png!';
	$pmsg[23] = 'Hochladen';
	$pmsg[24] = 'Was wollen Sie als nächstes machen?';
	$pmsg[25] = 'weiteres Bild hochladen';
	$pmsg[26] = 'Vorgang beenden und Fenster schließen';
	$pmsg[27] = 'z.B. Ort oder Motiv, Name des Fotografen o.ä..<br />Der Eintrag im Textfeld kann beliebig geändert werden.';
	$pmsg[28] = '<strong>Auffälliger Dateiname, Upload abgebrochen.</strong><br />Bitte benennen Sie die Datei um.';
	$pmsg[29] = '<strong>Es ist ein Fehler aufgetreten.</strong><br />Bitte versuchen Sie es nochmal.';
	$pmsg[30] = 'Pro Beitrag maximal';
	$pmsg[31] = 'Bild(er)';
	$pmsg[32] = '(nacheinander zu laden)';
	$pmsg[33] = 'Limit erreicht';
	$pmsg[34] = 'Bild zu klein (min. 10px hoch und breit)';
	$pmsg[35] = 'Bitte warten ...';
	
?>