<?php
/*
    myPHP Guestbook Copyright (C) 2003 - 2006  Claudio Pose
    myPHP Guestbook was an open source project of Networkarea.ch

    Version 3.x Copyright (C) 2011 - 2014 Christian Thomas, www.hostonline.de

    Version 4.x (MySQLi) Copyright (C) 2014 - 2022 Wolfgang Leverberg, www.php-guestbook.de

    This file is a part of myPHP Guestbook.
    myPHP Guestbook is free software; you can redistribute it and/or modify it under the terms of the 
    GNU General Public License as published by the Free Software Foundation; either version 3 of the 
    License, or (at your option) any later version.

    myPHP Guestbook is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
    even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

    See the GNU General Public License for more details.

    02.01.2022
*/

error_reporting (0);
ini_set ('display_errors', 'OFF');

$count_entries = $url = $host = $username = $password = $database = $siteAdminPass = "";
$allowed_characters = 'ÀÁÂÃÄÅÆÇČĎÈÉÊËĚÌÍÎÏÐĽĹŇÑÒÓÔÕÖØŔŘŠŤŮÙÚÛÜÝŽÞßàáâãäåæçčďěèéêëìíîïðľĺňñòóôõöøŕřšťůùúûüýþÿž';

(defined('PHP_VERSION_ID') && (PHP_VERSION_ID >= 50500) && (defined('PASSWORD_ARGON2ID') OR defined('PASSWORD_ARGON2I') OR defined('PASSWORD_BCRYPT') OR defined('PASSWORD_DEFAULT'))) ? define('BEST_PW', true) : define('BEST_PW', false);

if (BEST_PW) {
    $gb_salt = "";

	if (defined('PASSWORD_ARGON2ID')) {
		$gb_algo = 'ARG2ID';
	}
	elseif (defined('PASSWORD_ARGON2I')) {
		$gb_algo = 'ARGO2I';
	}
	elseif (defined('PASSWORD_BCRYPT')) {
		$gb_algo = 'BCRYPT';
	}
	else {
		$gb_algo = 'DEFLT';
	}
}
else {
	$hashAlgos = hash_algos();
	
	if (in_array('sha512', $hashAlgos))	{
		$gb_algo = 'sha512';
	}
	elseif (in_array('sha384', $hashAlgos)) {
		$gb_algo = 'sha384';
	}
	elseif (in_array('sha256', $hashAlgos)) {
		$gb_algo = 'sha256';
	}
	elseif (in_array('sha1', $hashAlgos)) {
		$gb_algo = 'sha1';
	}
	else {
		$gb_algo = 'md5';
	}
	
	function makeRandomName() {
		if (function_exists('gettimeofday()')) { 
			list($usec, $sec) = explode(' ', microtime());
			return ceil($sec)+(ceil($usec)*100000);
		}
		else {
			$sec = time();
			return ceil($sec*0.333);
		}
	}

	mt_srand(makeRandomName());
	$gb_salt = md5(mt_rand());

	function saltPassword($siteAdminPass, $gb_salt)	{
		global $gb_algo;
	   	return hash(''.$gb_algo.'', $siteAdminPass . $gb_salt);
	}
}

function getFiles($directory) {
	if ($dh = opendir($directory)) {
		while (($file = readdir($dh))) {
			if ($file != "." && $file != ".." )	{
				$files[] = $file;
			}
		}
		closedir($dh);
		return $files;
	}
}

if(isset($_POST['send_lang']) && ($_POST['language'] == "de" || $_POST['language'] == "en")){
	include("".$_POST['language'].".php");
}
else {
	include("de.php");
}

$count_entries= "";
$date = date("m.d.y");

function getmainpath() {
	$path = getcwd();
	$path = str_replace('/install', '/', $path);
	return $path;
}

function getdomainpath() {
	$scheme = (empty($_SERVER['HTTPS'])) ? 'http://' : 'https://';

	$path = '' . dirname($_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']);
	if (strlen($path) < 5) {
		$path = '' . dirname($_SERVER['HTTP_HOST'] . $_SERVER['PHP_SELF']);
	}
	$path = str_replace('/install', '/', $path);
	$path = str_replace('//', '/', $path);
	$path = ''.$scheme.''.$path;

	return $path;
}

function hostname() {
	$scheme = (empty($_SERVER['HTTPS'])) ? 'http://' : 'https://';

	$hostname = ''.$_SERVER['SERVER_NAME'];
	$hostname = ''.$scheme.''.$hostname.'/';

	return $hostname;
}
/*     
function gbookfolder() {  
	$uri = getdomainpath();
	$pieces = parse_url($uri);
	$folder = $pieces['path'];
	$folder = str_replace('/', '', $folder);

	return $folder;
}
*/

function makeconfigfile($contents, $main_path) {
	$filename = $main_path . 'includes/config.inc.php';
	$altfilename = $main_path . 'includes/config.inc.php.new';

	if (!file_exists($filename)) {
		if (file_exists($altfilename)) {
			rename($altfilename, $filename);
		}
		else {
			touch($filename);
		}
	}

	@chmod($filename, 0777);

	if (is_writable($filename))	{
		if (!$handle = fopen($filename, 'w')) {
			$return = false;
		}
		else {
			if (fwrite($handle, $contents) === false) {
				$return = false;
			}
			else {
				$return = true;
			}
		}
		fclose($handle);
	}
	else {
		$return = false;
	}
	return $return;
}

$noreplyMail = "noreply@".str_replace("www.", "", $_SERVER['SERVER_NAME'])."";
$count_noreply = strlen($noreplyMail);
$noreplyMail = ($count_noreply <= 80) ? $noreplyMail : "";

function show_config_table($fresh = true) {
	$count_entries = $url = $language = "";		

	if(isset($_POST['send_lang']) && $_POST['language'] != "" && ($_POST['language'] == "de" || $_POST['language'] == "en")){
		include("".$_POST['language'].".php");
		$language = $_POST['language'];
	}
	else {
		include("de.php");
	}

	$main_path = getmainpath();

	$data = '<div id="container_install">';
	$data .= '<form name="form1" method="post" action="./index.php?action=install&#38;step=1">';
	$data .= '<table class="install-table">';
	$data .= '<tr>';
	$data .= '<td style="width:160px">'.$imsg[1].'</td>';
	$data .= '<td style="width:150px"><input type="text" name="URL" value="'.getdomainpath().'" /></td>';
	$data .= '<td rowspan="2">'.$imsg[3].'<br /></td>';
	$data .= '</tr>';
	$data .= '<tr>';
	$data .= '<td>'.$imsg[2].'</td>';
	$data .= '<td><input type="text" name="mainpath" readonly="readonly" value="'.$main_path.'" /></td>';
	$data .= '</tr>';
	$data .= '<tr>';
	$data .= '<td>'.$imsg[53].'</td>';
	$data .= '<td>';
	$data .= '<select width="100" name="timezone" type="text">';
	$data .= '<option value="Australia/Perth">Australia (AWST)</option>';
	$data .= '<option value="Australia/Adelaide">Australia (ACST)</option>';
	$data .= '<option value="Australia/Sydney">Australia (AEST)</option>';
	$data .= '<option value="Europe/Amsterdam">BeNeLux</option>';
	$data .= '<option value="Europe/Sarajevo">Bosnia</option>';
	$data .= '<option value="America/Sao_Paulo">Brasil (UTC-3)</option>';
	$data .= '<option value="America/Boa_Vista">Brasil (UTC-4)</option>';
	$data .= '<option value="America/Rio_Branco">Brasil (UTC-5)</option>';
	$data .= '<option value="Europe/Zagreb">Croatia</option>';
	$data .= '<option value="Europe/Nicosia">Cyprus</option>';
	$data .= '<option value="Europe/Prague">Czech Republic</option>';
	$data .= '<option value="Europe/Copenhagen">Denmark</option>';
	$data .= '<option selected="selected" value="Europe/Berlin">Deutschland</option>';
	$data .= '<option value="Europe/London">England</option>';
	$data .= '<option value="Europe/Tallinn">Estonia</option>';
	$data .= '<option value="Europe/Helsinki">Finland</option>';
	$data .= '<option value="Europe/Paris">France</option>';
	$data .= '<option value="Europe/Athens">Greece</option>';
	$data .= '<option value="Europe/Budapest">Hungary</option>';
	$data .= '<option value="Europe/Dublin">Ireland</option>';
	$data .= '<option value="Europe/Rome">Italia</option>';
	$data .= '<option value="Europe/Riga">Latvia</option>';
	$data .= '<option value="Europe/Vilnius">Lithuania</option>';
	$data .= '<option value="Europe/Oslo">Norway</option>';
	$data .= '<option value="Europe/Vienna">Österreich</option>';
	$data .= '<option value="Europe/Warsaw">Poland</option>';
	$data .= '<option value="Europe/Lisbon">Portugal</option>';
	$data .= '<option value="Europe/Bucharest">Rumänie</option>';
	$data .= '<option value="Europe/Zurich">Schweiz</option>';
	$data .= '<option value="Europe/Belgrade">Serbia</option>';
	$data .= '<option value="Europe/Bratislava">Slovakia</option>';
	$data .= '<option value="Europe/Madrid">Spain</option>';
	$data .= '<option value="Europe/Stockholm">Sweden</option>';
	$data .= '<option value="Europe/Istanbul">Turkey</option>';
	$data .= '<option value="America/New_York">USA (Eastern)</option>';
	$data .= '<option value="America/Chicago">USA (Central)</option>';
	$data .= '<option value="America/Denver">USA (Mountain)</option>';
	$data .= '<option value="America/Los_Angeles">USA (Pacific)</option>';
	$data .= '<option value="">others</option>';
	$data .= '</select>';
	$data .= '</td>';
	$data .= '<td>'. $imsg[54].'</td>';
	$data .= '</tr>';
	$data .= '<tr>';
	$data .= '<td>'.$imsg[4].'</td>';
	$data .= '<td><input type="text" name="DBHost" value="localhost" /></td>';
	$data .= '<td>'.$imsg[5].'</td>';
	$data .= '</tr>';
	$data .= '<tr>';
	$data .= '<td>'.$imsg[6].'</td>';
	$data .= '<td><input type="text" name="DBUser" /></td>';
	$data .= '<td rowspan="3">'.$imsg[9].'</td>';
	$data .= '</tr>';
	$data .= '<tr>';
	$data .= '<td>'.$imsg[7].'</td>';
	$data .= '<td><input type="password" id="dbPSWch" name="DBPass" class="dbPSW" required="required" /><span id="warningPSWch"></span></td>';
	$data .= '</tr>';
	$data .= '<tr>';
	$data .= '<td>'.$imsg[8].'</td>';
	$data .= '<td><input type="text" name="DBName" /></td>';
	$data .= '</tr>';
	$data .= '<tr>';
	$data .= '<td>'.$imsg[10].'</td>';
	$data .= '<td><input type="text" name="DBPrefix" value="guestbook" /></td>';
	$data .= '<td>'.$imsg[11].'</td>';
	$data .= '</tr>';
	$data .= '<tr>';	
	$data .= '<td>'.$imsg[12].'</td>';
	$data .= '<td>';
  	$data .= '<select width="100" name="Lang" type="text">';
	$data .= '<option selected="selected" value="de">Deutsch</option>';
	$data .= '<option value="en">English</option>';
	$data .= '<option value="fr">Français</option>';
	$data .= '<option value="it">Italiano</option>';
	$data .= '<option value="nl">Nederlands</option>';
	$data .= '<option value="sv">Swedish</option>';
	$data .= '<option value="pl">Polski</option>';
	$data .= '<option value="pt">Português</option>';
	$data .= '<option value="sk">Slovenčina</option>';
	$data .= '<option value="cz">Čeština</option>';
	$data .= '</select>';
	$data .= '</td>';
	$data .= '<td>'.$imsg[13].'</td>';
	$data .= '</tr>';
	$data .= '<tr>';
	$data .= '<td>'.$imsg[14].'</td>';
	$data .= '<td><input type="text" name="EMail" maxlength="80" /></td>';
	$data .= '<td>'.$imsg[15].'</td>';
	$data .= '</tr>';
	$data .= '<tr>';
	$data .= '<td>'.$imsg[16].'</td>';
	$data .= '<td><input type="text" name="AName" maxlength="20" value="admin" /></td>';
	$data .= '<td>'.$imsg[17].'</td>';
	$data .= '</tr>';
 	$data .= '<tr>';
  	$data .= '<td>'.$imsg[18].'</td>';
  	$data .= '<td><input type="password" id="psw" name="APass" class="dbPSW" required="required" /><span id="warningAPSW"></span></td>';
  	$data .= '<td>'.$imsg[19].'</td>';
  	$data .= '</tr>';
 	$data .= '<tr>';
 	$data .= '<td colspan="3">';
 	$data .= '<div id="admin-message">';
 	$data .= '<div class="pw-me">';
 	$data .= '<p class="aligncenter">'.$imsg[66].'</p>';
 	$data .= '<div><p id="letter" class="invalid">'.$imsg[67].'</p>';
 	$data .= '<p id="capital" class="invalid">'.$imsg[68].'</p>';
 	$data .= '<p id="number" class="invalid">'.$imsg[69].'</p>';
 	$data .= '<p id="length" class="invalid">'.$imsg[70].'</p></div>';
 	$data .= '<p style="font-size:16px;line-height:130%;"><strong>'.$imsg[71].'</strong></p>';
 	$data .= '</div>';
 	$data .= '</div>';
 	$data .= '</td>';
  	$data .= '</tr>';
	$data .= '<tr>';
	$data .= '<td colspan="2"><strong>'.$imsg[20].'</strong></td>';
	$data .= '<td rowspan="10"></td>';
	$data .= '</tr>';

	$directories = array('backup/','banner/','images/smilies/','img_guest/');

	umask(0);
	$passed = true;

	foreach ($directories as $dir) {
		$exists = $write = false;

		// Try to create the directory if it does not exist
		if (!file_exists($main_path . $dir)) {
			@mkdir($main_path . $dir, 0755); //?? falls zwingend nötig 0777
			@chmod($main_path . $dir, 0755); //?? falls zwingend nötig 0777
		}

		// Now really check
		if (file_exists($main_path . $dir) && is_dir($main_path . $dir)) {
			$exists = true;
		}

		// Now check if it is writable by storing a simple file
		$fp = @fopen($main_path . $dir . 'test_lock', 'wb');

		if ($fp !== false) {
			$write = true;
		}
		@fclose($fp);

		@unlink($main_path . $dir . 'test_lock');

		if (!$exists || !$write) {
			$passed = false;
		}

		$data .= '<tr>';
		$data .= '<td>' . $dir . ':</td>';
		$data .= '<td>';
		$data .= ($exists) ? '<strong style="color:green">'.$imsg[21].'</strong>' : '<strong style="color:red">'.$imsg[24].'<sup>1)</sup></strong>';
		$data .= ($exists && $write) ? ', <strong style="color:green">'.$imsg[22].'</strong>' : (($exists && !$write) ? ', <br /><strong style="color:red">'.$imsg[23].'<sup>1)</sup></strong>' : '');
		$data .= '</td>';
		$data .= '</tr>';
	}

	$directories02 = array('includes/config.inc.php');

	foreach ($directories02 as $dir02) {
		$write02 = $exists02 = true;

		if (file_exists($main_path . $dir02)) {
			if (!@is_writable($main_path . $dir02))	{
				$write02 = false;
			}
		}
		else {
			$write02 = $exists02 = false;
		}

		if (!$exists02 || !$write02) {
			$passed = false;
		}

		$data .= '<tr><td>'.$dir02.':</td>';
		$data .= '<td>';
		$data .= ($exists02) ? '<strong style="color:green">'.$imsg[21].'</strong>' : '<strong style="color:red">'.$imsg[24].'</strong>';
		$data .= ($write02) ? ', <strong style="color:green">'.$imsg[22].'</strong>' : (($exists02) ? ', <strong style="color:red">'.$imsg[23].'</strong>' : '');
		$data .= '</td>';
		$data .= '</tr>';
	}

	$data .= '<tr><td>'.$imsg[41].'</td>';
	$data .= '<td>';
	$data .= (extension_loaded('mysqli')) ? '<strong style="color:green">'.$imsg[21].'</strong>' : '<strong style="color:red">'.$imsg[24].'</strong>';
	$data .= '</td>';
	$data .= '</tr>';
	$data .= '<tr><td>'.$imsg[43].'</td>';
	$data .= '<td>';
	$data .= (extension_loaded('zlib')) ? '<strong style="color:green">'.$imsg[21].'</strong>' : '<strong style="color:red">'.$imsg[24].' <sup>3)</sup></strong>';
	$data .= '</td>';
	$data .= '</tr>';
	$data .= '<tr><td>'.$imsg[25].'</td>';
	$data .= '<td>';
	$data .= (extension_loaded('gd') && function_exists('gd_info')) ? '<strong style="color:green">'.$imsg[21].'</strong>' : '<strong style="color:red">'.$imsg[24].' <sup>4)</sup></strong>';
	$data .= '</td>';
	$data .= '</tr>';
	$data .= '<tr><td>'.$imsg[26].'</td>';
	$data .= '<td>';
	$data .= (extension_loaded('bcmath')) ? '<strong style="color:green">'.$imsg[21].'</strong>' : '<strong style="color:red">'.$imsg[24].'</strong>';
	$data .= '</td>';
	$data .= '</tr>';
	$data .= '</table>';
	$data .= '<br />';
	$data .= (!$exists) ? '<p class="aligncenter"><strong style="color:red"><sup>1)</sup> '.$imsg[51].'</strong></p>' : '';
	$data .= ($exists && !$write) ? '<p class="aligncenter"><strong style="color:red"><sup>1)</sup> '.$imsg[52].'</strong></p>' : '';
	$data .= (!extension_loaded('zlib')) ? '<p class="aligncenter"><strong style="color:red"><sup>3)</sup> '.$imsg[49].'</strong></p>' : '';
	$data .= (!extension_loaded('gd')) ? '<p class="aligncenter"><strong style="color:red"><sup>4)</sup> '.$imsg[50].'</strong></p>' : '';
	$data .= (extension_loaded('mysqli')) ? '<p class="aligncenter"><input type="submit" class="gb-button" value="'.$imsg[39].'"></p>' : '<p class="aligncenter"><strong style="color:red;font-size:18px">'.$imsg[42].'</strong></p>';
	$data .= '<input type="hidden" name="language" value="';
	$data .= (isset($_POST['language']) && ($_POST['language'] == "de" || $_POST['language'] == "en")) ? ''.$_POST['language'].'' : 'de';
	$data .= '" />';
  	$data .= '</form>';
	$data .= '</div>';

	return $data;
}

function show_smallconfig_table($fresh = true) {
	$count_entries = $url = $language = "";		

	if(isset($_POST['send_lang']) && $_POST['language'] != "" && ($_POST['language'] == "de" || $_POST['language'] == "en")){
		include("".$_POST['language'].".php");
		$language = $_POST['language'];
	}
	else {
		include("de.php");
	}

	$main_path = getmainpath();

	$data = '<div id="container_install">';
	$data .= '<form name="form1" method="post" action="./index.php?action=install&#38;step=3">';
	$data .= '<table class="install-table">';
	$data .= '<tr>';
	$data .= '<td style="width:160px">'.$imsg[1].'</td>';
	$data .= '<td style="width:150px"><input type="text" name="URL" value="'.getdomainpath().'" /></td>';
	$data .= '<td rowspan="2">'.$imsg[3].'<br /></td>';
	$data .= '</tr>';
	$data .= '<tr>';
	$data .= '<td>'.$imsg[2].'</td>';
	$data .= '<td><input type="text" name="mainpath" readonly="readonly" value="'.$main_path.'" /></td>';
	$data .= '</tr>';
	$data .= '<tr>';	
	$data .= '<td>'.$imsg[12].'</td>';
	$data .= '<td>';
  	$data .= '<select width="100" name="Lang" type="text">';
	$data .= '<option selected="selected" value="de">Deutsch</option>';
	$data .= '<option value="en">English</option>';
	$data .= '<option value="fr">Français</option>';
	$data .= '<option value="it">Italiano</option>';
	$data .= '<option value="nl">Nederlands</option>';
	$data .= '<option value="sv">Swedish</option>';
	$data .= '<option value="pl">Polski</option>';
	$data .= '<option value="pt">Português</option>';
	$data .= '<option value="sk">Slovenčina</option>';
	$data .= '<option value="cz">Čeština</option>';
	$data .= '</select>';
	$data .= '</td>';
	$data .= '<td>'.$imsg[13].'</td>';
	$data .= '</tr>';
	$data .= '<tr>';
	$data .= '<td>'.$imsg[14].'</td>';
	$data .= '<td><input type="text" name="EMail" maxlength="80" /></td>';
	$data .= '<td>'.$imsg[15].'</td>';
	$data .= '</tr>';
	$data .= '<tr>';
	$data .= '<td>'.$imsg[16].'</td>';
	$data .= '<td><input type="text" name="AName" maxlength="20" value="admin" /></td>';
	$data .= '<td>'.$imsg[17].'</td>';
	$data .= '</tr>';
 	$data .= '<tr>';
  	$data .= '<td>'.$imsg[18].'</td>';
  	$data .= '<td><input type="password" id="psw" name="APass" class="dbPSW" required="required" /><span id="warningAPSW"></span></td>';
  	$data .= '<td>'.$imsg[19].'</td>';
  	$data .= '</tr>';
 	$data .= '<tr>';
 	$data .= '<td colspan="3">';
 	$data .= '<div id="admin-message">';
 	$data .= '<div class="pw-me">';
 	$data .= '<p class="aligncenter">'.$imsg[66].'</p>';
 	$data .= '<div><p id="letter" class="invalid">'.$imsg[67].'</p>';
 	$data .= '<p id="capital" class="invalid">'.$imsg[68].'</p>';
 	$data .= '<p id="number" class="invalid">'.$imsg[69].'</p>';
 	$data .= '<p id="length" class="invalid">'.$imsg[70].'</p></div>';
 	$data .= '<p style="font-size:16px;line-height:130%;"><strong>'.$imsg[71].'</strong></p>';
 	$data .= '</div>';
 	$data .= '</div>';
 	$data .= '</td>';
  	$data .= '</tr>';
	$data .= '<tr><td>'.$imsg[41].'</td>';
	$data .= '<td>';
	$data .= (extension_loaded('mysqli')) ? '<strong style="color:green">'.$imsg[21].'</strong>' : '<strong style="color:red">'.$imsg[24].'</strong>';
	$data .= '</td>';
	$data .= '<td rowspan="4"></td>';
	$data .= '</tr>';
	$data .= '<tr><td>'.$imsg[43].'</td>';
	$data .= '<td>';
	$data .= (extension_loaded('zlib')) ? '<strong style="color:green">'.$imsg[21].'</strong>' : '<strong style="color:red">'.$imsg[24].' <sup>3)</sup></strong>';
	$data .= '</td>';
	$data .= '</tr>';
	$data .= '<tr><td>'.$imsg[25].'</td>';
	$data .= '<td>';
	$data .= (extension_loaded('gd') && function_exists('gd_info')) ? '<strong style="color:green">'.$imsg[21].'</strong>' : '<strong style="color:red">'.$imsg[24].' <sup>4)</sup></strong>';
	$data .= '</td>';
	$data .= '</tr>';
	$data .= '<tr><td>'.$imsg[26].'</td>';
	$data .= '<td>';
	$data .= (extension_loaded('bcmath')) ? '<strong style="color:green">'.$imsg[21].'</strong>' : '<strong style="color:red">'.$imsg[24].'</strong>';
	$data .= '</td>';
	$data .= '</tr>';
	$data .= '</table>';
	$data .= '<br />';
	$data .= (!extension_loaded('zlib')) ? '<p class="aligncenter"><strong style="color:red"><sup>3)</sup> '.$imsg[49].'</strong></p>' : '';
	$data .= (!extension_loaded('gd')) ? '<p class="aligncenter"><strong style="color:red"><sup>4)</sup> '.$imsg[50].'</strong></p>' : '';
	$data .= (extension_loaded('mysqli')) ? '<p class="aligncenter"><input type="submit" class="gb-button" value="'.$imsg[39].'"></p>' : '<p class="aligncenter"><strong style="color:red;font-size:18px">'.$imsg[42].'</strong></p>';
	$data .= '<input type="hidden" name="language" value="';
	$data .= (isset($_POST['language']) && ($_POST['language'] == "de" || $_POST['language'] == "en")) ? ''.$_POST['language'].'' : 'de';
	$data .= '" />';
  	$data .= '</form>';
	$data .= '</div>';

	return $data;
}

define('InInstaller', 1);

$main_path = getmainpath();

header('Content-Type: text/html;charset=utf-8');
header('X-Robots-Tag: noindex');
header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
header("Cache-Control: no-store, no-cache, must-revalidate");
header("Pragma: no-cache");

echo"<!DOCTYPE html>
	<html lang=\"$lang_short\">
	<head>
		<meta charset=\"".$encoding."\" />
		<meta name=\"Content-language\" content=\"$lang_short\" />
		<link rel=\"stylesheet\" href=\"".getdomainpath()."/install/gbook-install-style2021.css\" />
		<style>
			.install-table{width:800px;border-collapse:collapse;border:solid 1px black;margin-left:auto;margin-right:auto}
			.install-table td{vertical-align:middle;padding:9px;text-align:left;border:solid 1px black}
		</style>
		<script>
			window.onload=externalLinks;function externalLinks(){if(!document.getElementsByTagName) return;var links,a,i;links=document.getElementsByTagName(\"a\");for(i=0;i<links.length;i++){a=links[i];if(a.getAttribute(\"rel\") && a.getAttribute(\"rel\").indexOf(\"external\")>-1){a.onclick=function(){window.open(this.href);return false}}}}
		</script>
		<meta name=\"robots\" content=\"noindex, nofollow\" />
		<meta name=\"author\" content=\"Wolfgang Leverberg - www.php-guestbook.de\" />
	</head>
	<body>
		<div id=\"container\">
			<a href=\"https://www.php-guestbook.de\" rel=\"external\" title=\"Link öffnet ein neues Fenster | Link opens a new window\"><img class=\"aligncenter\" src=\"".getdomainpath()."/install/myphpgb_installlogo.png\" alt=\"myPHP Guestbook $version\" border=\"0\" width=\"300\" height=\"34\" /></a>
			";

				if (isset($_GET['action']))	{
					if (!preg_match("/^[_\a-z]*$/is", $_GET['action']))	{
						require_once("intro.php");
					}
				}
				else {
					$_GET['action'] = "";
				}

				switch($_GET['action'])
					{
					    case "intro";

						echo"<div style=\"text-align:center;\">
								<br /><strong>Bitte Sprache wählen: / Please choose language:</strong>&nbsp;
								<form style=\"float:right;position:relative;right:60px;\" method=\"post\" action=\"#\">
									<select class=\"select\" name=\"language\">
										<option"; if (isset($_POST['send_lang']) && $_POST['language'] == "de"){echo" selected=\"selected\"";} echo" value=\"de\">Deutsch</option>
										<option"; if (isset($_POST['send_lang']) && $_POST['language'] == "en"){echo" selected=\"selected\"";} echo" value=\"en\">English</option>
									</select> 
									<input type=\"submit\" class=\"ok-button\" name=\"send_lang\" value=\"OK\" /><input type=\"hidden\" name=\"send_language\" value=\"";

										if(isset($_POST['send_lang']) && ($_POST['language'] == "de" || $_POST['language'] == "en")){
											echo"".$_POST['language']."";
										}
										else {
											echo"de";
										}

										echo"\" />

								</form><br /><br /><hr /><br />
							</div>";

				        require_once("intro.php");
				        break;

					    case "install";
				        require_once("install.php");
				        break;

					    case "update";
				        require_once("database.php");
				        break;

					    default:

    					echo"<div style=\"text-align:center;\">
								<br /><strong>Bitte Sprache wählen: / Please choose language:</strong>&nbsp;
								<form style=\"float:right;position:relative;right:60px;\" method=\"post\" action=\"#\">
									<select class=\"select\" name=\"language\">
										<option"; if (isset($_POST['send_lang']) && $_POST['language'] == "de"){echo" selected=\"selected\"";} echo" value=\"de\">Deutsch</option>
										<option"; if (isset($_POST['send_lang']) && $_POST['language'] == "en"){echo" selected=\"selected\"";} echo" value=\"en\">English</option>
									</select> 
									<input type=\"submit\" class=\"ok-button\" name=\"send_lang\" value=\"OK\" /><input type=\"hidden\" name=\"send_language\" value=\"";

										if(isset($_POST['send_lang']) && ($_POST['language'] == "de" || $_POST['language'] == "en")){
											echo"".$_POST['language']."";
										}
										else {
											echo"de";
										}

										echo"\" />

								</form><br /><br /><hr /><br />
							</div>";

			    	    require_once("intro.php");
				        break;
					}

	echo'
		</div>';

	echo'
		<script>
			function input_no_activate(){if(document.options.choose_version.checked == true){document.options.AName.disabled=false;document.options.APass.disabled=false;}else{document.options.AName.disabled=true;document.options.APass.disabled=true;}}
			function input_activate(){if(document.options.choose_version.checked == true){document.options.AName.disabled=true;document.options.APass.disabled=true;}else{document.options.AName.disabled=false;document.options.APass.disabled=false;}}
			var myInput=document.getElementById("psw");
			var letter=document.getElementById("letter");
			var capital=document.getElementById("capital");
			var number=document.getElementById("number");
			var length=document.getElementById("length");
			var pswSecHint=\'<a class="pswCH" data-tooltip="'.$imsg[76].'" href="javascript:void(0)"><img class="pswCH" src="../images/ausruf.png" width="14" height="14" alt="Check!" /></a>\';
			myInput.onfocus=function(){document.getElementById("admin-message").style.display="block";}
			myInput.onblur=function(){document.getElementById("admin-message").style.display="none";}
			myInput.onkeyup=function(){
				var lowerCaseLetters=/[a-zäöüß]/g;
				if(myInput.value.match(lowerCaseLetters)){letter.classList.remove("invalid");letter.classList.add("valid");}
				else{letter.classList.remove("valid");letter.classList.add("invalid");}
				var upperCaseLetters=/[A-ZÄÖÜ]/g;
				if(myInput.value.match(upperCaseLetters)){capital.classList.remove("invalid");capital.classList.add("valid");}
				else{capital.classList.remove("valid");capital.classList.add("invalid");}
				var numbers=/[0-9]/g;
				if(myInput.value.match(numbers)){number.classList.remove("invalid");number.classList.add("valid");}
				else{number.classList.remove("valid");number.classList.add("invalid");}
				if(myInput.value.length>=11){length.classList.remove("invalid");length.classList.add("valid");}
				else{length.classList.remove("valid");length.classList.add("invalid");}
				var signs=/[^A-Za-z0-9?!()]/g;
				if(myInput.value.match(signs)){document.getElementById("warningAPSW").innerHTML=pswSecHint;myInput.classList.add("no-insert");}
				else{document.getElementById("warningAPSW").innerHTML="";myInput.classList.remove("no-insert");}
			}
			var myDBpsw=document.getElementById("dbPSWch");
			var pswhint=\'<a class="pswCH" data-tooltip="'.$imsg[74].'" href="javascript:void(0)"><img class="pswCH" src="../images/ausruf.png" width="14" height="14" alt="Check!" /></a>\';
			myDBpsw.onkeyup=function(){
				var signs=/[^A-Za-z0-9#?!()]/g;
				if(myDBpsw.value.match(signs)){document.getElementById("warningPSWch").innerHTML=pswhint;myDBpsw.classList.add("no-insert");}
				else{document.getElementById("warningPSWch").innerHTML="";myDBpsw.classList.remove("no-insert");}
			}
			
		</script>
	</body>
	</html>';

?>