<?php
/*
	myPHP Guestbook Copyright (C) 2003 - 2006  Claudio Pose
	myPHP Guestbook was an open source project of Networkarea.ch

	Version 3.x Copyright (C) 2011 - 2014 Christian Thomas, www.hostonline.de

	Version 4.x (MySQLi) Copyright (C) 2014 - 2022 Wolfgang Leverberg, www.php-guestbook.de

	This file is a part of myPHP Guestbook.
	myPHP Guestbook is free software; you can redistribute it and/or modify it under the terms of the 
	GNU General Public License as published by the Free Software Foundation; either version 3 of the 
	License, or (at your option) any later version.

	myPHP Guestbook is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
	even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

	See the GNU General Public License for more details.

	02.01.2022
*/
	header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
	header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
	header("Cache-Control: no-store, no-cache, must-revalidate");
	header("Pragma: no-cache");

	require_once("includes/functions.inc.php");

	$_GET['userlang'] = isset($_GET['userlang']) ? htmlentities($_GET['userlang'], ENT_QUOTES, "UTF-8") : "";

	if(in_array($_GET['userlang'], $langArray, true)) {
		setcookie("myphpgb-language",$_GET['userlang'],0,"/","","",true);
		header("Location: ".$url."index.php");
	}
	else {
		$_GET['userlang'] = "";
	}

	if (isset($_SESSION['entrie_quote'])) {
		unset($_SESSION['entrie_quote']);
	}

	$sql_properties = $gbook->query("SELECT `admin_email`,`bbcode`,`check_email`,`check_homepage`,`deactivate_html`,`default_style`,`default_template`,`entries_per_site`,`guestbook_status`,`guestbook_title`,`images_in_entries`,`links_in_sitefunction`,`max_word_length`,`release_entries`,
									`smilies`,`statistic`,`statistic_ban`,`quote_func`,`link_entry`,`check_town`,`check_country`,`button_link`,`rating`,`rating_text`,`choose_lang`,`administration`,`check_banner`,`privacy_hint`,`privacy_url`,`search_func`,`permalink`  
									FROM `".$table."_properties`") or die();
	$properties    	= $sql_properties->fetch_assoc();
	$default_style 	= $properties['default_style'];

	$bad = $good = $separated_red = $separated_gray = $rating_entry = $show_rating_infos = $privMargLe = $star_ico = $quotation01 = $quotation02 = $quotation03 = $quotation04 = $copSign = "";
	$buttonReset = $errorSearch = $error_msg = $countMySearch = $search = $mySearch = $mySearchResult = $noSearch = $searchResult = $searchInfo = $pl_hind = $js_gbook = $oninput = $inputClass = "";
	$short_town = "30";
	$numSearch = 0;
	$show_default = true;

	$properties['link_entry'] = $properties['link_entry'] === NULL ? "" : $properties['link_entry'];
	$properties['rating_text'] = $properties['rating_text'] === NULL ? "" : $properties['rating_text'];
	$properties['privacy_url'] = $properties['privacy_url'] === NULL ? "" : $properties['privacy_url'];

	$query_count_entries = $gbook->query("SELECT `id` FROM `".$table."_entries` WHERE `status` != '0'");
	$count_entries       = $query_count_entries->num_rows;

	require_once("includes/lang.inc.php");

	if (!empty($properties['search_func'])) {
		session_start();
		include("includes/search.inc.php");
	}

	$_SESSION['mysearch'] = isset($_SESSION['mysearch']) ? stripslashes(htmlspecialchars(strip_tags($_SESSION['mysearch']))) : "";

	$numSearch > 0 ? $count_entries = $numSearch : "";

	SCROLL_TO_TOP ? $scrollTop = 'onclick="mygbTop();"' : $scrollTop = '';

	(empty($properties['link_entry'])) ? ($link_entry = $fmsg[13]) : ($link_entry = $properties['link_entry']);
	($setLang !== $langFile) ? ($link_entry = $fmsg[13]) : "";

	if ($properties['button_link'] == 0) {
		$html_entry = "<p class=\"margtop-dyn\"><strong><a class=\"navi-page\" ".$scrollTop." href=\"".$url."insert.php#anchor-gbooktop02\">".$link_entry."</a></strong></p>";
	}
	elseif ($properties['button_link'] == 1) {
		$html_entry = "<p class=\"button-marg\"><a class=\"button-gb insert-button\" style=\"font-size:1em;line-height:1.6em;\" ".$scrollTop." href=\"".$url."insert.php#anchor-gbooktop02\"><span class=\"dynLine\">".$link_entry."</span></a></p>";
	}
	else {
		$html_entry = "<br />";
	}

	if (isset($_GET['action']))	{
		$_GET['action'] = strip_tags(trim($_GET['action']));
		$_GET['action'] = $gbook->real_escape_string($_GET['action']);

		if ($_GET['action'] == "deactivate_entry") {
			include_once("admin/deactivate_entry.php");
		}
		elseif ($_GET['action'] == "activate_entry") {
			include_once("admin/activate_entry.php");
		}
		elseif ($_GET['action'] == "post") {
			$_GET['action'] = "post";
		}
		else {
			$_GET['action'] = "";
		}
	}
	else {
		$_GET['action'] = "";
	}

	if (isset($_GET['id']) && isset($_GET['number'])) {
		$_GET['id'] 	= trim($_GET['id']);
		$_GET['number'] = trim($_GET['number']);

		if (empty($_GET['id']) OR (!is_numeric($_GET['id']) OR intval($_GET['id']) != $_GET['id'])) {
			$_GET['id'] = $_GET['number'] = "";
		}
		elseif (empty($_GET['number']) OR (!is_numeric($_GET['number']) OR intval($_GET['number']) != $_GET['number'])) {
			$_GET['id'] = $_GET['number'] = "";
		}
	}
	else {
		$_GET['id'] = $_GET['number'] = "";
	}

	if ($properties['permalink'] && $_GET['action'] == "post" && $_GET['id'] != "") {
		$pl_hind = "<p class=\"button-marg\"><a class=\"button-gb insert-button\" href=\"".$url."index.php#anchor-gbooktop\">".$fmsg[195]."</a></p>";
		$show_default = false;
		unset($_SESSION['mysearch']);
		$mySearch = $_POST['search'] = "";
	}

	$sql_template = $gbook->query("SELECT `bgcolor`, `bgimage`, `fontcolor`, `html`, `image_email`, `image_homepage`, `divalign`, `tablewidth`, `tdcolor`, `td2color`, `image_star`, `fontfamily`, `fontsize`, `linkcolor`, `hovercolor` FROM `".$table."_template` WHERE `id` = '".$properties['default_template']."'");
	$template = $sql_template->fetch_assoc();

	$gbFontSize = $template['fontsize'];
	$checkSize = substr($gbFontSize, -2);
	$myFontSize = str_replace($checkSize,"",$gbFontSize);

	(($myFontSize < 15 && $myFontSize > 5) || $myFontSize < 1) ? $fontsizeClass = 'normal-size' : '';

	if ($myFontSize > 18 OR ($myFontSize < 5 && $myFontSize > 1.1)) {
		$linkSymClass = 'external-large';
		$fontsizeClass = 'small-03';
	}

	if ($properties['rating']) {
		$star_ico = $template['image_star'];

		(empty($properties['rating_text'])) ? ($rating_entry = $fmsg[352]) : ($rating_entry = $properties['rating_text']);
		($setLang !== $langFile) ? ($rating_entry = $fmsg[352]) : "";

		$sql_show_rating = $gbook->query("SELECT `count_rating`, `average_rating` FROM `".$table."_rating`");
		list($count_rating, $average_rating) = $sql_show_rating->fetch_row();

		($properties['rating'] == 2) ? ($show_rating_infos = "<br />".$fmsg[358].": ".$average_rating." ".$fmsg[359]." ".$count_rating." ".$fmsg[360]."") : "";
	}

	if (!empty($properties['quote_func'])) {
		if ($properties['default_template'] < 9) {
			$quotation01 = "<div class=\"quote\"><a ".$scrollTop." href=\"".$url."insert.php?action=quote&#38;id=";
			$quotation02 = "#anchor-gbooktop02\" title=\"".$fmsg[321]."\"><img title=\"".$fmsg[321]."\" src=\"".$url."images/quote.png\" width=\"20\" height=\"20\" alt=\"".$fmsg[321]."\" /></a></div>";
		}
		else {
			$quotation01 = "<a class=\"reply\" ".$scrollTop." href=\"".$url."insert.php?action=quote&#38;id=";
			$quotation02 = "#anchor-gbooktop02\" title=\"".$fmsg[322]."\">".$fmsg[200]."</a>";
		}
		$quotation03 = "<a class=\"reply\" ".$scrollTop." href=\"".$url."insert.php?action=quote&#38;id=";
		$quotation04 = "#anchor-gbooktop02\" title=\"".$fmsg[322]."\"></a>";
	}

	$quotes = array("<\$quote_ico\$>","<\$new_quote\$>");

	($properties['statistic'] == 1) ? require_once("includes/stats.inc.php") : "";

	if (!empty($properties['choose_lang']) && !empty($properties['search_func'])) {
		$startLeft = "i-left";
		$startRight = "i-right";
	}
	else {
		$startLeft = "i-mid";
		$startRight = "i-max";
	}

	if (isset($_GET['page'])) {
		(!is_numeric($_GET['page']) OR empty($_GET['page'])) ? $page = 1 : $page = $_GET['page'];
	}
	else {
		$page = 1;
	}

	$page               = $gbook->real_escape_string($page);
	$pages_total        = ceil($count_entries/$properties['entries_per_site']) ;
	$page_start         = floor($page - $properties['links_in_sitefunction']/2) ;
	$page_start         = $page_start <= 0 ?  1 : $page_start ;
	$page_end           = ($page_start + $properties['links_in_sitefunction']-1) ;
	$page_end           = $page_end >= $pages_total ?  $pages_total : $page_end ;
	$page_max           = $page*$properties['entries_per_site'];
	$max_minus_per_page = $page_max-$properties['entries_per_site'];
	$page_entry_start   = $count_entries-$max_minus_per_page+1;

	include("header.php");

	(empty($template['bgimage'])) ? $indexBody = "<body><div class=\"myphpgb gb-align text-center lineheight\">" : $indexBody = "<body style=\"background-image:url(".$template['bgimage'].")\"><div class=\"myphpgb gb-align text-center lineheight\">";

	echo "".$indexBody."";

	if ($properties['check_banner']) {
		$sql_banner = $gbook->query("SELECT `filename`, `title`, `width`, `height`, `link_text`, `url`, `status` FROM `".$table."_banner` WHERE `status` > 0");
		list($bannerFilename,$bannerTitle,$bannerWidth,$bannerHeight,$bannerText,$bannerURL,$bannerStatus) = $sql_banner->fetch_row();

		if ($bannerStatus == 1) {
			$bannerFilename = $bannerFilename === NULL ? "" : stripslashes(htmlentities(strip_tags($bannerFilename), ENT_QUOTES, "UTF-8"));
			$bannerTitle 	= $bannerTitle === NULL ? "" : stripslashes(htmlentities(strip_tags($bannerTitle), ENT_QUOTES, "UTF-8"));
			$bannerURL 		= $bannerURL === NULL ? "" : stripslashes(htmlentities(strip_tags($bannerURL), ENT_QUOTES, "UTF-8"));

			echo"
				<div class=\"myphpgb-banner\">
					<a href=\"".$bannerURL."\" title=\"".$bannerTitle."\"><img class=\"centered\" style=\"box-shadow:none !important;\" title=\"".$bannerTitle."\" src=\"".$url."banner/".$bannerFilename."\" alt=\"".$bannerTitle."\" width=\"".$bannerWidth."\" height=\"".$bannerHeight."\" /></a>
				</div>";
		}

		if (!empty($bannerText)) {
			$bannerText = $bannerText === NULL ? "" : htmlentities($bannerText, ENT_QUOTES, "UTF-8");
			$bannerText = nl2br($bannerText);
			$bannerText = stripslashes($bannerText);
			$bannerText = bbcode($bannerText);

			echo"
				<div class=\"banner-text\">
					".$bannerText."
				</div><br />";
		}
	}

	if ($properties['guestbook_status']) {
		echo'
			<span id="anchor-gbooktop"></span>
			<div class="i-wrapper" style="width:100%;">';

				if (!empty($properties['search_func']) && $show_default == true){
					echo'
						<div class="'.$startLeft.'">
							<form action="#anchor-gbooktop" method="post" class="search-form">
								<div class="search-container">
									<div class="input-search">
										<label class="dsR3" for="gbsearch">'.$fmsg[363].'</label>
										<input id="gbsearch" class="search-insert'.$inputClass.'" style="border-right:none;" type="text" name="search" '.$oninput.' maxlength="'.$maxInputSearch.'" placeholder="('.$fmsg[363].')" value="';
	
											if (isset($_POST['search']) AND trim($_POST['search']) != "" && $freeCounter) {
												echo stripslashes(htmlspecialchars(strip_tags($_POST['search'])));
											}
											elseif ($mySearch != "" && $freeCounter) {
												echo stripslashes(htmlspecialchars(strip_tags($search)));
											}

										echo '" required="required" autocomplete="off" /><input class="search-icon" style="border-left:none;" type="submit" name="send_suche" '.$scrollTop.' title="'.$fmsg[363].'" value="" />';
	
										if (isset($_SESSION['mysearch']) && !empty($_SESSION['mysearch'])) {
											echo'
												<input class="search-button" type="submit" name="reset" title="'.$fmsg[364].'" value="'.$fmsg[365].'" onclick="mygbTop();self.location.href=\''.$url.'index.php\'" />';
												$searchInfo = ' style="display:none;"';
										}
	
									echo'
										<div class="search-infobox"'.$searchInfo.'>
											<div class="info-box">
												<img src="'.$url.'images/help.png" width="14" height="14" alt="" /><div class="info-text">'.$fmsg[312].'</div>
											</div>
										</div>
									</div>
								</div>
							</form>
						</div>';

						$js_gbook = "<script>document.addEventListener('DOMContentLoaded', SearchField);</script>";

					if ((!empty($_POST['search']) OR (isset($_SESSION['mysearch']) && !empty($_SESSION['mysearch']))) && $freeCounter && empty($errorSearch)) {
						$searchResult = '<div class="myphpgb gb-align text-center"><mark>'.$fmsg[366].': <strong>'.$numSearch.'</strong></mark></div>';
					}
				}

				if ($properties['choose_lang'] && $show_default == true) {
					if ($setLang !== "en") {
						$tooltipClass = " class=\"gbtooltip\"";
						$tooltipText = "<span class=\"gbtooltiptext\" style=\"line-height:160%;\">".$fmsg[97]."</span>";
					}
					else {
						$tooltipClass = $tooltipText = "";
					}

					echo"
						<div class=\"".$startRight."\" style=\"margin-right:2px;\">
							<div class=\"text-right size-12\">
								<div id=\"myLang\">
									<div class=\"lang-block langtip\" title=\"".$fmsg[199]."!\"><img style=\"width:100%;height:auto;\" src=\"".$url."images/2021-flags-de-en-fr-it-nl-pl-sv-pt-cz-sk.png\" width=\"120\" height=\"29\" alt=\"".$fmsg[270]."\" /><span class=\"langtiptext\">Choose another language</span></div>
								</div>
								<div class=\"break\" style=\"line-height:1em;\"><noscript class=\"nojs-lang\">(".$fmsg[271].")</noscript></div>
								<div id=\"choose_language\" class=\"lang break\">";

									($properties['choose_lang'] == 2) ? ($selectLang = "<p class=\"cookie-hint\">".$cmsg[0]."</p>") : ($selectLang = "");

								echo"
									".$selectLang."
								</div>
								<div id=\"lang-menue\">
									<ul class=\"chooseLang\">
										<li".$tooltipClass."><a href=\"javascript:void(0);\" class=\"navi-page txtfade\">Select a language</a>".$tooltipText."
											<ul>
												<li><a href=\"?userlang=de#anchor-gbooktop\">Deutsch</a></li>
												<li><a href=\"?userlang=en#anchor-gbooktop\">English</a></li>
												<li><a href=\"?userlang=fr#anchor-gbooktop\">Français</a></li>
												<li><a href=\"?userlang=it#anchor-gbooktop\">Italiano</a></li>
												<li><a href=\"?userlang=nl#anchor-gbooktop\">Nederlands</a></li>
												<li><a href=\"?userlang=pl#anchor-gbooktop\">Polski</a></li>
												<li><a href=\"?userlang=pt#anchor-gbooktop\">Português</a></li>
												<li><a href=\"?userlang=sv#anchor-gbooktop\">Svenska</a></li>
												<li><a href=\"?userlang=sk#anchor-gbooktop\">Slovenčina</a></li>
												<li><a href=\"?userlang=cz#anchor-gbooktop\">Čeština</a></li>
											</ul>
										</li>
									</ul>
									<div class=\"break\"></div>";

									($properties['choose_lang'] == 2) ? ($selectLang02 = "<hr class=\"transp-03\" />") : ($selectLang02 = "<br />");

								echo"
									".$selectLang02."
								</div>
							</div>
						</div>";
					
					$js_gbook .= "
						<script>var labl=document.getElementsByClassName('lang-block');var chla=document.getElementById('choose_language');var lame=document.getElementById('lang-menue');var ct;if(labl!='undefined' && chla!='undefined' && lame!='undefined'){for(ct=0;ct<labl.length;ct++){labl[ct].addEventListener('click',function(){if(chla.style.maxHeight){chla.style.maxHeight=null;lame.style.display='none';}else{chla.style.maxHeight=chla.scrollHeight+'px';lame.style.display='block';}});}}</script>";
				}

		echo'
			</div>
			<div class="break">'.$searchResult.'</div>';

		if ($show_default == true) {
			if ($count_entries > 1) {
				if ($properties['default_template'] < 4) {
					echo"
						<p>".$fmsg[12]."</p>";
				}
			}
			else {
				if ($count_entries > 0)	{
					if ($properties['default_template'] < 4) {
						echo"
							<p>".$fmsg[227]."</p>";
					}
				}
				else {   
					echo"
						<p><br /><strong>".$fmsg[226]."</strong></p>";
				}
			}

			echo"
				".$html_entry."
				<span class=\"lh-large\">";

			if ($page > 1) {
				$page_minus = $page-1;
				echo "<a class=\"arrow-left\" href=\"".$url."index.php?page=".$page_minus."#anchor-gbooktop\"><img class=\"middle\" src=\"".$url."images/left.png\" height=\"14\" width=\"12\" title=\"".$fmsg[4]."\" alt=\"".$fmsg[4]."\" /></a>";
			}

			if ($page_start > 1) {
				echo "<a class=\"navi-page marg-side10\" href=\"".$url."index.php?page=1#anchor-gbooktop\">1</a>... ";
			}

			for ($i = $page_start; $i <= $page_end ;$i++) {
				if ($i == $page) {
					echo "<span class=\"this-page marg-side8\"> [".$i."] </span>";
				}
				else {
					echo "<a class=\"navi-page marg-side8\" href=\"".$url."index.php?page=".$i."#anchor-gbooktop\"> ".$i." </a>";
				}
			}

			if ($page_end < $pages_total) {
				echo " ...<a class=\"navi-page marg-side10\" href=\"".$url."index.php?page=".$pages_total."#anchor-gbooktop\">".$pages_total."</a>";
			}

			if ($page < $pages_total) {
				$page_plus = $page+1;
				echo "<a class=\"arrow-right\" href=\"".$url."index.php?page=".$page_plus."#anchor-gbooktop\"><img class=\"middle\" src=\"".$url."images/right.png\" height=\"14\" width=\"12\" title=\"".$fmsg[14]."\" alt=\"".$fmsg[14]."\" /></a>";
			}

			echo "</span>";
		}
		else {
			echo"
				".$pl_hind."";
		}

		echo"
			</div>
			<div class=\"break\"><br /></div>";

		if (!empty($properties['search_func']) && $numSearch > 0 && $_GET['action'] != "post") {
			$sql_entries = $gbook->prepare("SELECT `comment`, `date`, `email`, `homepage`, `id`, `status`, `name`, `text`, `time`, `origin`, `stars`, `check_time` FROM `".$table."_entries` WHERE `status` != '0' AND (`comment` LIKE ? OR `date` LIKE ? OR `name` LIKE ? OR `text` LIKE ?) ORDER BY `id` DESC LIMIT ".(($page-1)*$properties['entries_per_site'] ).",".$properties['entries_per_site']."");
			$sql_entries->bind_param('ssss', $mySearch,$mySearch,$mySearch,$mySearch);
			$sql_entries->execute();
			$sql_entries->store_result();
			$sql_entries->bind_result($comment, $date, $email, $homepage, $id, $status, $name, $text, $time, $origin, $stars, $usTime);
		}
		elseif (!empty($properties['permalink']) && $_GET['action'] == "post" && $_GET['id'] != "") {
			$sql_entries = $gbook->prepare("SELECT `comment`, `date`, `email`, `homepage`, `id`, `status`, `name`, `text`, `time`, `origin`, `stars`, `check_time` FROM `".$table."_entries` WHERE `status` != '0' AND `id` = ? LIMIT 1");
			$sql_entries->bind_param('i', $_GET['id']);
			$sql_entries->execute();
			$sql_entries->store_result();
			$numQuote = $sql_entries->num_rows;

			if ($numQuote == 0) {
				$no_quote = '<p class="aligncenter"><strong>'.$emsg[36].'</strong></p><br />';
			}
			else {
				$no_quote = "";
				$sql_entries->bind_result($comment, $date, $email, $homepage, $id, $status, $name, $text, $time, $origin, $stars, $usTime);
			}

			echo" ".$no_quote."";
			$page_entry_start = $_GET['number']+1;
		}
		else {
			$sql_entries = $gbook->prepare("SELECT `comment`, `date`, `email`, `homepage`, `id`, `status`, `name`, `text`, `time`, `origin`, `stars`, `check_time` FROM `".$table."_entries` WHERE `status` != '0' ORDER BY `id` DESC LIMIT ".(($page-1)*$properties['entries_per_site'] ).",".$properties['entries_per_site']."");
			$sql_entries->execute();
			$sql_entries->store_result();
			$sql_entries->bind_result($comment, $date, $email, $homepage, $id, $status, $name, $text, $time, $origin, $stars, $usTime);
		}

		while ($sql_entries->fetch()) {
			$gb_rating = $gb_rating01 = $gb_rating02 = "";

			$page_entry_start = $page_entry_start-1;
			$number = $page_entry_start;

			$bad  = array("(",")","{","}","@");
			$good = array("&#40;","&#41;","&#123;","&#125;","&#64;");

			$name = $name === NULL ? "" : $name;
			$origin = $origin === NULL ? "" : $origin;
			$email = $email === NULL ? "" : $email;
			$homepage = $homepage === NULL ? "" : $homepage;
			$comment = $comment === NULL ? "" : $comment;

			$name = nobadwords($name);
			$name = stripslashes(htmlentities(strip_tags($name), ENT_QUOTES, "UTF-8"));
			$name = str_replace($bad, $good, $name);

			$origin = (($properties['check_town'] == 1) && ($properties['check_country'] == 1)) ? "" : $origin;
			$origin = nobadwords($origin);
			$origin = stripslashes(htmlentities(strip_tags($origin), ENT_QUOTES, "UTF-8"));
			$origin = shortWords($origin, $short_town);

			$email = ($properties['check_email'] < 2) ? $email : "";
			$email = stripslashes(htmlspecialchars(strip_tags($email), ENT_QUOTES));
			$email = noInjektion($email);
			$email = noSpam02($email);

			$homepage = ($properties['check_homepage'] == 0) ? $homepage : "";
			$homepage = stripslashes(htmlentities(strip_tags($homepage), ENT_QUOTES, "UTF-8"));

			$stars = ($properties['rating'] != 0) ? $stars : 0;
			$stars = stripslashes(htmlentities(strip_tags($stars), ENT_QUOTES, "UTF-8"));

			$text = preg_replace('/(\r\n)(\\1{1,1})\\1*/sS', '$1$2', $text);
			$text = nobadwords($text);
			$text = shortWords($text, $properties['max_word_length']);

			if($properties['deactivate_html']){
				$text	= htmlentities(strip_tags($text), ENT_QUOTES, "UTF-8");
				$comment = htmlentities(strip_tags($comment), ENT_QUOTES, "UTF-8");
			}

			$text = nl2br($text);
			$text = stripslashes($text);

			$comment = nl2br($comment);
			$comment = stripslashes($comment);

			if ($numSearch > 0) {
				$date = str_replace(stripslashes(htmlentities(strip_tags($search), ENT_QUOTES, "UTF-8")), "<mark>".stripslashes(htmlentities(strip_tags($search), ENT_QUOTES, "UTF-8"))."</mark>", $date);
				$name = str_ireplace(stripslashes(htmlentities(strip_tags($search), ENT_QUOTES, "UTF-8")), "<mark>".stripslashes(htmlentities(strip_tags($search), ENT_QUOTES, "UTF-8"))."</mark>", $name);
				$text = str_ireplace(stripslashes(htmlentities(strip_tags($search), ENT_QUOTES, "UTF-8")), "<mark>".stripslashes(htmlentities(strip_tags($search), ENT_QUOTES, "UTF-8"))."</mark>", $text);
				$comment = str_ireplace(stripslashes(htmlentities(strip_tags($search), ENT_QUOTES, "UTF-8")), "<mark>".stripslashes(htmlentities(strip_tags($search), ENT_QUOTES, "UTF-8"))."</mark>", $comment);
			}

			if ($properties['quote_func']) {
				$text = quote($text);
			}

			if ($properties['bbcode']) {
				$text    = bbcode($text);
				$comment = bbcode($comment);
				$comment = pictures($comment);

				if ($properties['images_in_entries']) {
					if ($status == 2){
						$text = pictures($text);
					}
					else {
						$text = preg_replace("/\[img\](.*?)\[\/img\]/si", "<p id=\"placeholder\"><br /><br />".$fmsg[318]."</p>", $text);
					}
				}
				else {
					$text = preg_replace("/\[img\](.*?)\[\/img\]/si", "", $text);
				}
			}
			else {
				$text = preg_replace("/\[img\](.*?)\[\/img\]/si", "", $text);
				$text = preg_replace("/\[b\](.*?)\[\/b\]/si", "<strong>\\1</strong>", $text);
				$text = preg_replace("/\[.*?\]/si", "", $text);
				$comment = preg_replace("/\[.*?\]/si", "", $comment);
			}

			if ($properties['smilies']) {
				$text    = smilies($text);
				$comment = smilies($comment);
			}

			$text = preg_replace('/(.)(\\1{1,2})\\1*/sS', '$1$2', $text);
			$text = str_replace($bad, $good, $text);

			if ($properties['rating'] && $stars > 0) {
				$gbrat = 1;
				$gb_rating01 = array();

				while ($gbrat <= $stars) {
					$gb_rating01[] = "<img src=\"".$url."images/icons/stars/".$star_ico."\" width=\"16\" height=\"16\" alt=\"\" />";
					$gbrat ++;
				}

				$gbrat02 = 5;
				$gb_rating02 = array();

				while ($gbrat02 > $stars) {
					$gb_rating02[] = "<img src=\"".$url."images/icons/stars/star.png\" width=\"16\" height=\"16\" alt=\"\" />";
					$gbrat02 --;
				}

				$separated_red = implode("", $gb_rating01);

				($gb_rating02 != "" && $stars < 5) ? $separated_gray = implode("", $gb_rating02) : $separated_gray = "";

				$gb_rating = "<div class=\"star-rating\">
								<div class=\"startip\">".$separated_red."".$separated_gray."
									<span class=\"startiptext\">".$rating_entry." ".$stars." ".$fmsg[357]."".$show_rating_infos."</span>
								</div>
							</div>";
			}

			($properties['permalink']) ? $permaLink = "<a class=\"permalink\" href=\"".$url."index.php?action=post&#38;id=".$id."&#38;number=".$number."#anchor-gbooktop\" title=\"".$fmsg[194]."\"><img class=\"img-down\" src=\"".$url."images/permalink.png\" width=\"28\" height=\"16\" alt=\"\" /></a>" : $permaLink = "";

			if ($dateFormat === "us" && $setLang === "en") {
				!empty($usTime) ? $time = date("h:i A", $usTime) : (!empty($time) ? "" : $time = "(n.a.)");
				!empty($usTime) ? $date = date("m-d-Y", $usTime) : (!empty($date) ? "" : $date = "(n.a.)");
			}
			elseif ($setLang === "sv") {
				!empty($usTime) ? $time = date("H:i", $usTime) : (!empty($time) ? "" : $time = "(n.a.)");
				!empty($usTime) ? $date = date("Y-m-d", $usTime) : (!empty($date) ? "" : $date = "(n.a.)");
			}
			else {
				!empty($usTime) ? $time = date("H:i", $usTime) : (!empty($time) ? "" : $time = "(n.a.)");
				!empty($usTime) ? $date = date("d.m.Y", $usTime) : (!empty($date) ? "" : $date = "(n.a.)");
			}

			$template_data = $template['html'];
			$template_data = str_replace("<\$date\$>", $date, $template_data);
			$template_data = str_replace("<\$id\$>", $number, $template_data);
			$template_data = str_replace("<\$permalink\$>", "$permaLink", $template_data);
			$template_data = str_replace("<\$name\$>", $name, $template_data);
			$template_data = str_replace("<\$text\$>", $text, $template_data);
			$template_data = str_replace("<\$time\$>", $time, $template_data);
			$template_data = str_replace("<\$nr\$>", "$amsg[84]", $template_data);
			$template_data = str_replace("<\$wh\$>", "$amsg[85]", $template_data);
			$template_data = str_replace("<\$done\$>", "$amsg[86]", $template_data);
			$template_data = str_replace("<\$rating\$>", "$gb_rating", $template_data);

			if (!empty($comment)) {
				$template_data = str_replace("<\$comment\$>", "
				<div class=\"comment\">
				<p class=\"heading\">".$fmsg[106].":</p>
				".$comment."
				</div>", $template_data);
			}
			else {
				$template_data = str_replace("<\$comment\$>", "", $template_data);
			}

			if (!empty($origin)) {
				$template_data = str_replace("<\$origin\$>", "".$origin."", $template_data);
				$template_data = str_replace("<\$from\$>", "$fmsg[349]", $template_data);
				$template_data = str_replace("<\$br\$>", "<br />", $template_data);
			}
			else {
				$template_data = str_replace("<\$origin\$>", "", $template_data);
				$template_data = str_replace("<\$from\$>", "", $template_data);
				$template_data = str_replace("<\$br\$>", "", $template_data);
			}

			if (empty($email)) {
				$template_data = str_replace("<\$email_icon\$>", "", $template_data);
			}
			else {
				$template_data = str_replace("<\$email_icon\$>", "<a href=\"&#109;&#97;&#105;&#108;&#116;&#111;&#58;".$email."\"><img class=\"ico\" title=\"".$email."\" src=\"".$url."images/icons/email/".$template['image_email']."\" width=\"16\" height=\"17\" alt=\"".$email."\" /></a>", $template_data);
			}

			if (empty($homepage) OR $homepage == "http://")	{
				$template_data = str_replace("<\$homepage_icon\$>", "", $template_data);
			}
			elseif ((!empty($homepage) && $homepage != "http://") && !empty($email)) {
				$template_data = str_replace("<\$homepage_icon\$>", "<a title=\"".$homepage."\" href=\"".$homepage."\" rel=\"external\"><img class=\"ico\" src=\"".$url."images/icons/homepage/".$template['image_homepage']."\" width=\"16\" height=\"16\" alt=\"".$homepage."\" /></a>", $template_data);
			}
			else {
				$template_data = str_replace("<\$homepage_icon\$>", "<a title=\"".$homepage."\" href=\"".$homepage."\" rel=\"external\"><img src=\"".$url."images/icons/homepage/".$template['image_homepage']."\" width=\"16\" height=\"16\" alt=\"".$homepage."\" /></a>", $template_data);
			}

			if (!empty($properties['quote_func'])) {
				$replaceQuotes = array("".$quotation01."".$id."".$quotation02."","".$quotation03."".$id."".$quotation04."");

				$template_data = str_replace($quotes, $replaceQuotes, $template_data);
			}
			else {
				$template_data = str_replace($quotes, "", $template_data);
			}

			echo "
				".$template_data."";
		}

		$sql_entries->free_result();
		$sql_entries->close();

		echo "
			<div class=\"myphpgb gb-align text-center lineheight\">";

		if ($show_default == true) {
			echo"
				<span class=\"lh-large\">";

			if ($page > 1) {
				$page_minus = $page-1;
				echo "<a class=\"arrow-left\" ".$scrollTop." href=\"".$url."index.php?page=".$page_minus."#anchor-gbooktop\"><img class=\"middle\" src=\"".$url."images/left.png\" height=\"14\" width=\"12\" title=\"".$fmsg[4]."\" alt=\"".$fmsg[4]."\" /></a>";
			}

			if ($page_start > 1) {
				echo "<a class=\"navi-page marg-side10\" ".$scrollTop." href=\"".$url."index.php?page=1#anchor-gbooktop\">1</a>... ";
			}

			for ($i = $page_start; $i <= $page_end ;$i++) {
				if ($i == $page) {
					echo "<span class=\"this-page marg-side8\"> [".$i."] </span>";
				}
				else {
					echo "<a class=\"navi-page marg-side8\" ".$scrollTop." href=\"".$url."index.php?page=".$i."#anchor-gbooktop\"> ".$i." </a>";
				}
			}

			if ($page_end < $pages_total) {
				echo " ...<a class=\"navi-page marg-side10\" ".$scrollTop." href=\"".$url."index.php?page=".$pages_total."#anchor-gbooktop\">".$pages_total."</a>";
			}

			if ($page < $pages_total) {
				$page_plus = $page+1;
				echo "<a class=\"arrow-right\" ".$scrollTop." href=\"".$url."index.php?page=".$page_plus."#anchor-gbooktop\"><img class=\"middle\" src=\"".$url."images/right.png\" height=\"14\" width=\"12\" title=\"".$fmsg[14]."\" alt=\"".$fmsg[14]."\" /></a>";
			}

			echo"</span>";

			if ($count_entries > 0) {
				echo"
					".$html_entry."";
			}
		}

	echo" 
		</div>
		<div class=\"break\"></div>";
	}
	else {
		echo"
			<p class=\"text-center\"><br /><strong>".$emsg[17]."</strong></p>
			</div>
			<div class=\"break\"></div>";
	}

echo"<div class=\"myphpgb gb-align text-center\">";

		if ($properties['administration'] OR $properties['privacy_hint'] == 1 OR $properties['privacy_hint'] == 3) {
			echo"
				<div class=\"privacy\">";

					if ($properties['privacy_hint'] == 1 OR $properties['privacy_hint'] == 3) {
						$privMargLe = " class=\"priv-left\"";
						$properties['privacy_url'] = htmlspecialchars(strip_tags($properties['privacy_url']), ENT_QUOTES);

						echo "<a class=\"external gb-entry nowrap\" rel=\"external\" title=\"".$fmsg[266]."\" href=\"".$properties['privacy_url']."\">".$dsgvo[1]."</a>";
					}

					if ($properties['administration']) {
						echo "<span".$privMargLe."><a class=\"external gb-entry nowrap\" rel=\"external\" title=\"".$fmsg[2]."\" href=\"".$url."admin/admin.php\">".$fmsg[2]."</a></span>";
					}

			echo "</div>";
		}

		if(SCROLL_ON_INDEX) {
			$copSign = "margin-bottom:60px;";
			$js_gbook .= "
			<script>window.onscroll=function(){gbScrollPage()};</script>";

			echo"
				<div id=\"gbToTop\" onclick=\"mygbTop()\" title=\"To Top\"></div>";
		}

echo"
		<p class=\"margtop-dyn center\" style=\"width:110px;".$copSign."\"><a href=\"https://www.php-guestbook.de\" title=\"Download myPHP Guestbook ".$version."\" rel=\"external\"><img title=\"Download 'myPHP Guestbook ".$version."'\" src=\"".$url."images/myphpGuestbook.png\" width=\"110\" height=\"20\" alt=\"myPHP Guestbook\" /></a></p>
	</div>";

echo"
	<script>var searchSubMin=$minInputSearch-1;var searchSubMax=$maxInputSearch;var textSubMin=$jsMinInput;var textSubMax=$jsMaxInput;</script>
	<script src=\"js/gbook.func-00-05032021.js\"></script>
	$js_gbook";

echo"
	</body>
</html>";
?>