<?php
/*
	myPHP Guestbook Copyright (C) 2003 - 2006  Claudio Pose
	myPHP Guestbook was an open source project of Networkarea.ch

	Version 3.x Copyright (C) 2011 - 2014 Christian Thomas, www.hostonline.de

	Version 4.x (MySQLi) Copyright (C) 2014 - 2022 Wolfgang Leverberg, www.php-guestbook.de

	This file is a part of myPHP Guestbook.
	myPHP Guestbook is free software; you can redistribute it and/or modify it under the terms of the 
	GNU General Public License as published by the Free Software Foundation; either version 3 of the 
	License, or (at your option) any later version.

	myPHP Guestbook is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
	even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

	See the GNU General Public License for more details.

	02.01.2022
*/
    
	if (!isset($_SESSION['sid']) && !isset($_SESSION['modsid'])) {
		header("Location: admin.php?action=login");
		die();
	}
	elseif (!isset($_SESSION['sid']) && isset($_SESSION['modsid'])) {
		unset($_SESSION['modsid']);
		session_destroy();

		echo "<meta http-equiv=\"Refresh\" content=\"0; url=".$url."admin/admin.php?action=login\" />";
		die();
	}
	else {
		$gb_rating = $gb_rating01 = $gb_rating02 = $separated_red = $separated_gray = $rating_entry = "";

		echo "
			<div class=\"content-02\">";

		$sql_properties = $gbook->query("SELECT `bbcode`, `check_email`, `check_homepage`, `deactivate_html`, `images_in_entries`, `smilies`, `check_town`, `check_country`, `rating`, `rating_text` FROM `".$table."_properties`");
		$properties = $sql_properties->fetch_assoc();

		$properties['check_email'] = isset($properties['check_email']) ? $properties['check_email'] : 4;
		$properties['check_town'] = isset($properties['check_town']) ? $properties['check_town'] : 0;
		$properties['check_country'] = isset($properties['check_country']) ? $properties['check_country'] : 0;

		($properties['check_email'] > 1) ? ($hidden_email = '<span class="nowrap large-panel-le15">('.$fmsg[125].')</span>') : ($hidden_email = '');
		($properties['check_homepage'] == 1) ? ($hidden_hp = '<span class="nowrap large-panel-le15">('.$fmsg[125].')</span>') : ($hidden_hp = '');
		(($properties['check_town'] == 1) && ($properties['check_country'] == 1)) ? ($hidden_origin = '<span class="nowrap large-panel-le15">('.$fmsg[125].')</span>') : ($hidden_origin = '');

		$properties['rating_text'] = $properties['rating_text'] === NULL ? "" : $properties['rating_text'];

		$edit_timestamp = isset($edit_timestamp) ? $edit_timestamp : "";
		$edit_date = isset($edit_date) ? $edit_date : "";

		if (isset($_POST['send'])) {
			$error_msg = $output = "";

			$sql_entries = $gbook->query("SELECT `stars` FROM `".$table."_entries` WHERE `id` = '".$_REQUEST['id']."'");
			$entries = $sql_entries->fetch_assoc();

			if ($_POST['name'] == "" && !BlogMod) {
				$error_msg .= "<p class=\"error\">".$emsg[9]."</p>";
			}

			if ($_POST['origin'] != "") {
				if (!preg_match("/^[0-9a-zA-Z".$allowed_characters."\/ '():.,|-]*$/is", $_POST['origin'])) {
					$error_msg .= "<p class=\"error\">".$emsg[78]."</p>";
				}
			}

			if ($_POST['text'] == "") {
				$error_msg .= "<p class=\"error\">".$emsg[10]."</p>";
			}

			if($_POST['email'] != "" AND !validate_mail($_POST['email'])){
				$error_msg .= "<p class=\"error\">".$emsg[2]."</p>";
			}

			if ($_POST['homepage'] != "" && $_POST['homepage'] != "http://") {
				$hpcount_http = substr_count(strtolower($_POST['homepage']), 'http://', 0);
				$hpcount_https = substr_count(strtolower($_POST['homepage']), 'https://', 0);
				$hpcount_ftp = substr_count(strtolower($_POST['homepage']), 'ftp://', 0);

				if ($hpcount_http == 0 && $hpcount_https == 0 && $hpcount_ftp == 0) {
					$_POST['homepage'] = "http://".$_POST['homepage']."";
				}
			}

			if ($_POST['homepage'] != "" && $_POST['homepage'] != "http://" && !validate_url($_POST['homepage'])){
				$error_msg .= "<p class=\"error\">".$fmsg[207]."</p>";
			}

			if ($_POST['date'] == "" OR $_POST['time'] == "") {
				$error_msg .= "<p class=\"error\">".$emsg[0]."</p>";
			}

			if (!preg_match("/^[0-9.-]*$/is", $_POST['date'])) {
				$error_msg .= "<p class=\"error\">".$emsg[34]."</p>";
			}

			if (!preg_match("/^[0-9:]*$/is", $_POST['time'])) {
				$error_msg .= "<p class=\"error\">".$emsg[35]."</p>";
			}

			if (!preg_match("/^(0[0-9]|1[0-9]|2[0-3]):(0[0-9]|[1-5][0-9])$/",$_POST['time'])) {
				$error_msg .= "<p class=\"error\">Wrong Time input or Time format! Only: hh:mm</p>";
			}

			((isset($_POST['stars']) && $_POST['stars'] != "del") OR !isset($_POST['stars'])) ? ($_POST['stars'] = $entries['stars']) : ($_POST['stars'] = 0);

			if ($dateFormat === "us") {
				if (preg_match("/^(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])-[0-9]{4}$/",$_POST['date'])) {
					$edit_gbdate = date_create_from_format('m-d-Y',''.$_POST['date'].'');
					$edit_date = date_format($edit_gbdate, 'd.m.Y');
				}
				else {
					$error_msg .= "<p class=\"error\">Wrong Date input or Date format! Only: mm-dd-yyyy</p>";
				}
			}
			elseif ($dateFormat === "sv") {
				if (preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/",$_POST['date'])) {
					$edit_gbdate = date_create_from_format('Y-m-d',''.$_POST['date'].'');
					$edit_date = date_format($edit_gbdate, 'd.m.Y');
				}
				else {
					$error_msg .= "<p class=\"error\">Wrong Date input or Date format! Only: yyyy-mm-dd</p>";
				}
			}
			else {
				$edit_date = $_POST['date'];
			}

			$edit_timestamp = strtotime(''.$edit_date.''.$_POST['time'].'',time());

			if ($edit_timestamp === false) {
				$error_msg .= "<p class=\"error\">The input for the Date is not parseable.</p>";
			}

			if (!$error_msg == "") {
				echo "".$error_msg."<br />";
			}
			else {
				$_POST['date']     = $gbook->real_escape_string($_POST['date']);
				$_POST['time']	   = $gbook->real_escape_string($_POST['time']);
				$_POST['name']     = $gbook->real_escape_string($_POST['name']);
				$_POST['origin']   = $gbook->real_escape_string($_POST['origin']);
				$_POST['email']    = $gbook->real_escape_string($_POST['email']);
				$_POST['homepage'] = $gbook->real_escape_string($_POST['homepage']);
				$_POST['text']	   = $gbook->real_escape_string($_POST['text']);
				$_POST['stars']	   = $gbook->real_escape_string($_POST['stars']);

				$sql_update_entries = $gbook->query("UPDATE `".$table."_entries` SET `date` = '".$_POST['date']."', `email` = '".$_POST['email']."', `homepage` = '".$_POST['homepage']."', `name` = '".$_POST['name']."', `text` = '".$_POST['text']."', `time` = '".$_POST['time']."', `origin` = '".$_POST['origin']."', `stars` = '".$_POST['stars']."', `check_time` = '".$edit_timestamp."' WHERE `id` = '".$_REQUEST['id']."'");

				if ($sql_update_entries) {
					if ($properties['rating'] == 2) {
						$sql_count_ratings = $gbook->query("SELECT `id` FROM `".$table."_entries` WHERE `stars` != 0 AND `status` != 0");
						$count_ratings = $sql_count_ratings->num_rows;
						$sum_ratings = $count_ratings;

						$sql_count_stars = $gbook->query("SELECT SUM(`stars`) AS `stars` FROM `".$table."_entries` WHERE `status` != 0");
						$count_stars = $sql_count_stars->fetch_array();
						$sum_stars = $count_stars['stars'];

						($sum_ratings > 0 && $sum_stars > 0) ? $average_stars = $sum_stars / $sum_ratings : $average_stars = 0;

						$gbook->query("UPDATE `".$table."_rating` SET `count_rating` = '".$sum_ratings."', `average_rating` = '".$average_stars."'");
					}
					echo "<meta http-equiv=\"Refresh\" content=\"0; url=".$url."admin/admin.php?action=guestbook&#38;".session_name()."=".session_id()."\" />";
				}
			}
		}

		$sql_entries = $gbook->query("SELECT `date`, `email`, `homepage`, `name`, `text`, `time`, `origin`, `stars`, `check_time` FROM `".$table."_entries` WHERE `id` = '".$_REQUEST['id']."'");
		$entries = $sql_entries->fetch_assoc();

		$entries['name'] = $entries['name'] === NULL ? "" : htmlentities(strip_tags($entries['name']), ENT_QUOTES, "UTF-8");
		$entries['name'] = stripslashes($entries['name']);

		$entries['origin'] = $entries['origin'] === NULL ? "" : htmlentities(strip_tags($entries['origin']), ENT_QUOTES, "UTF-8");
		$entries['origin'] = stripslashes($entries['origin']);

		$entries['email'] = $entries['email'] === NULL ? "" : stripslashes(htmlspecialchars(strip_tags($entries['email']), ENT_QUOTES));

		$entries['homepage'] = $entries['homepage'] === NULL ? "" : htmlentities(strip_tags($entries['homepage']), ENT_QUOTES, "UTF-8");
		$entries['homepage'] = stripslashes($entries['homepage']);

		if ($properties['deactivate_html']){
			$entries['text'] = htmlentities(strip_tags($entries['text']), ENT_QUOTES, "UTF-8");
		}
		$entries['text']     = stripslashes($entries['text']);

		$stars = $entries['stars'];
		$stars = stripslashes($stars);
		$stars = strip_tags($stars);

		if ($dateFormat !== "us" && $dateFormat !== "sv") {
			$timeHintUS = "";
			!empty($entries['check_time']) ? $entries['date'] = date("d.m.Y", $entries['check_time']) : (!empty($entries['date']) ? "" : $entries['date'] = "(n.a.)");
		}
		elseif ($dateFormat === "sv") {
			$timeHintUS = "<p class=\"red\">Enter Date in format: <strong>yyyy-mm-dd</strong></p>";
			!empty($entries['check_time']) ? $entries['date'] = date("Y-m-d", $entries['check_time']) : (!empty($entries['date']) ? "" : $entries['date'] = "(n.a.)");
		}
		else {
			$timeHintUS = "<p class=\"red\">Enter Date in format: <strong>mm-dd-yyyy</strong><br />Enter Time in international 24-hour format! - <strong>(hh:mm)</strong></p>";
			!empty($entries['check_time']) ? $entries['date'] = date("m-d-Y", $entries['check_time']) : (!empty($entries['date']) ? "" : $entries['date'] = "(n.a.)");
		}

		!empty($entries['check_time']) ? $entries['time'] = date("H:i", $entries['check_time']) : (!empty($entries['time']) ? "" : $entries['time'] = "(n.a.)");

		echo"
		<fieldset><legend><strong>".$amsg[33]."</strong></legend>
		<form action=\"".$url."admin/admin.php?action=edit&#38;".session_name()."=".session_id()."\" method=\"post\" name=\"insert\">
		<table class=\"main-table-02 tb-pad0\">
		<tr>
		<td style=\"width:25%\"><br />".$fmsg[170]."<strong class=\"red size-20\">*</strong></td>
		<td><br /><input type=\"text\" class=\"insert\" name=\"date\" size=\"10\" maxlength=\"10\" value=\"";

		if (isset($_POST['date']) AND $_POST['date'] != "") {
			echo stripslashes(htmlspecialchars(strip_tags($_POST['date']), ENT_QUOTES));
		}
		elseif (isset($entries['date']) AND $entries['date'] != "") {
			echo "".$entries['date']."";
		}

		echo "\" tabindex=\"1\" /><span class=\"marg-le15 size-20 text-shadow\">|</span><input type=\"text\" class=\"marg-le15 insert\" name=\"time\" size=\"6\" maxlength=\"5\" value=\"";

		if (isset($_POST['time']) AND $_POST['time'] != "") {
			echo stripslashes(htmlspecialchars(strip_tags($_POST['time']), ENT_QUOTES));
		}
		elseif (isset($entries['time']) AND $entries['time'] != "") {
			echo "".$entries['time']."";
		}

		echo "\" tabindex=\"2\" />".$timeHintUS."</td>
		</tr>
		<tr>
		<td><br />".$fmsg[7]."<strong class=\"red size-20\">*</strong></td>
		<td><br /><input type=\"text\" class=\"insert\" name=\"name\" size=\"28\" maxlength=\"27\" value=\"";

		if (isset($_POST['name']) AND $_POST['name'] != "") {
			echo stripslashes(htmlspecialchars(strip_tags($_POST['name']), ENT_QUOTES));
		}
		elseif (isset($entries['name']) AND !empty($entries['name'])) {
			echo "".$entries['name']."";
		}

		echo "\" tabindex=\"3\" /></td>
		</tr>";

		echo"
		<tr>
		<td><br />".$amsg[129].":";
		
		if ((($properties['check_town'] == 2) && ($properties['check_country'] == 2)) || (($properties['check_town'] == 2) && ($properties['check_country'] == 1)) || (($properties['check_town'] == 1) && ($properties['check_country'] == 2))) {
			echo "<strong class=\"red size-20\">*</strong>";
		}
		
		echo "</td>
		<td><br /><input type=\"text\" class=\"insert\" name=\"origin\" size=\"28\" maxlength=\"100\" value=\"";

		if (isset($_POST['origin']) AND $_POST['origin'] != "") {
			echo stripslashes(htmlspecialchars(strip_tags($_POST['origin']), ENT_QUOTES));
		}
		elseif (isset($entries['origin']) AND !empty($entries['origin'])) {
			echo "".$entries['origin']."";
		}

		echo"\" tabindex=\"4\" /> ".$hidden_origin."</td>
		</tr>";

		echo"
		<tr>
		<td><br />".$fmsg[8].":";

		if (($properties['check_email'] == 1) || ($properties['check_email'] == 2)) {
			echo "<strong class=\"red size-20\">*</strong>";
		}

		echo "</td>
		<td><br /><input type=\"text\" class=\"insert\" name=\"email\" size=\"28\" maxlength=\"40\" value=\"";

		if (isset($_POST['email']) AND $_POST['email'] != "") {
			echo stripslashes(htmlspecialchars(strip_tags($_POST['email']), ENT_QUOTES));
		}
		elseif (isset($entries['email']) AND !empty($entries['email'])) {
			echo "".$entries['email']."";
		}

		echo"\" tabindex=\"5\" /> ".$hidden_email."</td>
		</tr>";

		echo"
		<tr>
		<td><br />".$fmsg[9]."</td>
		<td><br /><input type=\"text\" class=\"insert\" name=\"homepage\" size=\"28\" maxlength=\"80\" value=\"";

		if (isset($_POST['homepage']) AND $_POST['homepage'] != "") {
			echo stripslashes(htmlspecialchars(strip_tags($_POST['homepage']), ENT_QUOTES));
		}
		elseif (isset($entries['homepage']) AND !empty($entries['homepage'])) {
			echo "".$entries['homepage']."";
		}

		echo "\" tabindex=\"6\" /> ".$hidden_hp."</td>
		</tr>";

		if ($properties['rating']) {
			(empty($properties['rating_text'])) ? ($rating_entry = $fmsg[352]) : ($rating_entry = $properties['rating_text']);

			echo"
			<tr>
				<td align=\"left\" colspan=\"2\"><br /><span class=\"lh-35\">".$rating_entry."";

				if ($stars > 0) {
					$gbrat = 1;
					$gb_rating01 = array();

					while ($gbrat <= $stars) {
						$gb_rating01[] = "<img src=\"".$url."images/icons/stars/star_red.png\" width=\"16\" height=\"16\" alt=\"\" />";
						$gbrat ++;
					}

					$gbrat02 = 5;
					$gb_rating02 = array();

					while ($gbrat02 > $stars) {
						$gb_rating02[] = "<img src=\"".$url."images/icons/stars/star.png\" width=\"16\" height=\"16\" alt=\"\" />";
						$gbrat02 --;
					}

					$separated_red = implode("", $gb_rating01);

					($gb_rating02 != "" && $entries['stars'] < 5) ? $separated_gray = implode("", $gb_rating02) : $separated_gray = "";

					$gb_rating = "".$separated_red."".$separated_gray."";

					echo"&nbsp;&nbsp;<span style=\"position:relative;top:3px;margin-right:15px;\">".$gb_rating."</span><span class=\"nowrap\">".$amsg[58]."<label class=\"container\" style=\"display:inline-block;top:-15px;margin-left:13px;\"><input type=\"checkbox\" name=\"stars\" value=\"del\" /><span class=\"checkmark-02\"></span></label></span>";
				}
				else {
					echo"&nbsp;&nbsp;--";
				}
			echo "</span>
				</td>
			</tr>";
		}

		if ($properties['bbcode'] OR $properties['smilies']) {
			echo "
				<tr>
					<td colspan=\"2\"><br />
					<table class=\"main-table-02 tb-pad0\">
						<tr class=\"lh-35\">
							<td>";

								if ($properties['bbcode']) {
									echo"
										<a class=\"sprite-bold\" style=\"margin-left:0\" title=\"".$fmsg[185]."\" href=\"javascript:insert('[b]','[/b]');\">&nbsp;</a>
										<a class=\"sprite-italic\" title=\"".$fmsg[186]."\" href=\"javascript:insert('[i]','[/i]');\">&nbsp;</a>
										<a class=\"sprite-underline\" title=\"".$fmsg[187]."\" href=\"javascript:insert('[u]','[/u]');\">&nbsp;</a>
										<a class=\"sprite-shadow\" title=\"".$fmsg[188]."\" href=\"javascript:insert(' [shadow]','[/shadow] ');\">&nbsp;</a>
										<a class=\"sprite-crossed\" title=\"".$fmsg[280]."\" href=\"javascript:insert(' [cross]','[/cross] ');\">&nbsp;</a>
										<a class=\"sprite-justify\" title=\"".$fmsg[281]."\" href=\"javascript:insert(' [justify]',' [/justify] ');\">&nbsp;</a>
										<a class=\"sprite-center\" title=\"".$fmsg[309]."\" href=\"javascript:insert(' [center]',' [/center] ');\">&nbsp;</a>
										<a class=\"sprite-right\" title=\"".$fmsg[282]."\" href=\"javascript:insert(' [right]',' [/right] ');\">&nbsp;</a>
										<a class=\"sprite-sup\" title=\"".$fmsg[283]."\" href=\"javascript:insert('[sup]','[/sup]');\">&nbsp;</a>
										<a class=\"sprite-quote\" title=\"".$fmsg[191]."\" href=\"javascript:insert(' [quote]',' [/quote] ');\">&nbsp;</a>
										<a class=\"sprite-code\" title=\"Code\" href=\"javascript:insert(' [code]','[/code] ');\">&nbsp;</a>
										<a class=\"sprite-list\" title=\"".$fmsg[284]."\" href=\"javascript:insert(' [list] [-]', ' [/-] [-] [/-] [/list] ');\">&nbsp;</a>
										<a class=\"sprite-numlist\" title=\"".$fmsg[285]."\" href=\"javascript:insert(' [numlist] [-]', ' [/-] [-] [/-] [/numlist] ');\">&nbsp;</a>
										<a class=\"sprite-hr\" title=\"".$fmsg[286]."\" href=\"javascript:insert('[hr]','');\">&nbsp;</a>
										<a class=\"sprite-link\" title=\"".$fmsg[287]."\" href=\"".$url."bbcodes.php\" onclick=\"return PopUp(390,345,this.href);\">&nbsp;</a>
										<a class=\"sprite-email\" title=\"".$fmsg[288]."\" href=\"".$url."bbcodes.php?action=step4\" onclick=\"return PopUp(390,330,this.href)\">&nbsp;</a>";

											 if ($properties['images_in_entries']){
												echo"
													<a class=\"sprite-img\" title=\"".$fmsg[310]."\" onclick=\"javascript:NewWindow('".$url."pic.upload.php','upload','510','740','custom','front');return true;\">&nbsp;</a>";
											}

									echo"
										</td>
									</tr>
									<tr class=\"lh-35\">
										<td>
											<select class=\"select\" name=\"Color\" size=\"1\" onchange=\"InsertColorSize(this.form.Color.options[this.form.Color.selectedIndex].value,'[/color] ');this.selectedIndex=0\">
												<option value=\"\">".$fmsg[289]."</option>
												<option value=\" [color=gray] \">".$fmsg[274]."</option>
												<option value=\" [color=red] \">".$fmsg[306]."</option>
												<option value=\" [color=green] \">".$fmsg[307]."</option>
												<option value=\" [color=blue] \">".$fmsg[308]."</option>
												<option value=\" [color=yellow] \">".$fmsg[290]."</option>
												<option value=\" [color=orange] \">".$fmsg[291]."</option>
												<option value=\" [color=lime] \">".$fmsg[292]."</option>
												<option value=\" [color=pink] \">".$fmsg[293]."</option>
												<option value=\" [color=brown] \">".$fmsg[294]."</option>
											</select>
											<select class=\"select\" name=\"Size\" size=\"1\" onchange=\"InsertColorSize(this.form.Size.options[this.form.Size.selectedIndex].value,'[/size] ');this.selectedIndex=0\">
												<option value=\"\">".$fmsg[295]."</option>
												<option value=\" [size=8] \">8px</option>
												<option value=\" [size=10] \">10px</option>
												<option value=\" [size=12] \">12px</option>
												<option value=\" [size=14] \">14px</option>
												<option value=\" [size=16] \">16px</option>
												<option value=\" [size=18] \">18px</option>
												<option value=\" [size=20] \">20px</option>
											</select>";
								}

								if ($properties['smilies'])	{
									$sql_smilies_count = $gbook->query("SELECT `id` FROM `".$table."_smilies`");
									$count_smilies = $sql_smilies_count->num_rows;

									if ($count_smilies > 0 AND $properties['bbcode']) {
										echo"<span class=\"vertikal-linie\">||</span>
											";
									}

									($properties['bbcode']) ? ($emojiLimit = $emojis_and_bbcodes) : ($emojiLimit = $only_emojis);
									$sql_smilies = $gbook->query("SELECT `bbcode`, `filename`, `height`, `name`, `width` FROM `".$table."_smilies` ORDER BY `id` ASC LIMIT 0,".$emojiLimit."");

									while ($smilies = $sql_smilies->fetch_assoc()) {
										echo"<a href=\"javascript:insert(' ".$smilies['bbcode']." ','');\"><img class=\"smilies\" src=\"".$url."images/smilies/".$smilies['filename']."\" width=\"".$smilies['width']."\" height=\"".$smilies['height']."\" alt=\"".$smilies['name']."\" /></a>
											";
									}

									if ($count_smilies > $emojiLimit) {
										echo "<a class=\"sprite-more\" title=\"".$fmsg[15]."\" href=\"javascript:NewWindow('".$url."smilies.php','Emojis','380','750','custom','front');\">&nbsp;</a>";
									}

									echo"<br />
										";
								}

						echo"</td>
							</tr>
						</table>
					</td>
				</tr>
				";
		}

		echo"
		<tr>
			<td colspan=\"2\">
			<p class=\"aligncenter\"><textarea id=\"text\" class=\"insert\" name=\"text\" cols=\"44\" rows=\"13\" style=\"width:98%\" tabindex=\"8\" >";

			if (isset($_POST['text']) AND $_POST['text'] != "") {
				if ($properties['deactivate_html']){
					echo stripslashes(htmlspecialchars(strip_tags($_POST['text']), ENT_QUOTES));
				}
				else {
					echo "".$_POST['text']."";
				}
			}
			elseif (isset($entries['text']) AND !empty($entries['text'])) {
				echo "".$entries['text']."";
			}

		echo "</textarea></p>
		</td>
		</tr>
		<tr>
		<td colspan=\"2\">
			<br />
			<table class=\"main-table-02 tb-pad0\">
				<tr>
					<td style=\"width:50%\"><p class=\"aligncenter\"><input type=\"submit\" class=\"button\" name=\"send\" value=\"".$fmsg[55]."\" tabindex=\"9\" /><input type=\"hidden\" name=\"id\" value=\"".$_REQUEST['id']."\" /></p></td>
					<td><p class=\"aligncenter\"><input type=\"button\" class=\"button\" name=\"abbruch\" value=\"".$fmsg[269]."\" onclick=\"self.location.href='admin.php?action=guestbook&#38;".session_name()."=".session_id()."'\" /></p></td>
				</tr>
			</table>
		</td>
		</tr>
		</table>
		</form>
		</fieldset>
		</div>";
	}
?>