<?php
/*
	myPHP Guestbook Copyright (C) 2003 - 2006  Claudio Pose
	myPHP Guestbook was an open source project of Networkarea.ch

	Version 3.x Copyright (C) 2011 - 2014 Christian Thomas, www.hostonline.de

	Version 4.x (MySQLi) Copyright (C) 2014 - 2022 Wolfgang Leverberg, www.php-guestbook.de

	This file is a part of myPHP Guestbook.
	myPHP Guestbook is free software; you can redistribute it and/or modify it under the terms of the 
	GNU General Public License as published by the Free Software Foundation; either version 3 of the 
	License, or (at your option) any later version.

	myPHP Guestbook is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
	even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

	See the GNU General Public License for more details.

	10.03.2021
*/

	if (!isset($_SESSION['sid']) && !isset($_SESSION['modsid'])) {
		header("Location: admin.php?action=login");
		die();
	}
	elseif (!isset($_SESSION['sid']) && isset($_SESSION['modsid'])) {
		unset($_SESSION['modsid']);
		session_destroy();

		echo "<meta http-equiv=\"Refresh\" content=\"0; url=".$url."admin/admin.php?action=login\" />";
		die();
	}
	else {
		$msg_admin_options = $msg_mod_options = $msg_check_options = $mod_status = $modInfo = $modEmail =  "";

		$_POST['admin_name'] 	= isset($_POST['admin_name']) ? $_POST['admin_name'] : "";
		$_POST['password'] 	 	= isset($_POST['password']) ? $_POST['password'] : "";
		$_POST['password2']  	= isset($_POST['password2']) ? $_POST['password2'] : "";
		$_POST['admin_email']	= isset($_POST['admin_email']) ? $_POST['admin_email'] : "";
		$_POST['mod_name']	 	= isset($_POST['mod_name']) ? $_POST['mod_name'] : "";
		$_POST['mod_password']  = isset($_POST['mod_password']) ? $_POST['mod_password'] : "";
		$_POST['mod_password2'] = isset($_POST['mod_password2']) ? $_POST['mod_password2'] : "";
		$_POST['mod_email']	 	= isset($_POST['mod_email']) ? $_POST['mod_email'] : "";
		$_POST['mod_info']	 	= isset($_POST['mod_info']) ? $_POST['mod_info'] : 0;

		$sql_login = $gbook->query("SELECT `username`, `algos` FROM `".$table."_login` WHERE `id` = '1'");
		list($admin_name, $algo) = $sql_login->fetch_row();

		if (BEST_PW) {
			$gb_salt = "";

			if (defined('PASSWORD_ARGON2ID')) {
				$gb_algo = 'ARG2ID';
			}
			elseif (defined('PASSWORD_ARGON2I')) {
				$gb_algo = 'ARGO2I';
			}
			elseif (defined('PASSWORD_BCRYPT')) {
				$gb_algo = 'BCRYPT';
			}
			else {
				$gb_algo = 'DEFLT';
			}
		}
		else {
			$hashAlgos = hash_algos();

			if (in_array('sha512', $hashAlgos))	{
				$gb_algo = 'sha512';
			}
			elseif (in_array('sha384', $hashAlgos)) {
				$gb_algo = 'sha384';
			}
			elseif (in_array('sha256', $hashAlgos)) {
				$gb_algo = 'sha256';
			}
			elseif (in_array('sha1', $hashAlgos)) {
				$gb_algo = 'sha1';
			}
			else {
				$gb_algo = 'md5';
			}

			mt_srand(makeRandomName());
			$gb_salt = md5(mt_rand());

			$gb_password = $_POST['password'];

			function saltPassword($gb_password, $gb_salt) {
				global $gb_algo;
			   	return hash(''.$gb_algo.'', $gb_password . $gb_salt);
			}
		}

		echo "
			<div class=\"content-02\">";

		if ((BEST_PW && !empty($gbSalt)) OR (!empty($algo) && $gb_algo != $algo)) {
			$msg_admin_options = "<tr><td colspan=\"2\"><span class=\"aligncenter\">".$amsg[196]."".$amsg[197]."</span></td></tr>";
			$pwWarning = '<img class="img-ok marg-le10" src="../images/ausruf.png" width="14" height="14" alt="Check!" title="'.$amsg[200].'" />';
		}

		if (empty($main_pw)) {
			$msg_admin_options .= "<tr><td colspan=\"2\"><strong class=\"red aligncenter\">".$amsg[201]."</strong><p class=\"red aligncenter\"><strong>".$amsg[200]."</strong></p></td></tr>";
			$pwWarning = '<img class="img-ok marg-le10" src="../images/ausruf.png" width="14" height="14" alt="Check!" title="'.$amsg[201].'" />';
		}

		if ($adminEmail !== $adminEmail02) {
			$msg_admin_options .= "<tr><td colspan=\"2\"><strong class=\"red aligncenter\">".$emsg[89]."</strong><p class=\"red aligncenter\"><strong>".$emsg[90]."</strong></p></td></tr>";
			$mailWarning = '<img class="img-ok marg-le10" src="../images/ausruf.png" width="14" height="14" alt="Check!" title="'.$emsg[89].'" />';
		}

		if (isset($_POST['send'])) {
			$error_msg = "";

			$_POST['admin_name']  = trim($_POST['admin_name']);
			$_POST['admin_email'] = trim($_POST['admin_email']);

			$_POST['admin_name'] = $gbook->real_escape_string($_POST['admin_name']);
			$_POST['password'] 	 = $gbook->real_escape_string($_POST['password']);
			$_POST['password2']	 = $gbook->real_escape_string($_POST['password2']);
			$_POST['admin_email']= $gbook->real_escape_string($_POST['admin_email']);

			if ($_POST['admin_name'] == "" OR $_POST['password'] == "" OR $_POST['admin_email'] == "") {
				$error_msg = "- ".$emsg[0]."";
			}

			if ($_POST['admin_name'] != "" && !preg_match("/^[0-9a-zA-Z".$allowed_characters." ():.,!?-]*$/is", $_POST['admin_name'])) {
				$error_msg = "".$amsg[318]."";
			}

			if ($_POST['admin_email'] != "" && !validate_mail($_POST['admin_email'])) {
				$error_msg = "".$emsg[2]."";
			}
			elseif ($_POST['admin_email'] != "" && validate_mail($_POST['admin_email'])) {
				$sql_check_email = $gbook->query("SELECT `user_email` FROM `".$table."_login` WHERE `id` != '1' AND `user_email` = '".$_POST['admin_email']."'");

				if ($sql_check_email->num_rows != 0) {
					$error_msg = "".$amsg[301]."";
				}
			}

			if (!$error_msg == "") {
				$msg_admin_options = "<tr><td colspan=\"2\"><p class=\"error\">".$error_msg."</p></td></tr>";
			}
			else {
				(BEST_PW && $gb_algo == 'ARG2ID') ? $gb_password = password_hash("".$_POST['password']."", PASSWORD_ARGON2ID) : ((BEST_PW && $gb_algo == 'ARGO2I') ? $gb_password = password_hash("".$_POST['password']."", PASSWORD_ARGON2I) : ((BEST_PW && $gb_algo == 'BCRYPT') ? $gb_password = password_hash("".$_POST['password']."", PASSWORD_BCRYPT) : ((BEST_PW && $gb_algo == 'DEFLT') ? $gb_password = password_hash("".$_POST['password']."", PASSWORD_DEFAULT) : ($gb_password = saltPassword("".$_POST['password']."", $gb_salt)))));
				($gb_algo == 'ARG2ID') ? $gbHash = 'ARGON2ID' : (($gb_algo == 'ARGO2I') ? $gbHash = 'ARGON2I' : (($gb_algo == 'BCRYPT') ? $gbHash = 'BCRYPT' : (($gb_algo == 'DEFLT') ? $gbHash = 'DEFAULT' : ($gbHash = $gb_algo))));

				if ($_POST['password'] === $_POST['password2']) {
					$sql_update_login = $gbook->query("UPDATE `".$table."_login` SET `main_pw` = '".$gb_password."', `pw_time` = '".time()."', `email_pw` = NULL, `email_time` = '0', `username` = '".$_POST['admin_name']."', `gb_salt` = '".$gb_salt."', `algos` = '".$gb_algo."', `user_email` = '".$_POST['admin_email']."' WHERE `id` = 1");
					$sql_update_properties = $gbook->query("UPDATE `".$table."_properties` SET `admin_email` = '".$_POST['admin_email']."'");

					if ($sql_update_login && $sql_update_properties) {
						$msg_admin_options = "<tr><td colspan=\"2\"><p class=\"green size-14 aligncenter\"><strong>- ".$amsg[158]."</strong><img src=\"".$url."images/wait.gif\" class=\"img-ok marg-le15\" alt=\"wait...\" width=\"16\" height=\"16\" /></p>
												<span class=\"aligncenter\">Your Password Hash: <strong>".$gbHash."</strong></span></td></tr>";

						echo "<meta http-equiv=\"Refresh\" content=\"3; url=".$url."admin/admin.php?action=admin_options&#38;show=show_mod&#38;".session_name()."=".session_id()."\" />";
					}
					else {
						$msg_admin_options = "<tr><td colspan=\"2\"><p class=\"error size-14\">".$emsg[11]."</p></td></tr>";
					}
				}
				else {
					$msg_admin_options = "<tr><td colspan=\"2\"><p class=\"error\">".$emsg[3]."</p></td></tr>";
				}
			}
		}

		if (isset($_POST['send02']) OR isset($_POST['send04'])) {
			$error_msg = "";

			$_POST['mod_name']  = trim($_POST['mod_name']);
			$_POST['mod_email'] = trim($_POST['mod_email']);

			$_POST['mod_name'] 		= $gbook->real_escape_string($_POST['mod_name']);
			$_POST['mod_password']	= $gbook->real_escape_string($_POST['mod_password']);
			$_POST['mod_password2']	= $gbook->real_escape_string($_POST['mod_password2']);
			$_POST['mod_email']		= $gbook->real_escape_string($_POST['mod_email']);
		}

		$_GET['change'] = isset($_GET['change']) ? $gbook->real_escape_string($_GET['change']) : "";
		$_REQUEST['id'] = intval($_REQUEST['id']);

		if ($_GET['change'] == "delete_mod") {
			$mod_delete = $gbook->query("DELETE FROM `".$table."_login` WHERE `id` = '".$_REQUEST['id']."' AND `status` > '1'");

			if ($mod_delete) {
				echo "<meta http-equiv=\"Refresh\" content=\"0; url=".$url."admin/admin.php?action=admin_options&#38;show=show_mod&#38;".session_name()."=".session_id()."\" />";
			}
		}

		if ($_GET['change'] == "modstatus") {
			$sql_mod_status = $gbook->query("SELECT `status` FROM `".$table."_login` WHERE `id` = '".$_REQUEST['id']."'");
			list($mod_status) = $sql_mod_status->fetch_row();

			if ($mod_status == 2) {
				$update_status = $gbook->query("UPDATE `".$table."_login` SET `status` = '3' WHERE `id` = '".$_REQUEST['id']."'");
			}
			elseif ($mod_status == 3) {
				$update_status = $gbook->query("UPDATE `".$table."_login` SET `status` = '2' WHERE `id` = '".$_REQUEST['id']."'");
			}

			if ($update_status) {
				echo "<meta http-equiv=\"Refresh\" content=\"0; url=".$url."admin/admin.php?action=admin_options&#38;show=show_mod&#38;".session_name()."=".session_id()."\">";
			}
		}

		$sql_properties = $gbook->query("SELECT `admin_email` FROM `".$table."_properties`");
		$properties = $sql_properties->fetch_assoc();

		$select_mod_login = $gbook->query("SELECT `id`, `username`, `main_pw`, `gb_salt`, `algos`, `user_email`, `status` FROM `".$table."_login` WHERE `status` > '1' ORDER BY `id` ASC");

        echo "
		<script>function confirm_delete() {return confirm('".$amsg[310]."');}</script>
		<fieldset>
			<legend><strong>".$amsg[303]."</strong></legend><br />
			<form method=\"post\" action=\"".$url."admin/admin.php?action=admin_options&#38;show=show_mod&#38;".session_name()."=".session_id()."\">
				<table class=\"main-table-02 tb-pad0\" style=\"max-width:450px;\">
					".$msg_admin_options."<tr>
						<td style=\"width:49%;\"><br />".$fmsg[1].":</td>
						<td><br /><input type=\"text\" class=\"insert\" name=\"admin_name\" maxlength=\"25\" style=\"width:95%\" placeholder=\"(".$fmsg[334].")\" value=\"".$admin_name."\" required=\"required\" /></td>
					</tr>
					<tr>
						<td><br />".$fmsg[53]."".$pwWarning."</td>
						<td><br /><input type=\"password\" class=\"insert\" id=\"psw\" name=\"password\" style=\"width:95%\" placeholder=\"(".$fmsg[334].")\" required=\"required\" /></td>
					</tr>
					<tr>
						<td colspan=\"2\">
							<div id=\"admin-pw\">
								<div style=\"margin-top:20px;\"><span style=\"display:inline-block;width:48%;\">".$amsg[249]."</span><label class=\"container\" style=\"display:inline-block;top:-5px;\"><input type=\"checkbox\" onclick=\"showPw()\" style=\"display:none;\" /><span class=\"checkmark02-sm\"></span></label></div>
								<div id=\"psw-check\"><span id=\"psw-qual\" class=\"qual\"></span></div>
								<div class=\"psw-text\" style=\"margin-top:15px;\">
									<strong class=\"red\" style=\"float:left;\">".$amsg[248]."</strong>
									<strong class=\"green\" style=\"float:right;\">".$amsg[247]."</strong>
									<a href=\"".$url."admin/admin.php?action=help&#38;".session_name()."=".session_id()."#anchor-pws\" title=\"".$amsg[340]."\" class=\"aligncenter\" style=\"width:14px;height:14px;cursor:help;\"><img src=\"".$url."images/help.png\" width=\"14\" height=\"14\" alt=\"".$amsg[119]."\" /></a>
								</div>
							</div>
						</td>
					</tr>
					<tr>
						<td><br />".$fmsg[54]."</td>
						<td><br /><input type=\"password\" class=\"insert\" id=\"psw01\" name=\"password2\" style=\"width:95%\" placeholder=\"(".$fmsg[334].")\" /></td>
					</tr>
					<tr>
						<td><br />".$fmsg[8].":".$mailWarning."<a title=\"".$amsg[150]."\" class=\"cursor-help\" href=\"javascript:{}\" onclick=\"document.getElementById('admin_link').style.display='inline';return false;\"><img class=\"img-ok marg-le15\" src=\"".$url."images/help.png\" width=\"14\" height=\"14\" alt=\"".$amsg[150]."\" /></a></td>
						<td><br /><input type=\"text\" class=\"insert\" name=\"admin_email\" maxlength=\"80\" style=\"width:95%\" placeholder=\"(".$fmsg[334].")\" value=\"".$properties['admin_email']."\" required=\"required\" /></td>
					</tr>";
				echo"
					<tr>
						<td>
							<div id=\"admin_link\" class=\"gb-lightbox\" style=\"display:none\">
								<div class=\"gb-lightbox-inner\" style=\"max-width:300px;\">
									<span class=\"aligncenter\"><strong>".$amsg[150].":</strong></span><br />".$amsg[246]."
									<div class=\"gblb-close\"><img class=\"close-flag\" src=\"".$url."images/not_ok.png\" alt=\"Close\" width=\"14\" height=\"14\" onclick=\"document.getElementById('admin_link').style.display='none';\" /></div>
								</div>
							</div>
						</td>
					</tr>";
				echo"
					<tr>
						<td colspan=\"2\"><br /><br /><p class=\"aligncenter\"><input class=\"button\" type=\"submit\" name=\"send\" value=\"".$fmsg[55]."\" /></p></td>
					</tr>
				</table>  
			</form>
			</fieldset><br />";

		echo"
			<fieldset>
			<legend><strong>".$amsg[304]."</strong><a title=\"".$amsg[340]."\" class=\"cursor-help2\" href=\"javascript:{}\" onclick=\"document.getElementById('lightbox_mod').style.display='inline';return false;\"><img class=\"img-ok\" src=\"".$url."images/help.png\" width=\"14\" height=\"14\" alt=\"".$amsg[119]."\" /></a></legend><br />
			<div id=\"lightbox_mod\" class=\"gb-lightbox\" style=\"display:none\">
				<div class=\"gb-lightbox-inner\" style=\"max-width:580px;\">
					<strong class=\"aligncenter\">".$amsg[305]."</strong><br />".$amsg[306]."
					<div class=\"gblb-close\"><img class=\"close-flag\" src=\"".$url."images/not_ok.png\" alt=\"Close\" width=\"14\" height=\"14\" onclick=\"document.getElementById('lightbox_mod').style.display='none';\" /></div>
				</div>
			</div>";

		if ($_GET['show'] == "show_mod") {

			if ($select_mod_login->num_rows < 3) {
				echo"
					<p class=\"aligncenter\"><input type=\"button\" class=\"button\" value=\"".$amsg[316]."\" onclick=\"self.location.href='admin.php?action=admin_options&#38;show=new_mod&#38;".session_name()."=".session_id()."'\" /></p>
					<p>&nbsp;</p>";
			}

			if ($select_mod_login->num_rows != 0) {

				echo"
					<p class=\"zentriert\"><strong>".$amsg[307]."</strong></p>
					<form method=\"post\" action=\"".$url."admin/admin.php?action=admin_options&#38;show=show_mod&#38;".session_name()."=".session_id()."\">".$msg_check_options."
					<table class=\"main-table-02 tb-pad5\" style=\"max-width:450px;\">".$msg_mod_options."";

						while ($select_mod = $select_mod_login->fetch_assoc()) {

							if ((BEST_PW && !empty($select_mod['gb_salt'])) OR (!empty($select_mod['algos']) && $select_mod['algos'] != $gb_algo) OR (empty($select_mod['main_pw']))) {
								$pwModWarning = '<img class="img-ok marg-le10" src="../images/ausruf.png" width="14" height="14" alt="Check!" title="'.$amsg[200].'" />';
							}
							else {
								$pwModWarning = '';
							}

							echo"
								<tr>
									<td style=\"width:49%\"><br />".$fmsg[1].":</td>
									<td><br />".$select_mod['username']."".$pwModWarning."</td>
								</tr>
								<tr>
									<td>".$fmsg[8].":</td>
									<td>".$select_mod['user_email']."</td>
								</tr>
								<tr>
									<td>".$amsg[367]."</td>
									<td>";
								
										($select_mod['status'] == 2) ? ($modInfo = '<span class="tooltip tooltip-re tooltipmiddle"><img class="img-ok" src="../images/not_ok.png" width="14" height="14" alt="'.$amsg['41'].'" /><span class="tooltiptext tooltiptext-re tooltiptextmiddle">'.$amsg['41'].' - '.$amsg[202].'</span></span>') : ($modInfo = '<span class="tooltip tooltip-re tooltipmiddle"><img class="img-ok" src="../images/ok.png" width="14" height="14" alt="'.$amsg['167'].'" /><span class="tooltiptext tooltiptext-re tooltiptextmiddle">'.$amsg['167'].' - '.$amsg[202].'</span></span>');
								
										echo"<br /><a href=\"".$url."admin/admin.php?action=admin_options&#38;show=show_mod&#38;change=modstatus&#38;id=".$select_mod['id']."\">".$modInfo."</a>
									</td>
								</tr>
								<tr>
									<td>
										<p class=\"aligncenter\"><br /><strong>".$amsg[33].":</strong><a class=\"marg-le15 tooltip tooltipsmall\" href=\"".$url."admin/admin.php?action=admin_options&#38;show=edit_mod&#38;id=".$select_mod['id']."&#38;".session_name()."=".session_id()."\"><img src=\"../images/edit.png\" width=\"14\" height=\"14\" alt=\"".$amsg[96]."\" /><span class=\"tooltiptext tooltiptextsmall\">".$amsg[96]."</span></a></p>
									</td>
									<td>
										<p class=\"aligncenter\"><br /><strong>".$fmsg[325].":</strong><a class=\"marg-le15 tooltip tooltip-re tooltipsmall\" href=\"".$url."admin/admin.php?action=admin_options&#38;show=show_mod&#38;change=delete_mod&#38;id=".$select_mod['id']."&#38;".session_name()."=".session_id()."\" onclick=\"return confirm_delete()\"><img src=\"../images/delete.png\" width=\"14\" height=\"14\" alt=\"".$fmsg[325]."\" /><span class=\"tooltiptext tooltiptext-re tooltiptextsmall\">".$fmsg[325]."</span></a></p>
									</td>
								</tr>
								<tr>
									<td colspan=\"2\"><hr /></td>
								</tr>";
						}

					echo"
						</table>
						</form>";
			}
		}

		elseif ($_GET['show'] == "new_mod") {

			if ($select_mod_login->num_rows < 3) {

				if (isset($_POST['send02'])) {

					if ($_POST['mod_name'] == "" OR $_POST['mod_password'] == "" OR $_POST['mod_email'] == "") {
						$error_msg = "".$emsg[0]."";
					}

					if ($_POST['mod_name'] != "") {
						$sql_check_name = $gbook->query("SELECT `username` FROM `".$table."_login` WHERE `username` = '".$_POST['mod_name']."'");

						if ($sql_check_name->num_rows != 0) {
							$error_msg = "".$amsg[300]."";
						}
					}

					if ($_POST['mod_name'] != "" && !preg_match("/^[0-9a-zA-Z".$allowed_characters." ():.,!?-]*$/is", $_POST['mod_name'])) {
						$error_msg = "".$amsg[318]."";
					}

					if ($_POST['mod_password'] != "" && ($_POST['mod_password'] !== $_POST['mod_password2'])) {
						$error_msg = "".$emsg[3]."";
					}

					if ($_POST['mod_email'] != "" && !validate_mail($_POST['mod_email'])) {
						$error_msg = "".$emsg[2]."";
					}
					elseif ($_POST['mod_email'] != "" && validate_mail($_POST['mod_email'])) {
						$sql_check_email = $gbook->query("SELECT `user_email` FROM `".$table."_login` WHERE `user_email` = '".$_POST['mod_email']."'");

						if ($sql_check_email->num_rows != 0 OR $properties['admin_email'] == $_POST['mod_email']) {
							$error_msg = "".$amsg[301]."";
						}
					}

					if (!$error_msg == "") {
						$msg_mod_options = "<tr><td colspan=\"2\"><p class=\"error\">".$error_msg."</p></td></tr>";
					}
					else {
						(BEST_PW && $gb_algo == 'ARG2ID') ? $gb_password = password_hash("".$_POST['mod_password']."", PASSWORD_ARGON2ID) : ((BEST_PW && $gb_algo == 'ARGO2I') ? $gb_password = password_hash("".$_POST['mod_password']."", PASSWORD_ARGON2I) : ((BEST_PW && $gb_algo == 'BCRYPT') ? $gb_password = password_hash("".$_POST['mod_password']."", PASSWORD_BCRYPT) : ((BEST_PW && $gb_algo == 'DEFLT') ? $gb_password = password_hash("".$_POST['mod_password']."", PASSWORD_DEFAULT) : ($gb_password = saltPassword("".$_POST['mod_password']."", $gb_salt)))));
						$_POST['mod_info'] == 1 ? $mod_status = 3 : $mod_status = 2;

						if ($_POST['mod_password'] === $_POST['mod_password2']) {
							$sql_update_mod = $gbook->query("INSERT INTO `".$table."_login` (`main_pw`, `pw_time`, `email_pw`, `email_time`, `username`, `gb_salt`, `algos`, `user_email`, `status`) VALUES ('".$gb_password."', '".time()."', NULL, '0', '".$_POST['mod_name']."', '".$gb_salt."', '".$gb_algo."', '".$_POST['mod_email']."', '".$mod_status."')");

							if ($sql_update_mod) {
								echo "<meta http-equiv=\"Refresh\" content=\"0; url=".$url."admin/admin.php?action=admin_options&#38;show=show_mod&#38;".session_name()."=".session_id()."\" />";
							}
							else {
								$msg_mod_options = "<tr><td colspan=\"2\"><p class=\"size-14 error\">".$emsg[11]."</p></td></tr>";
							}
						}
						else {
							$msg_mod_options = "<tr><td colspan=\"2\"><p class=\"error\">".$emsg[3]."</p></td></tr>";
						}
					}
				}

				echo"
					<form method=\"post\" action=\"".$url."admin/admin.php?action=admin_options&#38;show=new_mod&#38;".session_name()."=".session_id()."\">
						<table class=\"main-table-02 tb-pad0\" style=\"max-width:450px;\">
							".$msg_mod_options."<tr>
								<td style=\"width:49%;\"><br />".$fmsg[1].":</td>
								<td><br /><input type=\"text\" class=\"insert\" name=\"mod_name\" maxlength=\"20\" style=\"width:95%\" placeholder=\"(".$fmsg[334].")\" value=\"";

									if (isset($_POST['mod_name']) AND $_POST['mod_name'] != "") {
										echo stripslashes(htmlspecialchars(strip_tags($_POST['mod_name']), ENT_QUOTES));
									}

								echo "\" required=\"required\" /></td>
							</tr>
							<tr>
								<td><br />".$fmsg[20].":</td>
								<td><br /><input type=\"password\" class=\"insert\" id=\"psw02\" name=\"mod_password\" style=\"width:95%\" placeholder=\"(".$fmsg[334].")\" required=\"required\" /></td>
							</tr>
							<tr>
								<td colspan=\"2\">
									<div id=\"mod-pw\">
										<div style=\"margin-top:20px;\"><span style=\"display:inline-block;width:48.5%;\">".$amsg[249]."</span><label class=\"container\" style=\"display:inline-block;top:-5px;\"><input type=\"checkbox\" onclick=\"showPw02()\" style=\"display:none;\" /><span class=\"checkmark02-sm\"></span></label></div>
										<div id=\"psw-check02\"><span id=\"psw-qual02\" class=\"qual\"></span></div>
										<div class=\"psw-text\" style=\"margin-top:15px;\">
											<strong class=\"red\" style=\"float:left;\">".$amsg[248]."</strong>
											<strong class=\"green\" style=\"float:right;\">".$amsg[247]."</strong>
											<a href=\"".$url."admin/admin.php?action=help&#38;".session_name()."=".session_id()."#anchor-pws\" title=\"".$amsg[340]."\" class=\"aligncenter\" style=\"width:14px;height:14px;cursor:help;\"><img src=\"".$url."images/help.png\" width=\"14\" height=\"14\" alt=\"".$amsg[119]."\" /></a>
										</div>
									</div>
								</td>
							</tr>
							<tr>
								<td><br />".$fmsg[54]."</td>
								<td><br /><input type=\"password\" class=\"insert\" id=\"psw03\" name=\"mod_password2\" style=\"width:95%\" placeholder=\"(".$fmsg[334].")\" /></td>
							</tr>
							<tr>
								<td><br />".$fmsg[8].":</td>
								<td><br /><input type=\"text\" class=\"insert\" name=\"mod_email\" maxlength=\"80\" style=\"width:95%\" placeholder=\"(".$fmsg[334].")\" value=\"";

									if (isset($_POST['mod_email']) AND $_POST['mod_email'] != "") {
										echo stripslashes(htmlspecialchars(strip_tags($_POST['mod_email']), ENT_QUOTES));
									}

								echo "\" required=\"required\" /></td>
							</tr>
							<tr>
								<td><br />".$amsg[367]."</td>
								<td>
									<label class=\"container\" style=\"top:-4px;\"><input type=\"checkbox\" name=\"mod_info\"";

									if (isset($_POST['mod_info']) AND $_POST['mod_info'] == '1') {
										echo " checked=\"checked\"";
									}

									echo" value=\"1\" /><span class=\"checkmark\"></span></label>
								</td>
							</tr>
							<tr>
								<td>
									<p class=\"aligncenter\"><br /><input class=\"button\" type=\"submit\" name=\"send02\" value=\"".$fmsg[55]."\" />
								</td>
								<td>
									<p class=\"aligncenter\"><br /><input class=\"button\" type=\"button\" name=\"abbruch\" value=\"".$fmsg[269]."\" onclick=\"self.location.href='admin.php?action=admin_options&#38;show=show_mod&#38;".session_name()."=".session_id()."'\" />
								</td>
							</tr>
						</table>  
					</form>";
			}
			else {
				echo "<meta http-equiv=\"Refresh\" content=\"0; url=".$url."admin/admin.php?action=admin_options&#38;show=show_mod&#38;".session_name()."=".session_id()."\" />";
			}
		}
		elseif ($_GET['show'] == "edit_mod") {
			$_REQUEST['id'] = intval($_REQUEST['id']);

			$sql_select_mod = $gbook->query("SELECT `username`, `main_pw`, `gb_salt`, `algos`, `user_email`, `status` FROM `".$table."_login` WHERE `id` = '".$_REQUEST['id']."'");
			list($mod_name, $mod_pw, $mod_salt, $mod_algo, $mod_email, $mod_info) = $sql_select_mod->fetch_row();

			if ((BEST_PW && !empty($mod_salt)) OR (!empty($mod_algo) && $mod_algo != $gb_algo) OR empty($mod_pw)) {
				$pwModWarning = '<img class="img-ok marg-le10" src="../images/ausruf.png" width="14" height="14" alt="Check!" title="'.$amsg[200].'" />';
			}

			$_POST['mod_info'] == 1 ? $mod_status = 3 : $mod_status = 2;

			if (isset($_POST['send04'])) {
				if ($_POST['mod_name'] == "" OR $_POST['mod_email'] == "") {
					$error_msg = "- ".$emsg[0]."";
				}

				if ($_POST['mod_name'] != "") {
					$sql_check_name = $gbook->query("SELECT `username` FROM `".$table."_login` WHERE `id` != '".$_REQUEST['id']."' AND `username` = '".$_POST['mod_name']."'");

					if ($sql_check_name->num_rows != 0) {
						$error_msg = "- ".$amsg[300]."";
					}
				}

				if ($_POST['mod_name'] != "" && !preg_match("/^[0-9a-zA-Z".$allowed_characters." ():.,!?-]*$/is", $_POST['mod_name'])) {
					$error_msg = "".$amsg[318]."";
				}

				if ($_POST['mod_password'] != "" && ($_POST['mod_password'] !== $_POST['mod_password2'])) {
					$error_msg = "".$emsg[3]."";
				}

				if ($_POST['mod_email'] != "" && !validate_mail($_POST['mod_email'])) {
					$error_msg = "".$emsg[2]."";
				}
				elseif ($_POST['mod_email'] != "" && validate_mail($_POST['mod_email'])) {
					$sql_check_email = $gbook->query("SELECT `user_email` FROM `".$table."_login` WHERE `id` != '".$_REQUEST['id']."' AND `user_email` = '".$_POST['mod_email']."'");

					if ($sql_check_email->num_rows != 0 OR $properties['admin_email'] == $_POST['mod_email']) {
						$error_msg = "".$amsg[301]."";
					}
				}

				if (!$error_msg == "") {
					$msg_mod_options = "<tr><td colspan=\"2\"><p class=\"error\">".$error_msg."</p></td></tr>";
				}
				else {
					(BEST_PW && $gb_algo == 'ARG2ID') ? $gb_password = password_hash("".$_POST['mod_password']."", PASSWORD_ARGON2ID) : ((BEST_PW && $gb_algo == 'ARGO2I') ? $gb_password = password_hash("".$_POST['mod_password']."", PASSWORD_ARGON2I) : ((BEST_PW && $gb_algo == 'BCRYPT') ? $gb_password = password_hash("".$_POST['mod_password']."", PASSWORD_BCRYPT) : ((BEST_PW && $gb_algo == 'DEFLT') ? $gb_password = password_hash("".$_POST['mod_password']."", PASSWORD_DEFAULT) : ($gb_password = saltPassword("".$_POST['mod_password']."", $gb_salt)))));

					if ($_POST['mod_password'] === $_POST['mod_password2'])	{

						if ($_POST['mod_password'] != "") {
							$sql_update_mod = $gbook->query("UPDATE `".$table."_login` SET `main_pw` = '".$gb_password."', `pw_time` = '".time()."', `email_pw` = NULL, `email_time` = '0', `username` = '".$_POST['mod_name']."', `gb_salt` = '".$gb_salt."', `algos` = '".$gb_algo."', `user_email` = '".$_POST['mod_email']."', `status` = '".$mod_status."' WHERE `id` = '".$_REQUEST['id']."'");
						}
						else {
							$sql_update_mod = $gbook->query("UPDATE `".$table."_login` SET `email_pw` = NULL, `email_time` = '0', `username` = '".$_POST['mod_name']."', `user_email` = '".$_POST['mod_email']."', `status` = '".$mod_status."' WHERE `id` = '".$_REQUEST['id']."'");
						}

						if ($sql_update_mod) {
							$msg_mod_options = "<tr><td colspan=\"2\"><p class=\"green size-14 aligncenter\"><strong>".$amsg[158]."</strong><img src=\"".$url."images/wait.gif\" class=\"img-ok marg-le15\" alt=\"wait...\" width=\"16\" height=\"16\" /></p></td></tr>";

							echo "<meta http-equiv=\"Refresh\" content=\"2; url=".$url."admin/admin.php?action=admin_options&#38;show=show_mod&#38;".session_name()."=".session_id()."\" />";
						}
						else {
							$msg_mod_options = "<tr><td colspan=\"2\"><p class=\"error size-14\">".$emsg[11]."</p></td></tr>";
						}
					}
					else {
						$msg_mod_options = "<tr><td colspan=\"2\"><p class=\"error\">".$emsg[3]."</p></td></tr>";
					}
				}
			}

			echo"
				<form method=\"post\" action=\"".$url."admin/admin.php?action=admin_options&#38;show=edit_mod&#38;id=".$_REQUEST['id']."&#38;".session_name()."=".session_id()."\">
					<table class=\"main-table-02 tb-pad0\" style=\"max-width:450px;\">
						".$msg_mod_options."<tr>
							<td colspan=\"2\"><p class=\"aligncenter\"><strong>".$amsg[312]." \"<span class=\"blue\">".$mod_name."</span>\" ".$amsg[313].":</strong></p></td>
						</tr>
						<tr>
							<td style=\"width:49%;\"><br />".$fmsg[1].":</td>
							<td><br /><input type=\"text\" class=\"insert\" name=\"mod_name\" maxlength=\"20\" style=\"width:95%\" value=\"";

								if (isset($_POST['mod_name']) AND $_POST['mod_name'] != "") {
									echo stripslashes(htmlspecialchars(strip_tags($_POST['mod_name']), ENT_QUOTES));
								}
								else {
									echo "".$mod_name."";
								}

							echo "\" required=\"required\" /></td>
						</tr>
						<tr>
							<td><br />".$fmsg[20].":".$pwModWarning."</td>
							<td><br /><input type=\"password\" class=\"insert\" id=\"psw02\" name=\"mod_password\" style=\"width:95%\" placeholder=\"(".$amsg[317].")\" /></td>
						</tr>
						<tr>
							<td colspan=\"2\">
								<div id=\"mod-pw\">
									<div style=\"margin-top:20px;\"><span style=\"display:inline-block;width:48.5%;\">".$amsg[249]."</span><label class=\"container\" style=\"display:inline-block;top:-5px;\"><input type=\"checkbox\" onclick=\"showPw02()\" style=\"display:none;\" /><span class=\"checkmark02-sm\"></span></label></div>
									<div id=\"psw-check02\"><span id=\"psw-qual02\" class=\"qual\"></span></div>
									<div class=\"psw-text\" style=\"margin-top:15px;\">
										<strong class=\"red\" style=\"float:left;\">".$amsg[248]."</strong>
										<strong class=\"green\" style=\"float:right;\">".$amsg[247]."</strong>
										<a href=\"".$url."admin/admin.php?action=help&#38;".session_name()."=".session_id()."#anchor-pws\" title=\"".$amsg[340]."\" class=\"aligncenter\" style=\"width:14px;height:14px;cursor:help;\"><img src=\"".$url."images/help.png\" width=\"14\" height=\"14\" alt=\"".$amsg[119]."\" /></a>
									</div>
								</div>
							</td>
						</tr>
						<tr>
							<td><br />".$fmsg[54]."</td>
							<td><br /><input type=\"password\" class=\"insert\" id=\"psw03\" name=\"mod_password2\" style=\"width:95%\" /></td>
						</tr>
						<tr>
							<td><br />".$fmsg[8].":</td>
							<td><br /><input type=\"text\" class=\"insert\" name=\"mod_email\" maxlength=\"80\" style=\"width:95%\" value=\"";

								if (isset($_POST['mod_email']) AND $_POST['mod_email'] != "") {
									echo stripslashes(htmlspecialchars(strip_tags($_POST['mod_email']), ENT_QUOTES));
								}
								else {
									echo "".$mod_email."";
								}

							echo "\" required=\"required\" /></td>
						</tr>
						<tr>
							<td><br />".$amsg[367]."</td>
							<td>
								<label class=\"container\" style=\"top:-4px;\"><input type=\"checkbox\" name=\"mod_info\"";

								if ($_POST['mod_info'] == '1' OR $mod_info == '3') {
									echo " checked=\"checked\"";
								}

								echo" value=\"1\" /><span class=\"checkmark\"></span></label>
							</td>
						</tr>
						<tr>
							<td>
								<p class=\"aligncenter\"><br /><input class=\"button\" type=\"submit\" name=\"send04\" value=\"".$fmsg[55]."\" /><input type=\"hidden\" name=\"id\" value=\"".$_REQUEST['id']."\" />
							</td>
							<td>
								<p class=\"aligncenter\"><br /><input class=\"button\" type=\"button\" name=\"abbruch\" value=\"".$fmsg[269]."\" onclick=\"self.location.href='admin.php?action=admin_options&#38;show=show_mod&#38;".session_name()."=".session_id()."'\" />
							</td>
						</tr>
					</table>  
				</form>";
		}

		echo"
		<p>&nbsp;</p>
		</fieldset>
		<p>&nbsp;</p>
		</div>
		<script>
			var myInput=document.getElementById(\"psw\");
			var myPswCheck=document.getElementById(\"psw-qual\");
			myInput.onfocus=function(){document.getElementById(\"admin-pw\").style.display=\"block\";}
			myInput.onkeyup=function(){
				var lowerCaseLetters=/[a-züöä]/g;
				if(myInput.value.match(lowerCaseLetters)){var pswStatus1=1;}else{var pswStatus1=0;}
				var upperCaseLetters=/[A-ZÜÖÄ]/g;
				if(myInput.value.match(upperCaseLetters)){var pswStatus2=1;}else{var pswStatus2=0;}
				var numbers=/[0-9]/g;
				if(myInput.value.match(numbers)){var pswStatus3=1;}else{var pswStatus3=0;}
				var signs=/[^A-ZÜÖÄa-züöä0-9]/g;
				if(myInput.value.match(signs)){var pswStatus4=1;}else{var pswStatus4=0;}
				if(myInput.value.length>=11){var pswStatus5=1;}else{var pswStatus5=0;}
				var pswStatus = pswStatus1+pswStatus2+pswStatus3+pswStatus4+pswStatus5;
				var lastsign=myInput.value.substr(myInput.value.length-1,1);
				if((lastsign.match(numbers)||lastsign.match(signs))&&pswStatus>3){var pswStatus=pswStatus-1;}
				if(myInput.value.length>=5 && myInput.value.length<7){var k=1;}
				else if(myInput.value.length>=7 && myInput.value.length<9){var k=2;}
				else if(myInput.value.length>=9){var k=3;}
				else{var k=0;}
				if(pswStatus==5){myPswCheck.classList.remove(\"qual-a\");myPswCheck.classList.remove(\"qual-b\");myPswCheck.classList.remove(\"qual-c\");myPswCheck.classList.remove(\"qual-d\");myPswCheck.classList.add(\"qual-e\");}
				else if(pswStatus>=4 && k==3){myPswCheck.classList.remove(\"qual-a\");myPswCheck.classList.remove(\"qual-b\");myPswCheck.classList.remove(\"qual-c\");myPswCheck.classList.remove(\"qual-e\");myPswCheck.classList.add(\"qual-d\");}
				else if(pswStatus>=3 && k>=2){myPswCheck.classList.remove(\"qual-a\");myPswCheck.classList.remove(\"qual-b\");myPswCheck.classList.remove(\"qual-d\");myPswCheck.classList.remove(\"qual-e\");myPswCheck.classList.add(\"qual-c\");}
				else if(pswStatus>=2 && k>=1){myPswCheck.classList.remove(\"qual-a\");myPswCheck.classList.remove(\"qual-c\");myPswCheck.classList.remove(\"qual-d\");myPswCheck.classList.remove(\"qual-e\");myPswCheck.classList.add(\"qual-b\");}
				else if(pswStatus>=1){myPswCheck.classList.remove(\"qual-b\");myPswCheck.classList.remove(\"qual-c\");myPswCheck.classList.remove(\"qual-d\");myPswCheck.classList.remove(\"qual-e\");myPswCheck.classList.add(\"qual-a\");}
				else{myPswCheck.classList.remove(\"qual-a\");myPswCheck.classList.remove(\"qual-b\");myPswCheck.classList.remove(\"qual-c\");myPswCheck.classList.remove(\"qual-d\");myPswCheck.classList.remove(\"qual-e\");}
			}
			var myInput02=document.getElementById(\"psw02\");
			var myPswCheck02=document.getElementById(\"psw-qual02\");
			if(myInput02){
				myInput02.onfocus=function(){document.getElementById(\"mod-pw\").style.display=\"block\";}
				myInput02.onkeyup=function(){
					var lowerCaseLetters=/[a-züöä]/g;
					if(myInput02.value.match(lowerCaseLetters)){var pswStatus11=1;}else{var pswStatus11=0;}
					var upperCaseLetters=/[A-ZÜÖÄ]/g;
					if(myInput02.value.match(upperCaseLetters)){var pswStatus12=1;}else{var pswStatus12=0;}
					var numbers=/[0-9]/g;
					if(myInput02.value.match(numbers)){var pswStatus13=1;}else{var pswStatus13=0;}
					var signs=/[^A-ZÜÖÄa-züöä0-9]/g;
					if(myInput02.value.match(signs)){var pswStatus14=1;}else{var pswStatus14=0;}
					if(myInput02.value.length>=11){var pswStatus15=1;}else{var pswStatus15=0;}
					var pswModStatus = pswStatus11+pswStatus12+pswStatus13+pswStatus14+pswStatus15;
					var lastModsign=myInput02.value.substr(myInput02.value.length-1,1);
					if((lastModsign.match(numbers)||lastModsign.match(signs))&&pswModStatus>3){var pswModStatus=pswModStatus-1;}
					if(myInput02.value.length>=5 && myInput02.value.length<7){var x=1;}
					else if(myInput02.value.length>=7 && myInput02.value.length<9){var x=2;}
					else if(myInput02.value.length>=9){var x=3;}
					else{var x=0;}
					if(pswModStatus==5){myPswCheck02.classList.remove(\"qual-a\");myPswCheck02.classList.remove(\"qual-b\");myPswCheck02.classList.remove(\"qual-c\");myPswCheck02.classList.remove(\"qual-d\");myPswCheck02.classList.add(\"qual-e\");}
					else if(pswModStatus>=4 && x==3){myPswCheck02.classList.remove(\"qual-a\");myPswCheck02.classList.remove(\"qual-b\");myPswCheck02.classList.remove(\"qual-c\");myPswCheck02.classList.remove(\"qual-e\");myPswCheck02.classList.add(\"qual-d\");}
					else if(pswModStatus>=3 && x>=2){myPswCheck02.classList.remove(\"qual-a\");myPswCheck02.classList.remove(\"qual-b\");myPswCheck02.classList.remove(\"qual-d\");myPswCheck02.classList.remove(\"qual-e\");myPswCheck02.classList.add(\"qual-c\");}
					else if(pswModStatus>=2 && x>=1){myPswCheck02.classList.remove(\"qual-a\");myPswCheck02.classList.remove(\"qual-c\");myPswCheck02.classList.remove(\"qual-d\");myPswCheck02.classList.remove(\"qual-e\");myPswCheck02.classList.add(\"qual-b\");}
					else if(pswModStatus>=1){myPswCheck02.classList.remove(\"qual-b\");myPswCheck02.classList.remove(\"qual-c\");myPswCheck02.classList.remove(\"qual-d\");myPswCheck02.classList.remove(\"qual-e\");myPswCheck02.classList.add(\"qual-a\");}
					else{myPswCheck02.classList.remove(\"qual-a\");myPswCheck02.classList.remove(\"qual-b\");myPswCheck02.classList.remove(\"qual-c\");myPswCheck02.classList.remove(\"qual-d\");myPswCheck02.classList.remove(\"qual-e\");}
				}
			}
			function showPw(){
				var y=document.getElementById(\"psw\");
				if(y.type===\"password\"){y.type=\"text\";}else{y.type=\"password\";}
				var z=document.getElementById(\"psw01\");
				if(z.type===\"password\"){z.type=\"text\";}else{z.type=\"password\";}
			} 
			function showPw02(){
				var v=document.getElementById(\"psw02\");
				if(v.type===\"password\"){v.type=\"text\";}else{v.type=\"password\";}
				var w=document.getElementById(\"psw03\");
				if(w.type===\"password\"){w.type=\"text\";}else{w.type=\"password\";}
			} 
		</script>";
	}
?>