<?php
/*
	myPHP Guestbook Copyright (C) 2003 - 2006  Claudio Pose
	myPHP Guestbook was an open source project of Networkarea.ch

	Version 3.x Copyright (C) 2011 - 2014 Christian Thomas, www.hostonline.de

	Version 4.x (MySQLi) Copyright (C) 2014 - 2022 Wolfgang Leverberg, www.php-guestbook.de

	This file is a part of myPHP Guestbook.
	myPHP Guestbook is free software; you can redistribute it and/or modify it under the terms of the 
	GNU General Public License as published by the Free Software Foundation; either version 3 of the 
	License, or (at your option) any later version.

	myPHP Guestbook is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
	even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

	See the GNU General Public License for more details.

	02.01.2022
*/

	if (!isset($_SESSION['sid']) && !isset($_SESSION['modsid'])) {
		header("Location: admin.php?action=login");
		die();
	}
	else {
		$count_entries = $output = $bad = $good = $mark_date = $mark_time = $mark_name = $mark_email = $mark_hp = $mark_icq = $mark_town = $mark_country = $origin = $mark_subject = $mark_text = $slash = "";
		$div_c = $div_t = $div_em = $div_hp = "dsR3";
		$short_town = "30";
		$rows = 13;
		$placeholderName = $placeholderEMail = $placeholderCountry = $placeholderTown = $fmsg[337];

		isset($_POST['date']) ? ($_POST['date'] = $_POST['date']) : ($_POST['date'] = GB_DATE);
		isset($_POST['time']) ? ($_POST['time'] = $_POST['time']) : ($_POST['time'] = date("H:i"));
		isset($_POST['name']) ? ($_POST['name'] = $_POST['name']) : ($_POST['name'] = "");
		isset($_POST['betreff']) ? ($_POST['betreff'] = $_POST['betreff']) : ($_POST['betreff'] = "");
		isset($_POST['email']) ? ($_POST['email'] = $_POST['email']) : ($_POST['email'] = "");
		isset($_POST['homepage']) ? ($_POST['homepage'] = $_POST['homepage']) : ($_POST['homepage'] = "");
		isset($_POST['town']) ? ($_POST['town'] = $_POST['town']) : ($_POST['town'] = "");
		isset($_POST['country']) ? ($_POST['country'] = $_POST['country']) : ($_POST['country'] = "");

		$myDate = GB_DATE;
		$myTime = date("H:i");
		$edit_timestamp = isset($edit_timestamp) ? $edit_timestamp : "";
		$edit_date = isset($edit_date) ? $edit_date : "";

		echo "
			<div class=\"content-02\">";

		$sql_properties = $gbook->query("SELECT `admin_email`, `antiflood_ban`, `bbcode`, `check_email`, `check_homepage`, `deactivate_html`, `guestbook_status`, `guestbook_title`, `images_in_entries`, `max_word_length`, `notification_entries`, `release_entries`, `smilies`, `statistic`, `statistic_ban`, `check_subject`, `check_town`, `check_country`, `check_free`, `button_link` 
											 FROM `".$table."_properties`");
		$properties = $sql_properties->fetch_assoc();

		$properties['check_town'] = isset($properties['check_town']) ? $properties['check_town'] : 0;
		$properties['check_country'] = isset($properties['check_country']) ? $properties['check_country'] : 0;
		$properties['check_email'] = isset($properties['check_email']) ? $properties['check_email'] : 4;
		$properties['check_homepage'] = isset($properties['check_homepage']) ? $properties['check_homepage'] : 1;

		if ($properties['check_town'] != 1 && $properties['check_country'] == 1) {
			$div_t = "i-max";
		}
		elseif ($properties['check_town'] == 1 && $properties['check_country'] != 1) {
			$div_c = "i-max";
		}
		elseif ($properties['check_town'] != 1 && $properties['check_country'] != 1) {
			$div_t = "i-left";
			$div_c = "i-right";
		}

		if (($properties['check_homepage'] == 0 && $properties['check_email'] > 1) OR ($properties['check_homepage'] == 1 && $properties['check_email'] != 4)) {
			$div_em = $div_hp = "i-max";
		}
		elseif ($properties['check_homepage'] == 0 && ($properties['check_email'] == 0 OR $properties['check_email'] == 1)) {
			$div_em = "i-left";
			$div_hp = "i-right";
		}

		($properties['check_homepage'] == 0 && ($properties['check_email'] == 2 OR $properties['check_email'] == 3)) ? $margDiv = "</div><div class=\"break\"></div><div class=\"insert-height\">" : $margDiv = "";
		($properties['check_email'] == 2 || $properties['check_email'] == 3) ? $hidden_email = "<span class=\"small-02\">(".$fmsg[125].")</span>" : $hidden_email = "";

		BlogMod ? ($blog = '<img class="img-ok marg-le15" title="'.$amsg['167'].'" src="../images/ok.png" width="14" height="14" alt="'.$amsg['167'].'" />') : ($blog = '<img class="img-ok marg-le15" title="'.$amsg['41'].'" src="../images/not_ok.png" width="14" height="14" alt="'.$amsg['41'].'" />');
		$properties['guestbook_status'] ? ($gbActive = '<img class="img-ok marg-le15" title="'.$amsg['167'].'" src="../images/ok.png" width="14" height="14" alt="'.$amsg['167'].'" />') : ($gbActive = '<img class="img-ok marg-le15" title="'.$amsg['41'].'" src="../images/not_ok.png" width="14" height="14" alt="'.$amsg['41'].'" />');

		echo"
			<fieldset><legend><strong>".$amsg[178]."</strong></legend>
				<table class=\"main-table-02 tb-pad0\" style=\"max-width:300px;\">
					<tr>
						<td>
							<p class=\"aligncenter\"><br /><strong>".$fmsg[173]."?</strong>".$gbActive."<a class=\"cursor-help\" title=\"".$amsg[340]."\" href=\"javascript:{}\" onclick=\"document.getElementById('gb_active').style.display='inline';return false;\"><img class=\"img-ok marg-le15\" src=\"".$url."images/help.png\" width=\"14\" height=\"14\" alt=\"".$amsg[119]."\" /></a></p>
						</td>
					</tr>
					<tr>
						<td>
							<span class=\"aligncenter\"><strong>".$amsg[179]."</strong>".$blog."<a class=\"cursor-help\" title=\"".$amsg[340]."\" href=\"javascript:{}\" onclick=\"document.getElementById('blog').style.display='inline';return false;\"><img class=\"img-ok marg-le15\" src=\"".$url."images/help.png\" width=\"14\" height=\"14\" alt=\"".$amsg[119]."\" /></a></span>
						</td>
					</tr>";
				echo"
					<tr>
						<td>
							<div id=\"blog\" class=\"gb-lightbox\" style=\"display:none\">
								<div class=\"gb-lightbox-inner\" style=\"max-width:500px;\">
									<strong class=\"aligncenter\">".$amsg[180]."</strong>".$amsg[181]."
									<div class=\"gblb-close\"><img class=\"close-flag\" src=\"".$url."images/not_ok.png\" alt=\"Close\" width=\"14\" height=\"14\" onclick=\"document.getElementById('blog').style.display='none';\" /></div>
								</div>
								</div>
							</div>
							<div id=\"gb_active\" class=\"gb-lightbox\" style=\"display:none\">
								<div class=\"gb-lightbox-inner\">
									<strong class=\"aligncenter\">".$fmsg[173]."?</strong>".$amsg[209]."
									<div class=\"gblb-close\"><img class=\"close-flag\" src=\"".$url."images/not_ok.png\" alt=\"Close\" width=\"14\" height=\"14\" onclick=\"document.getElementById('gb_active').style.display='none';\" /></div>
								</div>
							</div>
						</td>
					</tr>";
			echo $errorCookie;
			echo"
				</table>
			<br /><hr style=\"width:70%;\"/>
			<div>
				<p class=\"text-center\"><br /><strong>".$fmsg[5]."</strong></p>";

				if (isset($_POST['send']) OR isset($_POST['preview'])){
					$error_msg	 = "";

					$_POST['name'] = trim($_POST['name']);
					$_POST['text'] = trim($_POST['text']);
					$_POST['date'] = trim($_POST['date']);
					$_POST['time'] = trim($_POST['time']);
					$_POST['betreff'] = trim($_POST['betreff']);

					if (!preg_match("/^[0-9.-]*$/is", $_POST['date'])) {
						$mark_date = " no-insert";
						$error_msg .= "<p class=\"error\">".$emsg[34]."</p>";
						$_POST['date'] = $myDate;
					}

					if (!empty($_POST['time']) && !preg_match("/^(0[0-9]|1[0-9]|2[0-3]):(0[0-9]|[1-5][0-9])$/", $_POST['time'])) {
						$mark_time = " no-insert";
						$error_msg .= "<p class=\"error\">".$emsg[35]." - Format: (hh:mm)</p>";
						$_POST['time'] = $myTime;
					}

					if ($_POST['name'] == "" && !BlogMod) {
						$mark_name = " no-insert";
						$error_msg .= "<p class=\"error\">".$emsg[9]."</p>";
					}
					elseif ($_POST['name'] != "" && !preg_match("/^[0-9a-zA-Z".$allowed_characters."' ().-]*$/is", $_POST['name'])) {
						$mark_name = " no-insert";
						$error_msg .= "<p class=\"error\">".$emsg[81]."</p>";
					}

					if ($properties['check_town'] != 1 && $_POST['town'] != "") {
						$_POST['town'] = trim($_POST['town']);

						if (!preg_match("/^[0-9a-zA-Z".$allowed_characters."\/ '():.,-]*$/is", $_POST['town'])) {
							$mark_town = " no-insert";
							$error_msg .= "<p class=\"error\">".$emsg[76]."</p>";
						}
					}

					if ($properties['check_country'] != 1 && $_POST['country'] != "") {
						$_POST['country'] = trim($_POST['country']);

						if (!preg_match("/^[0-9a-zA-Z".$allowed_characters."\/ '():.,-]*$/is", $_POST['country'])) {
							$mark_country = " no-insert";
							$error_msg .= "<p class=\"error\">".$emsg[77]."</p>";
						}
					}

					if ($_POST['town'] != "" && $_POST['country'] != "") {
						$slash = " | ";
					}

					if ($properties['check_email'] != 4){
						$_POST['email'] = trim($_POST['email']);

						if (($properties['check_email'] == 1 || $properties['check_email'] == 2) AND !validate_mail($_POST['email'])) {
							$mark_email = " no-insert";
							$error_msg .= "<p class=\"error\">".$emsg[2]."</p>";
						}
						elseif($_POST['email'] != "" AND !validate_mail($_POST['email'])){
							$mark_email = " no-insert";
							$error_msg .= "<p class=\"error\">".$emsg[2]."</p>";
						}
					}
					else {
						$_POST['email'] = "";
					}

					if ($properties['check_homepage'] == 0){
						$_POST['homepage'] = trim($_POST['homepage']);

						if ($_POST['homepage'] != "") {
							$hpcount_http = substr_count(strtolower($_POST['homepage']), 'http://', 0);
							$hpcount_https = substr_count(strtolower($_POST['homepage']), 'https://', 0);
							$hpcount_ftp = substr_count(strtolower($_POST['homepage']), 'ftp://', 0);
							$hpcount_www = substr_count(strtolower($_POST['homepage']), 'www.', 0, 4);

							if ($hpcount_http == 0 && $hpcount_https == 0 && $hpcount_ftp == 0 && $hpcount_www == 1) {
								$_POST['homepage'] = "http://".$_POST['homepage']."";
							}
						}

						if ($_POST['homepage'] != "" && $_POST['homepage'] != "http://" && !validate_url($_POST['homepage'])){
							$mark_hp = " no-insert";
							$error_msg .= "<p class=\"error\">".$fmsg[207]."</p>";
						}
					}
					else {
						$_POST['homepage'] = "";
					}

					if ($_POST['betreff'] != "") {
						$_POST['betreff'] = preg_replace("/\s+/", " ", $_POST['betreff']);
					}

					if ($_POST['text'] == "") {
						$mark_text = " no-insert";
						$error_msg .= "<p class=\"error\">".$emsg[10]."</p>";
					}

					if (!$error_msg == ""){
						echo "".$error_msg."";
					}

					else {
						if (isset($_POST['send'])) {
							(isset($_POST['date']) AND $_POST['date'] != "") ? $_POST['date'] = $_POST['date'] : $_POST['date'] = $myDate;										
							(isset($_POST['time']) AND $_POST['time'] != "") ? $_POST['time'] = $_POST['time'] : $_POST['time'] = $myTime;

							if ($dateFormat === "us") {
								if (preg_match("/^(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])-[0-9]{4}$/",$_POST['date'])) {
									$edit_gbdate = date_create_from_format('m-d-Y',''.$_POST['date'].'');
									$edit_date = date_format($edit_gbdate, 'd.m.Y');
								}
								else {
									$error_msg .= "<p class=\"error\">Wrong Date input or Date format! Only: mm-dd-yyyy</p>";
								}
							}
							elseif ($dateFormat === "sv") {
								if (preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/",$_POST['date'])) {
									$edit_gbdate = date_create_from_format('Y-m-d',''.$_POST['date'].'');
									$edit_date = date_format($edit_gbdate, 'd.m.Y');
								}
								else {
									$error_msg .= "<p class=\"error\">Wrong Date input or Date format! Only: yyyy-mm-dd</p>";
								}
							}
							else {
								$edit_date = $_POST['date'];
							}
				
							$edit_timestamp = strtotime(''.$edit_date.''.$_POST['time'].'',time());
				
							if ($edit_timestamp === false) {
								$error_msg .= "<p class=\"error\">The input for the Date is not parseable.</p>";
							}
							
							$_POST['date']     = $gbook->real_escape_string($_POST['date']);
							$_POST['time']	   = $gbook->real_escape_string($_POST['time']);
							$_POST['name']     = $gbook->real_escape_string($_POST['name']);
							$_POST['town']     = $gbook->real_escape_string($_POST['town']);
							$_POST['country']  = $gbook->real_escape_string($_POST['country']);
							$_POST['email']    = $gbook->real_escape_string($_POST['email']);
							$_POST['homepage'] = $gbook->real_escape_string($_POST['homepage']);
							$_POST['betreff']  = $gbook->real_escape_string($_POST['betreff']);
							$_POST['text']     = $gbook->real_escape_string($_POST['text']);

							$origin  = $_POST['town'];
							$origin .= $slash;
							$origin .= $_POST['country'];

							($_POST['betreff'] != "") ? ($entry  = "[b]".$_POST['betreff']."[/b]\r\n\r\n") : $entry  = "";		                
							$entry .= $_POST['text'];

							$sql_insert_entry  = $gbook->query("INSERT INTO `".$table."_entries` (`comment`, `date`, `email`, `homepage`, `icq`, `ip`, `status`, `name`, `activation_code`, `text`, `time`, `origin`, `marker`, `stars`, `check_time`) VALUES (NULL, '".$_POST['date']."', '".$_POST['email']."', '".$_POST['homepage']."', '0', NULL, '2', '".$_POST['name']."', NULL, '".$entry."', '".$_POST['time']."', '".$origin."', '0', '0', '".$edit_timestamp."')");

							if (isset($sql_insert_entry)) {
								echo "<meta http-equiv=\"Refresh\" content=\"0; url=".$url."admin/admin.php?action=guestbook&#38;".session_name()."=".session_id()."\">";
							}
							else {
								echo "<p class=\"error\">".$emsg[11]."</p>";
							}
						}

						if (isset($_POST['preview'])) {
							$bad  = array("(",")","{","}","@");
							$good = array("&#40;","&#41;","&#123;","&#125;","&#64;");

							$name = $_POST['name'];
							$name = nobadwords($name);
							$name = stripslashes(htmlentities(strip_tags($name), ENT_QUOTES, "UTF-8"));
							$name = str_replace($bad, $good, $name);

							$town = $_POST['town'];
							$town = nobadwords($town);
							$town = stripslashes(htmlentities(strip_tags($town), ENT_QUOTES, "UTF-8"));
		                    $town = shortWords($town, $short_town);

							$country = $_POST['country'];
							$country = nobadwords($country);
							$country = stripslashes(htmlentities(strip_tags($country), ENT_QUOTES, "UTF-8"));

							$email = $_POST['email'];
							$email = stripslashes(htmlspecialchars(strip_tags($_POST['email']), ENT_QUOTES));
							$email = noInjektion($email);
		      				$email = noSpam02($email);

							$homepage = $_POST['homepage'];
							$homepage = stripslashes(htmlentities(strip_tags($homepage), ENT_QUOTES, "UTF-8"));

							$subject = $_POST['betreff'];
							$subject = nobadwords($subject);
							$subject = shortWords($subject, $properties['max_word_length']);
							$subject = stripslashes(htmlentities(strip_tags($subject), ENT_QUOTES, "UTF-8"));
							$subject = str_replace($bad, $good, $subject);

							if($_POST['betreff'] != "")	{
								$subject = "<strong>".$subject."</strong>
											<br /><br />
											";
							}

							$text = $_POST['text'];
							$text = preg_replace('/(\r\n)(\\1{1,1})\\1*/sS', '$1$2', $text);
							$text = nobadwords($text);
							$text = shortWords($text, $properties['max_word_length']);

							if ($properties['deactivate_html']){
								$text = htmlentities(strip_tags($text), ENT_QUOTES, "UTF-8");
							}

							$text  = nl2br($text);
							$text  = stripslashes($text);

							if ($properties['bbcode']) {
								$text = bbcode($text);

								$sql_picture = $gbook->query("SELECT `pic_name`, `width`, `height`, `title` FROM `".$table."_pictures`");

								while ($picture = $sql_picture->fetch_assoc()){
									$maxpicwidth = '490';
									$newwidth = $picture['width'];
									$newheight = $picture['height'];

									if ($picture['width'] > $maxpicwidth){
										$prozent = $maxpicwidth/$picture['width'];
										$newwidth = floor($picture['width']*$prozent);
										$newheight = floor($picture['height']*$prozent);
									}
									
									$picture['title'] = $picture['title'] === NULL ? "" : htmlspecialchars($picture['title']);

									$text = preg_replace("/\[img\](".$picture['pic_name'].")\[\/img\]/si", "<img class=\"centered\" title=\"".$picture['title']."\" src=\"".$url."img_guest/\\1\" alt=\"".$picture['title']."\" width=\"".$newwidth."\" height=\"".$newheight."\" />", $text);
								}
							}

							if ($properties['smilies']) {
								$text = smilies($text);
							}

							$text = str_replace($bad, $good, $text);

							$post  = $subject;
							$post .= $text;

							$town = (($town != "") && ($properties['check_town'] != 1)) ? $town : "";		                
							$country = (($country != "") && ($properties['check_country'] != 1)) ? $country : "";		                
							$origin  = $town;
							$origin .= $slash;
							$origin .= $country;

							$sql_count_entries	= $gbook->query("SELECT  `id`  FROM  `".$table."_entries`  WHERE  `status` != '0'");
							$count_entries 		= $sql_count_entries->num_rows;
							$count_entries 		= $count_entries+1;

							if ($dateFormat === "us") {
								if (isset($_POST['time']) && preg_match("/^(0[0-9]|1[0-9]|2[0-3]):(0[0-9]|[1-5][0-9])$/",$_POST['time'])) {
									$edit_time = date_create_from_format('H:i',''.$_POST['time'].'');
									$showTime = date_format($edit_time, 'h:i A');
								}
								elseif (preg_match("/^(0[0-9]|1[0-9]|2[0-3]):(0[0-9]|[1-5][0-9])$/",$myTime)) {
									$edit_time = date_create_from_format('H:i',''.$myTime.'');
									$showTime = date_format($edit_time, 'h:i A');
								}
							}
							else {
								if (isset($_POST['time']) && !empty($_POST['time'])) {
									$showTime = $_POST['time'];
								}
								else {
									$showTime = $myTime;
								}
							}

							echo "
								<div id=\"lightbox_hp\" class=\"gb-lightbox\" style=\"display:none\">
									<div class=\"gb-lightbox-inner\" style=\"max-width:530px;\">
										<span class=\"aligncenter\"><strong>".$amsg[206]."</strong></span><br />".$amsg[207]."
										<div class=\"gblb-close\"><img class=\"close-flag\" src=\"".$url."images/not_ok.png\" alt=\"Close\" width=\"14\" height=\"14\" onclick=\"document.getElementById('lightbox_hp').style.display='none';\" /></div>
									</div>
								</div>
								<table class=\"main-table\" style=\"width:98% !important;\">
									<tr class=\"headpost bg-gray\">
										<td style=\"width:43%\" class=\"headpad\">
											<strong>&nbsp;".$name."</strong>";

											if (!empty($origin)) {
												echo "<br />&nbsp;<span class=\"size-10\">".$origin."</span>";
											}
			
									echo"			
										</td>
										<td align=\"center\" style=\"width:22%\" class=\"headpad\">
										";

											if (empty($email) OR $properties['check_email'] == 4) {
												echo "&nbsp;";
											}
											else {
												echo "<a href=\"mailto:".$email."\"><img class=\"ico\" src=\"".$url."images/icons/email/emailnew.gif\" alt=\"".$email."\" /></a>";
											}
			
											if (empty($homepage) OR $homepage == "http://" OR $properties['check_homepage']) {
												echo "&nbsp;";
											}
											else {
												echo "<a href=\"javascript:{}\" onclick=\"document.getElementById('lightbox_hp').style.display='inline';return false;\"><img class=\"ico\" src=\"".$url."/images/icons/homepage/homepage.gif\" alt=\"".$homepage."\" title=\"".$homepage."\" /></a>";
											}

									echo"
										</td>
										<td align=\"right\" style=\"width:37%\" class=\"headpad beitragnr\">
											<strong>".$amsg[84]." # ".$count_entries."</strong><br />".$amsg[85]."";

											if(isset($_POST['date']) AND $_POST['date'] != "") {
												echo" ".$_POST['date']."";
											}
											else {
												echo" ".$myDate."";
											}
	
											echo" | ".$showTime."";
									echo"
										</td>
									</tr>
									<tr>
										<td align=\"left\" colspan=\"3\">
											".$post."
										</td>
									</tr>
								</table>
								<br /><br />";
						}
					}
				}

				echo"
					<form action=\"".$url."admin/admin.php?action=adminblog&#38;".session_name()."=".session_id()."\" method=\"post\" name=\"insert\">
					<table class=\"main-table-02 tb-pad3\">
						<tr>
							<td>
								<div class=\"insert-height\">
									<strong class=\"lineheight\">".$fmsg[170]."<span class=\"red size-20\">*</span></strong>
									<input class=\"marg-le15 insert".$mark_date."\" type=\"text\" name=\"date\" size=\"11\" style=\"width:70px;\" maxlength=\"10\" onfocus=\"this.value=''\" placeholder=\"".$myDate."\" value=\"";

										if (isset($_POST['date']) AND $_POST['date'] != "") {
											echo "".$_POST['date']."";
										}
										else {
											echo "".$myDate."";
										}

									echo "\" />
									<span class=\"marg-le15 size-20 text-shadow\">|</span>
									<input class=\"marg-le15 insert".$mark_time."\" type=\"text\" name=\"time\" size=\"6\" style=\"width:40px;\" maxlength=\"5\" onfocus=\"this.value=''\" placeholder=\"".$myTime."\" value=\"";

										if (isset($_POST['time']) AND $_POST['time'] != "") {
											echo "".$_POST['time']."";
										}
										else {
											echo "".$myTime."";
										}

									echo "\" />
								</div>
								<div class=\"break\"></div>
								<div class=\"insert-height\">
									<strong class=\"lineheight\">".$fmsg[7]."";

										if (!BlogMod) {
											echo "<span class=\"red size-20\">*</span>";
											$placeholderName = $fmsg[334];
										}

								echo "</strong>
									<input class=\"insert insert-blog".$mark_name."\" type=\"text\" name=\"name\" size=\"25\" maxlength=\"27\" placeholder=\"(".$placeholderName.")\" value=\"";

										if (isset($_POST['name']) AND $_POST['name'] != "") {
											echo stripslashes(htmlspecialchars(strip_tags($_POST['name']), ENT_QUOTES));
										}

									echo "\" />
								</div>
								<div class=\"break\"></div>";

						if(($properties['check_town'] != 1) OR ($properties['check_country'] != 1)) {
							echo"
								<div class=\"insert-height\">
										<div class=\"".$div_t."\">";

										if($properties['check_town'] != 1){
											echo"
											<strong class=\"lineheight\">".$fmsg[346]."";

											if ($properties['check_town'] == 2) {
												echo "<span class=\"red size-20\">*</span>";
												$placeholderTown = $fmsg[334];
											}

											echo "</strong>
											<input class=\"insert insert-blog".$mark_town."\" type=\"text\" name=\"town\" size=\"15\" maxlength=\"60\" placeholder=\"(".$placeholderTown.")\" value=\"";

											if (isset($_POST['town']) AND $_POST['town'] != "") {
												echo stripslashes(htmlspecialchars(strip_tags($_POST['town']), ENT_QUOTES));
											}

											echo"\" />";
										}

									echo"
										</div>
										<div class=\"".$div_c."\">";

										if($properties['check_country'] != 1){
											echo"
											<strong class=\"lineheight\">".$fmsg[347]."";

											if ($properties['check_country'] == 2) {
												echo "<span class=\"red size-20\">*</span>";
												$placeholderCountry = $fmsg[334];
											}

											echo "</strong>
											<input class=\"insert insert-blog".$mark_country."\" type=\"text\" name=\"country\" size=\"15\" maxlength=\"35\" placeholder=\"(".$placeholderCountry.")\" value=\"";

											if (isset($_POST['country']) AND $_POST['country'] != "") {
												echo stripslashes(htmlspecialchars(strip_tags($_POST['country']), ENT_QUOTES));
											}

											echo"\" />";
										}

									echo"
										</div>
									</div>";

									if(($properties['check_town'] == 0) && ($properties['check_country'] == 0)) {
										echo"<p class=\"pad-10\"><br /></p>";
									}

									echo"
										<div class=\"break\"></div>";
						}

						if(($properties['check_email'] != 4) OR ($properties['check_homepage'] == 0)) {
							echo"
								<div class=\"insert-height\">
									<div class=\"".$div_em."\">";

										if ($properties['check_email'] != 4) {
											echo"
											<strong class=\"lineheight\">".$fmsg[8].":";

											if($properties['check_email'] == 1 || $properties['check_email'] == 2) {
												echo "<span class=\"red size-20\">*</span>";
												$placeholderEMail = $fmsg[334];
											}
											echo"</strong> ".$hidden_email."
											<input class=\"insert insert-blog".$mark_email."\" type=\"text\" name=\"email\" size=\"25\" maxlength=\"50\" placeholder=\"(".$placeholderEMail.")\" value=\"";

											if (isset($_POST['email']) AND $_POST['email'] != "") {
												echo stripslashes(htmlspecialchars(strip_tags($_POST['email']), ENT_QUOTES));
											}

											echo"\" />";
										}

								echo"
									</div>".$margDiv."
									<div class=\"".$div_hp."\">";

										if($properties['check_homepage'] == 0){
											echo"
											<strong class=\"lineheight\">".$fmsg[9]."</strong>
											<input class=\"insert insert-blog".$mark_hp."\" type=\"text\" name=\"homepage\" size=\"25\" maxlength=\"150\" placeholder=\"(".$fmsg[337].")\" value=\"";

											if (isset($_POST['homepage']) AND $_POST['homepage'] != "") {
												echo stripslashes(htmlspecialchars(strip_tags($_POST['homepage']), ENT_QUOTES));
											}

											echo "\" />";
										}

								echo"
									</div>
								</div>
								<div class=\"break\"></div>";
						}

						if(isset($properties['check_subject']) && $properties['check_subject'] == 0){
							echo "
								<div class=\"insert-height\">
										<strong class=\"lineheight\">".$fmsg[313]."</strong>
										<input class=\"insert insert-blog".$mark_subject."\" type=\"text\" name=\"betreff\" size=\"25\" maxlength=\"70\" placeholder=\"(".$fmsg[337].")\" value=\"";

											if (isset($_POST['betreff']) AND $_POST['betreff'] != "") {
												echo stripslashes(htmlspecialchars(strip_tags($_POST['betreff']), ENT_QUOTES));
											}

										echo "\" />
								</div>
								<div class=\"break\"></div>";
						}
						else {
							$_POST['betreff'] = "";
							echo "<br />";
						}

						if ($properties['bbcode'] OR $properties['smilies']) {
							echo "
								<div class=\"bbc-space lh-35\">";

									if ($properties['bbcode']){
										echo"
											<a class=\"sprite-bold\" title=\"".$fmsg[185]."\" href=\"javascript:insert('[b]','[/b]');\">&nbsp;</a>
											<a class=\"sprite-italic\" title=\"".$fmsg[186]."\" href=\"javascript:insert('[i]','[/i]');\">&nbsp;</a>
											<a class=\"sprite-underline\" title=\"".$fmsg[187]."\" href=\"javascript:insert('[u]','[/u]');\">&nbsp;</a>
											<a class=\"sprite-shadow\" title=\"".$fmsg[188]."\" href=\"javascript:insert(' [shadow]','[/shadow] ');\">&nbsp;</a>
											<a class=\"sprite-crossed\" title=\"".$fmsg[280]."\" href=\"javascript:insert(' [cross]','[/cross] ');\">&nbsp;</a>
											<a class=\"sprite-justify\" title=\"".$fmsg[281]."\" href=\"javascript:insert(' [justify]',' [/justify] ');\">&nbsp;</a>
											<a class=\"sprite-center\" title=\"".$fmsg[309]."\" href=\"javascript:insert(' [center]',' [/center] ');\">&nbsp;</a>
											<a class=\"sprite-right\" title=\"".$fmsg[282]."\" href=\"javascript:insert(' [right]',' [/right] ');\">&nbsp;</a>
											<a class=\"sprite-sup\" title=\"".$fmsg[283]."\" href=\"javascript:insert('[sup]','[/sup]');\">&nbsp;</a>
											<a class=\"sprite-quote\" title=\"".$fmsg[191]."\" href=\"javascript:insert(' [quote]',' [/quote] ');\">&nbsp;</a>
											<a class=\"sprite-code\" title=\"Code\" href=\"javascript:insert(' [code]',' [/code] ');\">&nbsp;</a>
											<a class=\"sprite-list\" title=\"".$fmsg[284]."\" href=\"javascript:insert(' [list] [-]', ' [/-] [-] [/-] [/list] ');\">&nbsp;</a>
											<a class=\"sprite-numlist\" title=\"".$fmsg[285]."\" href=\"javascript:insert(' [numlist] [-]', ' [/-] [-] [/-] [/numlist] ');\">&nbsp;</a>
											<a class=\"sprite-hr\" title=\"".$fmsg[286]."\" href=\"javascript:insert('[hr]','');\">&nbsp;</a>
											<a class=\"sprite-link\" title=\"".$fmsg[287]."\" href=\"".$url."bbcodes.php\" onclick=\"return PopUp(390,345,this.href);\">&nbsp;</a>
											<a class=\"sprite-email\" title=\"".$fmsg[288]."\" href=\"".$url."bbcodes.php?action=step4\" onclick=\"return PopUp(390,330,this.href)\">&nbsp;</a>";

											if ($properties['images_in_entries']){
												echo"
													<a class=\"sprite-img\" title=\"".$fmsg[310]."\" onclick=\"javascript:NewWindow('".$url."pic.upload.php','upload','510','740','custom','front');return true;\">&nbsp;</a>";
											}

								echo"
									</div>
									<div class=\"margtop-ten\">
										<span class=\"bbc-space lh-35\">
											<select class=\"select\" name=\"Color\" size=\"1\" onchange=\"InsertColorSize(this.form.Color.options[this.form.Color.selectedIndex].value,'[/color] ');this.selectedIndex=0\">
												<option value=\"\">".$fmsg[289]."</option>
												<option value=\" [color=gray]\">".$fmsg[274]."</option>
												<option value=\" [color=red]\">".$fmsg[306]."</option>
												<option value=\" [color=green]\">".$fmsg[307]."</option>
												<option value=\" [color=blue]\">".$fmsg[308]."</option>
												<option value=\" [color=yellow]\">".$fmsg[290]."</option>
												<option value=\" [color=orange]\">".$fmsg[291]."</option>
												<option value=\" [color=lime]\">".$fmsg[292]."</option>
												<option value=\" [color=pink]\">".$fmsg[293]."</option>
												<option value=\" [color=brown]\">".$fmsg[294]."</option>
											</select>&nbsp;
											<select class=\"select\" name=\"Size\" size=\"1\" onchange=\"InsertColorSize(this.form.Size.options[this.form.Size.selectedIndex].value,'[/size] ');this.selectedIndex=0\">
												<option value=\"\">".$fmsg[295]."</option>
												<option value=\" [size=8]\">8px</option>
												<option value=\" [size=10]\">10px</option>
												<option value=\" [size=12]\">12px</option>
												<option value=\" [size=14]\">14px</option>
												<option value=\" [size=16]\">16px</option>
												<option value=\" [size=18]\">18px</option>
												<option value=\" [size=20]\">20px</option>
											</select>
										</span>";
									}

							if ($properties['smilies']){
								$sql_smilies_count = $gbook->query("SELECT `id` FROM `".$table."_smilies`");
								$count_smilies = $sql_smilies_count->num_rows;

								if ($count_smilies > 0 AND $properties['bbcode']){
									echo"<span class=\"vertikal-linie\">||</span>";
								}

								echo"<span class=\"bbc-space lineheight\">";

								($properties['bbcode']) ? ($emojiLimit = $emojis_and_bbcodes) : ($emojiLimit = $only_emojis);
								$sql_smilies = $gbook->query("SELECT `bbcode`, `filename`, `height`, `name`, `width` FROM `".$table."_smilies` ORDER BY `id` ASC LIMIT 0,".$emojiLimit."");

								while ($smilies = $sql_smilies->fetch_assoc()){
									echo"<a href=\"javascript:insert(' ".$smilies['bbcode']." ','');\"><img class=\"smilies\" src=\"".$url."images/smilies/".$smilies['filename']."\" width=\"".$smilies['width']."\" height=\"".$smilies['height']."\" title=\"".$smilies['bbcode']."\" alt=\"".$smilies['name']."\" /></a>
										";
								}

								if ($count_smilies > $emojiLimit){
									echo "<a class=\"sprite-more\" title=\"".$fmsg[15]."\" href=\"javascript:NewWindow('".$url."smilies.php','Smilies','380','750','custom','front');\">&nbsp;</a>";
								}

								echo"<br /></span>
									";
							}

							echo"</div>
								<noscript>".$emsg[55]."</noscript>";
						}

						echo"<br />
							<textarea rows=\"".$rows."\" id=\"text\" name=\"text\" class=\"insert insert-blog".$mark_text."\" cols=\"25\" placeholder=\"(".$fmsg[348].")\">";

								if (isset($_POST['text'])) {
									if ($properties['deactivate_html']) {
										echo stripslashes(htmlspecialchars(strip_tags($_POST['text']), ENT_QUOTES));
									}
									else {
										echo "".$_POST['text']."";
									}
								}

								echo "</textarea>
									<p class=\"marg-five\">&nbsp;</p>";

					echo"
					<table class=\"main-table-02 tb-pad0\">
						<tr>
							<td><span class=\"aligncenter\"><input class=\"button\" type=\"submit\" name=\"send\" value=\"".$fmsg[16]."\" /></span></td>
							<td><span class=\"aligncenter\"><input class=\"button\" type=\"submit\" name=\"preview\" value=\"".$fmsg[179]."\" /></span></td>
							<td><span class=\"aligncenter\"><input class=\"button\" type=\"button\" name=\"abbruch\" value=\"".$fmsg[269]."\" onclick=\"self.location.href='admin.php?action=adminblog&#38;".session_name()."=".session_id()."'\" /></span></td>
						</tr>
					</table>
					<div class=\"break\"><br /></div>
				</td>
			</tr>
		</table>
		</form>
		</div>
		</fieldset>
		</div>";
	}
?>