﻿import datetime
import time
import host
import bf2
from bf2 import g_debug

shutdownTime = "04:00" #use 24-hour time. Format should be "hh:mm"
quitOrPause = "quit" #options are "pause" (pause game but leave server running) or "quit" (kill the server)

shutdownTimer = None
def init():
	global shutdownTime, shutdownTimer
	shutdownHour = int(time.strftime("%H",time.strptime(shutdownTime,"%H:%M")))
	shutdownMinute = int(time.strftime("%M",time.strptime(shutdownTime,"%H:%M")))
	today = datetime.datetime.now()
	shutdownTime = datetime.datetime(today.year, today.month, today.day, shutdownHour, shutdownMinute)
	if shutdownHour < today.hour:
		shutdownTime = datetime.datetime(today.year, today.month, today.day + 1, shutdownHour, shutdownMinute)
	shutdownTimer = bf2.Timer(checktime, 1, 1)
	shutdownTimer.setRecurring(60)
	host.rcon_invoke('echo "autoshutdown.py loaded"')

def checktime(whatever):
	global shutdownTime
	global quitOrPause
	
	timeTilShutdown = shutdownTime - datetime.datetime.now()
	minsTilShutdown = int((timeTilShutdown.seconds / 60))
	host.rcon_invoke('echo "Debug: ' + str(minsTilShutdown) + ' minutes to reboot."')
	msg = None
	if minsTilShutdown == 60:
		msg = 'ADMIN: SERVER REBOOT IN 60 MINUTES'
	if minsTilShutdown == 30:
		msg = 'ADMIN: SERVER REBOOT IN 30 MINUTES'
	if minsTilShutdown == 15:
		msg = 'ADMIN: SERVER REBOOT IN 15 MINUTES'
	if minsTilShutdown == 10:
		msg = 'ADMIN: SERVER REBOOT IN 10 MINUTES'
	if minsTilShutdown == 5:
		msg = 'ADMIN: SERVER REBOOT IN 5 MINUTES'
	if 0 < minsTilShutdown < 5:
		msg = 'ADMIN: SERVER REBOOT IN ' + str(minsTilShutdown) + ' MINUTE(S)'
		
	if msg != None:
		adminMessage(msg)
		
	if minsTilShutdown <= 0:
		msg = 'ADMIN: SERVER WILL REBOOT *NOW*'
		adminMessage(msg)
		timestamp = time.strftime("%Y-%m-%d, %I:%M:%S %p",time.localtime())
		if quitOrPause == "quit": 
			if g_debug: print timestamp + ' -- Server halted.'
			host.rcon_invoke('quit')
		if quitOrPause == "pause": 
			host.rcon_invoke('echo "' + timestamp + ' -- Game paused."')
			if g_debug: print timestamp + ' -- Game paused.'
			host.rcon_invoke('gamelogic.togglepause')

def adminMessage(msg):
	for i in range(1,26):
		host.rcon_invoke('game.sayAll "' + msg + '"')
	host.rcon_invoke('echo "' + msg + '"')
	if g_debug: print msg