<?php

$sqlupgrade = array();

// <Text String>, <DB Version Introduced>, <Query String>

$sqlupgrade[] = array('Create Version Table', '1.4.0',
	"CREATE TABLE `_version` (
		`dbver` varchar(20) NOT NULL default '',
		`dbdate` int(10) unsigned NOT NULL default '0',
		PRIMARY KEY  (`dbver`),
		KEY `dbver` (`dbver`)
	) ENGINE=MyISAM;");

$sqlupgrade[] = array('Clear Version Table', $cfg->get('db_expected_ver'),
	"DELETE FROM `_version`;");
	
$sqlupgrade[] = array('Alter Army Table', '1.3.0',
	"ALTER TABLE  `army`
		ADD COLUMN `time9` int(10) unsigned NOT NULL default '0',
		ADD COLUMN `win9` int(10) unsigned NOT NULL default '0',
		ADD COLUMN `loss9` int(10) unsigned NOT NULL default '0',
		ADD COLUMN `score9` int(10) unsigned NOT NULL default '0',
		ADD COLUMN `best9` int(10) unsigned NOT NULL default '0',
		ADD COLUMN `worst9` int(10) unsigned NOT NULL default '0',
		ADD COLUMN `brnd9` int(10) unsigned NOT NULL default '0';");

$sqlupgrade[] = array('Alter Army Table (POE2 Support)', '1.4.2',
	"ALTER TABLE  `army`
		ADD COLUMN `time10` int(10) unsigned NOT NULL default '0',
		ADD COLUMN `win10` int(10) unsigned NOT NULL default '0',
		ADD COLUMN `loss10` int(10) unsigned NOT NULL default '0',
		ADD COLUMN `score10` int(10) unsigned NOT NULL default '0',
		ADD COLUMN `best10` int(10) unsigned NOT NULL default '0',
		ADD COLUMN `worst10` int(10) unsigned NOT NULL default '0',
		ADD COLUMN `brnd10` int(10) unsigned NOT NULL default '0',
		ADD COLUMN `time11` int(10) unsigned NOT NULL default '0',
		ADD COLUMN `win11` int(10) unsigned NOT NULL default '0',
		ADD COLUMN `loss11` int(10) unsigned NOT NULL default '0',
		ADD COLUMN `score11` int(10) unsigned NOT NULL default '0',
		ADD COLUMN `best11` int(10) unsigned NOT NULL default '0',
		ADD COLUMN `worst11` int(10) unsigned NOT NULL default '0',
		ADD COLUMN `brnd11` int(10) unsigned NOT NULL default '0';");		

$sqlupgrade[] = array('Alter Army Table (AIX Support, Army UN)', '1.4.3',
	"ALTER TABLE  `army`
		ADD COLUMN `time12` int(10) unsigned NOT NULL default '0',
		ADD COLUMN `win12` int(10) unsigned NOT NULL default '0',
		ADD COLUMN `loss12` int(10) unsigned NOT NULL default '0',
		ADD COLUMN `score12` int(10) unsigned NOT NULL default '0',
		ADD COLUMN `best12` int(10) unsigned NOT NULL default '0',
		ADD COLUMN `worst12` int(10) unsigned NOT NULL default '0',
		ADD COLUMN `brnd12` int(10) unsigned NOT NULL default '0';");
		
		
$sqlupgrade[] = array('Alter Army Table (Hard Justice Support, Army CANADIAN )', '1.4.3',
	"ALTER TABLE  `army`
		ADD COLUMN `time13` int(10) unsigned NOT NULL default '0',
		ADD COLUMN `win13` int(10) unsigned NOT NULL default '0',
		ADD COLUMN `loss13` int(10) unsigned NOT NULL default '0',
		ADD COLUMN `score13` int(10) unsigned NOT NULL default '0',
		ADD COLUMN `best13` int(10) unsigned NOT NULL default '0',
		ADD COLUMN `worst13` int(10) unsigned NOT NULL default '0',
		ADD COLUMN `brnd13` int(10) unsigned NOT NULL default '0';");


$sqlupgrade[] = array('Alter Map Info Table', '1.4.0',
	"ALTER TABLE  `mapinfo`
		ADD COLUMN `custom` tinyint(2) unsigned NOT NULL default '0',
		ADD INDEX `idxMapName`(`name`);");
		
$sqlupgrade[] = array('Create Servers Table', '1.3.2',	
	"CREATE TABLE `servers` (
		`id` int(11) unsigned NOT NULL AUTO_INCREMENT,
		`ip` varchar(15) NOT NULL default '',
		`prefix` varchar(30) NOT NULL default '',
		`name` varchar(100) default NULL,
		`port` int(6) unsigned default '0',
		`queryport` int(6) unsigned NOT NULL default '0',
		`lastupdate` datetime NOT NULL default '0000-00-00 00:00:00',
		PRIMARY KEY  (`id`),
		UNIQUE KEY `ip-prefix-unq` (`ip`,`prefix`)
	) ENGINE=MyISAM;");

$sqlupgrade[] = array('Alter Player Table (Add Mode Data)', '1.3.2',
	"ALTER TABLE  `player`
		ADD COLUMN `mode0` int(10) unsigned NOT NULL default '0',
		ADD COLUMN `mode1` int(10) unsigned NOT NULL default '0',
		ADD COLUMN `mode2` int(10) unsigned NOT NULL default '0';");

$sqlupgrade[] = array('Alter Player Table (Add Indexes)', '1.3.4',	
	"ALTER TABLE  `player`
		ADD KEY `ScoreIdx` (`score`),
		ADD KEY `CmdScoreIdx` (`cmdscore`),
		ADD KEY `TeamScoreIdx` (`teamscore`),
		ADD KEY `KillsIdx` (`kills`);");

$sqlupgrade[] = array('Alter Player Table (Clan Manager Support)', '1.4.0',	
	"ALTER TABLE  `player`
		ADD COLUMN `clantag` varchar(20) NOT NULL default '',
		ADD COLUMN `permban` tinyint(1) unsigned NOT NULL default '0';");
				
$sqlupgrade[] = array('Alter Player Table (Award Support)', '1.4.4',	
	"ALTER TABLE  `player_history`
		ADD COLUMN `vkills0` int(10) unsigned NOT NULL default '0' COMMENT 'Vehicle Kills Armor',
		ADD COLUMN `vkills1` int(10) unsigned NOT NULL default '0' COMMENT 'Vehicle Kills Aviator',
		ADD COLUMN `vkills2` int(10) unsigned NOT NULL default '0' COMMENT 'Vehicle Kills Airdefense',
		ADD COLUMN `vkills3` int(10) unsigned NOT NULL default '0' COMMENT 'Vehicle Kills Helicopter',
		ADD COLUMN `vkills4` int(10) unsigned NOT NULL default '0' COMMENT 'Vehicle Kills Transport',
		ADD COLUMN `vkills5` int(10) unsigned NOT NULL default '0' COMMENT 'Vehicle Kills Artillery',
		ADD COLUMN `vkills6` int(10) unsigned NOT NULL default '0' COMMENT 'Vehicle Kills Grunddefense',
		ADD COLUMN `teamdamage` int(10) unsigned NOT NULL default '0' COMMENT 'Team Damage',
		ADD COLUMN `teamvehicledamage` int(10) unsigned NOT NULL default '0' COMMENT 'Team Vehicle Damage',
		ADD COLUMN `cmdscore` int(10) unsigned NOT NULL default '0' COMMENT 'Commander Score',
		ADD COLUMN `cmdtime` int(10) unsigned NOT NULL default '0' COMMENT 'Commander Time'
;");

$sqlupgrade[] = array('Alter Player Table (XPack Award Support)', '1.4.5',	
	"ALTER TABLE  `player_history`
		ADD COLUMN `xkkills0` int(5) unsigned NOT NULL default '0' COMMENT 'Kit Kills XPack AT',
		ADD COLUMN `xkkills1` int(5) unsigned NOT NULL default '0' COMMENT 'Kit Kills XPack Assault',
		ADD COLUMN `xkkills2` int(5) unsigned NOT NULL default '0' COMMENT 'Kit Kills XPack Enginere',
		ADD COLUMN `xkkills3` int(5) unsigned NOT NULL default '0' COMMENT 'Kit Kills XPack Medic',
		ADD COLUMN `xkkills4` int(5) unsigned NOT NULL default '0' COMMENT 'Kit Kills XPack Specops',
		ADD COLUMN `xkkills5` int(5) unsigned NOT NULL default '0' COMMENT 'Kit Kills XPack Support',
		ADD COLUMN `xkkills6` int(5) unsigned NOT NULL default '0' COMMENT 'Kit Kills XPack Sniper'
;");

$sqlupgrade[] = array('Alter Player Table (Basic Award Support)', '1.4.6',
	"ALTER TABLE  `player_history`
		ADD COLUMN `kkills0` int(5) unsigned NOT NULL default '0' COMMENT 'Kit Kills AT',
		ADD COLUMN `kkills1` int(5) unsigned NOT NULL default '0' COMMENT 'Kit Kills Assault',
		ADD COLUMN `kkills2` int(5) unsigned NOT NULL default '0' COMMENT 'Kit Kills Enginere',
		ADD COLUMN `kkills3` int(5) unsigned NOT NULL default '0' COMMENT 'Kit Kills Medic',
		ADD COLUMN `kkills4` int(5) unsigned NOT NULL default '0' COMMENT 'Kit Kills Specops',
		ADD COLUMN `kkills5` int(5) unsigned NOT NULL default '0' COMMENT 'Kit Kills Support',
		ADD COLUMN `kkills6` int(5) unsigned NOT NULL default '0' COMMENT 'Kit Kills Sniper',
		ADD COLUMN `knifekills` int(5) unsigned NOT NULL default '0' COMMENT 'Weapons Kills Knife',
		ADD COLUMN `wkills5` int(5) unsigned NOT NULL default '0' COMMENT 'Weapons Kills Pistols',
		ADD COLUMN `heals` int(5) unsigned NOT NULL default '0' COMMENT 'Heals',
		ADD COLUMN `ammos` int(5) unsigned NOT NULL default '0' COMMENT 'Resupplies',
		ADD COLUMN `vtime0` int(10) unsigned NOT NULL default '0' COMMENT 'Time using Armor',
		ADD COLUMN `vtime1` int(10) unsigned NOT NULL default '0' COMMENT 'Time using Aviator',
		ADD COLUMN `vtime2` int(10) unsigned NOT NULL default '0' COMMENT 'Time using Air Defense',
		ADD COLUMN `vtime3` int(10) unsigned NOT NULL default '0' COMMENT 'Time using Helicopter',
		ADD COLUMN `vtime4` int(10) unsigned NOT NULL default '0' COMMENT 'Time using Transport',
		ADD COLUMN `vtime6` int(10) unsigned NOT NULL default '0' COMMENT 'Time using Ground Defense',
		ADD COLUMN `rk4` int(5) unsigned NOT NULL default '0' COMMENT 'Roadkills using Transport',
		ADD COLUMN `driverspecials` int(5) unsigned NOT NULL default '0' COMMENT 'Driverspecials Points',
		ADD COLUMN `driverassists` int(5) unsigned NOT NULL default '0' COMMENT 'Driverassists Points',
		ADD COLUMN `explosives` int(5) unsigned NOT NULL default '0' COMMENT 'Explosives',
		ADD COLUMN `repairs` int(5) unsigned NOT NULL default '0' COMMENT 'Repairs',
		ADD COLUMN `ktime2` int(10) unsigned NOT NULL default '0' COMMENT 'Kit Time Enginere',
		ADD COLUMN `sqltime` int(10) unsigned NOT NULL default '0' COMMENT 'Time as Squad Leader',
		ADD COLUMN `sqmtime` int(10) unsigned NOT NULL default '0' COMMENT 'Time as Squad Member',
		ADD COLUMN `sqtime` int(10) unsigned NOT NULL default '0' COMMENT 'Time in Squad',
		ADD COLUMN `timepara` int(10) unsigned NOT NULL default '0' COMMENT 'Time in Parachute',
		ADD COLUMN `killstreak` int(5) unsigned NOT NULL default '0' COMMENT 'Longest Kill Streak',
		ADD COLUMN `deathstreak` int(5) unsigned NOT NULL default '0' COMMENT 'Longest Death Streak'
;");

$sqlupgrade[] = array('Create Player History Table', '1.3.4',
	"CREATE TABLE  `player_history` (
		`id` int(8) unsigned NOT NULL default '0',
		`timestamp` int(10) unsigned NOT NULL default '0',
		`time` int(10) unsigned NOT NULL default '0',
		`score` int(10) unsigned NOT NULL default '0',
		`cmdscore` int(10) unsigned NOT NULL default '0',
		`skillscore` int(10) unsigned NOT NULL default '0',
		`teamscore` int(10) unsigned NOT NULL default '0',
		`kills` int(10) unsigned NOT NULL default '0',
		`deaths` int(10) unsigned NOT NULL default '0',
		`rank` tinyint(2) unsigned NOT NULL default '0',
	  PRIMARY KEY  (`id`, `timestamp`),
	  KEY (`score`)
	) ENGINE=MyISAM;");
	
$sqlupgrade[] = array('Create Round History Table', '1.4.0',
	"CREATE TABLE `round_history` (
		`id` SERIAL,
		`timestamp` int(10) unsigned NOT NULL default '0',
		`mapid` int(8) unsigned NOT NULL default '0',
		`time` int(10) unsigned NOT NULL default '0',
		`team1` tinyint(2) unsigned NOT NULL default '0',
		`team2` tinyint(2) unsigned NOT NULL default '0',
		`tickets1` int(10) unsigned NOT NULL default '0',
		`tickets2` int(10) unsigned NOT NULL default '0',
		`pids1` int(10) unsigned NOT NULL default '0',
		`pids1_end` int(10) unsigned NOT NULL default '0',
		`pids2` int(10) unsigned NOT NULL default '0',
		`pids2_end` int(10) unsigned NOT NULL default '0',
		PRIMARY KEY  (`id`),
		KEY `timestamp` (`timestamp`),
		KEY `mapid` (`mapid`)
	) ENGINE=MyISAM;");
	
$sqlupgrade[] = array('Create Virtual Player Table', '1.4.3',	
	"CREATE TABLE `v_player` (
	`id` int(8) unsigned NOT NULL default '0',
	`name` varchar(45) NOT NULL default '',
	PRIMARY KEY  (`id`)
) ENGINE=MyISAM;");
	
$sqlupgrade[] = array('Update Version Table', $cfg->get('db_expected_ver'),
	"INSERT INTO `_version` VALUES ('".$cfg->get('db_expected_ver')."', ".time().");");

?>