<?php

/*
	Copyright (C) 2006  BF2Statistics

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

/*******************************************
* 14/08/06 v0.0.1 - Initial build          *
*******************************************/

/*******************************************
* 12.4.2013 Leon_tbk
* Fehlende Award's eingefügt.
* - Medal of Valour
* - Meritorious Service Medal
*******************************************/

/*******************************************
* 25.4.2013 Leon_tbk
* Basic Award's eingefügt.
*******************************************/


// Where clause Substitution String
$awards_substr = "###";

function buildAwardsData($mod) {

	$awardsdata = array();
	
	// Data: array(<short name>, <0 = badges, 1 = Other>)
	
	#Badges
	$awardsdata[] = array(1031406, "kcb", 0);
	$awardsdata[] = array(1031619, "pcb", 0);
	$awardsdata[] = array(1031119, "Acb", 0);
	$awardsdata[] = array(1031120, "Atcb", 0);
	$awardsdata[] = array(1031109, "Sncb", 0);
	$awardsdata[] = array(1031115, "Socb", 0);
	$awardsdata[] = array(1031121, "Sucb", 0);
	$awardsdata[] = array(1031105, "Ecb", 0);
	$awardsdata[] = array(1031113, "Mcb", 0);
	$awardsdata[] = array(1032415, "Eob", 0);
	$awardsdata[] = array(1190601, "Fab", 0);
	$awardsdata[] = array(1190507, "Eb", 0);
	$awardsdata[] = array(1191819, "Rb", 0);
	$awardsdata[] = array(1190304, "Cb", 0);
	$awardsdata[] = array(1220118, "Ab", 0);
	$awardsdata[] = array(1222016, "Tb", 0);
	$awardsdata[] = array(1220803, "Hb", 0);
	$awardsdata[] = array(1220122, "Avb", 0);
	$awardsdata[] = array(1220104, "adb", 0);
	$awardsdata[] = array(1031923, "Swb", 0);
	
	#Ribbons
	$awardsdata[] = array(3240301, "Car", 1);
	$awardsdata[] = array(3211305, "Mur", 1);
	$awardsdata[] = array(3150914, "Ior", 1);
	$awardsdata[] = array(3151920, "Sor", 1);
	$awardsdata[] = array(3190409, "Dsr", 1);
	$awardsdata[] = array(3242303, "Wcr", 1);
	$awardsdata[] = array(3212201, "Vur", 1);
	$awardsdata[] = array(3241213, "Lmr", 1);
	$awardsdata[] = array(3190318, "Csr", 1);
	$awardsdata[] = array(3190118, "Arr", 1);
	$awardsdata[] = array(3190105, "Aer", 1);
	$awardsdata[] = array(3190803, "Hsr", 1);
	$awardsdata[] = array(3040109, "Adr", 1);
	$awardsdata[] = array(3040718, "Gdr", 1);
	$awardsdata[] = array(3240102, "Ar", 1);
	$awardsdata[] = array(3240703, "gcr", 1);
	$awardsdata[] = array(3191305, "Msr", 1);
	$awardsdata[] = array(3190605, "Fsr", 1);
	
	// EF ribbon added by Wolverine
	$awardsdata[] = array(3270519, "Esr", 1);
	// AF ribbon added by Wolverine
	$awardsdata[] = array(3271401, "Nas", 1);
	
	#medals
	$awardsdata[] = array(2051907, "erg", 1);
	$awardsdata[] = array(2051919, "ers", 1);
	$awardsdata[] = array(2051902, "erb", 1);
	$awardsdata[] = array(2191608, "ph", 1);
	$awardsdata[] = array(2191319, "Msm", 1);
	$awardsdata[] = array(2190303, "Cam", 1);
	$awardsdata[] = array(2190309, "Acm", 1);
	$awardsdata[] = array(2190318, "Arm", 1);
	$awardsdata[] = array(2190308, "Hcm", 1);
	$awardsdata[] = array(2190703, "gcm", 1);
	$awardsdata[] = array(2020903, "Cim", 1);
	$awardsdata[] = array(2020913, "Mim", 1);
	$awardsdata[] = array(2020919, "Sim", 1);
	$awardsdata[] = array(2021322, "Mvm", 1);
	$awardsdata[] = array(2020419, "Dsm", 1);
	$awardsdata[] = array(2021403, "Ncm", 1);
	$awardsdata[] = array(2020719, "Gsm", 1);
	$awardsdata[] = array(2021613, "pmm", 1);
	
	// EF medal added by Wolverine
	$awardsdata[] = array(2270521, "Eum", 1);
	
	// SF
	if ($mod == 'xpack')
	{
		#badges
		$awardsdata[] = array(1261119, "X1Acb", 0);
		$awardsdata[] = array(1261120, "X1Atcb", 0);
		$awardsdata[] = array(1261109, "X1Sncb", 0);
		$awardsdata[] = array(1261115, "X1Socb", 0);
		$awardsdata[] = array(1261121, "X1Sucb", 0);
		$awardsdata[] = array(1261105, "X1Ecb", 0);
		$awardsdata[] = array(1261113, "X1Mcb", 0);
		$awardsdata[] = array(1260602, "X1fbb", 0);
		$awardsdata[] = array(1260708, "X1ghb", 0);
		$awardsdata[] = array(1262612, "X1zlb", 0);
		
		#ribbons
		$awardsdata[] = array(3261919, "X1Nss", 1);
		$awardsdata[] = array(3261901, "X1Sas", 1);
		$awardsdata[] = array(3261819, "X1Rsz", 1);
		$awardsdata[] = array(3261319, "X1Msf", 1);
		$awardsdata[] = array(3261805, "X1Reb", 1);
		$awardsdata[] = array(3260914, "X1Ins", 1);
		$awardsdata[] = array(3260318, "X1Csr", 1);
		$awardsdata[] = array(3260118, "X1Arr", 1);
		$awardsdata[] = array(3260105, "X1Aer", 1);
		$awardsdata[] = array(3260803, "X1Hsr", 1);
		
		#medals
		$awardsdata[] = array(2261913, "X1Nsm", 1);
		$awardsdata[] = array(2261919, "X1Ssm", 1);
		$awardsdata[] = array(2261613, "X1Spm", 1);
		$awardsdata[] = array(2261303, "X1Mcm", 1);
		$awardsdata[] = array(2261802, "X1Rbm", 1);
		$awardsdata[] = array(2260914, "X1Inm", 1);
	}
	
	return $awardsdata;
}


function buildBackendAwardsData($mod) {
	
	// Build Awards Data Array
	$awardsdata = array();
	
	// Criteria data:
	//	array(<table>, <field>, <expected result>, <where clause>)
	
// Knife Combat Badge
	//Basic
	$awardsdata[] = array(1031406, "kcb", 0,
						array(
							array('player_history', 'count(*)', 1, '`knifekills` >= 7')
						), 1
					);
	
	//Veteran
	$awardsdata[] = array(1031406, "kcb", 0,
						array(
							array('weapons', 'count(*)', 1, '`knifekills` >= 50'),
							array('awards', 'count(*)', 1, '`awd` = 1031406 AND `level` = 1')
						), 2
					);

	//Expert
	$awardsdata[] = array(1031406, "kcb", 0,
						array(
							array('weapons', 'count(*)', 1, '`knifekills` >= 100'),
							array('awards', 'count(*)', 1, '`awd` = 1031406 AND `level` = 2')
						), 3
					);
	
// Pistol Combat Badge
	//Basic
	$awardsdata[] = array(1031619, "pcb", 0,
						array(
							array('player_history', 'count(*)', 1, '`wkills5` >= 5')
						), 1
					);
	
	//Veteran
	$awardsdata[] = array(1031619, "pcb", 0,
						array(
							array('player_history', 'count(*)', 1, '`wkills5` >= 7'),
							array('weapons', 'count(*)', 1, '`kills5` >= 50'),
							array('awards', 'count(*)', 1, '`awd` = 1031619 AND `level` = 1')
						), 2
					);
	
	//Expert
	$awardsdata[] = array(1031619, "pcb", 0,
						array(
							array('player_history', 'count(*)', 1, '`wkills5` >= 18'),
							array('weapons', 'count(*)', 1, '`kills5` >= 500'),
							array('awards', 'count(*)', 1, '`awd` = 1031619 AND `level` = 2')
						), 3
					);

// Assault Combat Badge
	//Basic
	$awardsdata[] = array(1031119, "Acb", 0,
						array(
							array('player_history', 'count(*)', 1, '`kkills1` >= 5')
						), 1
					);
	
	//Veteran
	$awardsdata[] = array(1031119, "Acb", 0,
						array(
							array('player_history', 'count(*)', 1, '`kkills1` >= 20'),
							array('kits', 'count(*)', 1, '`time1` >= 54000'),
							array('awards', 'count(*)', 1, '`awd` = 1031119 AND `level` = 1')
						), 2
					);
	
	//Expert
	$awardsdata[] = array(1031119, "Acb", 0,
						array(
							array('player_history', 'count(*)', 1, '`kkills1` >= 40'),
							array('kits', 'count(*)', 1, '`time1` >= 360000'),
							array('awards', 'count(*)', 1, '`awd` = 1031119 AND `level` = 2')
						), 3
					);

// Anti-Tank Combat Badge
	//Basic
	$awardsdata[] = array(1031120, "Atcb", 0,
						array(
							array('player_history', 'count(*)', 1, '`kkills0` >= 10')
						), 1
					);
	//Veteran
	$awardsdata[] = array(1031120, "Atcb", 0,
						array(
							array('player_history', 'count(*)', 1, '`kkills0` >= 20'),
							array('kits', 'count(*)', 1, '`time0` >= 54000'),
							array('awards', 'count(*)', 1, '`awd` = 1031120 AND `level` = 1')
						), 2
					);
	
	//Expert
	$awardsdata[] = array(1031120, "Atcb", 0,
						array(
							array('player_history', 'count(*)', 1, '`kkills0` >= 40'),
							array('kits', 'count(*)', 1, '`time0` >= 360000'),
							array('awards', 'count(*)', 1, '`awd` = 1031120 AND `level` = 2')
						), 3
					);

// Sniper Combat Badge
	//Basic
	$awardsdata[] = array(1031109, "Sncb", 0,
						array(
							array('player_history', 'count(*)', 1, '`kkills6` >= 10')
						), 1
					);
	
	//Veteran
	$awardsdata[] = array(1031109, "Sncb", 0,
						array(
							array('player_history', 'count(*)', 1, '`kkills6` >= 15'),
							array('kits', 'count(*)', 1, '`time6` >= 54000'),
							array('awards', 'count(*)', 1, '`awd` = 1031109 AND `level` = 1')
						), 2
					);
	
	//Expert
	$awardsdata[] = array(1031109, "Sncb", 0,
						array(
							array('player_history', 'count(*)', 1, '`kkills6` >= 35'),
							array('kits', 'count(*)', 1, '`time6` >= 360000'),
							array('awards', 'count(*)', 1, '`awd` = 1031109 AND `level` = 2')
						), 3
					);

// Spec Ops Combat Badge
	//Basic
	$awardsdata[] = array(1031115, "Socb", 0,
						array(
							array('player_history', 'count(*)', 1, '`kkills4` >= 5')
						), 1
					);
	
	//Veteran
	$awardsdata[] = array(1031115, "Socb", 0,
						array(
							array('player_history', 'count(*)', 1, '`kkills4` >= 20'),
							array('kits', 'count(*)', 1, '`time4` >= 54000'),
							array('awards', 'count(*)', 1, '`awd` = 1031115 AND `level` = 1')
						), 2
					);
	
	//Expert
	$awardsdata[] = array(1031115, "Socb", 0,
						array(
							array('player_history', 'count(*)', 1, '`kkills4` >= 40'),
							array('kits', 'count(*)', 1, '`time4` >= 360000'),
							array('awards', 'count(*)', 1, '`awd` = 1031115 AND `level` = 2')
						), 3
					);

// Support Combat Badge
	//Basic
	$awardsdata[] = array(1031121, "Sucb", 0,
						array(
							array('player_history', 'count(*)', 1, '`kkills5` >= 10')
						), 1
					);
	
	//Veteran
	$awardsdata[] = array(1031121, "Sucb", 0,
						array(
							array('player_history', 'count(*)', 1, '`kkills5` >= 20'),
							array('kits', 'count(*)', 1, '`time5` >= 54000'),
							array('awards', 'count(*)', 1, '`awd` = 1031121 AND `level` = 1')
						), 2
					);
	
	//Expert
	$awardsdata[] = array(1031121, "Sucb", 0,
						array(
							array('player_history', 'count(*)', 1, '`kkills5` >= 40'),
							array('kits', 'count(*)', 1, '`time5` >= 360000'),
							array('awards', 'count(*)', 1, '`awd` = 1031121 AND `level` = 2')
						), 3
					);

// Engineer Combat Badge
	//Basic
	$awardsdata[] = array(1031121, "Sucb", 0,
						array(
							array('player_history', 'count(*)', 1, '`kkills2` >= 10')
						), 1
					);
	
	//Veteran
	$awardsdata[] = array(1031105, "Ecb", 0,
						array(
							array('player_history', 'count(*)', 1, '`kkills2` >= 20'),
							array('kits', 'count(*)', 1, '`time2` >= 54000'),
							array('awards', 'count(*)', 1, '`awd` = 1031105 AND `level` = 1')
						), 2
					);
	
	//Expert
	$awardsdata[] = array(1031105, "Ecb", 0,
						array(
							array('player_history', 'count(*)', 1, '`kkills2` >= 40'),
							array('kits', 'count(*)', 1, '`time2` >= 360000'),
							array('awards', 'count(*)', 1, '`awd` = 1031105 AND `level` = 2')
						), 3
					);

// Medic Combat Badge
	//Basic
	$awardsdata[] = array(1031113, "Mcb", 0,
						array(
							array('player_history', 'count(*)', 1, '`kkills3` >= 10')
						), 1
					);
	
	//Veteran
	$awardsdata[] = array(1031113, "Mcb", 0,
						array(
							array('player_history', 'count(*)', 1, '`kkills3` >= 20'),
							array('kits', 'count(*)', 1, '`time3` >= 54000'),
							array('awards', 'count(*)', 1, '`awd` = 1031113 AND `level` = 1')
						), 2
					);
	
	//Expert
	$awardsdata[] = array(1031113, "Mcb", 0,
						array(
							array('player_history', 'count(*)', 1, '`kkills3` >= 40'),
							array('kits', 'count(*)', 1, '`time3` >= 360000'),
							array('awards', 'count(*)', 1, '`awd` = 1031113 AND `level` = 2')
						), 3
					);

// Explosive Ordinance Badge
	//Basic
	$awardsdata[] = array(1032415, "Eob", 0,
						array(
							array('player_history', 'count(*)', 1, '`explosives` >= 5')
						), 1
					);
	
	//Veteran
	$awardsdata[] = array(1032415, "Eob", 0,
						array(
							array('weapons', 'count(*)', 1, '(`claymorekills` + `atminekills` + `c4kills`) >= 50'),
							array('player_history', 'count(*)', 1, '`explosives` >= 20'),
							array('awards', 'count(*)', 1, '`awd` = 1032415 AND `level` = 1')
						), 2
					);
	
	//Expert
	$awardsdata[] = array(1032415, "Eob", 0,
						array(
							array('weapons', 'count(*)', 1, '(`claymorekills` + `atminekills` + `c4kills`) >= 300'),
							array('player_history', 'count(*)', 1, '`explosives` >= 30'),
							array('awards', 'count(*)', 1, '`awd` = 1032415 AND `level` = 2')
						), 3
					);

// First Aid Badge
	//Basic
	$awardsdata[] = array(1190601, "Fab", 0,
						array(
							array('player_history', 'count(*)', 1, '`heals` >= 5')
						), 1
					);
	
	//Veteran
	$awardsdata[] = array(1190601, "Fab", 0,
						array(
							array('kits', 'count(*)', 1, '`time3` >= 54000'),
							array('player_history', 'count(*)', 1, '`heals` >= 10'),
							array('awards', 'count(*)', 1, '`awd` = 1190601 AND `level` = 1')
						), 2
					);
	
	//Expert
	$awardsdata[] = array(1190601, "Fab", 0,
						array(
							array('player', 'count(*)', 1, '`heals` >= 750'),
							array('kits', 'count(*)', 1, '`time3` >= 360000'),
							array('player_history', 'count(*)', 1, '`heals` >= 20'),
							array('awards', 'count(*)', 1, '`awd` = 1190601 AND `level` = 2')
						), 3
					);
					
// Engineer Badge
	//Basic
	$awardsdata[] = array(1190507, "Eb", 0,
						array(
							array('player_history', 'count(*)', 1, '`repairs` >= 5')
						), 1
					);
	
	//Veteran
	$awardsdata[] = array(1190507, "Eb", 0,
						array(
							array('kits', 'count(*)', 1, '`time2` >= 54000'),
							array('player_history', 'count(*)', 1, '`repairs` >= 10'),
							array('awards', 'count(*)', 1, '`awd` = 1190507 AND `level` = 1')
						), 2
					);
	
	//Expert
	$awardsdata[] = array(1190507, "Eb", 0,
						array(
							array('player', 'count(*)', 1, '`repairs` >= 250'),
							array('kits', 'count(*)', 1, '`time2` >= 360000'),
							array('player_history', 'count(*)', 1, '`repairs` >= 20'),
							array('awards', 'count(*)', 1, '`awd` = 1190507 AND `level` = 2')
						), 3
					);

// Resupply Badge
	//Basic
	$awardsdata[] = array(1191819, "Rb", 0,
						array(
							array('player_history', 'count(*)', 1, '`ammos` >= 5')
						), 1
					);
	
	//Veteran
	$awardsdata[] = array(1191819, "Rb", 0,
						array(
							array('kits', 'count(*)', 1, '`time5` >= 54000'),
							array('player_history', 'count(*)', 1, '`ammos` >= 10'),
							array('awards', 'count(*)', 1, '`awd` = 1191819 AND `level` = 1')
						), 2
					);
	
	//Expert
	$awardsdata[] = array(1191819, "Rb", 0,
						array(
							array('player', 'count(*)', 1, '`ammos` >= 500'),
							array('kits', 'count(*)', 1, '`time5` >= 360000'),
							array('player_history', 'count(*)', 1, '`ammos` >= 20'),
							array('awards', 'count(*)', 1, '`awd` = 1191819 AND `level` = 2')
						), 3
					);
					
// Command Badge
	//Basic
	$awardsdata[] = array(1190304, "Cb", 0,
						array(
							array('player_history', 'count(*)', 1, '`cmdtime` >= 40')
						), 1
					);
	
	//Veteran
	$awardsdata[] = array(1190304, "Cb", 0,
						array(
							array('player', 'count(*)', 1, '`cmdscore` >= 1000'),
							array('player_history', 'count(*)', 1, '`cmdtime` >= 1500'),
							array('awards', 'count(*)', 1, '`awd` = 1190304 AND `level` = 1')
						), 2
					);
	
	//Expert
	$awardsdata[] = array(1190304, "Cb", 0,
						array(
							array('player', 'count(*)', 1, '`cmdscore` >= 10000'),
							array('player_history', 'count(*)', 1, '`cmdtime` >= 1800'),
							array('awards', 'count(*)', 1, '`awd` = 1190304 AND `level` = 2')
						), 3
					);

// Armour Badge
	//Basic
	$awardsdata[] = array(1220118, "Ab", 0,
						array(
							array('player_history', 'count(*)', 1, '`vtime0` >= 600')
						), 1
					);
	
	//Veteran
	$awardsdata[] = array(1220118, "Ab", 0,
						array(
							array('vehicles', 'count(*)', 1, '`time0` >= 360000'),
							array('player_history', 'count(*)', 1, '`vkills0` >= 12'),
							array('awards', 'count(*)', 1, '`awd` = 1220118 AND `level` = 1')
						), 2
					);
	
	//Expert
	$awardsdata[] = array(1220118, "Ab", 0,
						array(
							array('vehicles', 'count(*)', 1, '`time0` >= 1440000'),
							array('player_history', 'count(*)', 1, '`vkills0` >= 24'),
							array('awards', 'count(*)', 1, '`awd` = 1220118 AND `level` = 2')
						), 3
					);

// Transport Badge
	//Basic
	$awardsdata[] = array(1222016, "Tb", 0,
						array(
							array('player_history', 'count(*)', 1, '`vtime4` >= 600')
						), 1
					);
	
	//Veteran
	$awardsdata[] = array(1222016, "Tb", 0,
						array(
							array('vehicles', 'count(*)', 1, '`time4` >= 90000'),
							array('player_history', 'count(*)', 1, '`driverspecials` >= 200'),
							array('player_history', 'count(*)', 1, '`rk4` >= 5'),
							array('awards', 'count(*)', 1, '`awd` = 1222016 AND `level` = 1')
						), 2
					);
	
	//Expert
	$awardsdata[] = array(1222016, "Tb", 0,
						array(
							array('vehicles', 'count(*)', 1, '`time4` >= 270000'),
							array('player_history', 'count(*)', 1, '`driverspecials` >= 2000'),
							array('player_history', 'count(*)', 1, '`rk4` >= 11'),
							array('awards', 'count(*)', 1, '`awd` = 1222016 AND `level` = 2')
						), 3
					);
					
// Helicopter Badge
	//Basic
	$awardsdata[] = array(1220803, "Hb", 0,
						array(
							array('player_history', 'count(*)', 1, '`vtime3` >= 900')
						), 1
					);
	
	//Veteran
	$awardsdata[] = array(1220803, "Hb", 0,
						array(
							array('vehicles', 'count(*)', 1, '`time3` >= 180000'),
							array('player_history', 'count(*)', 1, '`vkills3` >= 12'),
							array('awards', 'count(*)', 1, '`awd` = 1220803 AND `level` = 1')
						), 2
					);
	
	//Expert
	$awardsdata[] = array(1220803, "Hb", 0,
						array(
							array('vehicles', 'count(*)', 1, '`time3` >= 540000'),
							array('player_history', 'count(*)', 1, '`vkills3` >= 24'),
							array('awards', 'count(*)', 1, '`awd` = 1220803 AND `level` = 2')
						), 3
					);
					
// Aviator Badge
	//Basic
	$awardsdata[] = array(1220122, "Avb", 0,
						array(
							array('player_history', 'count(*)', 1, '`vtime1` >= 600')
						), 1
					);
	
	//Veteran
	$awardsdata[] = array(1220122, "Avb", 0,
						array(
							array('vehicles', 'count(*)', 1, '`time1` >= 180000'),
							array('player_history', 'count(*)', 1, '`vkills1` >= 12'),
							array('awards', 'count(*)', 1, '`awd` = 1220122 AND `level` = 1')
						), 2
					);
	
	//Expert
	$awardsdata[] = array(1220122, "Avb", 0,
						array(
							array('vehicles', 'count(*)', 1, '`time1` >= 540000'),
							array('player_history', 'count(*)', 1, '`vkills1` >= 24'),
							array('awards', 'count(*)', 1, '`awd` = 1220122 AND `level` = 2')
						), 3
					);

// Air Defence Badge
	//Basic
	$awardsdata[] = array(1220104, "adb", 0,
						array(
							array('player_history', 'count(*)', 1, '`vtime2` >= 600')
						), 1
					);
	
	//Veteran
	$awardsdata[] = array(1220104, "adb", 0,
						array(
							array('player_history', 'count(*)', 1, '`vkills2` >= 10'),
							array('awards', 'count(*)', 1, '`awd` = 1220104 AND `level` = 1')
						), 2
					);
	
	//Expert
	$awardsdata[] = array(1220104, "adb", 0,
						array(
							array('player_history', 'count(*)', 1, '`vkills2` >= 20'),
							array('awards', 'count(*)', 1, '`awd` = 1220104 AND `level` = 2')
						), 3
					);

// Ground Defence Badge
	//Basic
	$awardsdata[] = array(1031923, "Swb", 0,
						array(
							array('player_history', 'count(*)', 1, '`vtime6` >= 300')
						), 1
					);
	
	//Veteran
	$awardsdata[] = array(1031923, "Swb", 0,
						array(
							array('player_history', 'count(*)', 1, '`vkills6` >= 10'),
							array('awards', 'count(*)', 1, '`awd` = 1031923 AND `level` = 1')
						), 2
					);
	
	//Expert
	$awardsdata[] = array(1031923, "Swb", 0,
						array(
							array('player_history', 'count(*)', 1, '`vkills6` >= 20'),
							array('awards', 'count(*)', 1, '`awd` = 1031923 AND `level` = 2')
						), 3
					);
			
	#Helicopter Combat Medal
	$awardsdata[] = array(2190308, "Hcm", 2,
						array(
							array('vehicles', 'count(*)', 1, '`time3` >= 360000'),
							array('vehicles', 'count(*)', 1, '`kills3` >= 5000'),
							array('player_history', 'count(*)', 1, '`vkills3` >= 30')
						)
					);
	
	//Crew Service Ribbon
	$awardsdata[] = array(3240301, "Car", 1,
						array(
							array('player_history', 'count(*)', 1, '`kills` >= 5'),
							array('player_history', 'count(*)', 1, '(`driverspecials` + `driverassists`) >= 13')
						)
					);
	
	#Staff Officer Ribbon
	$awardsdata[] = array(3151920, "Sor", 1,
						array(
							array('player', 'count(*)', 1, '`cmdscore` >= 1680'),
							array('player_history', 'count(*)', 1, '`cmdtime` >= 50')
						)
					);
	
	#Combat Action Medal
	$awardsdata[] = array(2190303, "Cam", 2,
						array(
							array('player', 'count(*)', 1, '`time` >= 900000'),
							array('player', 'count(*)', 1, '`kills` >= 25000'),
							array('player', 'count(*)', 1, '`killstreak` >= 25'),
							array('player_history', 'count(*)', 1, '`time` >= 1980')
						)
					);
	
	#Legion of Merit Ribbon
	$awardsdata[] = array(3241213, "Lmr", 1,
						array(
							array('player', 'count(*)', 1, '`time` >= 720000'),
							array('player', 'count(*)', 1, '`killstreak` >= 10'),
							array('player', 'count(*)', 1, '`deathstreak` >= 8'),
							array('player_history', 'count(*)', 1, '`teamscore` >= 50')
						)
					);
	
	#Distinguished Service Ribbon
	$awardsdata[] = array(3190409, "DSR", 1,
						array(
							array('player', 'count(*)', 1, '`sqmtime` >= 36000'),
							array('player', 'count(*)', 1, '`sqltime` >= 36000'),
							array('player', 'count(*)', 1, '`cmdtime` >= 36000'),
							array('player_history', 'count(*)', 1, '`teamscore` >= 15')
						)
					);
	
	#Combat Infantry Medal
	$awardsdata[] = array(2020903, "Cim", 1,
						array(
							array('player', 'count(*)', 1, '`time` > 720000'),
							array('awards', 'count(*)', 1, '`awd` = 1031406 AND `level` = 1'),
							array('awards', 'count(*)', 1, '`awd` = 1031619 AND `level` = 1'),
							array('awards', 'count(*)', 1, '`awd` = 1031119 AND `level` = 1'),
							array('awards', 'count(*)', 1, '`awd` = 1031120 AND `level` = 1'),
							array('awards', 'count(*)', 1, '`awd` = 1031109 AND `level` = 1'),
							array('awards', 'count(*)', 1, '`awd` = 1031115 AND `level` = 1'),
							array('awards', 'count(*)', 1, '`awd` = 1031121 AND `level` = 1'),
							array('awards', 'count(*)', 1, '`awd` = 1031105 AND `level` = 1'),
							array('awards', 'count(*)', 1, '`awd` = 1031113 AND `level` = 1')
						)
					);
	
	#Marksman Infantry Medal
	$awardsdata[] = array(2020913, "Mim", 1,
						array(
							array('player', 'count(*)', 1, '`time` > 1080000'),
							array('awards', 'count(*)', 1, '`awd` = 2020903'),
							array('awards', 'count(*)', 1, '`awd` = 1031406 AND `level` = 2'),
							array('awards', 'count(*)', 1, '`awd` = 1031619 AND `level` = 2'),
							array('awards', 'count(*)', 1, '`awd` = 1031119 AND `level` = 2'),
							array('awards', 'count(*)', 1, '`awd` = 1031120 AND `level` = 2'),
							array('awards', 'count(*)', 1, '`awd` = 1031109 AND `level` = 2'),
							array('awards', 'count(*)', 1, '`awd` = 1031115 AND `level` = 2'),
							array('awards', 'count(*)', 1, '`awd` = 1031121 AND `level` = 2'),
							array('awards', 'count(*)', 1, '`awd` = 1031105 AND `level` = 2'),
							array('awards', 'count(*)', 1, '`awd` = 1031113 AND `level` = 2')
						)
					);
	
	#Sharpshooter Infantry Medal
	$awardsdata[] = array(2020919, "Sim", 1,
						array(
							array('player', 'count(*)', 1, '`time` > 1440000'),
							array('awards', 'count(*)', 1, '`awd` = 2020913'),
							array('awards', 'count(*)', 1, '`awd` = 1031406 AND `level` = 3'),
							array('awards', 'count(*)', 1, '`awd` = 1031619 AND `level` = 3'),
							array('awards', 'count(*)', 1, '`awd` = 1031119 AND `level` = 3'),
							array('awards', 'count(*)', 1, '`awd` = 1031120 AND `level` = 3'),
							array('awards', 'count(*)', 1, '`awd` = 1031109 AND `level` = 3'),
							array('awards', 'count(*)', 1, '`awd` = 1031115 AND `level` = 3'),
							array('awards', 'count(*)', 1, '`awd` = 1031121 AND `level` = 3'),
							array('awards', 'count(*)', 1, '`awd` = 1031105 AND `level` = 3'),
							array('awards', 'count(*)', 1, '`awd` = 1031113 AND `level` = 3')
						)
					);
					
	#Medal of Valour
	$awardsdata[] = array(2021322, "Mvm", 1,
						array(
							array('player', 'count(*)', 1, '`time` >= 900000'),
							array('player', 'count(*)', 1, '`driverspecials` >= 5000'),
							array('player', 'count(*)', 1, '`defends` >= 1000'),
							array('player', 'count(*)', 1, '`teamscore` >= 3000')
						)
					);
					
	#Meritorious Service Medal
	$awardsdata[] = array(2191319, "Msm", 1,
						array(
							array('player', 'count(*)', 1, '`time` >= 900000'),
							array('player', 'count(*)', 1, '`heals` >= 1000'),
							array('player', 'count(*)', 1, '`repairs` >= 1000'),
							array('player', 'count(*)', 1, '`ammos` >= 1000')
						)
					);
					
	
	#Mid-East Service
	$awardsdata[] = array(3191305, "Msr", 1,
						array(
							array('maps', 'count(*)', 7, 'mapid IN (0,1,2,3,4,5,6) AND `time` >= 1')
						)
					);
	
	#Far-East Service
	$awardsdata[] = array(3190605, "Fsr", 1,
						array(
							array('maps', 'count(*)', 6, 'mapid IN (100,101,102,103,105,601) AND `time` >= 1')
						)
					);
	
	#Navy Cross
	$awardsdata[] = array(2021403, "Ncm", 2,
						array(
							array('army', 'count(*)', 1, 'time0 >= 360000*### AND best0 >= 100*### AND win0 >= 100*###')
						)
					);
	
	#Golden Scimitar
	$awardsdata[] = array(2020719, "Gsm", 2,
						array(
							array('army', 'count(*)', 1, 'time1 >= 360000*### AND best1 >= 100*### AND win1 >= 100*###')
						)
					);
	
	#People's Medallion
	$awardsdata[] = array(2021613, "pmm", 2,
						array(
							array('army', 'count(*)', 1, 'time2 >= 360000*### AND best2 >= 100*### AND win2 >= 100*###')
						)
					);
	
	#European Union Special Service Medal
	$awardsdata[] = array(2270521, "Esr", 2,
						array(
							array('maps', 'count(*)', 3, 'mapid IN (10,11,110) AND `time` >= 1'),
							array('army', 'count(*)', 1, 'time9 >= 180000*### AND best9 >= 100*### AND win9 >= 100*###')
						)
					);
	
	#European Union Service ribbon
	$awardsdata[] = array(3270519, "Eum", 1,
						array(
							array('maps', 'count(*)', 3, 'mapid IN (10,11,110) AND `time` >= 1'),
							array('maps', 'sum(`time`)', 180000, 'mapid IN (10,11,110) AND `time` >= 1')
						)
					);
	
	#North American Service Ribbon
	$awardsdata[] = array(3271401, "Nas", 1,
						array(
							array('maps', 'count(*)', 3, 'mapid IN (200,201,202) AND `time` >= 1'),
							array('maps', 'sum(`time`)', 90000, 'mapid IN (200,201,202) AND `time` >= 1')
						)
					);
	
	### Special Forces ###
	// SF
	if ($mod == 'xpack') {
		# Navy Seal Special Service Medal
		$awardsdata[] = array(2261913, "X1Nsm", 2,
							array(
								array('army', 'count(*)', 1, 'time3 >= 180000*### AND best3 >= 100*### AND win3 >= 50*###')
							)
						);
						
		# SAS Special Service Medal
		$awardsdata[] = array(2261919, "X1Ssm", 2,
							array(
								array('army', 'count(*)', 1, 'time4 >= 180000*### AND best4 >= 100*### AND win4 >= 50*###')
							)
						);
						
		# SPETZ Special Service Medal
		$awardsdata[] = array(2261613, "X1Spm", 2,
							array(
								array('army', 'count(*)', 1, 'time5 >= 180000*### AND best5 >= 100*### AND win5 >= 50*###')
							)
						);
						
		# MECSF Special Service Medal
		$awardsdata[] = array(2261303, "X1Mcm", 2,
							array(
								array('army', 'count(*)', 1, 'time6 >= 180000*### AND best6 >= 100*### AND win6 >= 50*###')
							)
						);
						
		# Rebel Special Service Medal
		$awardsdata[] = array(2261802, "X1Rbm", 2,
							array(
								array('army', 'count(*)', 1, 'time7 >= 180000*### AND best7 >= 100*### AND win7 >= 50*###')
							)
						);
						
		# Insurgent Special Service Medal
		$awardsdata[] = array(2260914, "X1Inm", 2,
							array(
								array('army', 'count(*)', 1, 'time8 >= 180000*### AND best8 >= 100*### AND win8 >= 50*###')
							)
						);
	}
		
		# Navy Seal Service Ribbon
		$awardsdata[] = array(3261919, "X1Nss", 1,
							array(
								array('army', 'count(*)', 1, 'time3 >= 180000'),
								array('maps', 'count(*)', 3, 'mapid IN (300,301,304) AND `time` >= 1')
							)
						);
						
		# SAS Service Ribbon
		$awardsdata[] = array(3261901, "X1Sas", 1,
							array(
								array('army', 'count(*)', 1, 'time4 >= 180000'),
								array('maps', 'count(*)', 3, 'mapid IN (302,303,307) AND `time` >= 1')
							)
						);
						
		# SPETZNAS Service Ribbon
		$awardsdata[] = array(3261819, "X1Rsz", 1,
							array(
								array('army', 'count(*)', 1, 'time5 >= 180000'),
								array('maps', 'count(*)', 3, 'mapid IN (305,306,307) AND `time` >= 1')
							)
						);
						
		# MECSF Service Ribbon
		$awardsdata[] = array(3261319, "X1Msf", 1,
							array(
								array('army', 'count(*)', 1, 'time6 >= 180000'),
								array('maps', 'count(*)', 3, 'mapid IN (300,301,304) AND `time` >= 1')
							)
						);
						
		# Rebel Service Ribbon
		$awardsdata[] = array(3261805, "X1Reb", 1,
							array(
								array('army', 'count(*)', 1, 'time7 >= 180000'),
								array('maps', 'count(*)', 2, 'mapid IN (305,306) AND `time` >= 1')
							)
						);
						
		# Insurgent Service Ribbon
		$awardsdata[] = array(3260914, "X1Ins", 1,
							array(
								array('army', 'count(*)', 1, 'time8 >= 180000'),
								array('maps', 'count(*)', 2, 'mapid IN (302,303) AND `time` >= 1')
							)
						);
	
	return $awardsdata;
}


function buildBackendBasicsAwardsData($mod) {
	
	// Build Awards Data Array
	$basicsawardsdata = array();
	
	// Criteria data:
	// Data: array(<Awardnumber> <short name>, <0 = badges, 1 = Other> <Criteria>)
	
	#Knife Combat Badge
	$basicsawardsdata[] = array(1031406, "kcb", 0, 'ke0', 7);
	
	#Pistol Combat Badge
	$basicsawardsdata[] = array(1031619, "pcb", 0, 'kw5', 10);
	
	#Assault Combat Badge
	$basicsawardsdata[] = array(1031119, "Acb", 0, 'kk1', 5);
	
	#Anti-Tank Combat Badge
	$basicsawardsdata[] = array(1031120, "Atcb", 0, 'kk0', 10);
	
	#Sniper Combat Badge
	$basicsawardsdata[] = array(1031109, "Sncb", 0, 'kk6', 10);
	
	#Spec Ops Combat Badge
	$basicsawardsdata[] = array(1031115, "Socb", 0, 'kk4', 5);
	
	#Support Combat Badge
	$basicsawardsdata[] = array(1031121, "Sucb", 0, 'kk5', 10);
	
	#Engineer Combat Badge
	$basicsawardsdata[] = array(1031105, "Ecb", 0, 'kk2', 10);
	
	#Medic Combat Badge
	$basicsawardsdata[] = array(1031113, "Mcb", 0, 'kk3', 10);
	
	#Explosive Ordinance Badge
	$basicsawardsdata[] = array(1032415, "Eob", 0, 'explosive', 5);
	
	#First Aid Badge
	$basicsawardsdata[] = array(1190601, "Fab", 0, 'he', 5);
	
	#Engineer Badge
	$basicsawardsdata[] = array(1190507, "Eb", 0, 'rep', 5);
	
	#Resupply Badge
	$basicsawardsdata[] = array(1191819, "Rb", 0, 'rsp', 5);
	
	#Command Badge
	$basicsawardsdata[] = array(1190304, "Cb", 0, 'cs', 40);
	
	#Armour Badge
	$basicsawardsdata[] = array(1220118, "Ab", 0, 'tv0', 600);
	
	#Transport Badge
	$basicsawardsdata[] = array(1222016, "Tb", 0, 'tv4', 600);
	
	#Helicopter Badge
	$basicsawardsdata[] = array(1220803, "Hb", 0, 'tv3', 900);
	
	#Aviator Badge
	$basicsawardsdata[] = array(1220122, "Avb", 0, 'tv1', 600);
	
	#Air Defence Badge
	$basicsawardsdata[] = array(1220104, "adb", 0, 'tv2', 600);
	
	#Ground Defence Badge
	$basicsawardsdata[] = array(1031923, "Swb", 0, 'tv6', 300);
	
	#Tactical Support Combat Badge
	$basicsawardsdata[] = array(1260602, "X1fbb", 0, 'de6', 10);
	
	#Grappling Hook Usage
	$basicsawardsdata[] = array(1260708, "X1ghb", 0, 'de7', 10);
	
	#Zip Line Usage
	$basicsawardsdata[] = array(1262612, "X1zlb", 0, 'de8', 10);
	
	### Special Forces ###
	// SF
	if ($mod == 'xpack') {
		#Assault Combat Badge
		$basicsawardsdata[] = array(1261119, "X1Acb", 0, 'kk1', 6);
		
		#Anti-Tank Combat Badge
		$basicsawardsdata[] = array(1261120, "X1Atcb", 0, 'kk0', 11);
		
		#Sniper Combat Badge
		$basicsawardsdata[] = array(1261109, "X1Sncb", 0, 'kk6', 11);
		
		#Spec Ops Combat Badge
		$basicsawardsdata[] = array(1261115, "X1Socb", 0, 'kk4', 6);
		
		#Support Combat Badge
		$basicsawardsdata[] = array(1261121, "X1Sucb", 0, 'kk5', 11);
		
		#Engineer Combat Badge
		$basicsawardsdata[] = array(1261105, "X1Ecb", 0, 'kk2', 11);
		
		#Medic Combat Badge
		$basicsawardsdata[] = array(1261113, "X1Mcb", 0, 'kk3', 11);
	}
	
	return $basicsawardsdata;
}
?>
