<?php

/*
	Copyright (C) 2006  BF2Statistics

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

/**************************************
* 12/01/05 v0.0.1 - ALPHA build       *
* 12/02/05 v0.0.2 - Updated query     *
* 12/03/05 v0.0.3 - Updated query     *
* 12/08/05 v0.0.4 - Updated query     *
* 12/09/05 v0.0.5 - Removed nvg/gm    *
* 12/10/05 v0.0.6 - Updated query     *
* 12/11/05 v0.0.7 - Updated query     *
* 12/12/05 v0.0.8 - Updated for MNG   *
* 12/14/05 v0.0.9 - Updated for MNG   *
*                   Added abs-        *
* 12/23/05 v0.0.10 - Added tkills     *
* 12/25/05 v0.0.11 - Updated query    *
* 12/27/05 v0.0.12 - Updated query    *
* 12/29/05 v0.0.13 - Updated for MNG  *
* 01/03/06 v0.1 - BETA release        *
* 01/05/06 v0.1.1 - Updated query     *
* 02/14/06 v0.1.2 - Fixed skillscore  *
* 06/17/06 v0.1.3 - EF and AF support *
*                  added by Wolverine *
* 06/24/06 v0.1.4 - Validated output  *
*		against gamespy	              *
* 07/26/06 v0.1.6 - Added transpose   *
*		  support                     *
*		Correct output data			  *
* 07/31/06 v0.1.7 - Corrected Best    *
*		  Round Result Data           *
*		added support for Mode0/1/2	  *
*		added error check for kit/    *
*		  weapon/vehicle/map query 	  *
* 08/02/06 v0.1.8 - Added support for * 
*		mtm- data in gamespy query   *
*		Added prelim. support for v1.4 patch *
* 08/08/06 v0.1.9 - Added support for * 
*		mbs- & mws- data in gamespy query   *
**************************************/

//Disable Zlib Compression
ini_set('zlib.output_compression', '0'); 

$pid = (isset($_GET['pid'])) ? $_GET['pid'] : false;
$info = (isset($_GET['info'])) ? $_GET['info'] : '';
$transpose = (isset($_GET['transpose'])) ? $_GET['transpose'] : 0;

/*
URL:http://bf2.fun-o-matic.org/index.php/BF2_Statistics

Each function returns data in a similar standard format,
the data is simple text with tab seperated data values.
The opening line will either be an O or an E, an E signifies an error has occurred,
whereas an O is valid data.
The last line of the returned data starts with a $
followed by the number of bytes in the message (without tabs, newlines, or the length itself),
followed by a final $.
When valid data is returned, the lines consist of header and data rows,
indicated by H and D. Each header row is followed by one or more data rows.
*/

//omero, 2006-04-15
//better have this close to the to the beginning
// Import configuration
require('includes/utils.php');
require('_mod_keys.php');

$aarmies = array_merge($sarmies, $carmies);

$cfg = new Config();

if ((!$pid) || (!is_numeric($pid)) || (!is_numeric($transpose)) || ($info == '')) {
	$num = 0;
	$head = "E\nH\tasof\terr\n";
	$out  = "D\t" . time() . "\tInvalid Syntax!\n";
	$num += strlen(preg_replace('/[\t\n]/','',$head));
	$num += strlen(preg_replace('/[\t\n]/','',$out));
	
	print $head;
	print $out;
	print "$\t$num\t$";
}
else
{
	
	//omero, 2006-04-15
	//initialize message lengh counter and message header part
	$num = 0;
	$head = "O\n" .
	"H\tasof\n" .
	"D\t" . time() . "\n";
	
	//FIXME
	//omero, 2006-04-15
	//correct length of message will be calculated later
	//$num = 25;

	$connection = @mysql_connect($cfg->get('db_host'), $cfg->get('db_user'), $cfg->get('db_pass'));
	@mysql_select_db($cfg->get('db_name'), $connection);

	// Player info
	//'Reworked' for MNG stats =)
	//omero, 2006-04-15
	//split up an otherwise long and unreadable line
	$requiredKeys = "per*,cmb*,twsc,cpcp,cacp,dfcp,kila,heal,rviv,rsup,rpar," .
		"tgte,dkas,dsab,cdsc,rank,cmsc,kick,kill,deth,suic,ospm," .
		"klpm,klpr,dtpr,bksk,wdsk,bbrs,tcdr,ban,dtpm,lbtl,osaa," .
		"vrk,tsql,tsqm,tlwf,mvks,vmks,mvn*,vmr*,fkit,fmap,fveh,fwea," .
		"wtm-,wkl-,wdt-,wac-,wkd-,vtm-,vkl-,vdt-,vkd-,vkr-," .
		"atm-,awn-,alo-,abr-,ktm-,kkl-,kdt-,kkd-";
		
	if (strpos($info,$requiredKeys) !== false)
	{		
		$head .= "H\t" .
			"pid\tnick\tscor\tjond\twins\tloss\tmode0\tmode1\tmode2\t" .
			"time\tsmoc\tcmsc\tosaa\tkill\tkila\tdeth\tsuic\tbksk\twdsk\ttvcr\ttopr\tklpm\t" .
			"dtpm\tospm\tklpr\tdtpr\ttwsc\tcpcp\tcacp\tdfcp\theal\trviv\trsup\trpar\ttgte\t" .
			"dkas\tdsab\tcdsc\trank\tkick\tbbrs\ttcdr\tban\tlbtl\tvrk\ttsql\ttsqm\ttlwf\t" .
			"mvks\tvmks\tmvns\tmvrs\tvmns\tvmrs\tfkit\tfmap\tfveh\tfwea\ttnv\ttgm\t" .
			"wtm-0\twtm-1\twtm-2\twtm-3\twtm-4\twtm-5\twtm-6\twtm-7\twtm-8\twtm-9\twtm-10\twtm-11\twtm-12\twtm-13\t" .
			"wkl-0\twkl-1\twkl-2\twkl-3\twkl-4\twkl-5\twkl-6\twkl-7\twkl-8\twkl-9\twkl-10\twkl-11\twkl-12\twkl-13\t" .
			"wdt-0\twdt-1\twdt-2\twdt-3\twdt-4\twdt-5\twdt-6\twdt-7\twdt-8\twdt-9\twdt-10\twdt-11\twdt-12\twdt-13\t" .
			"wac-0\twac-1\twac-2\twac-3\twac-4\twac-5\twac-6\twac-7\twac-8\twac-9\twac-10\twac-11\twac-12\twac-13\t" .
			"wkd-0\twkd-1\twkd-2\twkd-3\twkd-4\twkd-5\twkd-6\twkd-7\twkd-8\twkd-9\twkd-10\twkd-11\twkd-12\twkd-13\t" .
			"vtm-0\tvtm-1\tvtm-2\tvtm-3\tvtm-4\tvtm-5\tvtm-6\t" .
			"vkl-0\tvkl-1\tvkl-2\tvkl-3\tvkl-4\tvkl-5\tvkl-6\t" .
			"vdt-0\tvdt-1\tvdt-2\tvdt-3\tvdt-4\tvdt-5\tvdt-6\t" .
			"vkd-0\tvkd-1\tvkd-2\tvkd-3\tvkd-4\tvkd-5\tvkd-6\t" .
			"vkr-0\tvkr-1\tvkr-2\tvkr-3\tvkr-4\tvkr-5\tvkr-6\t";

			foreach ($sarmies as $sarmy) {
			$head .= "atm-" . $sarmy ."\t" .
				"awn-" . $sarmy ."\t" .
				"alo-" . $sarmy ."\t" .
				"abr-" . $sarmy ."\t";
			}
			
			$head .= "ktm-0\tktm-1\tktm-2\tktm-3\tktm-4\tktm-5\tktm-6\t" .
			"kkl-0\tkkl-1\tkkl-2\tkkl-3\tkkl-4\tkkl-5\tkkl-6\t" .
			"kdt-0\tkdt-1\tkdt-2\tkdt-3\tkdt-4\tkdt-5\tkdt-6\t" .
			"kkd-0\tkkd-1\tkkd-2\tkkd-3\tkkd-4\tkkd-5\tkkd-6\t" .
			"de-6\tde-7\tde-8";

		// Mods Extra Army Data
		if (strpos($info, 'mods-') !== false) {
			foreach ($carmies as $carmy) {
				$head .= "\tatm-" . $carmy ."\t" .
					"awn-" . $carmy ."\t" .
					"alo-" . $carmy ."\t" .
					"abrnd-" . $carmy ."\t" .
					"abs-" . $carmy ."\t" .
					"aws-" . $carmy;
			}
		}
		
		# For MNG
		if (strpos($info, 'mng-') !== false)
		{
			// Added variables for EF, AF and Highway Tampa maps
			$head .= "\t";
				foreach ($smaps as $smap) {
					$head .= "mtm-" . $smap . "\t" .
						  "mwn-" . $smap . "\t" .
						  "mls-" . $smap . "\t" .
						  "mbs-" . $smap . "\t" .
						  "mws-" . $smap . "\t";
				}

				foreach ($sarmies as $sarmy) {
					$head .= "abrnd-" . $sarmy . "\t" .
						  "abs-"   . $sarmy . "\t" .
						  "aws-"   . $sarmy . "\t";
				}
					
			$head .= "mng-1\tmng-2\tmng-3\tmng-4\tmng-5\tmng-6\tmng-7\tmng-8\tmng-9\t" .
				"mng-10\tmng-11\tmng-12\tmng-13\tmng-14\tmng-15\tmng-16\tmng-17\t" .
				"mng-18\tmng-19\tmng-20\tmng-21\tmng-22\tmng-23\tmng-24\t" .
				"tkil\ttdmg\ttvdm\ttvp\tpip";
			
			// Custom Map Handling (Based on idea by: THE_WUQKED)
			if (strpos($info, 'cmap-') !== false)
			{
				$query = "SELECT * FROM mapinfo WHERE id >= " . $cfg->get('game_custom_mapid');
				$resultm = mysql_query($query) or die(mysql_error());
				if (!mysql_num_rows($resultm)) {
					// No Custom Maps found, ignoring section
				} else {
					$usermaps = $cmaps;
					while ($rowum = mysql_fetch_array($resultm)) {
						$usermaps[] = $rowum['id'];
					}
					asort($usermaps);
					
					// Map Time Header
					foreach ($usermaps as $usermapid) {$head .= "\tmtm-" . $usermapid;}
					// Map Wins Header
					foreach ($usermaps as $usermapid) {$head .= "\tmwn-" . $usermapid;}
					// Map Lossess Header
					foreach ($usermaps as $usermapid) {$head .= "\tmls-" . $usermapid;}
					// Map Best Score Header
					foreach ($usermaps as $usermapid) {$head .= "\tmbs-" . $usermapid;}
					// Map Worst Score Header
					foreach ($usermaps as $usermapid) {$head .= "\tmws-" . $usermapid;}
				}
			}
		}
		
		//omero, 2006-04-15
		//header is complete now,
		//add length of message header
		$num += strlen(preg_replace('/[\t\n]/','',$head));

		// Player
		$query = "SELECT * FROM player WHERE id = {$pid}";
		$result = mysql_query($query) or die(mysql_error());
		$row = mysql_fetch_array($result);
		if (!$row) {
			error_head_Player();
		} elseif ($row['score'] == 0) {
			// This player is most likely a new player with NO data!
			$out = "D\t" . $row['id'] . "\t" . $row['name'] . "\t";
			// Set All Data responses to 0
			$fieldCount = substr_count($head, "\t") - 3;
			for( $i = 1; $i < $fieldCount; $i++ ) {
				$out .= "0\t";
			}
			$num += strlen(preg_replace('/[\t\n]/','',$out));
		} else {
			
			# For MNG
			$name = $row['name'];
			if (strpos($info, 'mng-') !== false) {$name = htmlspecialchars($name);}

			// Weapons
			$query = "SELECT * FROM weapons WHERE id = {$pid}";
			$result = mysql_query($query) or die(mysql_error());
			$roww = mysql_fetch_array($result);

			// Vehicles
			$query = "SELECT * FROM vehicles WHERE id = {$pid}";
			$result = mysql_query($query) or die(mysql_error());
			$rowv = mysql_fetch_array($result);

			// Army
			$query = "SELECT * FROM army WHERE id = {$pid}";
			$result = mysql_query($query) or die(mysql_error());
			$rowa = mysql_fetch_array($result);

			// Kits
			$query = "SELECT * FROM kits WHERE id = {$pid}";
			$result = mysql_query($query) or die(mysql_error());
			$rowk = mysql_fetch_array($result);
			
			// Overall weapon accuracy
			$acc = $count = 0;
			if ($roww['fired0'] != 0) {$acc += ($roww['hit0'] / $roww['fired0']) * 100; $count++;}
			if ($roww['fired1'] != 0) {$acc += ($roww['hit1'] / $roww['fired1']) * 100; $count++;}
			if ($roww['fired2'] != 0) {$acc += ($roww['hit2'] / $roww['fired2']) * 100; $count++;}
			if ($roww['fired3'] != 0) {$acc += ($roww['hit3'] / $roww['fired3']) * 100; $count++;}
			if ($roww['fired4'] != 0) {$acc += ($roww['hit4'] / $roww['fired4']) * 100; $count++;}
			if ($roww['fired5'] != 0) {$acc += ($roww['hit5'] / $roww['fired5']) * 100; $count++;}
			if ($roww['fired6'] != 0) {$acc += ($roww['hit6'] / $roww['fired6']) * 100; $count++;}
			if ($roww['fired7'] != 0) {$acc += ($roww['hit7'] / $roww['fired7']) * 100; $count++;}
			if ($roww['fired8'] != 0) {$acc += ($roww['hit8'] / $roww['fired8']) * 100; $count++;}
			if ($roww['knifefired'] != 0) {$acc += ($roww['knifehit'] / $roww['knifefired']) * 100; $count++;}
			if ($roww['shockpadfired'] != 0) {$acc += ($roww['shockpadhit'] / $roww['shockpadfired']) * 100; $count++;}
			if ($roww['c4fired'] != 0) {$acc += ($roww['c4hit'] / $roww['c4fired']) * 100; $count++;}
			if ($roww['claymorefired'] != 0) {$acc += ($roww['claymorehit'] / $roww['claymorefired']) * 100; $count++;}
			if ($roww['atminefired'] != 0) {$acc += ($roww['atminehit'] / $roww['atminefired']) * 100; $count++;}
			if ($roww['handgrenadefired'] != 0) {$acc += ($roww['handgrenadehit'] / $roww['handgrenadefired']) * 100; $count++;}
			if ($count) {$acc /= $count;}

			// Favorite opponent
			$query = "SELECT attacker, count FROM kills WHERE victim = {$pid} GROUP BY count DESC LIMIT 1";
			$result = mysql_query($query) or die(mysql_error());
			if (mysql_num_rows($result)) {
				$row2 = mysql_fetch_array($result);
				$favoi = $row2['attacker'];
				$favok = $row2['count'];
				$query = "SELECT name, rank FROM player WHERE id = {$favoi}";
				$result = mysql_query($query) or die(mysql_error());
				$row2 = mysql_fetch_array($result);
				$favon = $row2['name'];
				$favor = $row2['rank'];
			} else {
				$favoi = 'n/a';
				$favok = 0;
				$favon = 'n/a';
				$favor = '';
			}

			# For MNG
			if (strpos($info, 'mng-') !== false) {$favon = htmlspecialchars($favon);}
			
			

			// Favorite victim
			$query = "SELECT victim, count FROM kills WHERE attacker = {$pid} GROUP BY count DESC LIMIT 1";
			$result = mysql_query($query) or die(mysql_error());
			if (mysql_num_rows($result)) {
				$row2 = mysql_fetch_array($result);
				$favvi = $row2['victim'];
				$favvk = $row2['count'];
				$query = "SELECT name, rank FROM player WHERE id = {$favvi}";
				$result = mysql_query($query) or die(mysql_error());
				$row2 = mysql_fetch_array($result);
				$favvn = $row2['name'];
			} else {
				$favvi = 'n/a';
				$favvk = 0;
				$favvn = 'n/a';
			}

			# For MNG
			if (strpos($info, 'mng-') !== false) {$favvn = htmlspecialchars($favvn);}

			$favvr = $row2['rank'];

			// Favorite kit
			$query = "SELECT time0, time1, time2, time3, time4, time5, time6 FROM kits WHERE id = {$pid}";
			$result = mysql_query($query) or die(mysql_error());
			$row2 = mysql_fetch_array($result);
			arsort($row2);
			if (is_numeric(key($row2))) {$favk = key($row2);}
			else {next($row2); $favk = key($row2);}

			// Favorite map
			$favmap = array();
			$query = "SELECT time FROM maps WHERE id = {$pid}";
			$result = mysql_query($query) or die(mysql_error());
			while ($row2 = mysql_fetch_array($result))	{$favmap[] = $row2['time'];}
			rsort($favmap);
			$query = "SELECT mapid FROM maps WHERE (id = {$pid}) AND (time = {$favmap[0]})";
			$result = mysql_query($query) or die(mysql_error());
			$row2 = mysql_fetch_array($result);
			$favm = $row2[0];

			// Favorite vehicle
			$query = "SELECT time0, time1, time2, time3, time4, time5, time6 FROM vehicles WHERE id = {$pid}";
			$result = mysql_query($query) or die(mysql_error());
			$row2 = mysql_fetch_array($result);
			arsort($row2);
			if (is_numeric(key($row2))) {$favv = key($row2);}
			else {next($row2); $favv = key($row2);}
			
			// Road Kills
			$vrk = 0;
			for ($i = 0; $i < 7; $i++) {
				$vrk = $vrk + $rowv["rk$i"];
			}
			
			// Favorite weapon
			$query = "SELECT time0, time1, time2, time3, time4, time5, time6, time7, time8 FROM weapons WHERE id = {$pid}";
			$result = mysql_query($query) or die(mysql_error());
			$row2 = mysql_fetch_array($result);
			arsort($row2);
			if (is_numeric(key($row2))) {$favw = key($row2);}
			else {next($row2); $favw = key($row2);}

			// Sergeant Major Of The Corps
			$smoc = $row['rank'] == 11 ? 1 : 0;

			// Weapon accuracy
			$a0 = $a1 = $a2 = $a3 = $a4 = $a5 = $a6 = $a7 = $a8 = $a9 = $a10 = $a11 = $a12 = 0;
			if ($roww['fired0'] != 0) {$a0 = ($roww['hit0'] / $roww['fired0']) * 100;}
			if ($roww['fired1'] != 0) {$a1 = ($roww['hit1'] / $roww['fired1']) * 100;}
			if ($roww['fired2'] != 0) {$a2 = ($roww['hit2'] / $roww['fired2']) * 100;}
			if ($roww['fired3'] != 0) {$a3 = ($roww['hit3'] / $roww['fired3']) * 100;}
			if ($roww['fired4'] != 0) {$a4 = ($roww['hit4'] / $roww['fired4']) * 100;}
			if ($roww['fired5'] != 0) {$a5 = ($roww['hit5'] / $roww['fired5']) * 100;}
			if ($roww['fired6'] != 0) {$a6 = ($roww['hit6'] / $roww['fired6']) * 100;}
			if ($roww['fired7'] != 0) {$a7 = ($roww['hit7'] / $roww['fired7']) * 100;}
			if ($roww['fired8'] != 0) {$a8 = ($roww['hit8'] / $roww['fired8']) * 100;}
			if ($roww['knifefired'] != 0) {$a9 = ($roww['knifehit'] / $roww['knifefired']) * 100;}
			if ($roww['shockpadfired'] != 0) {$a10 = ($roww['shockpadhit'] / $roww['shockpadfired']) * 100;}

			if (($roww['c4fired'] + $roww['claymorefired'] + $roww['atminefired']) != 0) {

				$exphts = $roww['c4hit'] + $roww['claymorehit'] + $roww['atminehit'];
				$expfrd = $roww['c4fired'] + $roww['claymorefired'] + $roww['atminefired'];
				$a11 = (($exphts) / ($expfrd)) * 100;
			}

			if ($roww['handgrenadefired'] != 0) {$a12 = ($roww['handgrenadehit'] / $roww['handgrenadefired']) * 100;}

			// Weapon ratio
			$w0 = ratio($roww['kills0'], $roww['deaths0']);
			$w1 = ratio($roww['kills1'], $roww['deaths1']);
			$w2 = ratio($roww['kills2'], $roww['deaths2']);
			$w3 = ratio($roww['kills3'], $roww['deaths3']);
			$w4 = ratio($roww['kills4'], $roww['deaths4']);
			$w5 = ratio($roww['kills5'], $roww['deaths5']);
			$w6 = ratio($roww['kills6'], $roww['deaths6']);
			$w7 = ratio($roww['kills7'], $roww['deaths7']);
			$w8 = ratio($roww['kills8'], $roww['deaths8']);
			$w9 = ratio($roww['knifekills'], $roww['knifedeaths']);
			$w10 = ratio($roww['shockpadkills'], $roww['shockpaddeaths']);
			
			//omero, 2006-04-16
			//pre-calculate both deaths and kills with explosives
			$expdeth = $roww['c4deaths'] + $roww['claymoredeaths'] + $roww['atminedeaths'];
			$expklls = $roww['c4kills'] + $roww['claymorekills'] + $roww['atminekills'];
			$w11 = ratio($expklls, $expdeth);
			$w12 = ratio($roww['handgrenadekills'], $roww['handgrenadedeaths']);

			// Vehicle ratio
			$v0 = ratio($rowv['kills0'], $rowv['deaths0']);
			$v1 = ratio($rowv['kills1'], $rowv['deaths1']);
			$v2 = ratio($rowv['kills2'], $rowv['deaths2']);
			$v3 = ratio($rowv['kills3'], $rowv['deaths3']);
			$v4 = ratio($rowv['kills4'], $rowv['deaths4']);
			$v5 = ratio($rowv['kills5'], $rowv['deaths5']);
			$v6 = ratio($rowv['kills6'], $rowv['deaths6']);

			// Kit ratio
			$k0 = ratio($rowk['kills0'], $rowk['deaths0']);
			$k1 = ratio($rowk['kills1'], $rowk['deaths1']);
			$k2 = ratio($rowk['kills2'], $rowk['deaths2']);
			$k3 = ratio($rowk['kills3'], $rowk['deaths3']);
			$k4 = ratio($rowk['kills4'], $rowk['deaths4']);
			$k5 = ratio($rowk['kills5'], $rowk['deaths5']);
			$k6 = ratio($rowk['kills6'], $rowk['deaths6']);

			// Output
			$out = "D\t" .
				$row['id'] . "\t" .
				$name . "\t" .
				$row['score'] . "\t" .
				$row['joined'] . "\t" .
				$row['wins'] . "\t" .
				$row['losses'] . "\t" .
				$row['mode0'] . "\t" .
				$row['mode1'] . "\t" .
				$row['mode2'] . "\t" .
				$row['time'] . "\t" .
				$smoc . "\t" .
				$row['skillscore'] . "\t" .
				@number_format($acc, 2) . "\t" .
				$row['kills'] . "\t" .
				$row['damageassists'] . "\t" .
				$row['deaths'] . "\t" .
				$row['suicides'] . "\t" .
				$row['killstreak'] . "\t" .
				$row['deathstreak'] . "\t" .
				#top victim/opponent in _round_
				"0\t0\t" .
				@number_format(60 * ($row['kills'] / $row['time']), 2) . "\t" .
				@number_format(60 * ($row['deaths'] / $row['time']), 2) . "\t" .
				@number_format(60 * ($row['score'] / $row['time']), 2) . "\t" .
				@number_format($row['kills'] / $row['rounds'], 2) . "\t" .
				@number_format($row['deaths'] / $row['rounds'], 2) . "\t" .
				$row['teamscore'] . "\t" .
				$row['captures'] . "\t" .
				$row['captureassists'] . "\t" .
				$row['defends'] . "\t" .
				$row['heals'] . "\t" .
				$row['revives'] . "\t" .
				$row['ammos'] . "\t" .
				$row['repairs'] . "\t" .
				$row['targetassists'] . "\t" .
				$row['driverassists'] . "\t" .
				$row['driverspecials'] . "\t" .
				$row['cmdscore'] . "\t" .
				$row['rank'] . "\t" .
				$row['kicked'] . "\t" .
				$row['rndscore'] . "\t" .
				$row['cmdtime'] . "\t" .
				$row['banned'] . "\t" .
				$row['lastonline'] . "\t" .
				$vrk . "\t" .
				$row['sqltime'] . "\t" .
				$row['sqmtime'] . "\t" .
				$row['lwtime'] . "\t" .
				$favvk . "\t" .
				$favok . "\t" .
				$favvn . "\t" .
				$favvr . "\t" .
				$favon . "\t" .
				$favor . "\t" .
				$favk . "\t" .
				$favm . "\t" .
				$favv . "\t" .
				$favw . "\t" .
				#nvg/gas time
				"0\t0\t" .
				$roww['time0'] . "\t" .
				$roww['time1'] . "\t" .
				$roww['time2'] . "\t" .
				$roww['time3'] . "\t" .
				$roww['time4'] . "\t" .
				$roww['time5'] . "\t" .
				$roww['time6'] . "\t" .
				$roww['time7'] . "\t" .
				$roww['time8'] . "\t" .
				$roww['knifetime'] . "\t" .
				$roww['shockpadtime'] . "\t" .
				($roww['c4time'] + $roww['claymoretime'] + $roww['atminetime']). "\t" .
				$roww['handgrenadetime'] . "\t" .
				#wtm-13
				"0\t" .
				$roww['kills0'] . "\t" .
				$roww['kills1'] . "\t" .
				$roww['kills2'] . "\t" .
				$roww['kills3'] . "\t" .
				$roww['kills4'] . "\t" .
				$roww['kills5'] . "\t" .
				$roww['kills6'] . "\t" .
				$roww['kills7'] . "\t" .
				$roww['kills8'] . "\t" .
				$roww['knifekills'] . "\t" .
				$roww['shockpadkills'] . "\t" .
				($roww['c4kills'] + $roww['claymorekills'] + $roww['atminekills']) . "\t" .
				$roww['handgrenadekills'] . "\t" .
				#wkl-13
				"0\t" .
				$roww['deaths0'] . "\t" .
				$roww['deaths1'] . "\t" .
				$roww['deaths2'] . "\t" .
				$roww['deaths3'] . "\t" .
				$roww['deaths4'] . "\t" .
				$roww['deaths5'] . "\t" .
				$roww['deaths6'] . "\t" .
				$roww['deaths7'] . "\t" .
				$roww['deaths8'] . "\t" .
				$roww['knifedeaths'] . "\t" .
				$roww['shockpaddeaths'] . "\t" .
				($roww['c4deaths'] + $roww['claymoredeaths'] + $roww['atminedeaths']) . "\t" .
				$roww['handgrenadedeaths'] . "\t" .
				# wdt-13
				"0\t" . # $roww['ziplinedeaths'] . "\t" .
				(int)$a0 . "\t" .
				(int)$a1 . "\t" .
				(int)$a2 . "\t" .
				(int)$a3 . "\t" .
				(int)$a4 . "\t" .
				(int)$a5 . "\t" .
				(int)$a6 . "\t" .
				(int)$a7 . "\t" .
				(int)$a8 . "\t" .
				(int)$a9 . "\t" .
				(int)$a10 . "\t" .
				(int)$a11 . "\t" .
				(int)$a12 . "\t" .
				#wac-13
				"0\t" .
				$w0 . "\t" .
				$w1 . "\t" .
				$w2 . "\t" .
				$w3 . "\t" .
				$w4 . "\t" .
				$w5 . "\t" .
				$w6 . "\t" .
				$w7 . "\t" .
				$w8 . "\t" .
				$w9 . "\t" .
				$w10 . "\t" .
				$w11 . "\t" .
				$w12 . "\t" .
				#wkd-13
				"0:0\t" .
				$rowv['time0'] . "\t" .
				$rowv['time1'] . "\t" .
				$rowv['time2'] . "\t" .
				$rowv['time3'] . "\t" .
				$rowv['time4'] . "\t" .
				$rowv['time5'] . "\t" .
				$rowv['time6'] . "\t" .
				$rowv['kills0'] . "\t" .
				$rowv['kills1'] . "\t" .
				$rowv['kills2'] . "\t" .
				$rowv['kills3'] . "\t" .
				$rowv['kills4'] . "\t" .
				$rowv['kills5'] . "\t" .
				$rowv['kills6'] . "\t" .
				$rowv['deaths0'] . "\t" .
				$rowv['deaths1'] . "\t" .
				$rowv['deaths2'] . "\t" .
				$rowv['deaths3'] . "\t" .
				$rowv['deaths4'] . "\t" .
				$rowv['deaths5'] . "\t" .
				$rowv['deaths6'] . "\t" .
				$v0 . "\t" .
				$v1 . "\t" .
				$v2 . "\t" .
				$v3 . "\t" .
				$v4 . "\t" .
				$v5 . "\t" .
				$v6 . "\t" .
				$rowv['rk0'] . "\t" .
				$rowv['rk1'] . "\t" .
				$rowv['rk2'] . "\t" .
				$rowv['rk3'] . "\t" .
				$rowv['rk4'] . "\t" .
				$rowv['rk5'] . "\t" .
				$rowv['rk6'] . "\t";
				
				foreach ($sarmies as $sarmy) {
					$out .= $rowa['time' . $sarmy] ."\t" .
						$rowa['win' . $sarmy] ."\t" .
						$rowa['loss' . $sarmy] ."\t" .
						$rowa['brnd' . $sarmy] ."\t";
				}
				
				$out .= $rowk['time0'] . "\t" .
				$rowk['time1'] . "\t" .
				$rowk['time2'] . "\t" .
				$rowk['time3'] . "\t" .
				$rowk['time4'] . "\t" .
				$rowk['time5'] . "\t" .
				$rowk['time6'] . "\t" .
				$rowk['kills0'] . "\t" .
				$rowk['kills1'] . "\t" .
				$rowk['kills2'] . "\t" .
				$rowk['kills3'] . "\t" .
				$rowk['kills4'] . "\t" .
				$rowk['kills5'] . "\t" .
				$rowk['kills6'] . "\t" .
				$rowk['deaths0'] . "\t" .
				$rowk['deaths1'] . "\t" .
				$rowk['deaths2'] . "\t" .
				$rowk['deaths3'] . "\t" .
				$rowk['deaths4'] . "\t" .
				$rowk['deaths5'] . "\t" .
				$rowk['deaths6'] . "\t" .
				$k0 . "\t" .
				$k1 . "\t" .
				$k2 . "\t" .
				$k3 . "\t" .
				$k4 . "\t" .
				$k5 . "\t" .
				$k6 . "\t" .
				#de-6/7/8
				$roww['tacticaldeployed'] . "\t" .
				$roww['grapplinghookdeployed'] . "\t" .
				$roww['ziplinedeployed'] . "\t";
			
			// Mods Extra Army Data
			if (strpos($info, 'mods-') !== false) {
				foreach ($carmies as $carmy) {
					$out .= $rowa['time' . $carmy] ."\t" .
						$rowa['win' . $carmy] ."\t" .
						$rowa['loss' . $carmy] ."\t" .
						$rowa['brnd' . $carmy] ."\t" .
						$rowa['best' . $carmy] ."\t" .
						$rowa['worst' . $carmy] ."\t";
				}
			}
			
			# For MNG
			if (strpos($info, 'mng-') !== false)
			{
				// Maps
				if (isset($usermaps)) {
					$time = $win = $loss = $best = $worst = array_fill(0, end($usermaps)+1, '0');
				} else {
					foreach ($smaps as $smap) {
						$time[$smap] = $win[$smap] = $loss[$smap] = $best[$smap] = $worst[$smap] = 0;
					}
				}
				$querym = "SELECT * FROM maps WHERE id = {$pid}";
				$resultm = mysql_query($querym) or die(mysql_error());
				while ($rowm = mysql_fetch_array($resultm))
				{
					$time[$rowm['mapid']] = $rowm['time'];
					$win[$rowm['mapid']] = $rowm['win'];
					$loss[$rowm['mapid']] = $rowm['loss'];
					$best[$rowm['mapid']] = $rowm['best'];
					$worst[$rowm['mapid']] = $rowm['worst'];
				}
				
				$out = rtrim($out) . "\t";
					
				foreach ($smaps as $smap) {
					$out .= $time[$smap]  . "\t" .
						 $win[$smap]   . "\t" .
						 $loss[$smap]  . "\t" .
						 $best[$smap]  . "\t" .
						 $worst[$smap] . "\t";
				}

				foreach ($sarmies as $sarmy) {
					$out .= $rowa['brnd' . $sarmy] . "\t" .
						 $rowa['best' . $sarmy] . "\t" .
						 $rowa['worst' . $sarmy] . "\t";
				}

				$out .= $roww['c4time'] . "\t" .
					$roww['claymoretime'] . "\t" .
					$roww['atminetime'] . "\t" .
					$roww['tacticaltime'] . "\t" .
					$roww['grapplinghooktime'] . "\t" .
					$roww['ziplinetime'] . "\t" .
					$roww['c4kills'] . "\t" .
					$roww['claymorekills'] . "\t" .
					$roww['atminekills'] . "\t" .
					$roww['c4deaths'] . "\t" .
					$roww['claymoredeaths'] . "\t" .
					$roww['atminedeaths'] . "\t" .
					$roww['ziplinedeaths'] . "\t" .
					$roww['grapplinghookdeaths'] . "\t" .
					$roww['tacticaldeployed'] . "\t" .
					$roww['grapplinghookdeployed'] . "\t" .
					$roww['ziplinedeployed'] . "\t" .
					$roww['c4fired'] . "\t" .
					$roww['claymorefired'] . "\t" .
					$roww['atminefired'] . "\t" .
					$roww['c4hit'] . "\t" .
					$roww['claymorehit'] . "\t" .
					$roww['atminehit'] . "\t" .
					$row['country'] . "\t" .
					$row['teamkills'] . "\t" .
					$row['teamdamage'] . "\t" .
					$row['teamvehicledamage'] . "\t" .
					$rowv['timepara'] . "\t" .
					$row['ip'] . "\t";
				
				// Custom Map Handling (Based on idea by: THE_WUQKED)
				if ((strpos($info, 'cmap-') !== false) && (isset($usermaps))) {
					// Map Time Output
					foreach ($usermaps as $usermapid) {$out .= $time[$usermapid] . "\t";}
					// Map Wins Output
					foreach ($usermaps as $usermapid) {$out .= $win[$usermapid] . "\t";}
					// Map Lossess Output
					foreach ($usermaps as $usermapid) {$out .= $loss[$usermapid] . "\t";}
					// Map Best Score Output
					foreach ($usermaps as $usermapid) {$out .= $best[$usermapid] . "\t";}
					// Map Worst Score Output
					foreach ($usermaps as $usermapid) {$out .= $worst[$usermapid] . "\t";}
				}
			}
		}
	}
	// Time info
	elseif ($info == 'ktm-,vtm-,wtm-,mtm-')
	{
		$kit = ($_GET['kit']) ? $_GET['kit'] : 0;
		$vehicle = ($_GET['vehicle']) ? $_GET['vehicle'] : 0;
		$weapon = ($_GET['weapon']) ? $_GET['weapon'] : 0;
		$map = ($_GET['map']) ? $_GET['map'] : 0;
		
		$head .= "H\tpid\tnick\tktm-$kit\tvtm-$vehicle\twtm-$weapon\tmtm-$map\n";
		$num += strlen(preg_replace('/[\t\n]/','',$head));

		// Player
		$query = "SELECT name FROM player WHERE id = {$pid}";
		$result = mysql_query($query) or die(mysql_error());
		$row = mysql_fetch_array($result);
		if (!$row) {
			error_head_Player();
		}
		$name = $row['name'];

		// Kits
		$query = "SELECT time{$kit} FROM kits WHERE id = {$pid}";
		$result = mysql_query($query) or die(mysql_error());
		if (mysql_num_rows($result))
		{
			$row = mysql_fetch_array($result);
			$kitt = $row["time$kit"];
		}
		else {$kitt = 0;}

		// Vehicles
		$query = "SELECT time{$vehicle} FROM vehicles WHERE id = {$pid}";
		$result = mysql_query($query) or die(mysql_error());
		if (mysql_num_rows($result))
		{
			$row = mysql_fetch_array($result);
			$vehiclet = $row["time$vehicle"];
		}
		else {$vehiclet = 0;}

		// Weapons
		$query = "SELECT time{$weapon} FROM weapons WHERE id = {$pid}";
		$result = mysql_query($query) or die(mysql_error());
		if (mysql_num_rows($result))
		{
			$row = mysql_fetch_array($result);
			$weapont = $row["time$weapon"];
		}
		else {$weapont = 0;}

		// Maps
		$query = "SELECT time FROM maps WHERE (id = {$pid}) AND (mapid = {$map})";
		$result = mysql_query($query) or die(mysql_error());
		if (mysql_num_rows($result))
		{
			$row = mysql_fetch_array($result);
			$mapt = $row['time'];
		}
		else {$mapt = 0;}

		$out = "D\t" .
			$pid . "\t" .
			$name . "\t" .
			$kitt . "\t" .
			$vehiclet . "\t" .
			$weapont . "\t" .
			$mapt . "\n";
		
	}
	// Map info (added support for mbs- & mws-)
	elseif ($info == 'mtm-,mwn-,mls-' || $info == 'mtm-,mwn-,mls-,mbs-,mws-' ||
		$info == 'mtm-,mwn-,mls-,cmap-' || $info == 'mtm-,mwn-,mls-,mbs-,mws-,cmap-')
	{
		// Added EF and AF variables
		// Added Patch 1.4 info
		
		$head .= "H\tpid\tnick";
		foreach ($smaps as $smap) {
			$head .= "\tmtm-" . $smap ."\t" .
				"mwn-" . $smap ."\t" .
				"mls-" . $smap;
		}
			
		# For mbs-,mws-
		if (strpos($info, 'mbs-,mws-') !== false)
		{
			foreach ($smaps as $smap) {
				$head .= "\tmbs-" . $smap ."\t" .
					"mws-" . $smap;
			}
		}
		
		// Custom Map Handling (Based on idea by: THE_WUQKED)
		if (strpos($info, 'cmap-') !== false)
		{
			$query = "SELECT * FROM mapinfo WHERE id >= " . $cfg->get('game_custom_mapid');
			$resultm = mysql_query($query) or die(mysql_error());
			if (!mysql_num_rows($resultm)) {
				// No Custom Maps found, ignoring section
			} else {
				$usermaps = $cmaps;
				while ($rowum = mysql_fetch_array($resultm)) {
					$usermaps[] = $rowum['id'];
				}
				asort($usermaps);
				
				// Map Time Header
				foreach ($usermaps as $usermapid) {$head .= "\tmtm-" . $usermapid;}
				// Map Wins Header
				foreach ($usermaps as $usermapid) {$head .= "\tmwn-" . $usermapid;}
				// Map Lossess Header
				foreach ($usermaps as $usermapid) {$head .= "\tmls-" . $usermapid;}
				
				if (strpos($info, 'mbs-,mws-') !== false)
				{
					// Map Best Score Header
					foreach ($usermaps as $usermapid) {$head .= "\tmbs-" . $usermapid;}
					// Map Worst Score Header
					foreach ($usermaps as $usermapid) {$head .= "\tmws-" . $usermapid;}
				}
			}
		}
			
		$num += strlen(preg_replace('/[\t\n]/','',$head));

		// Player
		$query = "SELECT name FROM player WHERE id = {$pid}";
		$result = mysql_query($query) or die(mysql_error());
		$row = mysql_fetch_array($result);
		if (!$row) {
			error_head_Player();
		}
		$name = $row['name'];
			
		// Maps (Added extra for mbs-,mws-)
		if (isset($usermaps)) {
			$time = $win = $loss = $best = $worst = array_fill(0, end($usermaps)+1, '0');
		} else {
			foreach ($smaps as $smap) {

				$time[$smap] = $win[$smap] = $loss[$smap] = $best[$smap] = $worst[$smap] = 0;
			}
		}
		$query = "SELECT * FROM maps WHERE id = {$pid}";
		$result = mysql_query($query) or die(mysql_error());
		while ($row = mysql_fetch_array($result))
		{
			$time[$row['mapid']] = $row['time'];
			$win[$row['mapid']] = $row['win'];
			$loss[$row['mapid']] = $row['loss'];
			$best[$row['mapid']] = $row['best'];
			$worst[$row['mapid']] = $row['worst'];
		}

		$out = "D\t" .
			$pid . "\t" .
			$name . "\t";
			foreach ($smaps as $smap) {
				$out .= $time[$smap] . "\t" .
					 $win[$smap] . "\t" .
					 $loss[$smap] . "\t";
			}
		
		# For mbs-,mws-
		if (strpos($info, 'mbs-,mws-') !== false)
		{
			foreach ($smaps as $smap) {
			$out .= $best[$smap] . "\t" .
					$worst[$smap] . "\t";
			}
		}
		
		// Custom Map Handling (Based on idea by: THE_WUQKED)
		if ((strpos($info, 'cmap-') !== false) && (isset($usermaps))) {
			// Map Time Output
			foreach ($usermaps as $usermapid) {$out .= $time[$usermapid] . "\t";}
			// Map Wins Output
			foreach ($usermaps as $usermapid) {$out .= $win[$usermapid] . "\t";}
			// Map Lossess Output
			foreach ($usermaps as $usermapid) {$out .= $loss[$usermapid] . "\t";}
			if (strpos($info, 'mbs-,mws-') !== false)
			{
				// Map Best Score Output
				foreach ($usermaps as $usermapid) {$out .= $best[$usermapid] . "\t";}
				// Map Worst Score Output
				foreach ($usermaps as $usermapid) {$out .= $worst[$usermapid] . "\t";}
			}
		}
	}
	elseif ($info == 'rank')
	{
		$query = "SELECT rank FROM player WHERE id = {$pid}";
		$result = mysql_query($query) or die(mysql_error());

		if (!mysql_num_rows($result)) {print 'Player not found!';}
		else
		{
			$row = mysql_fetch_array($result);
			$rank = $row['rank'];
			
			$query = "SELECT id, name, chng, decr FROM player WHERE id = {$pid}";
			$result = mysql_query($query) or die(mysql_error());
			$row = mysql_fetch_array($result);
			
			$head .= "H\tpid\tnick\trank\tchng\tdecr\n";
			$num += strlen(preg_replace('/[\t\n]/','',$head));
			
			$out .= "D\t$row[id]\t$row[name]\t$rank\t$row[chng]\t$row[decr]\n";
			
			$query = "UPDATE player SET chng = 0, decr = 0 WHERE id = {$pid}";
			mysql_query($query) or die(mysql_error());
		}
	}
	elseif (checkGameServerRequest($info))
	{
		// NOTE: xpack and bf2 have same return
		// Added support for MODs (POE2)
		// Added support for AIX
		$head .= "H\t" .
			"pid\tnick\trank\t" . 
			"ktm-0\tktm-1\tktm-2\tktm-3\tktm-4\tktm-5\tktm-6\tdfcp\trpar\t" .
			"vtm-0\tvtm-1\tvtm-2\tvtm-3\tvtm-4\tvtm-5\tvtm-6\tscor\twdsk\t" .
			"wkl-0\twkl-1\twkl-2\twkl-3\twkl-4\twkl-5\twkl-6\twkl-7\twkl-8\twkl-9\twkl-10\twkl-11\twkl-12\twkl-13\theal\t" .
			"dsab\tcdsc\ttsql\ttsqm\tloss\twins\t" .
			"vkl-0\tvkl-1\tvkl-2\tvkl-3\tvkl-4\tvkl-5\tvkl-6\ttwsc\tbksk\ttime\tkill\trsup\ttcdr\t";
			
			foreach ($aarmies as $sarmy) {
				$head .= "atm-" . $sarmy ."\t" .
					"abr-" . $sarmy ."\t" .
					"awn-" . $sarmy ."\t";
			}
			
		if (strpos($info, 'mtm-') !== false) {
			// Add Map Time Data for New Medals Data
			foreach ($smaps as $smap) {
				$head .= "mtm-" . $smap . "\t";
			}
		}
		
		if (strpos($info, 'de-') !== false) {
			$head .= "de-6\tde-7\tde-8\t";
		}
		
		$head .= "vac-0\tvac-1\tvac-2\tvac-3\tvac-4\tvac-5\tvac-6\n";
			
		$num += strlen(preg_replace('/[\t\n]/','',$head));
		
		// Player
		$query = "SELECT * FROM player WHERE id = {$pid}";
		$result = mysql_query($query) or die(mysql_error());
		$row = mysql_fetch_array($result);
		if (!$row) {
			error_head_Player();
		}

		// Weapons
		$query = "SELECT * FROM weapons WHERE id = {$pid}";
		$result = mysql_query($query) or die(mysql_error());
		if (mysql_num_rows($result)) {
			$roww = mysql_fetch_array($result);
		} else {
			$roww = array();
			for ($i = 0; $i <= 8; $i++) {
				$roww["kills$i"] = '0';
			}
			$roww['knifekills'] = $roww['shockpadkills'] = $roww['c4kills'] = $roww['claymorekills'] = '0';
			$roww['atminekills'] = $roww['handgrenadekills'] = '0';
		}

		// Kits
		$query = "SELECT * FROM kits WHERE id = {$pid}";
		$result = mysql_query($query) or die(mysql_error());
		if (mysql_num_rows($result)) {
			$rowk = mysql_fetch_array($result);
		} else {
			$rowk = array();
			for ($i = 0; $i <= 6; $i++) {
				$rowk["time$i"] = '0';
				$rowk["kills$i"] = '0';
			}
		}
		
		// Vehicles
		$query = "SELECT * FROM vehicles WHERE id = {$pid}";
		$result = mysql_query($query) or die(mysql_error());
		if (mysql_num_rows($result)) {
			$rowv = mysql_fetch_array($result);
		} else {
			$rowv = array();
			for ($i = 0; $i <= 6; $i++) {
				$rowv["time$i"] = '0';
				$rowv["kills$i"] = '0';
			}
		}
		
		// Army
		$query = "SELECT * FROM army WHERE id = {$pid}";
		$result = mysql_query($query) or die(mysql_error());
		if (mysql_num_rows($result)) {
			$rowa = mysql_fetch_array($result);
		} else {
			$rowa = array();
			foreach ($aarmies as $sarmy) {
				$rowa['time' . $sarmy] = '0';
				$rowa['best' . $sarmy] = '0';
				$rowa['win' . $sarmy] = '0';
			}
		}

		if (strpos($info, 'mtm-') !== false) {
			// Add Map Time Data for New Medals Data
			foreach ($smaps as $smap) {
				$maptime[$smap] = 0;
			}
			$query = "SELECT * FROM maps WHERE id = {$pid}";
			$result = mysql_query($query) or die(mysql_error());
			while ($rowm = mysql_fetch_array($result)){
				$maptime[$rowm['mapid']] = $rowm['time'];
			}
		}
		
		// Output
		$out = "D\t" .
			$row['id'] . "\t" .
			$row['name'] . "\t" .
			$row['rank'] . "\t" .
			$rowk['time0'] . "\t" .
			$rowk['time1'] . "\t" .
			$rowk['time2'] . "\t" .
			$rowk['time3'] . "\t" .
			$rowk['time4'] . "\t" .
			$rowk['time5'] . "\t" .
			$rowk['time6'] . "\t" .
			$row['defends'] . "\t" .
			$row['repairs'] . "\t" .
			$rowv['time0'] . "\t" .
			$rowv['time1'] . "\t" .
			$rowv['time2'] . "\t" .
			$rowv['time3'] . "\t" .
			$rowv['time4'] . "\t" .
			$rowv['time5'] . "\t" .
			$rowv['time6'] . "\t" .
			$row['score'] . "\t" .
			$row['deathstreak'] . "\t" .
			$roww['kills0'] . "\t" .
			$roww['kills1'] . "\t" .
			$roww['kills2'] . "\t" .
			$roww['kills3'] . "\t" .
			$roww['kills4'] . "\t" .
			$roww['kills5'] . "\t" .
			$roww['kills6'] . "\t" .
			$roww['kills7'] . "\t" .
			$roww['kills8'] . "\t" .
			$roww['knifekills'] . "\t" .
			$roww['shockpadkills'] . "\t" .
			($roww['c4kills'] + $roww['claymorekills'] + $roww['atminekills']) . "\t" .
			$roww['handgrenadekills'] . "\t" .
			#wkl-13
			"0\t" .
			$row['heals'] . "\t" .
			$row['driverspecials'] . "\t" .
			$row['cmdscore'] . "\t" .
			$row['sqltime'] . "\t" .
			$row['sqmtime'] . "\t" .
			$row['losses'] . "\t" .
			$row['wins'] . "\t" .
			$rowv['kills0'] . "\t" .
			$rowv['kills1'] . "\t" .
			$rowv['kills2'] . "\t" .
			$rowv['kills3'] . "\t" .
			$rowv['kills4'] . "\t" .
			$rowv['kills5'] . "\t" .
			$rowv['kills6'] . "\t" .
			$row['teamscore'] . "\t" .
			$row['killstreak'] . "\t" .
			$row['time'] . "\t" .
			$row['kills'] . "\t" .
			$row['ammos'] . "\t" .
			$row['cmdtime'] . "\t";
			
			foreach ($aarmies as $sarmy) {
				$out .= $rowa['time' . $sarmy] ."\t" .
						$rowa['best' . $sarmy] ."\t" .
						$rowa['win' . $sarmy] ."\t";
			}
		
		if (strpos($info, 'mtm-') !== false) {
			// Add Map Time Data for New Medals Data
			foreach ($smaps as $smap) {
				$out .= $maptime[$smap] . "\t";
			}
		}
		
		if (strpos($info, 'de-') !== false) {
			$out .= $roww['tacticaldeployed'] . "\t" .
			$roww['grapplinghookdeployed'] . "\t" .
			$roww['ziplinedeployed'] . "\t";
		}
		
		#vac-
		$out .=	"0\t0\t0\t0\t0\t0\t0\n";
	} 
	else
	{
		$num = 0;
		$head = "E\nH\tasof\terr\n";
		$out  = "D\t" . time() . "\tParameter Error!\n";
		$num += strlen(preg_replace('/[\t\n]/','',$head));
		$num += strlen(preg_replace('/[\t\n]/','',$out));
	
		print rtrim($head) . "\n";
		print rtrim($out) . "\n";
		print "$\t$num\t$";
		die();
	}
	
	if ($transpose) {
		// Display in Alternate Format
		$num = 0;
		$transout = "O\n" .
			"H\tD\n" .
			"asof\t" . time() . "\n";
			
		$arrdata = split("\n",rtrim($head)."\n".rtrim($out));
		$keys = split("\t", $arrdata[3]);
		$vals = split("\t", $arrdata[4]);
		
		$i = 0;
		foreach ($keys as $key=>$keyval) {
			$transout .= $keyval . "\t" . $vals[$i] . "\n";
			$i++;
		}
		
		print rtrim($transout) . "\n";
		$num += strlen(preg_replace('/[\t\n]/','',$transout));
	} else {
		print rtrim($head) . "\n";
		print rtrim($out) . "\n";
		$num += strlen(preg_replace('/[\t\n]/','',$out));
	}
	print "$\t$num\t$";
	
	// Close database connection
	@mysql_close($connection);
}

function checkGameServerRequest($info) {
	// Checks Game Server Query String
	$complete = true;
	//$arr = array('rank','ktm-','dfcp','rpar','vtm-','scor','atm-','wdsk','wkl-','abr-','heal','dsab','cdsc','tsql','tsqm','awn-','wins','vkl-','twsc','bksk','time','kill','rsup','tcdr','vac-');
	$arr = array('rank','ktm-','dfcp','rpar','vtm-','bksk','scor','wdsk','wkl-','heal','dsab','cdsc','tsql','tsqm','wins','vkl-','twsc','time','kill','rsup','tcdr','vac-');
		
	for($a = 0; $a < count($arr); $a++)
	{
		if (strpos( $info, $arr[$a]) === false )
		{
			$complete = false;
		}
	}
	return $complete;
}


/**
* Berechnet ein Verhltnis zwischen den Parametern
* @param variant $x
* @param variant $x
* @return Float
*/
function ratio($x, $y) {
	if ($y != 0) {
		return sprintf("%.2f", $x / $y);
	}
	else {
		return '0.00';
	}
}

function error_head_Player() {
	$num = 0;
			$head = "E\nH\tasof\terr\n";
			$out  = "D\t" . time() . "\tPlayer Not Found!\n";
			$num += strlen(preg_replace('/[\t\n]/','',$head));
			$num += strlen(preg_replace('/[\t\n]/','',$out));
			
			print $head;
			print $out;
			print "$\t$num\t$";
			die();
}
?>
